/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.converter.AcmPropertyMapType;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.WorkflowPropertyMapsType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmWorkflowPropertyMapsType {
    private static final Log log = LogFactory.getLog((String)AcmWorkflowPropertyMapsType.class.getName());
    public static final String PROPERTYMAP = "propertyMap";
    public String jsonstr = null;
    public AcmPropertyMapType mapType;
    public WorkflowPropertyMapsType workflowmap;

    public AcmWorkflowPropertyMapsType(String json) {
        this.jsonstr = json;
        log.debug((Object)(" Work flow Map Json : " + json));
    }

    public void process() throws AcmException {
        try {
            log.info((Object)" Processing for workflow property maps");
            JSONObject jsonObj = JSONObject.parse((String)this.jsonstr);
            Object propertymap = jsonObj.get((Object)PROPERTYMAP);
            if (propertymap != null) {
                this.workflowmap = new WorkflowPropertyMapsType();
                log.debug((Object)"Property map exists");
                String mapString = propertymap.toString();
                if (mapString.startsWith("{")) {
                    log.debug((Object)"One map exists");
                    this.mapType = new AcmPropertyMapType(mapString);
                    this.mapType.process();
                    this.workflowmap.getPropertyMap().add(this.mapType.getMaptype());
                } else {
                    JSONArray mapArr = JSONArray.parse((String)mapString);
                    if (mapArr != null) {
                        log.debug((Object)(" Total maps available : " + mapArr.size()));
                        for (int idx = 0; idx < mapArr.size(); ++idx) {
                            JSONObject tempJsonObj = (JSONObject)mapArr.get(idx);
                            String tempmapString = tempJsonObj.toString();
                            this.mapType = new AcmPropertyMapType(tempmapString);
                            this.mapType.process();
                            this.workflowmap.getPropertyMap().add(this.mapType.getMaptype());
                        }
                    }
                }
                log.debug((Object)"Added property map to workflow property maps");
            } else {
                log.debug((Object)"work flow Property maps not used");
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
    }

    public WorkflowPropertyMapsType getWorkflowmap() {
        return this.workflowmap;
    }
}

