/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.common.type.RoleInbasketsType;
import com.ibm.acm.sold.common.type.RoleType;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmRoleInbasket {
    private static final Log log = LogFactory.getLog((String)AcmRoleInbasket.class.getName());
    private Object json;
    private List<RoleInbasketsType> inbaskets;
    private RoleType rt;

    public AcmRoleInbasket(Object json, List<RoleInbasketsType> inbaskets, RoleType rt) {
        this.json = json;
        this.inbaskets = inbaskets;
        this.rt = rt;
    }

    public void processRoleInbasket() throws AcmException {
        try {
            if (this.json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)this.json;
                this.iterateInbasket(jsob);
            } else {
                JSONArray ja = (JSONArray)this.json;
                for (JSONObject js : ja) {
                    log.debug((Object)js.toString());
                    this.iterateInbasket(js);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
    }

    private void iterateInbasket(JSONObject js) {
        RoleInbasketsType inbasket = new RoleInbasketsType();
        String name = js.get((Object)"name").toString();
        inbasket.setName(name);
        String queue = js.get((Object)"queue").toString();
        inbasket.setQueue(queue);
        Object isPersonal = js.get((Object)"isPersonal");
        if (isPersonal != null) {
            inbasket.setPersonal(Boolean.parseBoolean(js.get((Object)"isPersonal").toString()));
        }
        this.inbaskets.add(inbasket);
    }
}

