/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumFieldDirection;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumFieldType;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyMapType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.EnumCardinality;

public class AcmPropertyMapType {
    private static final Log log = LogFactory.getLog((String)AcmPropertyMapType.class.getName());
    public static final String WORKFLOWFIELDNAME = "workflowFieldName";
    public static final String PROPERTYNAME = "propertyName";
    public static final String WORKFLOWFIELDTYPE = "workflowFieldType";
    public static final String WORKFLOWFIELDCARDINALITY = "workflowFieldCardinality";
    public static final String WORKFLOWFIELDDIRECTION = "workflowFieldDirection";
    public String jsonStr;
    public PropertyMapType maptype;

    public AcmPropertyMapType(String jsonStr) {
        this.jsonStr = jsonStr;
        log.debug((Object)("Property map Json String : " + jsonStr));
    }

    public void process() throws AcmException {
        JSONObject jsonObj = null;
        try {
            Object workflowFieldDirection;
            Object workflowFieldCardinality;
            Object workflowFieldType;
            Object propertyName;
            jsonObj = JSONObject.parse((String)this.jsonStr);
            Object workFlowFieldName = jsonObj.get((Object)WORKFLOWFIELDNAME);
            this.maptype = new PropertyMapType();
            if (workFlowFieldName != null) {
                String workFlowFieldNameString = workFlowFieldName.toString();
                this.maptype.setWorkflowFieldName(workFlowFieldNameString);
                log.debug((Object)("work flow field name  : " + workFlowFieldNameString));
            }
            if ((propertyName = jsonObj.get((Object)PROPERTYNAME)) != null) {
                String propertyNameString = propertyName.toString();
                this.maptype.setPropertyName(propertyNameString);
                log.debug((Object)("Property name : " + propertyNameString));
            }
            if ((workflowFieldType = jsonObj.get((Object)WORKFLOWFIELDTYPE)) != null) {
                String workflowFieldTypeString = workflowFieldType.toString();
                this.maptype.setWorkflowFieldType(EnumFieldType.fromValue((String)workflowFieldTypeString));
                log.debug((Object)("Field Type :" + this.maptype.getWorkflowFieldType().value()));
            }
            if ((workflowFieldCardinality = jsonObj.get((Object)WORKFLOWFIELDCARDINALITY)) != null) {
                String workflowFieldCardinalityString = workflowFieldCardinality.toString();
                this.maptype.setWorkflowFieldCardinality(EnumCardinality.fromValue((String)workflowFieldCardinalityString));
                log.debug((Object)("Cardinality is :" + this.maptype.getWorkflowFieldCardinality().value()));
            }
            if ((workflowFieldDirection = jsonObj.get((Object)WORKFLOWFIELDDIRECTION)) != null) {
                String workflowFieldDirectionString = workflowFieldDirection.toString();
                this.maptype.setWorkflowFieldDirection(EnumFieldDirection.fromValue((String)workflowFieldDirectionString));
                log.debug((Object)("Direction is :" + this.maptype.getWorkflowFieldDirection().value()));
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
    }

    public PropertyMapType getMaptype() {
        return this.maptype;
    }
}

