/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmProcessWgAttach {
    private static final Log log = LogFactory.getLog((String)AcmProcessWgAttach.class.getName());

    public void updateWgDataFromJson(JSONObject js, CaseTypeData ct) throws AcmException {
        log.trace((Object)">>updateWgDataFromJson");
        Object tempObj = js.get((Object)"workgroup");
        try {
            if (tempObj != null) {
                String wgjs = js.get((Object)"workgroup").toString();
                log.trace((Object)wgjs);
                if (wgjs.startsWith("{")) {
                    JSONObject wgjsob = JSONObject.parse((String)wgjs);
                    Object[] keys1 = wgjsob.keySet().toArray();
                    AcmWorkGroupDefinition wg = new AcmWorkGroupDefinition();
                    this.iterateWorkGroup(keys1, wgjsob, wg);
                    ct.addWorkGroup(wg);
                } else {
                    JSONArray ja = null;
                    ja = JSONArray.parse((String)wgjs);
                    for (Object object : ja) {
                        log.trace((Object)object.toString());
                        JSONObject wgjsob = JSONObject.parse((String)object.toString());
                        Object[] keys = wgjsob.keySet().toArray();
                        AcmWorkGroupDefinition wg = new AcmWorkGroupDefinition();
                        this.iterateWorkGroup(keys, wgjsob, wg);
                        ct.addWorkGroup(wg);
                    }
                }
            }
        }
        catch (IOException e1) {
            log.error((Object)" error ::  ", (Throwable)e1);
            Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e1.getLocalizedMessage());
            throw new AcmException(msg, (Throwable)e1);
        }
        log.trace((Object)"<<updateWgDataFromJson");
    }

    private void iterateWorkGroup(Object[] keys, JSONObject js, AcmWorkGroupDefinition wgData) {
        block4: for (int i = 0; i < keys.length; ++i) {
            switch (this.checkWgKey(keys[i].toString())) {
                case 600: {
                    String name = js.get((Object)keys[i].toString()).toString();
                    wgData.setName(name);
                    continue block4;
                }
                case 601: {
                    String desc = js.get((Object)keys[i].toString()).toString();
                    wgData.setDescription(desc);
                }
            }
        }
    }

    public void updateAttachDataFromJson(JSONObject js, CaseTypeData ct) throws AcmException {
        log.trace((Object)">>updateAttachDataFromJson");
        try {
            Object tempObj = js.get((Object)"attachment");
            if (tempObj != null) {
                String attjs = js.get((Object)"attachment").toString();
                log.trace((Object)attjs);
                if (attjs.startsWith("{")) {
                    JSONObject attjsob = JSONObject.parse((String)attjs);
                    Object[] keys1 = attjsob.keySet().toArray();
                    AcmActivityAttachment att = new AcmActivityAttachment();
                    this.iterateAttachment(keys1, attjsob, att);
                    ct.addAttachment(att);
                } else {
                    JSONArray ja = null;
                    ja = JSONArray.parse((String)attjs);
                    for (Object object : ja) {
                        log.trace((Object)object.toString());
                        JSONObject attjsob = JSONObject.parse((String)object.toString());
                        Object[] keys1 = attjsob.keySet().toArray();
                        AcmActivityAttachment att = new AcmActivityAttachment();
                        this.iterateAttachment(keys1, attjsob, att);
                        ct.addAttachment(att);
                    }
                }
            }
        }
        catch (IOException e1) {
            log.error((Object)" error ::  ", (Throwable)e1);
            Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e1.getLocalizedMessage());
            throw new AcmException(msg, (Throwable)e1);
        }
        log.trace((Object)"<<updateAttachDataFromJson");
    }

    private void iterateAttachment(Object[] keys, JSONObject js, AcmActivityAttachment attachData) {
        block4: for (int i = 0; i < keys.length; ++i) {
            switch (this.checkAttachKey(keys[i].toString())) {
                case 700: {
                    String name = js.get((Object)keys[i].toString()).toString();
                    attachData.setName(name);
                    continue block4;
                }
                case 701: {
                    String desc = js.get((Object)keys[i].toString()).toString();
                    attachData.setDescription(desc);
                }
            }
        }
    }

    private int checkWgKey(String key) {
        if (key.equalsIgnoreCase("name")) {
            return 600;
        }
        if (key.equalsIgnoreCase("description")) {
            return 601;
        }
        log.trace((Object)("Unknown Key is :" + key.toString()));
        return 999;
    }

    private int checkAttachKey(String key) {
        if (key.equalsIgnoreCase("name")) {
            return 700;
        }
        if (key.equalsIgnoreCase("description")) {
            return 701;
        }
        log.trace((Object)("Unknown Key is :" + key.toString()));
        return 999;
    }
}

