/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SdfData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.type.RoleType;
import com.ibm.acm.sold.common.type.RolesType;
import com.ibm.acm.sold.connector.CEManager;
import com.ibm.acm.sold.connector.PEConfig;
import com.ibm.acm.sold.converter.AcmConverter;
import com.ibm.acm.sold.converter.AcmJsonSplitter;
import com.ibm.acm.sold.diagrammer.AcmActivitySdfData;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmRoleInbasketproperties;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumPropertyType;

public class AcmProcessSolutionData {
    private static final Log log = LogFactory.getLog((String)AcmProcessSolutionData.class.getName());
    SolutionData solnData = null;
    Config config;

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public AcmProcessSolutionData(SolutionData solnData) {
        this.solnData = solnData;
    }

    private Set<String> getpropertiesList(SolutionData solnData, String casetypename) throws AcmException {
        HashSet<String> properties = new HashSet<String>();
        List caseList = null;
        try {
            caseList = solnData.getConverterData().getSolutionType().getCaseTypes().getCaseType();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (caseList != null) {
            for (CaseTypeType caseType : caseList) {
                if (!caseType.getName().equalsIgnoreCase(casetypename)) continue;
                try {
                    Iterator i2 = caseType.getCaseProperties().getPropertyDefinition().iterator();
                    while (i2.hasNext()) {
                        properties.add(((CmisPropertyDefinitionType)i2.next()).getDisplayName());
                    }
                }
                catch (NullPointerException e1) {
                }
            }
        }
        return properties;
    }

    public Set<String> getpropertiesSymbolicList(SolutionData solnData, String casetypename) throws AcmException {
        HashSet<String> properties = new HashSet<String>();
        List caseList = null;
        try {
            caseList = solnData.getConverterData().getSolutionType().getCaseTypes().getCaseType();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (caseList != null) {
            for (CaseTypeType caseType : caseList) {
                if (!caseType.getName().equalsIgnoreCase(casetypename)) continue;
                try {
                    Iterator i2 = caseType.getCaseProperties().getPropertyDefinition().iterator();
                    while (i2.hasNext()) {
                        properties.add(((CmisPropertyDefinitionType)i2.next()).getLocalName());
                    }
                }
                catch (NullPointerException e1) {
                }
            }
        }
        return properties;
    }

    private int getPEFieldTypeFromCEType(EnumPropertyType propType) {
        if (propType == EnumPropertyType.BOOLEAN) {
            return 4;
        }
        if (propType == EnumPropertyType.DATETIME) {
            return 16;
        }
        if (propType == EnumPropertyType.DECIMAL) {
            return 8;
        }
        if (propType == EnumPropertyType.HTML || propType == EnumPropertyType.STRING || propType == EnumPropertyType.URI) {
            return 2;
        }
        if (propType == EnumPropertyType.ID) {
            return 512;
        }
        if (propType == EnumPropertyType.INTEGER) {
            return 1;
        }
        return -1;
    }

    private CmisPropertyDefinitionType getPropertyDefinition(String propertyName) throws AcmException {
        log.debug((Object)("Looking for property: " + propertyName));
        for (CmisPropertyDefinitionType type : this.solnData.getConverterData().getSolutionType().getProperties().getPropertyDefinition()) {
            if (!propertyName.equals(type.getLocalName())) continue;
            log.debug((Object)("Found property: " + propertyName));
            return type;
        }
        log.debug((Object)("Did not find property: " + propertyName));
        return null;
    }

    public Set<AcmRoleInbasketproperties> getRoleInbasketProperties(String queueName, PEConfig peconfig, Set<String> caseProps) throws AcmException {
        HashSet<AcmRoleInbasketproperties> inbasketPropsList = new HashSet<AcmRoleInbasketproperties>();
        try {
            VWWorkBasketDefinition[] workBasketDefs;
            VWQueueDefinition queueDef = peconfig.getSystemConfiguration().getQueueDefinition(queueName);
            if (queueDef != null && (workBasketDefs = queueDef.getWorkBasketDefinitions()) != null) {
                for (int i = 0; i < workBasketDefs.length; ++i) {
                    VWWorkBasketColumnDefinition[] columnDefs = workBasketDefs[i].getWorkBasketColumnDefinitions();
                    if (columnDefs == null) continue;
                    for (int j = 0; j < columnDefs.length; ++j) {
                        String colName = columnDefs[j].getName();
                        for (String cp : caseProps) {
                            if (!colName.equals(cp)) continue;
                            CmisPropertyDefinitionType propDef = this.getPropertyDefinition(colName);
                            AcmRoleInbasketproperties inbasProp = new AcmRoleInbasketproperties();
                            inbasProp.setSymName(colName);
                            inbasProp.setDisplayName(propDef.getDisplayName());
                            inbasProp.setDescription(propDef.getDescription());
                            inbasProp.setArray(false);
                            inbasProp.setDataType(this.getPEFieldTypeFromCEType(propDef.getPropertyType()));
                            inbasketPropsList.add(inbasProp);
                        }
                    }
                }
            }
        }
        catch (NullPointerException e1) {
        }
        catch (VWException e) {
            log.error((Object)" VWexception occurred in getRoleInbasketProperties() ");
            Message msg = new Message("B4066E.VW_EXCEPTION");
            throw new AcmException(msg);
        }
        return inbasketPropsList;
    }

    private Map<String, Set<AcmRoleInbasketproperties>> getInbasketPropMap(AcmCaseShareInfo caseShareInfo, PEConfig peconfig) throws AcmException {
        HashMap<String, Set<AcmRoleInbasketproperties>> inbasketMap = new HashMap<String, Set<AcmRoleInbasketproperties>>();
        Map queueMap = (Map)caseShareInfo.getObject(AcmCaseShareInfo.QUEUE_ROLE_MAP);
        Set caseProps = (Set)caseShareInfo.getObject(AcmCaseShareInfo.CASE_PROPERTIES_SYMBOLIC_LIST);
        Set<AcmRoleInbasketproperties> propSet = this.getRoleInbasketProperties("Inbox", peconfig, caseProps);
        inbasketMap.put("Inbox", propSet);
        for (String qm : queueMap.keySet()) {
            propSet = this.getRoleInbasketProperties(qm, peconfig, caseProps);
            inbasketMap.put(qm, propSet);
        }
        return inbasketMap;
    }

    public CaseTypeData updateCaseTypeDataSharedInfo(SolutionData solnData, String caseTypeName, CaseTypeData ctData) throws AcmException {
        ctData.resetSharedInfo();
        AcmCaseShareInfo shareInfo = ctData.getSharedInfo();
        String solPrefix = solnData.getConverterData().getSolutionType().getPrefix();
        shareInfo.addObject(AcmCaseShareInfo.SOL_PREFIX, solPrefix);
        String solName = solnData.getConverterData().getSolutionType().getName();
        shareInfo.addObject(AcmCaseShareInfo.SOL_NAME, solName);
        shareInfo.addObject(AcmCaseShareInfo.CASE_PROPERTIES_LIST, this.getpropertiesList(solnData, caseTypeName));
        shareInfo.addObject(AcmCaseShareInfo.CASE_PROPERTIES_SYMBOLIC_LIST, this.getpropertiesSymbolicList(solnData, caseTypeName));
        shareInfo.addObject(AcmCaseShareInfo.ACTIVITY_CONFIG_INFO, solnData.getActivityConfigInfo());
        PEConfig peConfig = solnData.getPeconfigData();
        try {
            VWRosterDefinition[] rr = peConfig.getSystemConfiguration().getRosterDefinitions();
            if (rr != null) {
                String rosterName = rr[0].getName();
                shareInfo.addObject(AcmCaseShareInfo.ROSTER_NAME, rosterName);
            }
            if (caseTypeName != null) {
                String eventLogName = caseTypeName;
                shareInfo.addObject(AcmCaseShareInfo.EVENT_LOG_NAME, eventLogName);
            }
        }
        catch (VWException vwe) {
            log.error((Object)" VWexception occurred in Roster and EventLogs from PE Config: ", (Throwable)vwe);
            Message msg = new Message("B4066E.VW_EXCEPTION");
            throw new AcmException(msg);
        }
        catch (Exception e) {
            log.error((Object)" Exception while creating Roster/Event Log names from PE Config :", (Throwable)e);
            Message msg = new Message("B4063E.PE_CONFIG_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
        ctData.setSharedInfo(shareInfo);
        HashMap queueRoleMap = new HashMap();
        RolesType rolesType = solnData.getRoles();
        Collection<RoleType> rolesList = rolesType.getRoleTable().values();
        for (RoleType role : rolesList) {
            String roleName = role.getName();
            String queueName = role.getPrimaryQueue();
            if (queueName == null) continue;
            if (queueRoleMap.containsKey(queueName)) {
                ((Set)queueRoleMap.get(queueName)).add(roleName);
                continue;
            }
            HashSet<String> roles = new HashSet<String>();
            roles.add(roleName);
            queueRoleMap.put(queueName, roles);
        }
        shareInfo.addObject(AcmCaseShareInfo.QUEUE_ROLE_MAP, queueRoleMap);
        shareInfo.addObject(AcmCaseShareInfo.INBASKET_PROP_MAP, this.getInbasketPropMap(shareInfo, peConfig));
        return ctData;
    }

    public synchronized void updateSolDataXPDL(String jsonStr, String casetypename) throws AcmException {
        log.trace((Object)">>updateSolDataXPDL");
        try {
            CaseTypeData ctData = this.solnData.getCasetypedata(casetypename);
            if (ctData == null) {
                ctData = new CaseTypeData();
                ctData.setSymName(casetypename);
                this.solnData.setCasetypedata(casetypename, ctData);
            }
            AcmJsonSplitter splitObj = new AcmJsonSplitter(jsonStr);
            splitObj.splitJson();
            log.debug((Object)"json Splitting successful");
            jsonStr = splitObj.getActualSolution();
            AcmConverter converter = this.createSdfUIData(jsonStr, this.solnData);
            CEManager cemgr = new CEManager(this.solnData, this.config);
            cemgr.setProjectArea(splitObj.getProjectArea());
            cemgr.openSession();
            converter.getSolutionType();
            if (ctData.getActivitiesMap().size() == 0) {
                this.updateActivityData(this.solnData, casetypename, ctData);
            } else {
                this.adjustDeletedTasks(this.solnData, casetypename, ctData);
            }
            PEConfig peconfig = this.solnData.getPeconfigData();
            if (peconfig == null) {
                peconfig = new PEConfig(this.solnData, converter);
                this.solnData.setPeconfigData(peconfig);
            } else {
                peconfig.setConverter(converter);
            }
            try {
                peconfig.generateConfig(this.solnData);
            }
            catch (AcmConnectionFailure e) {
                log.error((Object)" Exception occurred while generating PE Config data:", (Throwable)e);
                Message msg = new Message("B4063E.PE_CONFIG_ERROR");
                throw new AcmException(msg, (Throwable)e);
            }
            ctData = this.updateCaseTypeDataSharedInfo(this.solnData, casetypename, ctData);
            try {
                InputStream xpdlStream = cemgr.retrieveXPDLdoc(casetypename, true);
                cemgr.closeSession();
                if (xpdlStream != null) {
                    ctData.readXpdl(xpdlStream, true);
                } else {
                    log.debug((Object)(" No XPDL Available for CaseType : " + casetypename));
                }
            }
            catch (DiagrammerException e) {
                log.error((Object)" error ::  ", (Throwable)e);
                throw new AcmException(e.getLocalizedMessage(), (Throwable)e);
            }
            log.info((Object)"-- Successfully loaded XPDL and updated Activities --");
            this.solnData.setCasetypedata(casetypename, ctData);
        }
        catch (Exception e) {
            log.error((Object)" error ::  ", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException(msg);
        }
        log.trace((Object)"<<updateSolDataXPDL");
    }

    private InputStream getXPDLdoc(String casetypename, boolean checkOut) throws AcmException {
        log.trace((Object)">> getXPDLdoc");
        CEManager cemgr = new CEManager(this.solnData, this.config);
        cemgr.openSession();
        InputStream xpdlStream = cemgr.retrieveXPDLdoc(casetypename, checkOut);
        cemgr.closeSession();
        log.debug((Object)"XPDL data Stream obtained");
        log.trace((Object)"<< getXPDLdoc");
        return xpdlStream;
    }

    private synchronized AcmConverter createSdfUIData(String jsonStr, SolutionData solData) throws AcmConnectionFailure, AcmException {
        log.trace((Object)">>createSdfUIData");
        AcmConverter converter = new AcmConverter(jsonStr, solData);
        if (solData.getSdfData() == null) {
            solData.setSdfData(new SdfData());
        }
        try {
            solData.setConverterData(converter);
            converter.resetAllTypeState();
            converter.convertJsonToXml();
        }
        catch (AcmException e) {
            log.error((Object)" Exception occured while parsing Solution Json : ", (Throwable)e);
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"<<createSdfUIData");
        return converter;
    }

    public void updateActivityData(SolutionData solData, String casetypename, CaseTypeData ctData) throws AcmException {
        log.trace((Object)">>updateActivityData");
        List caseTypes = null;
        if (solData.getConverterData() == null || solData.getConverterData().getSolutionType() == null || solData.getConverterData().getSolutionType().getCaseTypes() == null) {
            log.debug((Object)(" Activity Data not found for this CaseType : " + casetypename));
            return;
        }
        caseTypes = solData.getConverterData().getSolutionType().getCaseTypes().getCaseType();
        for (CaseTypeType caseType : caseTypes) {
            if (!casetypename.equals(caseType.getName())) continue;
            if (ctData.getId() == null) {
                ctData.setId(caseType.getId());
            }
            ArrayList actList = (ArrayList)caseType.getTasks().getTask();
            for (TaskType act : actList) {
                if (act.getWorkflowType() != null && act.getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) continue;
                AcmActivity acmActiv = this.createActivityObject(act);
                ctData.addActivity(acmActiv);
            }
        }
        log.trace((Object)"<<updateActivityData");
    }

    public void adjustDeletedTasks(SolutionData solData, String casetypename, CaseTypeData ctData) throws AcmException {
        log.trace((Object)">>adjustDeletedTasks");
        List caseTypes = null;
        if (solData.getConverterData() == null || solData.getConverterData().getSolutionType() == null || solData.getConverterData().getSolutionType().getCaseTypes() == null) {
            log.debug((Object)(" Activity Data not found for this CaseType : " + casetypename));
            return;
        }
        caseTypes = solData.getConverterData().getSolutionType().getCaseTypes().getCaseType();
        for (CaseTypeType caseType : caseTypes) {
            if (!casetypename.equals(caseType.getName())) continue;
            ArrayList actList = (ArrayList)caseType.getTasks().getTask();
            boolean found = false;
            Iterator<AcmActivity> ctActItr = ctData.getActivitiesMap().values().iterator();
            while (ctActItr.hasNext()) {
                AcmActivity ctAct = ctActItr.next();
                found = false;
                for (TaskType act : actList) {
                    if (!ctAct.getSymbolicName().equals(act.getName())) continue;
                    found = true;
                }
                if (found) continue;
                ctActItr.remove();
            }
        }
        log.trace((Object)"<<adjustDeletedTasks");
    }

    public AcmActivity createActivityObject(TaskType actType) throws AcmException {
        String id;
        log.trace((Object)">>createActivityObject");
        AcmActivity activityData = null;
        try {
            activityData = new AcmActivity();
        }
        catch (DiagrammerException e) {
            log.error((Object)" Exception occured while creating Task Object :  ", (Throwable)e);
            Message msg = new Message("B4061E.CREATE_TASK_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
        AcmActivitySdfData actSdfdata = new AcmActivitySdfData();
        String sname = actType.getName();
        activityData.setSymbolicName(sname);
        actSdfdata.setSymbolicName(sname);
        String dname = actType.getDisplayName();
        activityData.setName(dname);
        String desc = actType.getDescription();
        activityData.setDescription(desc);
        Boolean editable = actType.isEditable();
        if (editable != null) {
            log.debug((Object)("Is this Task Editable =" + editable));
            actSdfdata.setEditable(editable);
        } else {
            actSdfdata.setEditable(true);
        }
        EnumWorkflowType workflowtype = actType.getWorkflowType();
        actSdfdata.setWorkflowType(workflowtype);
        Boolean iscontainer = actType.isIsContainer();
        if (iscontainer == null) {
            iscontainer = false;
        }
        actSdfdata.setContainer(iscontainer);
        String parenttask = actType.getParentTask();
        actSdfdata.setparentTask(parenttask);
        List propertyupdatetrigger = actType.getPropertyUpdateTrigger();
        actSdfdata.setpropertyUpdateTrigger(propertyupdatetrigger);
        String designnote = actType.getDesignNote();
        actSdfdata.setDesignNote(designnote);
        List filingDocsList = actType.getFilingDocumentType();
        actSdfdata.setFilingDocumentTypeList(filingDocsList);
        String propertypre = actType.getPropertyPrecondition();
        actSdfdata.setPropertyPreCondition(propertypre);
        boolean required = actType.isRequired();
        actSdfdata.setRequired(required);
        Boolean hidden = actType.isHidden();
        if (hidden == null) {
            hidden = false;
        }
        actSdfdata.setHidden(hidden);
        String launchmode = actType.getLaunchMode().value().toString();
        actSdfdata.setLaunchMode(launchmode);
        boolean repeatable = actType.isRepeatable();
        actSdfdata.setRepeatable(repeatable);
        boolean usercreatable = actType.isUserCreatable();
        actSdfdata.setUserCreatable(usercreatable);
        if (actType.getGroupId() != null) {
            String groupid = actType.getGroupId().toString();
            actSdfdata.setGroupID(groupid);
        }
        if ((id = actType.getId()).equalsIgnoreCase("-1") && activityData.getSymbolicName() != null) {
            String guid = this.solnData.checkCreateTaskGuid(activityData.getSymbolicName());
            actSdfdata.setId(guid);
        } else {
            actSdfdata.setId(id);
        }
        activityData.setSdfData(actSdfdata);
        log.trace((Object)"<<createActivityObject");
        return activityData;
    }
}

