/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmJsonSplitter {
    private static final Log log = LogFactory.getLog((String)AcmJsonSplitter.class.getName());
    public static final String PROJECT_AREA = "projectArea";
    public static final String ACTUAL_SOLUTION = "actualSolution";
    private String json = null;
    private String projectArea = null;
    private String actualSolution = null;

    public String getProjectArea() {
        log.info((Object)(PROJECT_AREA + this.projectArea));
        return this.projectArea;
    }

    public String getActualSolution() {
        log.debug((Object)("Actual solution Json " + this.actualSolution));
        return this.actualSolution;
    }

    public AcmJsonSplitter(String jsonStr) {
        this.json = jsonStr;
    }

    public void splitJson() throws AcmException {
        log.trace((Object)">splitJson");
        JSONObject js = null;
        try {
            log.debug((Object)("Parsing the json :" + this.json));
            js = JSONObject.parse((String)this.json);
            this.projectArea = (String)js.get((Object)PROJECT_AREA);
            log.debug((Object)("Retrieved project area : " + this.projectArea));
            this.actualSolution = js.get((Object)ACTUAL_SOLUTION).toString();
            log.debug((Object)(" Retrieved solution json :" + this.actualSolution));
        }
        catch (IOException e) {
            log.debug((Object)(" Error occured while parsing json :" + this.json));
            log.error((Object)e);
            throw new AcmException(e);
        }
        log.trace((Object)"<splitJson");
    }
}

