/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.common.type.Column;
import com.ibm.acm.sold.common.type.Filter;
import com.ibm.acm.sold.common.type.InbasketType;
import com.ibm.acm.sold.common.type.InbasketsType;
import com.ibm.acm.sold.common.type.TypeState;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmUnhandledKeyException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmInbox {
    private static final Log log = LogFactory.getLog((String)AcmInbox.class.getName());
    private Object json;
    private InbasketsType inbaskets;

    public AcmInbox(Object jsonstr, InbasketsType inbaskets) {
        this.json = jsonstr;
        this.inbaskets = inbaskets;
    }

    public void processInbasket() throws AcmException {
        log.trace((Object)">processInbasket");
        try {
            if (this.json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)this.json;
                this.iterateInbasket(jsob);
            } else {
                JSONArray ja = (JSONArray)this.json;
                for (JSONObject js : ja) {
                    log.debug((Object)js.toString());
                    this.iterateInbasket(js);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
    }

    private void iterateInbasket(JSONObject js) throws AcmException {
        InbasketType in = new InbasketType();
        Object tempObj = js.get((Object)"index");
        Integer index = null;
        if (tempObj != null) {
            index = Integer.parseInt(tempObj.toString());
            in = this.inbaskets.getInbasketTable().get(index);
            if (in == null) {
                in = new InbasketType();
                in.setState(TypeState.EnumTypeState.NEW);
            } else {
                in.setState(TypeState.EnumTypeState.PERSISTED);
            }
        } else {
            in = new InbasketType();
            in.setState(TypeState.EnumTypeState.NEW);
        }
        boolean foundDesc = false;
        tempObj = js.get((Object)"name");
        if (tempObj != null) {
            log.debug((Object)("Inbasket Name :" + tempObj.toString()));
            String inbasketName = tempObj.toString();
            if (!inbasketName.equals(in.getName())) {
                in.setOldName(in.getName());
                in.setName(inbasketName);
                if (in.getState() == TypeState.EnumTypeState.PERSISTED) {
                    in.setState(TypeState.EnumTypeState.MODIFIED);
                }
            }
        }
        if ((tempObj = js.get((Object)"description")) != null) {
            foundDesc = true;
            in.setDescription(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"type")) != null) {
            in.setType(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"ECM_RemovePrefix")) != null) {
            in.setRemovePrefix(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"columns")) != null) {
            List<Column> columns = in.getColumns();
            if (columns == null) {
                columns = new ArrayList<Column>(100);
                in.setColumns(columns);
            }
            this.processColumnElement(tempObj, columns, in);
        }
        if ((tempObj = js.get((Object)"filters")) != null) {
            List<Filter> filters = in.getFilters();
            if (filters == null) {
                filters = new ArrayList<Filter>(100);
                in.setFilters(filters);
            }
            this.processFilterElement(tempObj, filters, in);
        }
        if ((tempObj = js.get((Object)"queue")) != null) {
            in.setQueue(tempObj.toString());
        }
        if (!foundDesc) {
            log.debug((Object)"couldnt find the role desc");
            in.setDescription("");
        }
        Integer last2 = 0;
        Set<Integer> keys = this.inbaskets.getInbasketTable().keySet();
        for (Integer last2 : keys) {
        }
        if (in.getState() == TypeState.EnumTypeState.NEW) {
            this.inbaskets.getInbasketTable().put(last2 + 1, in);
        }
    }

    private void processFilterElement(Object json, List<Filter> filters, InbasketType in) throws AcmException {
        log.trace((Object)">processFilterElement");
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                this.iterateFilter(jsob, filters, in);
            } else {
                JSONArray ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    this.iterateFilter(js, filters, in);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"<processFilterElement");
    }

    public void iterateColumn(JSONObject js, List<Column> columns, InbasketType in) throws AcmUnhandledKeyException {
        Column oldColumn;
        log.trace((Object)">iterateColumn");
        Column column = new Column();
        Object tempObj = js.get((Object)"name");
        if (tempObj != null) {
            column.setName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"label")) != null) {
            column.setLabel(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"sortable")) != null) {
            column.setSortable(Boolean.parseBoolean(tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"sortDefault")) != null) {
            column.setSortDefault(Boolean.parseBoolean(tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"sortAscending")) != null) {
            column.setSortAscending(Boolean.parseBoolean(tempObj.toString()));
        }
        if ((oldColumn = in.findColumn(column.getName())) == null) {
            column.setState(TypeState.EnumTypeState.NEW);
        } else {
            if (column.isSortable() != oldColumn.isSortable()) {
                column.setState(TypeState.EnumTypeState.MODIFIED);
            } else if (column.isSortAscending() != oldColumn.isSortAscending()) {
                column.setState(TypeState.EnumTypeState.MODIFIED);
            } else if (column.isSortDefault() != oldColumn.isSortDefault()) {
                column.setState(TypeState.EnumTypeState.MODIFIED);
            } else {
                column.setState(TypeState.EnumTypeState.PERSISTED);
            }
            columns.remove(oldColumn);
        }
        columns.add(column);
        log.trace((Object)"<iterateColumn");
    }

    public void processColumnElement(Object json, List<Column> columns, InbasketType in) throws AcmException {
        log.trace((Object)">processColumnElement");
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                this.iterateColumn(jsob, columns, in);
            } else {
                JSONArray ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    log.debug((Object)js.toString());
                    this.iterateColumn(js, columns, in);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"<processColumnElement");
    }

    public void iterateFilter(JSONObject js, List<Filter> filters, InbasketType in) {
        log.trace((Object)">iterateCondition");
        Filter condition = new Filter();
        Object tempObject = js.get((Object)"name");
        if (tempObject != null) {
            condition.setName(tempObject.toString());
        }
        if ((tempObject = js.get((Object)"operator")) != null) {
            condition.setOperator(tempObject.toString());
        }
        if ((tempObject = js.get((Object)"type")) != null) {
            condition.setType(tempObject.toString());
        }
        if ((tempObject = js.get((Object)"label")) != null) {
            condition.setLabel(tempObject.toString());
        }
        condition.setUniqueName(condition.getName() + condition.getOperator());
        Filter oldCondition = in.findFilter(condition.getUniqueName());
        if (oldCondition == null) {
            condition.setState(TypeState.EnumTypeState.NEW);
        } else {
            if (condition.getLabel() == null && oldCondition.getLabel() != null || condition.getLabel() != null && !condition.getLabel().equals(oldCondition.getLabel())) {
                condition.setState(TypeState.EnumTypeState.MODIFIED);
            } else {
                condition.setState(TypeState.EnumTypeState.PERSISTED);
            }
            filters.remove(oldCondition);
        }
        filters.add(condition);
        log.trace((Object)"<iterateCondition");
    }
}

