/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.converter.DateTime;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmNullValueException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.cmis.caseextensions.FromTemplate;
import com.ibm.xmlns.prod.ecm.cmis.caseextensions.Hidden;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBooleanDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTime;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTimeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimal;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimalDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyHtmlDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIdDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyInteger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyString;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyStringDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyUriDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDocumentDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;
import org.oasis_open.docs.ns.cmis.core._200908.EnumContentStreamAllowed;
import org.oasis_open.docs.ns.cmis.core._200908.EnumPropertyType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumUpdatability;

public class AcmDocType {
    private static final Log log = LogFactory.getLog((String)AcmDocType.class.getName());
    public Object json;
    public SolutionType solnType;
    private SolutionData solData;

    public AcmDocType(Object json, SolutionType soln, SolutionData solData) {
        this.json = json;
        this.solnType = soln;
        this.solData = solData;
    }

    public void process() throws AcmException {
        log.trace((Object)"> process");
        JSONObject docprops = null;
        try {
            docprops = (JSONObject)this.json;
            Object docProp = docprops.get((Object)"documentType");
            if (docProp.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)docProp;
                this.iterateDocType(jsob);
            } else {
                JSONArray ja = (JSONArray)docProp;
                for (JSONObject js : ja) {
                    this.iterateDocType(js);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"< process");
    }

    private void iterateDocType(JSONObject js) throws AcmException {
        log.trace((Object)">iterateDocType");
        CmisTypeDocumentDefinitionType docType = new CmisTypeDocumentDefinitionType();
        docType.setLocalNamespace("");
        docType.setBaseId(EnumBaseObjectTypeIds.CMIS_DOCUMENT);
        docType.setCreatable(true);
        docType.setFileable(true);
        docType.setQueryable(true);
        docType.setFulltextIndexed(false);
        docType.setIncludedInSupertypeQuery(true);
        docType.setControllablePolicy(true);
        docType.setControllableACL(true);
        docType.setVersionable(true);
        docType.setContentStreamAllowed(EnumContentStreamAllowed.ALLOWED);
        docType.setId("");
        boolean createGuid = false;
        Object tempObj = js.get((Object)"localName");
        if (tempObj != null) {
            docType.setLocalName(tempObj.toString());
            log.trace((Object)("Document Name " + tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"description")) != null) {
            docType.setDescription(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"property")) != null) {
            log.trace((Object)("Document properties:" + tempObj.toString()));
            ArrayList<CmisPropertyDefinitionType> propList = this.processPropertiesElement(tempObj);
            docType.getPropertyDefinition().addAll(propList);
        }
        if ((tempObj = js.get((Object)"displayName")) != null) {
            docType.setDisplayName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"id")) != null) {
            String docid = tempObj.toString();
            if (docid.equals("-1")) {
                createGuid = true;
            } else {
                docType.setId(docid);
                createGuid = false;
            }
        }
        if ((tempObj = js.get((Object)"localNamespace")) != null) {
            docType.setLocalNamespace(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"queryName")) != null) {
            docType.setQueryName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"baseId")) != null) {
            if (tempObj.toString().equals("CMIS_DOCUMENT")) {
                docType.setBaseId(EnumBaseObjectTypeIds.CMIS_DOCUMENT);
            } else if (tempObj.toString().equals("CMIS_POLICY")) {
                docType.setBaseId(EnumBaseObjectTypeIds.CMIS_POLICY);
            } else if (tempObj.toString().equals("CMIS_FOLDER")) {
                docType.setBaseId(EnumBaseObjectTypeIds.CMIS_FOLDER);
            } else if (tempObj.toString().equals("CMIS_RELATIONSHIP")) {
                docType.setBaseId(EnumBaseObjectTypeIds.CMIS_RELATIONSHIP);
            }
        }
        if ((tempObj = js.get((Object)"parentId")) != null) {
            docType.setParentId(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"creatable")) != null) {
            boolean crtb = Boolean.parseBoolean(tempObj.toString());
            docType.setCreatable(crtb);
        }
        if ((tempObj = js.get((Object)"fileable")) != null) {
            boolean fb = Boolean.parseBoolean(tempObj.toString());
            docType.setFileable(fb);
        }
        if ((tempObj = js.get((Object)"queryable")) != null) {
            boolean qb = Boolean.parseBoolean(tempObj.toString());
            docType.setQueryable(qb);
        }
        if ((tempObj = js.get((Object)"fulltextIndexed")) != null) {
            boolean fib = Boolean.parseBoolean(tempObj.toString());
            docType.setFulltextIndexed(fib);
        }
        if ((tempObj = js.get((Object)"includedInSupertypeQuery")) != null) {
            boolean inb = Boolean.parseBoolean(tempObj.toString());
            docType.setIncludedInSupertypeQuery(inb);
        }
        if ((tempObj = js.get((Object)"controllablePolicy")) != null) {
            boolean cnb = Boolean.parseBoolean(tempObj.toString());
            docType.setControllablePolicy(cnb);
        }
        if ((tempObj = js.get((Object)"controllableACL")) != null) {
            boolean cnab = Boolean.parseBoolean(tempObj.toString());
            docType.setControllableACL(cnab);
        }
        if ((tempObj = js.get((Object)"versionable")) != null) {
            boolean vb = Boolean.parseBoolean(tempObj.toString());
            docType.setVersionable(vb);
        }
        if ((tempObj = js.get((Object)"contentStreamAllowed")) != null) {
            String contentStream = tempObj.toString();
            if (contentStream.equals("ALLOWED")) {
                docType.setContentStreamAllowed(EnumContentStreamAllowed.ALLOWED);
            } else if (contentStream.equals("NOTALLOWED")) {
                docType.setContentStreamAllowed(EnumContentStreamAllowed.NOTALLOWED);
            } else if (contentStream.equals("REQUIRED")) {
                docType.setContentStreamAllowed(EnumContentStreamAllowed.REQUIRED);
            }
        }
        if ((tempObj = js.get((Object)"fromTemplate")) != null) {
            boolean casehid = Boolean.parseBoolean(tempObj.toString());
            FromTemplate h = new FromTemplate(Boolean.valueOf(casehid));
            docType.getAny().add(h);
        }
        if (createGuid && docType.getLocalName() != null) {
            String guid = this.solData.checkCreateDocTypeGuid(docType.getLocalName());
            docType.setId(guid);
        }
        this.solnType.getTypes().getTypeDefinition().add(docType);
        log.trace((Object)"<iterateDocType");
    }

    private ArrayList<CmisPropertyDefinitionType> processPropertiesElement(Object json) throws AcmException {
        log.trace((Object)">processPropertiesElement");
        ArrayList<CmisPropertyDefinitionType> list = new ArrayList<CmisPropertyDefinitionType>();
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                list.add(this.iterateProperty(jsob));
            } else {
                JSONArray ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    list.add(this.iterateProperty(js));
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"<processPropertiesElement");
        return list;
    }

    private CmisPropertyDefinitionType iterateProperty(JSONObject js) throws AcmNullValueException, AcmException {
        String name = js.get((Object)"localName").toString();
        if (name == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "localName");
            throw new AcmException(msg);
        }
        CmisPropertyDefinitionType type = this.getPropertyFromSolution(name);
        if (type == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "PropertyDefinitionType");
            throw new AcmException(msg);
        }
        CmisPropertyDefinitionType cloneType = this.cloneProperty(type);
        if (cloneType == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "cloneProperty");
            throw new AcmException(msg);
        }
        this.setPropertyValue(cloneType, js);
        return cloneType;
    }

    private CmisPropertyDefinitionType cloneProperty(CmisPropertyDefinitionType type) {
        CmisPropertyIntegerDefinitionType cloneType = null;
        if (type.getPropertyType() == EnumPropertyType.INTEGER) {
            cloneType = new CmisPropertyIntegerDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.BOOLEAN) {
            cloneType = new CmisPropertyBooleanDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.DATETIME) {
            cloneType = new CmisPropertyDateTimeDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.DECIMAL) {
            cloneType = new CmisPropertyDecimalDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.HTML) {
            cloneType = new CmisPropertyHtmlDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.ID) {
            cloneType = new CmisPropertyIdDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.STRING) {
            cloneType = new CmisPropertyStringDefinitionType();
        } else if (type.getPropertyType() == EnumPropertyType.URI) {
            cloneType = new CmisPropertyUriDefinitionType();
        } else {
            log.warn((Object)" check the doc prop type");
            cloneType = null;
        }
        if (cloneType == null) {
            return null;
        }
        cloneType.setCardinality(type.getCardinality());
        cloneType.setDescription(type.getDescription());
        cloneType.setDisplayName(type.getDisplayName());
        cloneType.setId(type.getId());
        cloneType.setLocalName(type.getLocalName());
        cloneType.setOpenChoice(type.isOpenChoice());
        cloneType.setOrderable(type.isOrderable());
        cloneType.setPropertyType(type.getPropertyType());
        cloneType.setQueryable(type.isQueryable());
        cloneType.setQueryName(type.getQueryName());
        cloneType.setRequired(type.isRequired());
        cloneType.setUpdatability(type.getUpdatability());
        return cloneType;
    }

    private CmisPropertyDefinitionType getPropertyFromSolution(String propName) {
        for (CmisPropertyDefinitionType type : this.solnType.getProperties().getPropertyDefinition()) {
            if (!propName.equals(type.getLocalName())) continue;
            return type;
        }
        return null;
    }

    private void setPropertyValue(CmisPropertyDefinitionType type, JSONObject js) throws AcmException {
        Object defaultValue = null;
        try {
            String defVal = null;
            Object tempObj = null;
            if (js.get((Object)"defaultValue") != null) {
                JSONObject jsob;
                CmisPropertyInteger cbp;
                tempObj = js.get((Object)"defaultValue");
                defVal = tempObj.toString();
                log.trace((Object)("default value of prop at doc level :: " + defVal));
                if (type.getPropertyType() == EnumPropertyType.INTEGER) {
                    cbp = new CmisPropertyInteger();
                    if (defVal != null && (defaultValue = (jsob = (JSONObject)tempObj).get((Object)"value")) != null) {
                        Long l = Long.parseLong(defaultValue.toString());
                        cbp.getValue().add(BigInteger.valueOf(l));
                        ((CmisPropertyIntegerDefinitionType)type).setDefaultValue(cbp);
                    }
                } else if (type.getPropertyType() == EnumPropertyType.BOOLEAN) {
                    cbp = new CmisPropertyBoolean();
                    cbp.setLocalName(type.getLocalName());
                    if (defVal != null && (defaultValue = (jsob = (JSONObject)tempObj).get((Object)"value")) != null) {
                        cbp.getValue().add(Boolean.parseBoolean(defaultValue.toString()));
                        ((CmisPropertyBooleanDefinitionType)type).setDefaultValue((CmisPropertyBoolean)cbp);
                    }
                } else if (type.getPropertyType() == EnumPropertyType.DATETIME) {
                    cbp = new CmisPropertyDateTime();
                    if (defVal != null && (defaultValue = (jsob = (JSONObject)tempObj).get((Object)"value")) != null) {
                        XMLGregorianCalendar cal = DateTime.getXMLGregorianCalendar(defaultValue.toString());
                        cbp.getValue().add(cal);
                        ((CmisPropertyDateTimeDefinitionType)type).setDefaultValue((CmisPropertyDateTime)cbp);
                    }
                } else if (type.getPropertyType() == EnumPropertyType.DECIMAL) {
                    cbp = new CmisPropertyDecimal();
                    if (defVal != null && (defaultValue = (jsob = (JSONObject)tempObj).get((Object)"value")) != null) {
                        Double d = Double.valueOf(defaultValue.toString());
                        cbp.getValue().add(BigDecimal.valueOf(d));
                        ((CmisPropertyDecimalDefinitionType)type).setDefaultValue((CmisPropertyDecimal)cbp);
                    }
                } else if (type.getPropertyType() != EnumPropertyType.HTML && type.getPropertyType() != EnumPropertyType.ID) {
                    if (type.getPropertyType() == EnumPropertyType.STRING) {
                        cbp = new CmisPropertyString();
                        if (defVal != null && (defaultValue = (jsob = (JSONObject)tempObj).get((Object)"value")) != null) {
                            cbp.getValue().add(defaultValue.toString());
                            ((CmisPropertyStringDefinitionType)type).setDefaultValue((CmisPropertyString)cbp);
                        }
                    } else if (type.getPropertyType() == EnumPropertyType.URI) {
                        // empty if block
                    }
                }
            }
            if (js.get((Object)"hidden") != null) {
                tempObj = js.get((Object)"hidden");
                String hidden = tempObj.toString();
                boolean casehid = Boolean.parseBoolean(hidden);
                Hidden h = new Hidden(Boolean.valueOf(casehid));
                type.getAny().add(h);
            }
            if (js.get((Object)"updatability") != null) {
                tempObj = js.get((Object)"updatability");
                type.setUpdatability(EnumUpdatability.fromValue((String)tempObj.toString()));
            }
            if (js.get((Object)"required") != null) {
                tempObj = js.get((Object)"required");
                Boolean breq = false;
                if (tempObj.toString().equals("true")) {
                    breq = true;
                }
                type.setRequired(breq.booleanValue());
                log.trace((Object)("value of breq :: " + breq));
            }
            if (js.get((Object)"fromTemplate") != null) {
                tempObj = js.get((Object)"fromTemplate");
                boolean casehid = Boolean.parseBoolean(tempObj.toString());
                FromTemplate h = new FromTemplate(Boolean.valueOf(casehid));
                type.getAny().add(h);
            }
        }
        catch (ClassCastException e) {
            log.error((Object)"error ::", (Throwable)e);
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
    }
}

