/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.filenet.api.util.Id;
import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.type.Column;
import com.ibm.acm.sold.common.type.Filter;
import com.ibm.acm.sold.common.type.InbasketType;
import com.ibm.acm.sold.common.type.InbasketsType;
import com.ibm.acm.sold.common.type.RoleInbasketsType;
import com.ibm.acm.sold.common.type.RoleType;
import com.ibm.acm.sold.common.type.RolesType;
import com.ibm.acm.sold.common.type.TypeState;
import com.ibm.acm.sold.converter.AcmCaseRolePageName;
import com.ibm.acm.sold.converter.AcmCaseStructure;
import com.ibm.acm.sold.converter.AcmChoiceList;
import com.ibm.acm.sold.converter.AcmChoiceListType;
import com.ibm.acm.sold.converter.AcmDocType;
import com.ibm.acm.sold.converter.AcmInbox;
import com.ibm.acm.sold.converter.AcmOneBPMInfo;
import com.ibm.acm.sold.converter.AcmProcessActivity;
import com.ibm.acm.sold.converter.AcmRoleInbasket;
import com.ibm.acm.sold.converter.DateTime;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmUnhandledKeyException;
import com.ibm.acm.sold.jaxb.JAXBSingleton;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseStructureType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ContentType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumHashTimePattern;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumIconType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumIntegrationType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumTaskGroupMode;
import com.ibm.xmlns.prod.ecm.acm.sdf.GroupType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ObjectFactory;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.RolePageNamesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskGroupType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TasksType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TypeDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ViewType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ViewsType;
import com.ibm.xmlns.prod.ecm.cmis.caseextensions.FromTemplate;
import com.ibm.xmlns.prod.ecm.cmis.caseextensions.Hidden;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBooleanDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTime;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDateTimeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimal;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDecimalDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyInteger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyString;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyStringDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumCardinality;
import org.oasis_open.docs.ns.cmis.core._200908.EnumPropertyType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumUpdatability;

public class AcmConverter {
    private static final Log log = LogFactory.getLog((String)AcmConverter.class.getName());
    private SolutionType solntype;
    private SolutionData solData;
    private RolesType roles;
    private String jsonStr;
    private PropertyDefinitionsType props;
    private InbasketsType inbaskets;
    private Thread helperThread = null;
    private AcmException acmEx;

    public SolutionType getSolutionType() throws AcmException {
        CBLogger.trace(log, "<getSolutionType");
        if (this.helperThread != null) {
            try {
                if (this.acmEx != null) {
                    throw new AcmException(this.acmEx);
                }
                this.helperThread.join();
                CBLogger.debug(log, "helperThread finished job");
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                throw new AcmException(e);
            }
            this.helperThread = null;
        }
        CBLogger.trace(log, "<getSolutionType");
        return this.solntype;
    }

    public void setSolutionType(SolutionType st) {
        CBLogger.trace(log, ">setSolutionType");
        this.solntype = st;
        CBLogger.trace(log, "<setSolutionType");
    }

    public PropertyDefinitionsType getProperties() {
        CBLogger.trace(log, ">getProperties");
        return this.props;
    }

    public InputStream getConverterdXMLStream() throws AcmException {
        CBLogger.trace(log, ">getConvertedXMLStream");
        JAXBSingleton js = JAXBSingleton.getSingleton();
        ObjectFactory factory = new ObjectFactory();
        InputStream inputStream = null;
        try {
            inputStream = js.writeOutput(factory.createSolution(this.solntype));
        }
        catch (JAXBException e) {
            log.error((Object)"JaxB Exception", (Throwable)e);
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<getConvertedXMLStream");
        return inputStream;
    }

    public AcmConverter(SolutionData solData) {
        this.solData = solData;
        this.solntype = new SolutionType();
        if (solData.getRoles() == null) {
            solData.setRoles(new RolesType());
        }
        this.roles = solData.getRoles();
        if (solData.getInbaskets() == null) {
            solData.setInbaskets(new InbasketsType());
        }
        this.inbaskets = solData.getInbaskets();
        this.props = new PropertyDefinitionsType();
        this.acmEx = null;
    }

    public AcmConverter(String json, SolutionData solData) {
        this.solData = solData;
        this.solntype = new SolutionType();
        if (solData.getRoles() == null) {
            solData.setRoles(new RolesType());
        }
        this.roles = solData.getRoles();
        if (solData.getInbaskets() == null) {
            solData.setInbaskets(new InbasketsType());
        }
        this.inbaskets = solData.getInbaskets();
        this.props = new PropertyDefinitionsType();
        this.jsonStr = json;
        this.acmEx = null;
    }

    public void convertJsonToXml() throws AcmException {
        CBLogger.trace(log, ">ConvertJsonToXml");
        JsonToXmlHelperThread jsonToXmlHelperThread = new JsonToXmlHelperThread();
        this.helperThread = new Thread(jsonToXmlHelperThread);
        this.helperThread.start();
        CBLogger.debug(log, "helperThread started job");
        CBLogger.trace(log, "<ConvertJsonToXml");
    }

    public void processCaseTypeElement(Object json) throws AcmException {
        CBLogger.trace(log, ">processCaseTypeElement");
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                this.iterateCase(jsob);
            } else {
                JSONArray ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    CBLogger.debug(log, js.toString());
                    this.iterateCase(js);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<processCaseTypeElement");
    }

    public void iterateCase(JSONObject js) throws AcmException {
        CaseTypeData ctData;
        CBLogger.trace(log, ">iterateCase");
        CaseTypeType ct = new CaseTypeType();
        ViewsType vts = new ViewsType();
        ct.setViews(vts);
        TasksType acts = new TasksType();
        ct.setTasks(acts);
        PropertyDefinitionsType caseProps = new PropertyDefinitionsType();
        ct.setCaseProperties(caseProps);
        ct.setId("");
        boolean createGuid = false;
        Object tempObj = js.get((Object)"name");
        if (tempObj != null) {
            ct.setName(tempObj.toString());
            ct.setHashTimePattern(EnumHashTimePattern.YYYY_MM_DD_HH);
        }
        if ((tempObj = js.get((Object)"description")) != null) {
            ct.setDescription(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"caseProperties")) != null) {
            CBLogger.debug(log, "properties:" + tempObj.toString());
            JSONObject props1 = null;
            try {
                props1 = (JSONObject)tempObj;
                CBLogger.debug(log, "case property string going to the getcasepropname" + props1.get((Object)"property").toString());
                this.getCasePropName(caseProps, props1.get((Object)"property"));
            }
            catch (ClassCastException e) {
                Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
                throw new AcmException(msg, (Throwable)e);
            }
        }
        if ((tempObj = js.get((Object)"views")) != null) {
            JSONObject casejs = null;
            try {
                casejs = (JSONObject)tempObj;
                Object views = casejs.get((Object)"view");
                this.processViewTypeElement(views, vts);
            }
            catch (ClassCastException e) {
                Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
                throw new AcmException(msg, (Throwable)e);
            }
        }
        if ((tempObj = js.get((Object)"caseStructure")) != null) {
            CaseStructureType caseStructure = new CaseStructureType();
            ct.setCaseStructure(caseStructure);
            AcmCaseStructure casestut = new AcmCaseStructure(ct, tempObj);
            casestut.process();
        }
        if ((tempObj = js.get((Object)"displayName")) != null) {
            ct.setDisplayName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"caseTitle")) != null) {
            String titelString = tempObj.toString();
            CBLogger.debug(log, "Case Title : " + titelString);
            ct.setCaseTitle(titelString);
        }
        if ((tempObj = js.get((Object)"tasks")) != null) {
            CBLogger.debug(log, tempObj.toString());
            try {
                this.processActivitiesTypeElement(tempObj, acts);
            }
            catch (IOException ioe) {
                Message msg = new Message("B4065E.ERROR_IO_EXCEPTION");
                throw new AcmException(msg, (Throwable)ioe);
            }
        }
        if ((tempObj = js.get((Object)"casePageName")) != null) {
            ct.setCasePageName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"caseCreationPageName")) != null) {
            ct.setCaseCreationPageName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"caseSplitPageName")) != null) {
            ct.setCaseSplitPageName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"designNote")) != null) {
            ct.setDesignNote(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"initiatingDocumentType")) != null) {
            ct.setInitiatingDocumentType(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"rolePageNames")) != null) {
            RolePageNamesType rps = new RolePageNamesType();
            ct.setRolePageNames(rps);
            JSONObject rolepjs = null;
            try {
                rolepjs = (JSONObject)tempObj;
                Object rolePages = rolepjs.get((Object)"rolePageName");
                AcmCaseRolePageName acrp = new AcmCaseRolePageName(rolePages, rps);
                acrp.processRolePageNameElement();
            }
            catch (ClassCastException e) {
                Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
                throw new AcmException(msg, (Throwable)e);
            }
        }
        if ((tempObj = js.get((Object)"id")) != null) {
            String caseid = tempObj.toString();
            if (caseid.equalsIgnoreCase("-1")) {
                createGuid = true;
            } else {
                ct.setId(caseid);
                createGuid = false;
            }
        }
        if ((tempObj = js.get((Object)"copyDocumentProperties")) != null) {
            String copyDocpropFlag = tempObj.toString();
            CBLogger.debug(log, "CaseType CopyDocumentProperties flag :" + copyDocpropFlag);
            ct.setCopyDocumentProperties(Boolean.valueOf(Boolean.parseBoolean(copyDocpropFlag)));
        }
        if ((tempObj = js.get((Object)"processDefinition")) != null) {
            String processDef = tempObj.toString();
            ContentType cnt = new ContentType();
            cnt.setContentId(processDef);
            ct.setProcessDefinition(cnt);
        }
        if (createGuid && ct.getName() != null) {
            String guid = this.solData.checkCreateCaseTypeGuid(ct.getName());
            ct.setId(guid);
        }
        if ((ctData = this.solData.getCasetypedata(ct.getName())) == null) {
            ctData = new CaseTypeData(ct.getName(), ct.getId(), this.solData);
            this.solData.setCasetypedata(ct.getName(), ctData);
        }
        this.solntype.getCaseTypes().getCaseType().add(ct);
        CBLogger.trace(log, "<iterateCase");
    }

    public void processViewTypeElement(Object json, ViewsType vts) throws AcmException {
        CBLogger.trace(log, ">processViewTypeElement");
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                this.iterateView(jsob, vts);
            } else {
                JSONArray ja = null;
                ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    CBLogger.trace(log, js.toString());
                    this.iterateView(js, vts);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<processViewTypeElement");
    }

    public void iterateView(JSONObject js, ViewsType vts) throws AcmException {
        CBLogger.trace(log, ">iterateView");
        ViewType vt = new ViewType();
        Object tempObj = js.get((Object)"id");
        if (tempObj != null) {
            CBLogger.trace(log, tempObj.toString());
            vt.setId(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"group")) != null) {
            CBLogger.trace(log, tempObj.toString());
            this.processCaseGroups(tempObj, vt);
        }
        if ((tempObj = js.get((Object)"propertyId")) != null) {
            CBLogger.trace(log, tempObj.toString());
            this.processViewProperty(tempObj.toString(), vt);
        }
        vts.getView().add(vt);
        CBLogger.trace(log, "<iterateView");
    }

    public void processCaseGroups(Object json, ViewType vt) throws AcmException {
        CBLogger.trace(log, ">processDataViewGroups");
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                GroupType gp = this.iterateCaseGroup(jsob);
                vt.getGroup().add(gp);
            } else {
                JSONArray ja = null;
                ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    GroupType gp = this.iterateCaseGroup(js);
                    vt.getGroup().add(gp);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<processDataViewGroups");
    }

    public GroupType iterateCaseGroup(JSONObject js) throws AcmUnhandledKeyException {
        CBLogger.trace(log, ">iterateInboxFilter");
        GroupType gp = new GroupType();
        gp.setOpenState(false);
        Object tempObject = js.get((Object)"name");
        if (tempObject != null) {
            gp.setName(tempObject.toString());
        }
        if ((tempObject = js.get((Object)"openState")) != null) {
            gp.setOpenState(Boolean.parseBoolean(tempObject.toString()));
        }
        if ((tempObject = js.get((Object)"propertyId")) != null) {
            this.processViewProperty(tempObject.toString(), gp);
        }
        return gp;
    }

    public void processViewProperty(String property, GroupType gp) {
        CBLogger.trace(log, ">processViewProperty");
        if (property.charAt(0) == '[') {
            String[] tokens;
            StringBuilder sb = new StringBuilder(property);
            sb.deleteCharAt(0);
            sb.deleteCharAt(sb.length() - 1);
            sb.trimToSize();
            property = sb.toString();
            for (String s : tokens = property.split(",")) {
                s = s.trim();
                gp.getPropertyId().add(s);
            }
        } else {
            gp.getPropertyId().add(property);
        }
        CBLogger.trace(log, "<processViewProperty");
    }

    public void processViewProperty(String property, ViewType vt) {
        CBLogger.trace(log, ">processViewProperty");
        if (property.charAt(0) == '[') {
            String[] tokens;
            StringBuilder sb = new StringBuilder(property);
            sb.deleteCharAt(0);
            sb.deleteCharAt(sb.length() - 1);
            sb.trimToSize();
            property = sb.toString();
            for (String s : tokens = property.split(",")) {
                s = s.trim();
                vt.getPropertyId().add(s);
            }
        } else {
            vt.getPropertyId().add(property);
        }
        CBLogger.trace(log, "<processViewProperty");
    }

    public void getCasePropName(PropertyDefinitionsType caseProps, Object json) throws AcmException {
        CBLogger.trace(log, ">getCasePropName");
        String s = "";
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                s = jsob.get((Object)"localName").toString();
                for (CmisPropertyDefinitionType type : this.props.getPropertyDefinition()) {
                    CBLogger.debug(log, "property name" + type.getLocalName());
                    if (!s.equalsIgnoreCase(type.getLocalName())) continue;
                    EnumPropertyType cpt = type.getPropertyType();
                    this.iterateCaseProperty(caseProps, cpt, jsob, type);
                }
            } else {
                JSONArray ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    CBLogger.trace(log, js.toString());
                    s = js.get((Object)"localName").toString();
                    for (CmisPropertyDefinitionType type : this.props.getPropertyDefinition()) {
                        CBLogger.trace(log, "property name" + type.getLocalName());
                        if (!s.equals(type.getLocalName())) continue;
                        EnumPropertyType cpt = type.getPropertyType();
                        this.iterateCaseProperty(caseProps, cpt, js, type);
                    }
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<getCasePropName");
    }

    public void iterateCaseProperty(PropertyDefinitionsType caseProps, EnumPropertyType cpt, JSONObject js, CmisPropertyDefinitionType type) throws AcmException {
        CBLogger.trace(log, ">iterateCaseProperty");
        String defVal = null;
        try {
            CmisPropertyBooleanDefinitionType p;
            Object defaultValue1 = js.get((Object)"defaultValue");
            Object defaultValue = null;
            if (defaultValue1 != null) {
                JSONObject jsob = (JSONObject)defaultValue1;
                defaultValue = jsob.get((Object)"value");
            }
            if (cpt.toString().equalsIgnoreCase("boolean")) {
                p = new CmisPropertyBooleanDefinitionType();
                p.setPropertyType(EnumPropertyType.BOOLEAN);
                this.setCaseProperty(js, (CmisPropertyDefinitionType)p, type);
                CmisPropertyBoolean cbp = new CmisPropertyBoolean();
                if (defaultValue != null) {
                    defVal = defaultValue.toString();
                    cbp.getValue().add(Boolean.parseBoolean(defVal));
                    p.setDefaultValue(cbp);
                }
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("string")) {
                p = new CmisPropertyStringDefinitionType();
                p.setPropertyType(EnumPropertyType.STRING);
                this.setCaseProperty(js, (CmisPropertyDefinitionType)p, type);
                CmisPropertyString cbp = new CmisPropertyString();
                if (defaultValue != null) {
                    defVal = defaultValue.toString();
                    cbp.getValue().add(defVal);
                    p.setDefaultValue(cbp);
                }
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("datetime")) {
                p = new CmisPropertyDateTimeDefinitionType();
                p.setPropertyType(EnumPropertyType.DATETIME);
                this.setCaseProperty(js, (CmisPropertyDefinitionType)p, type);
                CmisPropertyDateTime cbp = new CmisPropertyDateTime();
                if (defaultValue != null) {
                    XMLGregorianCalendar cal = DateTime.getXMLGregorianCalendar(defaultValue.toString());
                    cbp.getValue().add(cal);
                    p.setDefaultValue(cbp);
                }
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("decimal")) {
                p = new CmisPropertyDecimalDefinitionType();
                p.setPropertyType(EnumPropertyType.DECIMAL);
                this.setCaseProperty(js, (CmisPropertyDefinitionType)p, type);
                CmisPropertyDecimal cbp = new CmisPropertyDecimal();
                if (defaultValue != null) {
                    Double d = Double.valueOf(defaultValue.toString());
                    cbp.getValue().add(BigDecimal.valueOf(d));
                    p.setDefaultValue(cbp);
                }
                caseProps.getPropertyDefinition().add(p);
            } else if (cpt.toString().equalsIgnoreCase("integer")) {
                p = new CmisPropertyIntegerDefinitionType();
                p.setPropertyType(EnumPropertyType.INTEGER);
                this.setCaseProperty(js, (CmisPropertyDefinitionType)p, type);
                CmisPropertyInteger cbp = new CmisPropertyInteger();
                if (defaultValue != null) {
                    defVal = defaultValue.toString();
                    Long l = Long.parseLong(defVal.toString());
                    cbp.getValue().add(BigInteger.valueOf(l));
                    p.setDefaultValue(cbp);
                }
                caseProps.getPropertyDefinition().add(p);
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
    }

    public void setCaseProperty(JSONObject js, CmisPropertyDefinitionType p, CmisPropertyDefinitionType type) throws AcmUnhandledKeyException {
        Object tempObj;
        CBLogger.trace(log, ">setCaseProperty");
        p.setCardinality(type.getCardinality());
        p.setRequired(type.isRequired());
        p.setOpenChoice(Boolean.valueOf(false));
        p.setInherited(Boolean.valueOf(false));
        p.setOrderable(true);
        p.setQueryable(true);
        p.setDescription(type.getDescription());
        p.setUpdatability(type.getUpdatability());
        if (type.getLocalName() != null) {
            p.setLocalName(type.getLocalName());
        }
        if (type.getDisplayName() != null) {
            p.setDisplayName(type.getDisplayName());
        }
        if (type.getId() != null) {
            p.setId(type.getId());
        }
        if ((tempObj = js.get((Object)"localName")) != null) {
            CBLogger.debug(log, "Name :" + tempObj.toString());
        }
        if ((tempObj = js.get((Object)"updatability")) != null) {
            CBLogger.debug(log, "readonly :" + tempObj.toString());
            p.setUpdatability(EnumUpdatability.fromValue((String)tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"required")) != null) {
            CBLogger.debug(log, "in case required :" + tempObj.toString());
            String req = tempObj.toString();
            boolean casereq = Boolean.parseBoolean(req);
            p.setRequired(casereq);
        }
        if ((tempObj = js.get((Object)"hidden")) != null) {
            String hidden = tempObj.toString();
            boolean casehid = Boolean.parseBoolean(hidden);
            Hidden h = new Hidden(Boolean.valueOf(casehid));
            p.getAny().add(h);
        }
        if ((tempObj = js.get((Object)"fromTemplate")) != null) {
            String temp = tempObj.toString();
            boolean tempFlag = Boolean.parseBoolean(temp);
            FromTemplate ft = new FromTemplate(Boolean.valueOf(tempFlag));
            p.getAny().add(ft);
        }
        if ((tempObj = js.get((Object)"id")) != null) {
            String pid = tempObj.toString();
            if (pid.equalsIgnoreCase("-1")) {
                p.setId(Id.createId().toString());
            } else {
                p.setId(pid);
            }
        }
    }

    public void processActivitiesTypeElement(Object json, TasksType actstype) throws IOException, AcmException {
        JSONArray ja;
        CBLogger.trace(log, ">>processActivityTypeElement");
        CBLogger.debug(log, json.toString());
        JSONObject jsob = (JSONObject)json;
        Object tempObj = jsob.get((Object)"taskGroup");
        if (tempObj != null) {
            String grjs = tempObj.toString();
            int grid = 1;
            CBLogger.debug(log, grjs);
            if (grjs != null) {
                if (grjs.startsWith("{")) {
                    JSONObject grjsob = (JSONObject)tempObj;
                    this.iterateActivityGroup(grjsob, actstype, grid);
                } else {
                    ja = (JSONArray)tempObj;
                    for (JSONObject js : ja) {
                        CBLogger.debug(log, js.toString());
                        this.iterateActivityGroup(js, actstype, grid);
                        ++grid;
                    }
                }
            }
        }
        if ((tempObj = jsob.get((Object)"task")) != null) {
            String actjs = jsob.get((Object)"task").toString();
            CBLogger.debug(log, actjs);
            if (actjs != null) {
                AcmProcessActivity procActivity = new AcmProcessActivity(this.solData);
                if (actjs.startsWith("{")) {
                    JSONObject actjsob = (JSONObject)tempObj;
                    Object[] keys1 = actjsob.keySet().toArray();
                    procActivity.updateActivityTypeDataFromJson(keys1, actjsob, actstype);
                } else {
                    ja = (JSONArray)tempObj;
                    for (JSONObject js : ja) {
                        CBLogger.debug(log, js.toString());
                        Object[] keys = js.keySet().toArray();
                        procActivity.updateActivityTypeDataFromJson(keys, js, actstype);
                    }
                }
            }
        }
        CBLogger.trace(log, "<<processActivityTypeElement");
    }

    public void iterateActivityGroup(JSONObject js, TasksType actsType, int grid) throws AcmUnhandledKeyException {
        CBLogger.trace(log, ">>iterateActivityGroup");
        TaskGroupType agt = new TaskGroupType();
        Object tempObj = js.get((Object)"name");
        if (tempObj != null) {
            agt.setName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"description")) != null) {
            agt.setDescription(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"groupMode")) != null) {
            EnumTaskGroupMode mode = EnumTaskGroupMode.fromValue((String)tempObj.toString());
            agt.setGroupMode(mode);
        }
        BigInteger id = BigInteger.valueOf(Integer.valueOf(grid).intValue());
        agt.setId(id);
        actsType.getTaskGroup().add(agt);
        CBLogger.trace(log, "<<iterateActivityGroup");
    }

    public void processRoleTypeElement(Object json) throws AcmException {
        CBLogger.trace(log, ">processRoleTypeElement");
        try {
            if (json.toString().startsWith("{")) {
                JSONObject jsob = (JSONObject)json;
                this.iterateRole(jsob);
            } else {
                JSONArray ja = (JSONArray)json;
                for (JSONObject js : ja) {
                    CBLogger.debug(log, js.toString());
                    this.iterateRole(js);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<processRoleTypeElement");
    }

    public void iterateRole(JSONObject js) throws AcmException {
        CBLogger.trace(log, ">iterateRole");
        RoleType rt = new RoleType();
        Object tempObj = js.get((Object)"index");
        Integer index = null;
        if (tempObj != null) {
            index = Integer.parseInt(tempObj.toString());
            rt = this.roles.getRoleTable().get(index);
            if (rt == null) {
                rt = new RoleType();
                rt.setState(TypeState.EnumTypeState.NEW);
            } else {
                rt.setState(TypeState.EnumTypeState.PERSISTED);
            }
        } else {
            rt = new RoleType();
            rt.setState(TypeState.EnumTypeState.NEW);
        }
        boolean foundRoleDesc = false;
        tempObj = js.get((Object)"name");
        if (tempObj != null) {
            CBLogger.debug(log, "Name :" + tempObj.toString());
            String rolename = tempObj.toString();
            if (!rolename.equals(rt.getName())) {
                rt.setOldName(rt.getName());
                rt.setName(rolename);
                if (rt.getState() == TypeState.EnumTypeState.PERSISTED) {
                    rt.setState(TypeState.EnumTypeState.MODIFIED);
                }
            }
        }
        if ((tempObj = js.get((Object)"description")) != null) {
            foundRoleDesc = true;
            String roledesc = tempObj.toString();
            rt.setDescription(roledesc);
        }
        if ((tempObj = js.get((Object)"primaryQueue")) != null) {
            rt.setPrimaryQueue(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"personalInbasketType")) != null) {
            rt.setPersonalInbasketType(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"ECM_canAssignWork")) != null) {
            rt.setCanAssignWork(Boolean.parseBoolean(tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"ECM_canMoveWorkToPersonalInBasket")) != null) {
            rt.setCanMoveWorkToPersonalInBasket(Boolean.parseBoolean(tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"ECM_viewAssignedWorkInBasket")) != null) {
            rt.setViewAssignedWorkInBasket(Boolean.parseBoolean(tempObj.toString()));
        }
        if ((tempObj = js.get((Object)"inbaskets")) != null) {
            ArrayList<RoleInbasketsType> inbaskets = new ArrayList<RoleInbasketsType>(100);
            rt.setRoleInbasketsType(inbaskets);
            AcmRoleInbasket roleInbaskets = new AcmRoleInbasket(tempObj, inbaskets, rt);
            roleInbaskets.processRoleInbasket();
        }
        if (!foundRoleDesc) {
            CBLogger.debug(log, "couldnt find the role desc");
            rt.setDescription("");
        }
        Integer last2 = 0;
        Set<Integer> keys = this.roles.getRoleTable().keySet();
        for (Integer last2 : keys) {
        }
        if (rt.getState() == TypeState.EnumTypeState.NEW) {
            this.roles.getRoleTable().put(last2 + 1, rt);
        }
        CBLogger.trace(log, "<iterateRole");
    }

    public void processPropertiesElement(Object jsob) throws AcmException {
        CBLogger.trace(log, ">processPropertiesElement");
        try {
            if (jsob.toString().startsWith("{")) {
                JSONObject property = (JSONObject)jsob;
                this.iterateProperty(property);
            } else {
                JSONArray ja = (JSONArray)jsob;
                for (JSONObject js : ja) {
                    CBLogger.debug(log, js.toString());
                    this.iterateProperty(js);
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<processPropertiesElement");
    }

    public void iterateProperty(JSONObject js) throws AcmException {
        CBLogger.trace(log, ">iterateProperty");
        Object defaultValue1 = js.get((Object)"defaultValue");
        Object choice = js.get((Object)"choice");
        Object defaultValue = null;
        try {
            CmisPropertyBooleanDefinitionType p;
            if (defaultValue1 != null) {
                JSONObject jsob = (JSONObject)defaultValue1;
                defaultValue = jsob.get((Object)"value");
            }
            if (js.get((Object)"propertyType").toString().equalsIgnoreCase("boolean")) {
                p = new CmisPropertyBooleanDefinitionType();
                p.setPropertyType(EnumPropertyType.BOOLEAN);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, js);
                CmisPropertyBoolean cbp = new CmisPropertyBoolean();
                if (defaultValue != null) {
                    String defVal = defaultValue.toString();
                    cbp.getValue().add(Boolean.parseBoolean(defVal));
                }
                p.setDefaultValue(cbp);
                this.props.getPropertyDefinition().add(p);
            } else if (js.get((Object)"propertyType").toString().equalsIgnoreCase("string")) {
                p = new CmisPropertyStringDefinitionType();
                p.setPropertyType(EnumPropertyType.STRING);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, js);
                CmisPropertyString cbp = new CmisPropertyString();
                if (defaultValue != null) {
                    cbp.getValue().add(defaultValue.toString());
                }
                p.setDefaultValue(cbp);
                Object mxl = js.get((Object)"maxLength");
                if (mxl != null) {
                    String maxLength = mxl.toString();
                    long parseLong = Long.parseLong(maxLength.toString());
                    Long mxlen = parseLong;
                    p.setMaxLength(BigInteger.valueOf(mxlen));
                }
                if (choice != null) {
                    AcmChoiceList acl = new AcmChoiceList(choice);
                    acl.processChoiceListString((CmisPropertyStringDefinitionType)p);
                }
                this.props.getPropertyDefinition().add(p);
            } else if (js.get((Object)"propertyType").toString().equalsIgnoreCase("datetime")) {
                p = new CmisPropertyDateTimeDefinitionType();
                p.setPropertyType(EnumPropertyType.DATETIME);
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, js);
                CmisPropertyDateTime cbp = new CmisPropertyDateTime();
                if (defaultValue != null) {
                    XMLGregorianCalendar cal = DateTime.getXMLGregorianCalendar(defaultValue.toString());
                    cbp.getValue().add(cal);
                }
                p.setDefaultValue(cbp);
                this.props.getPropertyDefinition().add(p);
            } else if (js.get((Object)"propertyType").toString().equalsIgnoreCase("decimal")) {
                Object mn;
                p = new CmisPropertyDecimalDefinitionType();
                p.setPropertyType(EnumPropertyType.DECIMAL);
                Object mx = js.get((Object)"maxValue");
                if (mx != null) {
                    String maxVal = mx.toString();
                    Double mxv = Double.valueOf(maxVal.toString());
                    p.setMaxValue(BigDecimal.valueOf(mxv));
                }
                if ((mn = js.get((Object)"minValue")) != null) {
                    String minVal = mn.toString();
                    Double mv = Double.valueOf(minVal.toString());
                    p.setMinValue(BigDecimal.valueOf(mv));
                }
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, js);
                CmisPropertyDecimal cbp = new CmisPropertyDecimal();
                if (defaultValue != null) {
                    Double d = Double.valueOf(defaultValue.toString());
                    cbp.getValue().add(BigDecimal.valueOf(d));
                }
                p.setDefaultValue(cbp);
                this.props.getPropertyDefinition().add(p);
            } else if (js.get((Object)"propertyType").toString().equalsIgnoreCase("integer")) {
                Object mn;
                p = new CmisPropertyIntegerDefinitionType();
                p.setPropertyType(EnumPropertyType.INTEGER);
                Object mx = js.get((Object)"maxValue");
                if (mx != null) {
                    String maxVal = mx.toString();
                    Long mxl = Long.parseLong(maxVal.toString());
                    p.setMaxValue(BigInteger.valueOf(mxl));
                }
                if ((mn = js.get((Object)"minValue")) != null) {
                    String minVal = mn.toString();
                    Long ml = Long.parseLong(minVal.toString());
                    p.setMinValue(BigInteger.valueOf(ml));
                }
                this.setCommonPropertyFields((CmisPropertyDefinitionType)p, js);
                CmisPropertyInteger cbp = new CmisPropertyInteger();
                if (defaultValue != null) {
                    Long l = Long.parseLong(defaultValue.toString());
                    cbp.getValue().add(BigInteger.valueOf(l));
                }
                if (choice != null) {
                    AcmChoiceList acl = new AcmChoiceList(choice);
                    acl.processChoiceListInteger((CmisPropertyIntegerDefinitionType)p);
                }
                p.setDefaultValue(cbp);
                this.props.getPropertyDefinition().add(p);
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        this.solntype.setProperties(this.props);
        CBLogger.trace(log, "<iterateProperty");
    }

    public void setCommonPropertyFields(CmisPropertyDefinitionType p, JSONObject js) throws AcmUnhandledKeyException {
        CBLogger.trace(log, ">setCommonPropertyFields");
        p.setCardinality(EnumCardinality.SINGLE);
        p.setUpdatability(EnumUpdatability.READWRITE);
        p.setOpenChoice(Boolean.valueOf(false));
        p.setRequired(false);
        p.setInherited(Boolean.valueOf(false));
        p.setOrderable(true);
        p.setQueryable(true);
        p.setId("");
        boolean createGuid = false;
        Object tempObj = js.get((Object)"displayName");
        if (tempObj != null) {
            p.setDisplayName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"description")) != null) {
            p.setDescription(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"cardinality")) != null) {
            if (tempObj.toString().equalsIgnoreCase("Single")) {
                p.setCardinality(EnumCardinality.SINGLE);
            } else if (tempObj.toString().equalsIgnoreCase("Multi")) {
                p.setCardinality(EnumCardinality.MULTI);
            }
            CBLogger.debug(log, "Prop cardinality******** :" + tempObj.toString());
        }
        if ((tempObj = js.get((Object)"minValue")) != null) {
            CBLogger.debug(log, "prop min value:" + tempObj.toString());
        }
        if ((tempObj = js.get((Object)"maxValue")) != null) {
            CBLogger.debug(log, "prop max value:" + tempObj.toString());
        }
        if ((tempObj = js.get((Object)"maxLength")) != null) {
            CBLogger.debug(log, "prop max length:" + tempObj.toString());
        }
        if ((tempObj = js.get((Object)"updatability")) != null && tempObj.toString().equalsIgnoreCase("readOnly")) {
            CBLogger.debug(log, "card......" + tempObj.toString());
            p.setUpdatability(EnumUpdatability.READONLY);
        }
        if ((tempObj = js.get((Object)"readWrite")) != null && tempObj.toString().equalsIgnoreCase("readWrite")) {
            CBLogger.debug(log, "card......" + tempObj.toString());
            p.setUpdatability(EnumUpdatability.READWRITE);
        }
        if ((tempObj = js.get((Object)"localName")) != null) {
            p.setLocalName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"id")) != null) {
            String pid = tempObj.toString();
            if (pid.equalsIgnoreCase("-1")) {
                createGuid = true;
            } else {
                p.setId(pid);
                createGuid = false;
            }
        }
        if ((tempObj = js.get((Object)"loocalNamespace")) != null) {
            p.setLocalNamespace(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"queryName")) != null) {
            p.setQueryName(tempObj.toString());
        }
        if ((tempObj = js.get((Object)"inherited")) != null) {
            boolean inb = Boolean.parseBoolean(tempObj.toString());
            p.setInherited(Boolean.valueOf(inb));
        }
        if ((tempObj = js.get((Object)"queryable")) != null) {
            boolean qb = Boolean.parseBoolean(tempObj.toString());
            p.setQueryable(qb);
        }
        if ((tempObj = js.get((Object)"orderable")) != null) {
            boolean ob = Boolean.parseBoolean(tempObj.toString());
            p.setOrderable(ob);
        }
        if ((tempObj = js.get((Object)"openChoice")) != null) {
            boolean opb = Boolean.parseBoolean(tempObj.toString());
            p.setOpenChoice(Boolean.valueOf(opb));
        }
        if ((tempObj = js.get((Object)"required")) != null) {
            boolean rqb = Boolean.parseBoolean(tempObj.toString());
            p.setRequired(rqb);
        }
        if ((tempObj = js.get((Object)"hidden")) != null) {
            boolean casehid = Boolean.parseBoolean(tempObj.toString());
            Hidden h = new Hidden(Boolean.valueOf(casehid));
            p.getAny().add(h);
        }
        if ((tempObj = js.get((Object)"fromTemplate")) != null) {
            boolean fromTemplateflag = Boolean.parseBoolean(tempObj.toString());
            FromTemplate ft = new FromTemplate(Boolean.valueOf(fromTemplateflag));
            p.getAny().add(ft);
        }
        if (createGuid && p.getLocalName() != null) {
            String guid = this.solData.checkCreatePropertyGuid(p.getLocalName());
            p.setId(guid);
        }
        CBLogger.trace(log, "<setCommonPropertyFields");
    }

    public void process(JSONObject js) throws AcmException, IOException {
        JSONObject props;
        Object innerTemp;
        JSONObject casejs;
        JSONObject properties;
        CBLogger.trace(log, ">Process");
        CaseTypesType caseTypes = new CaseTypesType();
        this.solntype.setCaseTypes(caseTypes);
        TypeDefinitionsType types = new TypeDefinitionsType();
        this.solntype.setTypes(types);
        this.solntype.setProperties(this.props);
        this.solntype.setIntegrationType(EnumIntegrationType.P_8);
        Object tempObject = js.get((Object)"name");
        this.solntype.setName(tempObject.toString());
        tempObject = js.get((Object)"description");
        if (tempObject != null) {
            this.solntype.setDescription(tempObject.toString());
        }
        if ((properties = (JSONObject)js.get((Object)"properties")) != null) {
            Object property = properties.get((Object)"property");
            CBLogger.debug(log, "Processing solution properties");
            this.processPropertiesElement(property);
        }
        if ((casejs = (JSONObject)js.get((Object)"caseTypes")) != null) {
            Object cases = casejs.get((Object)"caseType");
            CBLogger.debug(log, "Processing casetypes");
            this.processCaseTypeElement(cases);
        }
        if ((tempObject = js.get((Object)"roles")) != null) {
            CBLogger.debug(log, "processing roles");
            this.processRoleTypeElement(tempObject);
        }
        if ((tempObject = js.get((Object)"types")) != null) {
            AcmDocType docType = new AcmDocType(tempObject, this.solntype, this.solData);
            docType.process();
        }
        if (this.inbaskets == null) {
            this.inbaskets = new InbasketsType();
        }
        if ((tempObject = js.get((Object)"inbaskets")) != null) {
            AcmInbox acmInbox = new AcmInbox(tempObject, this.inbaskets);
            acmInbox.processInbasket();
        }
        ContentType ct = new ContentType();
        tempObject = js.get((Object)"icon");
        if (tempObject != null) {
            Object uri = ((JSONObject)tempObject).get((Object)"uri");
            if (uri != null) {
                ct.setUri(uri.toString());
            }
            this.solntype.setIcon(ct);
        }
        if ((tempObject = js.get((Object)"prefix")) != null) {
            this.solntype.setPrefix(tempObject.toString());
        }
        this.solntype.setIconType(EnumIconType.fromValue((String)"builtin"));
        tempObject = js.get((Object)"designNote");
        if (tempObject != null) {
            String dn = tempObject.toString();
            this.solntype.setDesignNote(dn);
        }
        if ((tempObject = js.get((Object)"defaultCasePageName")) != null) {
            String dfcasepg = tempObject.toString();
            this.solntype.setDefaultCasePageName(dfcasepg);
        }
        if ((tempObject = js.get((Object)"defaultStepPageName")) != null) {
            String dfsteppg = tempObject.toString();
            this.solntype.setDefaultStepPageName(dfsteppg);
        }
        if ((tempObject = js.get((Object)"choiceLists")) != null && (innerTemp = (props = (JSONObject)tempObject).get((Object)"choiceList")) != null) {
            ChoiceListDefinitionsType chlstdefs = new ChoiceListDefinitionsType();
            this.solntype.setChoiceLists(chlstdefs);
            AcmChoiceListType choiceLst = new AcmChoiceListType(innerTemp, this.solntype);
            choiceLst.setSolData(this.solData);
            choiceLst.update();
        }
        if ((tempObject = js.get((Object)"integrationType")) != null) {
            String integrationType = tempObject.toString();
            this.solntype.setIntegrationType(EnumIntegrationType.fromValue((String)integrationType));
        }
        if ((tempObject = js.get((Object)"processConfiguration")) != null) {
            String processConfig = tempObject.toString();
            ContentType ct1 = new ContentType();
            ct1.setContentId(processConfig);
            this.solntype.setProcessConfiguration(ct1);
        }
        if ((tempObject = js.get((Object)"OneBPMIntegrationInfo")) != null) {
            AcmOneBPMInfo oneBPM = new AcmOneBPMInfo(tempObject.toString());
            oneBPM.process();
            this.solntype.setOneBPMIntegrationInfo(oneBPM.getOneBPMInfo());
        }
        this.solntype.setProductName("IBM Case Manager");
        this.solntype.setProductVersion("5.1.1");
        this.solntype.setSchemaVersion("2.1");
        this.solntype.setVendorName("IBM Corp.");
        CBLogger.trace(log, "<Process");
    }

    public void resetAllTypeState() {
        for (RoleType role : this.roles.getRoleTable().values()) {
            role.setState(TypeState.EnumTypeState.DELETED);
        }
        if (this.inbaskets != null) {
            for (InbasketType inbasket : this.inbaskets.getInbasketTable().values()) {
                this.resetInbasketState(inbasket);
            }
        }
    }

    private void resetInbasketState(InbasketType inbasketType) {
        inbasketType.setState(TypeState.EnumTypeState.DELETED);
        if (inbasketType.getColumns() != null) {
            for (Column column : inbasketType.getColumns()) {
                column.setState(TypeState.EnumTypeState.DELETED);
            }
        }
        if (inbasketType.getFilters() != null) {
            for (Filter filter : inbasketType.getFilters()) {
                filter.setState(TypeState.EnumTypeState.DELETED);
            }
        }
    }

    private class JsonToXmlHelperThread
    implements Runnable {
        private JsonToXmlHelperThread() {
        }

        @Override
        public void run() {
            try {
                this.jsonToXmlConverterWrapper();
            }
            catch (AcmException e) {
                AcmConverter.this.acmEx = e;
                log.error((Object)e);
            }
        }

        private void jsonToXmlConverterWrapper() throws AcmException {
            JSONObject js = null;
            CBLogger.trace(log, ">jsonToXmlConverterWrapper");
            try {
                js = JSONObject.parse((String)AcmConverter.this.jsonStr);
                Object[] keys = js.keySet().toArray();
                String originaljson = js.get((Object)keys[0].toString()).toString();
                CBLogger.debug(log, "json Structure to jaxb" + originaljson);
                js = JSONObject.parse((String)originaljson);
            }
            catch (IOException e) {
                log.error((Object)" error ::  ", (Throwable)e);
                Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e);
                throw new AcmException(msg, (Throwable)e);
            }
            try {
                AcmConverter.this.process(js);
            }
            catch (IOException e) {
                log.error((Object)" error ::  ", (Throwable)e);
                Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e);
                throw new AcmException(msg, (Throwable)e);
            }
            CBLogger.trace(log, "<jsonToXmlConverterWrapper");
        }
    }
}

