/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.converter.IAcmChoiceLists;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListStringDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumChoiceListType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceString;

public class AcmChoicelistStringType
implements IAcmChoiceLists {
    private String jsonStr = null;
    private CmisChoiceString outerStringChoiceList = null;
    private String guid = null;
    private boolean createGUID = false;
    private SolutionData solData;
    private static final Log log = LogFactory.getLog((String)AcmChoicelistStringType.class.getName());

    public AcmChoicelistStringType(String str) {
        this.jsonStr = str;
        log.debug((Object)("JSON str :" + this.jsonStr));
    }

    @Override
    public void parseJsonForChoiceList() throws IOException {
        log.trace((Object)">parseJsonForChoiceList");
        JSONObject jsonObj = JSONObject.parse((String)this.jsonStr);
        String listName = (String)jsonObj.get((Object)"displayName");
        log.debug((Object)("List Name :" + listName));
        if (this.createGUID) {
            this.guid = this.getSolData().checkCreateChoiceListTypeGuid(listName);
            log.debug((Object)"Created GUID");
            this.createGUID = false;
        }
        this.outerStringChoiceList = new CmisChoiceString();
        this.outerStringChoiceList.setDisplayName(listName);
        Object choice = jsonObj.get((Object)"choice");
        if (choice == null) {
            log.debug((Object)"choice items are null");
            return;
        }
        String choiceStr = choice.toString();
        log.debug((Object)(" choice str : " + choiceStr));
        if (choiceStr.startsWith("{")) {
            JSONObject choiceObj = JSONObject.parse((String)choiceStr);
            CmisChoiceString stringChoiceItem = new CmisChoiceString();
            stringChoiceItem.setDisplayName(choiceObj.get((Object)"displayName").toString());
            String val = choiceObj.get((Object)"value").toString();
            stringChoiceItem.getValue().add(val);
            this.outerStringChoiceList.getChoice().add(stringChoiceItem);
            log.debug((Object)("Item Name :" + stringChoiceItem.getDisplayName() + " : Value " + val));
        } else {
            JSONArray choiceArr = JSONArray.parse((String)choiceStr);
            if (choiceArr != null) {
                for (int idx = 0; idx < choiceArr.size(); ++idx) {
                    jsonObj = (JSONObject)choiceArr.get(idx);
                    CmisChoiceString stringChoiceItem = new CmisChoiceString();
                    stringChoiceItem.setDisplayName(jsonObj.get((Object)"displayName").toString());
                    String val = jsonObj.get((Object)"value").toString();
                    stringChoiceItem.getValue().add(val);
                    this.outerStringChoiceList.getChoice().add(stringChoiceItem);
                    log.debug((Object)("Item Name :" + stringChoiceItem.getDisplayName() + " : Value " + val));
                }
            }
        }
        log.trace((Object)"<parseJsonForChoiceList");
    }

    @Override
    public ChoiceListDefinitionType getChoiceList() {
        log.trace((Object)"> getChoiceList");
        if (this.outerStringChoiceList != null) {
            ChoiceListStringDefinitionType chd = new ChoiceListStringDefinitionType();
            chd.setChoice(this.outerStringChoiceList);
            chd.setId(this.guid);
            chd.setType(EnumChoiceListType.STRING);
            log.trace((Object)"< getChoiceList");
            return chd;
        }
        log.debug((Object)"choice list is empty");
        log.trace((Object)"> getChoiceList");
        return null;
    }

    @Override
    public void setID(String id) {
        this.guid = id;
    }

    @Override
    public SolutionData getSolData() {
        return this.solData;
    }

    @Override
    public void setSolData(SolutionData solData) {
        this.solData = solData;
    }

    @Override
    public void setCreatGUId(boolean flag) {
        this.createGUID = flag;
    }
}

