/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.converter.IAcmChoiceLists;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListIntegerDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumChoiceListType;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceInteger;

public class AcmChoicelistIntegerType
implements IAcmChoiceLists {
    private String jsonStr = null;
    private CmisChoiceInteger outerIntergerChoiceList = null;
    private String guid = null;
    private boolean createGUID = false;
    private SolutionData solData;
    ChoiceListIntegerDefinitionType interChoiceListDefType = null;
    private static final Log log = LogFactory.getLog((String)AcmChoicelistIntegerType.class.getName());

    public AcmChoicelistIntegerType(String json) {
        this.jsonStr = json;
        log.debug((Object)("JSON str :" + this.jsonStr));
        log.debug((Object)"AcmChoicelistIntegerType");
        this.interChoiceListDefType = new ChoiceListIntegerDefinitionType();
    }

    @Override
    public void parseJsonForChoiceList() throws IOException {
        log.trace((Object)"< parseJsonForChoiceList");
        JSONObject jsonObj = JSONObject.parse((String)this.jsonStr);
        String listName = (String)jsonObj.get((Object)"displayName");
        if (this.createGUID) {
            this.guid = this.getSolData().checkCreateChoiceListTypeGuid(listName);
            this.createGUID = false;
        }
        this.outerIntergerChoiceList = new CmisChoiceInteger();
        this.outerIntergerChoiceList.setDisplayName(listName);
        log.debug((Object)("List Name :" + listName));
        Object choice = jsonObj.get((Object)"choice");
        if (choice == null) {
            log.debug((Object)"choice items are null");
            return;
        }
        String choiceStr = choice.toString();
        log.debug((Object)(" Choice String : " + choiceStr));
        if (choiceStr.startsWith("{")) {
            jsonObj = JSONObject.parse((String)choiceStr);
            CmisChoiceInteger choiceListItem = new CmisChoiceInteger();
            choiceListItem.setDisplayName(jsonObj.get((Object)"displayName").toString());
            String val = jsonObj.get((Object)"value").toString();
            long parseLong = Long.parseLong(val);
            choiceListItem.getValue().add(BigInteger.valueOf(parseLong));
            this.outerIntergerChoiceList.getChoice().add(choiceListItem);
            log.debug((Object)("Item Name :" + choiceListItem.getDisplayName() + " : Value " + val));
        } else {
            JSONArray choiceArr = JSONArray.parse((String)choiceStr);
            if (choiceArr != null) {
                for (int idx = 0; idx < choiceArr.size(); ++idx) {
                    jsonObj = (JSONObject)choiceArr.get(idx);
                    CmisChoiceInteger choiceListItem = new CmisChoiceInteger();
                    choiceListItem.setDisplayName(jsonObj.get((Object)"displayName").toString());
                    String val = jsonObj.get((Object)"value").toString();
                    long parseLong = Long.parseLong(val);
                    choiceListItem.getValue().add(BigInteger.valueOf(parseLong));
                    this.outerIntergerChoiceList.getChoice().add(choiceListItem);
                    log.debug((Object)("Item Name :" + choiceListItem.getDisplayName() + " : Value " + val));
                }
            }
        }
        log.trace((Object)"> parseJsonForChoiceList");
    }

    @Override
    public ChoiceListDefinitionType getChoiceList() {
        log.trace((Object)"> getChoiceList");
        if (this.outerIntergerChoiceList != null) {
            this.interChoiceListDefType.setChoice(this.outerIntergerChoiceList);
            this.interChoiceListDefType.setId(this.guid);
            this.interChoiceListDefType.setType(EnumChoiceListType.INTEGER);
            log.trace((Object)"< getChoiceList");
            return this.interChoiceListDefType;
        }
        log.debug((Object)"choice list is empty");
        log.trace((Object)"> getChoiceList");
        return null;
    }

    @Override
    public void setID(String id) {
        this.guid = id;
    }

    @Override
    public SolutionData getSolData() {
        return this.solData;
    }

    @Override
    public void setSolData(SolutionData solData) {
        this.solData = solData;
    }

    @Override
    public void setCreatGUId(boolean flag) {
        this.createGUID = flag;
    }
}

