/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.converter.AcmChoicelistIntegerType;
import com.ibm.acm.sold.converter.AcmChoicelistStringType;
import com.ibm.acm.sold.converter.IAcmChoiceLists;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmChoiceListType {
    private SolutionType solnType = null;
    private Object json = null;
    private SolutionData solData;
    private boolean guidCreateFlag = false;
    private static final String INTEGER = "integer";
    private static final String STRING = "string";
    private static final Log log = LogFactory.getLog((String)AcmChoiceListType.class.getName());

    public AcmChoiceListType(Object json, SolutionType solnType) {
        this.json = json;
        this.solnType = solnType;
    }

    public void update() throws AcmException {
        IAcmChoiceLists Iacmchlst = null;
        log.trace((Object)"> update");
        String id = null;
        try {
            if (this.json.toString().startsWith("{")) {
                JSONObject choiceObj = (JSONObject)this.json;
                Object idObj = choiceObj.get((Object)"id");
                if (idObj != null) {
                    id = choiceObj.get((Object)"id").toString();
                    log.debug((Object)(" ID object is updated :" + id));
                    if (id.equals("-1")) {
                        this.guidCreateFlag = true;
                    }
                } else {
                    id = "";
                    this.guidCreateFlag = false;
                }
                String val = choiceObj.get((Object)"type").toString();
                log.debug((Object)("Json str : " + choiceObj.toString()));
                if (val.equalsIgnoreCase(INTEGER)) {
                    log.debug((Object)"Intger Choice List");
                    val = choiceObj.get((Object)"choice").toString();
                    Iacmchlst = new AcmChoicelistIntegerType(val);
                } else if (val.equalsIgnoreCase(STRING)) {
                    log.debug((Object)"String Choice List");
                    val = choiceObj.get((Object)"choice").toString();
                    Iacmchlst = new AcmChoicelistStringType(val);
                } else {
                    log.debug((Object)("unknwon type :" + choiceObj.toString()));
                }
                Iacmchlst.setID(id);
                Iacmchlst.setCreatGUId(this.guidCreateFlag);
                Iacmchlst.setSolData(this.solData);
                Iacmchlst.parseJsonForChoiceList();
                this.solnType.getChoiceLists().getChoiceListDefinition().add(Iacmchlst.getChoiceList());
            } else {
                JSONArray choiceArr = (JSONArray)this.json;
                if (choiceArr != null) {
                    for (int idx = 0; idx < choiceArr.size(); ++idx) {
                        JSONObject jsonObj = (JSONObject)choiceArr.get(idx);
                        Object idObj = jsonObj.get((Object)"id");
                        if (idObj != null) {
                            id = jsonObj.get((Object)"id").toString();
                            if (id.equals("-1")) {
                                this.guidCreateFlag = true;
                            }
                        } else {
                            id = "";
                            this.guidCreateFlag = false;
                        }
                        String val = jsonObj.get((Object)"type").toString();
                        log.debug((Object)("Json str : " + jsonObj.toString()));
                        if (val.equalsIgnoreCase(INTEGER)) {
                            log.debug((Object)"Intger Choice List");
                            val = jsonObj.get((Object)"choice").toString();
                            Iacmchlst = new AcmChoicelistIntegerType(val);
                        } else if (val.equalsIgnoreCase(STRING)) {
                            log.debug((Object)"String Choice List");
                            val = jsonObj.get((Object)"choice").toString();
                            Iacmchlst = new AcmChoicelistStringType(val);
                        } else {
                            log.debug((Object)("unknwon type :" + jsonObj.toString()));
                        }
                        Iacmchlst.setID(id);
                        Iacmchlst.setCreatGUId(this.guidCreateFlag);
                        Iacmchlst.setSolData(this.solData);
                        Iacmchlst.parseJsonForChoiceList();
                        this.solnType.getChoiceLists().getChoiceListDefinition().add(Iacmchlst.getChoiceList());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.trace((Object)"< update");
    }

    public SolutionData getSolData() {
        return this.solData;
    }

    public void setSolData(SolutionData solData) {
        this.solData = solData;
    }
}

