/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.FolderReferenceType;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmCaseStructure {
    public CaseTypeType caseType;
    public Object json;
    private static final Log log = LogFactory.getLog((String)AcmCaseStructure.class.getName());

    public AcmCaseStructure(CaseTypeType caset, Object json) {
        this.caseType = caset;
        this.json = json;
    }

    public void process() throws AcmException {
        log.trace((Object)"> process");
        try {
            JSONObject props = (JSONObject)this.json;
            Object tempObject = props.get((Object)"childFolder");
            if (tempObject != null) {
                List ft = this.caseType.getCaseStructure().getChildFolder();
                this.fillFolders(tempObject, ft);
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"< process");
    }

    private void fillFolders(Object tempObject, List<FolderReferenceType> ft) throws AcmException {
        try {
            if (tempObject.toString().startsWith("{")) {
                ft.add(this.fillFolderElement(tempObject));
            } else {
                JSONArray ja = (JSONArray)tempObject;
                for (JSONObject jsonob : ja) {
                    ft.add(this.fillFolderElement(jsonob));
                }
            }
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        log.trace((Object)"<processCaseTypeElement");
    }

    private FolderReferenceType fillFolderElement(Object tempObject) throws AcmException {
        FolderReferenceType ft = new FolderReferenceType();
        JSONObject jsob = null;
        try {
            jsob = (JSONObject)tempObject;
        }
        catch (ClassCastException e) {
            Message msg = new Message("B4068E.ERROR_CLASS_CAST_EXCEPTION", e);
            throw new AcmException(msg, (Throwable)e);
        }
        Object tmp = jsob.get((Object)"name");
        if (tmp != null) {
            ft.setName(tmp.toString());
        }
        if ((tmp = jsob.get((Object)"childFolder")) != null) {
            this.fillFolders(tmp, ft.getChildFolder());
        }
        return ft;
    }
}

