/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector.onebpm;

import com.ibm.acm.sold.connector.onebpm.OneBPMConnectionInfo;
import com.ibm.acm.sold.connector.onebpm.OneBPMResponse;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONObject;

public abstract class ResourceObject {
    protected static final String STATUS = "status";
    protected static final String DATA = "data";
    protected static final String DATA_UPPER = "Data";
    protected static final String STATUS_ERROR = "error";
    protected static final String ERROR_MESSAGE = "errorMessage";
    protected final OneBPMConnectionInfo connInfo;

    protected ResourceObject(OneBPMConnectionInfo connInfo) {
        this.connInfo = connInfo;
    }

    public final OneBPMConnectionInfo getOneBPMConnectionInfo() {
        return this.connInfo;
    }

    protected final PreProcessResponseResult preProcessResponse(OneBPMResponse response) throws AcmException {
        try {
            int statusCode;
            JSONObject bpmJObj = null;
            String body = response.getResponseBody();
            if (body != null && body.length() != 0) {
                bpmJObj = JSONObject.parse((String)response.getResponseBody());
            }
            if (bpmJObj != null) {
                Object statusVal = bpmJObj.get((Object)STATUS);
                if (statusVal instanceof String && ((String)statusVal).equalsIgnoreCase(STATUS_ERROR)) {
                    JSONObject joData = this.getDataPayloadObject(bpmJObj);
                    String errMsg = (String)joData.get((Object)ERROR_MESSAGE);
                    throw new AcmException("EXTERNAL_ERROR_MESSAGE" + errMsg);
                }
                statusCode = Integer.parseInt(statusVal.toString());
            } else {
                statusCode = response.getHttpResponseCode();
            }
            if (statusCode >= 400) {
                switch (statusCode) {
                    case 401: 
                    case 403: {
                        throw new AcmException("IBM_BPM_USER_FORBIDDEN" + this.connInfo.getUsername());
                    }
                }
                throw new AcmException("EXTERNAL_ERROR_MESSAGE" + response.getHttpResponseMsg());
            }
            return new PreProcessResponseResult(statusCode, bpmJObj);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    protected final JSONObject getDataPayloadObject(JSONObject payload) throws AcmException {
        try {
            JSONObject dataObj = null;
            try {
                dataObj = (JSONObject)payload.get((Object)DATA);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dataObj == null) {
                dataObj = (JSONObject)payload.get((Object)DATA_UPPER);
            }
            return dataObj;
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    protected static final class PreProcessResponseResult {
        private final int statusCode;
        private final JSONObject responseJson;

        private PreProcessResponseResult(int statusCode, JSONObject responseJson) {
            this.statusCode = statusCode;
            this.responseJson = responseJson;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public JSONObject getResponseJson() {
            return this.responseJson;
        }
    }
}

