/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector.onebpm;

import com.ibm.acm.sold.connector.onebpm.OneBPMConnectionInfo;
import com.ibm.acm.sold.connector.onebpm.OneBPMRequestHandler;
import com.ibm.acm.sold.connector.onebpm.OneBPMResponse;
import com.ibm.acm.sold.connector.onebpm.ResourceObject;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessServer
extends ResourceObject {
    private static final Log logger = LogFactory.getLog((String)ProcessServer.class.getName());
    private static final String CLASS_NAME = "ProcessServer";
    private static final String PROCESSAPPSLIST = "processAppsList";
    private static final String SHORTNAME = "shortName";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULTVERSION = "defaultVersion";
    private static final String INSTALLEDSNAPSHOTS = "installedSnapshots";
    private static final String ACRONYM = "acronym";
    private static final String ACTIVE = "active";
    private static final String ID = "ID";
    private static final String ACTIVESINCE = "activeSince";
    private static final String EXPOSEDITEMLIST = "exposedItemsList";
    private static final String ITEMID = "itemID";
    private static final String ITEMREFERENCE = "itemReference";
    private static final String SNAPSHOTID = "snapshotID";
    private static final String DISPLAY = "display";
    private static final String TIP = "tip";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String UTC = "UTC";
    private static final List<ProcessApp> EMPTY_PROCESSAPPS_LIST = Collections.unmodifiableList(new ArrayList());
    private static final List<Process> EMPTY_PROCESSES_LIST = Collections.unmodifiableList(new ArrayList());

    public static ProcessServer getFetchlessProcessServer(OneBPMConnectionInfo connInfo) {
        if (connInfo == null) {
            throw new IllegalArgumentException();
        }
        return new ProcessServer(connInfo);
    }

    private ProcessServer(OneBPMConnectionInfo connInfo) {
        super(connInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProcessApp> fetchProcessApps() throws AcmException {
        String method = "fetchProcessApps()";
        logger.trace((Object)"Entering ProcessServerfetchProcessApps()");
        try {
            List<ProcessApp> fetchResult;
            OneBPMRequestHandler requestHandler = new OneBPMRequestHandler();
            OneBPMResponse response = requestHandler.readProcessApps(this.connInfo);
            ResourceObject.PreProcessResponseResult preProcessResult = this.preProcessResponse(response);
            JSONObject bpmJObj = preProcessResult.getResponseJson();
            int statusCode = preProcessResult.getStatusCode();
            switch (statusCode) {
                case 200: {
                    fetchResult = this.generateProcessApps(bpmJObj);
                    break;
                }
                case 204: {
                    fetchResult = EMPTY_PROCESSAPPS_LIST;
                    break;
                }
                default: {
                    throw new AcmException("A0006E.EXTERNAL_ERROR_MESSAGE" + response.getHttpResponseMsg());
                }
            }
            List<ProcessApp> list = fetchResult;
            return list;
        }
        finally {
            logger.trace((Object)"Exiting ProcessServerfetchProcessApps()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessApp fetchProcessAppByName(String processAppName) throws AcmException {
        String method = "fetchProcessAppByName()";
        logger.trace((Object)"Entering ProcessServerfetchProcessAppByName()");
        try {
            ProcessApp processApp;
            OneBPMRequestHandler requestHandler = new OneBPMRequestHandler();
            OneBPMResponse response = requestHandler.readProcessApps(this.connInfo);
            ResourceObject.PreProcessResponseResult preProcessResult = this.preProcessResponse(response);
            JSONObject bpmJObj = preProcessResult.getResponseJson();
            int statusCode = preProcessResult.getStatusCode();
            switch (statusCode) {
                case 200: {
                    processApp = this.findAndGenerateProcessAppByName(bpmJObj, processAppName);
                    break;
                }
                case 204: {
                    throw new AcmException("IBM_BPM_PROCESS_APPLICATION_NOT_FOUND" + processAppName);
                }
                default: {
                    throw new AcmException("EXTERNAL_ERROR_MESSAGE" + response.getHttpResponseMsg());
                }
            }
            ProcessApp processApp2 = processApp;
            return processApp2;
        }
        finally {
            logger.trace((Object)"Exiting ProcessServerfetchProcessAppByName()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessApp fetchProcessAppByAcronym(String processAppAcronym) throws AcmException {
        String method = "fetchProcessAppByAcronym()";
        logger.trace((Object)"Entering ProcessServerfetchProcessAppByAcronym()");
        try {
            ProcessApp processApp;
            OneBPMRequestHandler requestHandler = new OneBPMRequestHandler();
            OneBPMResponse response = requestHandler.readProcessApps(this.connInfo);
            ResourceObject.PreProcessResponseResult preProcessResult = this.preProcessResponse(response);
            JSONObject bpmJObj = preProcessResult.getResponseJson();
            int statusCode = preProcessResult.getStatusCode();
            switch (statusCode) {
                case 200: {
                    processApp = this.findAndGenerateProcessAppByAcronym(bpmJObj, processAppAcronym);
                    break;
                }
                case 204: {
                    throw new AcmException("IBM_BPM_PROCESS_APPLICATION_NOT_FOUND" + processAppAcronym);
                }
                default: {
                    throw new AcmException("EXTERNAL_ERROR_MESSAGE" + response.getHttpResponseMsg());
                }
            }
            ProcessApp processApp2 = processApp;
            return processApp2;
        }
        finally {
            logger.trace((Object)"Exiting ProcessServerfetchProcessAppByAcronym()");
        }
    }

    private List<ProcessApp> generateProcessApps(JSONObject bpmJObj) throws AcmException {
        try {
            JSONObject joData = this.getDataPayloadObject(bpmJObj);
            JSONArray joProcessAppsList = (JSONArray)joData.get((Object)PROCESSAPPSLIST);
            logger.trace((Object)("Number of process applications: " + joProcessAppsList.size()));
            ArrayList<ProcessApp> processApps = new ArrayList<ProcessApp>();
            for (Object obj : joProcessAppsList) {
                JSONObject jObj = (JSONObject)obj;
                processApps.add(this.generateProcessApp(jObj));
            }
            return Collections.unmodifiableList(processApps);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private ProcessApp findAndGenerateProcessAppByName(JSONObject bmpJObj, String processAppName) throws AcmException {
        try {
            JSONObject joData = this.getDataPayloadObject(bmpJObj);
            JSONArray joProcessAppsList = (JSONArray)joData.get((Object)PROCESSAPPSLIST);
            JSONObject foundJO = null;
            for (Object obj : joProcessAppsList) {
                JSONObject jObj = (JSONObject)obj;
                if (!jObj.get((Object)NAME).equals(processAppName)) continue;
                foundJO = jObj;
                break;
            }
            if (foundJO == null) {
                throw new AcmException("IBM_BPM_PROCESS_APPLICATION_NOT_FOUND" + processAppName);
            }
            return this.generateProcessApp(foundJO);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private ProcessApp findAndGenerateProcessAppByAcronym(JSONObject bmpJObj, String processAppAcronym) throws AcmException {
        try {
            JSONObject joData = this.getDataPayloadObject(bmpJObj);
            JSONArray joProcessAppsList = (JSONArray)joData.get((Object)PROCESSAPPSLIST);
            JSONObject foundJO = null;
            for (Object obj : joProcessAppsList) {
                JSONObject jObj = (JSONObject)obj;
                if (!jObj.get((Object)SHORTNAME).equals(processAppAcronym)) continue;
                foundJO = jObj;
                break;
            }
            if (foundJO == null) {
                throw new AcmException("IBM_BPM_PROCESS_APPLICATION_NOT_FOUND" + processAppAcronym);
            }
            return this.generateProcessApp(foundJO);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private ProcessApp generateProcessApp(JSONObject jObj) throws AcmException {
        try {
            String shortName = (String)jObj.get((Object)SHORTNAME);
            String name = (String)jObj.get((Object)NAME);
            String description = (String)jObj.get((Object)DESCRIPTION);
            String defaultVersion = (String)jObj.get((Object)DEFAULTVERSION);
            JSONArray joInstalledSnapshots = (JSONArray)jObj.get((Object)INSTALLEDSNAPSHOTS);
            if (joInstalledSnapshots != null) {
                logger.trace((Object)("Number of installed snapshots: " + joInstalledSnapshots.size()));
            }
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            Snapshot defaultSnapshot = null;
            if (joInstalledSnapshots != null) {
                for (Object obj : joInstalledSnapshots) {
                    JSONObject jsObj = (JSONObject)obj;
                    Snapshot snapshot = this.generateSnapshot(jsObj);
                    if (snapshot.getName().equals(defaultVersion)) {
                        defaultSnapshot = snapshot;
                        logger.trace((Object)("Default snapshot found based on defaultVersion: " + snapshot.getName()));
                    }
                    snapshots.add(snapshot);
                }
                if (defaultSnapshot == null) {
                    defaultSnapshot = this.getLatestActiveSnapshot(snapshots);
                }
            }
            return new ProcessApp(shortName, name, description, defaultVersion, defaultSnapshot, Collections.unmodifiableList(snapshots));
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private Snapshot getLatestActiveSnapshot(List<Snapshot> snapshots) throws AcmException {
        Snapshot defaultSnapshot = null;
        for (Snapshot snapshot : snapshots) {
            if (!snapshot.isActive()) continue;
            if (defaultSnapshot == null) {
                defaultSnapshot = snapshot;
            }
            try {
                Date currentDate = this.convertStringToDate(snapshot.getActiveSince());
                Date latestDate = this.convertStringToDate(defaultSnapshot.getActiveSince());
                if (latestDate.compareTo(currentDate) >= 0) continue;
                defaultSnapshot = snapshot;
            }
            catch (ParseException e) {
                throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
            }
        }
        if (defaultSnapshot != null) {
            logger.trace((Object)("Latest active snapshot found based on activeSince: " + defaultSnapshot.getName()));
        }
        return defaultSnapshot;
    }

    private Snapshot generateSnapshot(JSONObject jObj) throws AcmException {
        try {
            String name = (String)jObj.get((Object)NAME);
            String acronym = (String)jObj.get((Object)ACRONYM);
            boolean active = (Boolean)jObj.get((Object)ACTIVE);
            String id = (String)jObj.get((Object)ID);
            String activeSince = null;
            if (active) {
                activeSince = (String)jObj.get((Object)ACTIVESINCE);
            }
            return new Snapshot(name, acronym, active, id, activeSince);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Process> fetchExposedProcessesForSnapshotId(String snapshotId) throws AcmException {
        String method = "fetchExposedProcessesForSnapshotId()";
        logger.trace((Object)"Entering ProcessServerfetchExposedProcessesForSnapshotId()");
        try {
            List<Process> fetchResult;
            OneBPMRequestHandler requestHandler = new OneBPMRequestHandler();
            OneBPMResponse response = requestHandler.readExposedProcesses(this.connInfo);
            ResourceObject.PreProcessResponseResult preProcessResult = this.preProcessResponse(response);
            JSONObject bpmJObj = preProcessResult.getResponseJson();
            int statusCode = preProcessResult.getStatusCode();
            switch (statusCode) {
                case 200: {
                    fetchResult = this.generateExposedProcesses(bpmJObj, snapshotId);
                    break;
                }
                case 204: {
                    fetchResult = EMPTY_PROCESSES_LIST;
                    break;
                }
                default: {
                    throw new AcmException("EXTERNAL_ERROR_MESSAGE" + response.getHttpResponseMsg());
                }
            }
            List<Process> list = fetchResult;
            return list;
        }
        finally {
            logger.trace((Object)"Exiting ProcessServerfetchExposedProcessesForSnapshotId()");
        }
    }

    private List<Process> generateExposedProcesses(JSONObject bpmJObj, String snapshotId) throws AcmException {
        try {
            JSONObject joData = this.getDataPayloadObject(bpmJObj);
            JSONArray joExposedItemList = (JSONArray)joData.get((Object)EXPOSEDITEMLIST);
            logger.trace((Object)("Number of exposed processes: " + joExposedItemList.size()));
            ArrayList<Process> processes = new ArrayList<Process>();
            for (Object obj : joExposedItemList) {
                JSONObject jObj = (JSONObject)obj;
                Process process = this.generateProcess(jObj);
                if (process.isTip() || !process.getSnapshotId().equalsIgnoreCase(snapshotId)) continue;
                processes.add(this.generateProcess(jObj));
            }
            return Collections.unmodifiableList(processes);
        }
        catch (Exception e) {
            throw new AcmException("A0006E.EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private Process generateProcess(JSONObject jObj) throws AcmException {
        try {
            String itemId = (String)jObj.get((Object)ITEMID);
            String itemReference = (String)jObj.get((Object)ITEMREFERENCE);
            String snapshotId = (String)jObj.get((Object)SNAPSHOTID);
            String display = (String)jObj.get((Object)DISPLAY);
            boolean tip = (Boolean)jObj.get((Object)TIP);
            return new Process(itemId, itemReference, snapshotId, display, tip);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private Date convertStringToDate(String strDate) throws ParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
        dateFormatter.setTimeZone(new SimpleTimeZone(0, UTC));
        Date parsedDate = dateFormatter.parse(strDate);
        return parsedDate;
    }

    public static final class Process {
        private final String itemId;
        private final String itemReference;
        private final String snapshotId;
        private final String display;
        private final boolean tip;

        private Process(String itemId, String itemReference, String snapshotId, String display, boolean tip) {
            this.itemId = itemId;
            this.itemReference = itemReference;
            this.snapshotId = snapshotId;
            this.display = display;
            this.tip = tip;
        }

        public String getItemId() {
            return this.itemId;
        }

        public String getItemReference() {
            return this.itemReference;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public String getDisplay() {
            return this.display;
        }

        public boolean isTip() {
            return this.tip;
        }
    }

    public static final class Snapshot {
        private final String name;
        private final String acronym;
        private final boolean active;
        private final String id;
        private final String activeSince;

        private Snapshot(String name, String acronym, boolean active, String id, String activeSince) {
            this.name = name;
            this.acronym = acronym;
            this.active = active;
            this.id = id;
            this.activeSince = activeSince;
        }

        public String getName() {
            return this.name;
        }

        public String getAcronym() {
            return this.acronym;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public String getActiveSince() {
            return this.activeSince;
        }
    }

    public static final class ProcessApp {
        private final String shortName;
        private final String name;
        private final String description;
        private final String defaultVersion;
        private final Snapshot defaultSnapshot;
        private final List<Snapshot> snapshots;

        private ProcessApp(String shortName, String name, String description, String defaultVersion, Snapshot defaultSnapshot, List<Snapshot> snapshots) {
            this.shortName = shortName;
            this.name = name;
            this.description = description;
            this.defaultVersion = defaultVersion;
            this.defaultSnapshot = defaultSnapshot;
            this.snapshots = snapshots;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultVersion() {
            return this.defaultVersion;
        }

        public Snapshot getDefaultSnapshot() {
            return this.defaultSnapshot;
        }

        public List<Snapshot> getSnapshots() {
            return this.snapshots;
        }
    }
}

