/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector.onebpm;

import com.ibm.acm.sold.connector.onebpm.OneBPMConnectionInfo;
import com.ibm.acm.sold.connector.onebpm.OneBPMRequestHandler;
import com.ibm.acm.sold.connector.onebpm.OneBPMResponse;
import com.ibm.acm.sold.connector.onebpm.ResourceObject;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessModel
extends ResourceObject {
    private static final Log logger = LogFactory.getLog((String)ProcessModel.class.getName());
    private static final String CLASS_NAME = "ProcessModel";
    private static final String DATAMODEL = "DataModel";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String ISLIST = "isList";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String TYPE_INTEGER = "Integer";
    private static final String TYPE_BOOLEAN = "Boolean";
    private static final String TYPE_DECIMAL = "Decimal";
    private static final String TYPE_STRING = "String";
    private static final String TYPE_DATE = "Date";
    private static final List<DataField> EMPTY_FIELDS_LIST = Collections.unmodifiableList(new ArrayList());
    private final String bpdId;
    private final String snapshotId;

    public static ProcessModel getFetchlessProcessModel(OneBPMConnectionInfo connInfo, String bpdId, String snapshotId) {
        if (connInfo == null || bpdId == null || snapshotId == null) {
            throw new IllegalArgumentException();
        }
        return new ProcessModel(connInfo, bpdId, snapshotId);
    }

    private ProcessModel(OneBPMConnectionInfo connInfo, String bpdId, String snapshotId) {
        super(connInfo);
        this.bpdId = bpdId;
        this.snapshotId = snapshotId;
    }

    public String getBpdId() {
        return this.bpdId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchDataFieldsResult fetchDataFields() throws AcmException {
        String method = "fetchDataFields()";
        logger.trace((Object)"Entering ProcessModelfetchDataFields()");
        try {
            FetchDataFieldsResult fetchResult;
            OneBPMRequestHandler requestHandler = new OneBPMRequestHandler();
            OneBPMResponse response = requestHandler.readProcessModel(this.connInfo, this.bpdId, this.snapshotId);
            ResourceObject.PreProcessResponseResult preProcessResult = this.preProcessResponse(response);
            JSONObject bpmJObj = preProcessResult.getResponseJson();
            int statusCode = preProcessResult.getStatusCode();
            switch (statusCode) {
                case 200: {
                    fetchResult = this.generateDataFields(bpmJObj);
                    break;
                }
                case 204: {
                    fetchResult = new FetchDataFieldsResult(EMPTY_FIELDS_LIST, EMPTY_FIELDS_LIST);
                    break;
                }
                default: {
                    throw new AcmException("EXTERNAL_ERROR_MESSAGE" + response.getHttpResponseMsg());
                }
            }
            FetchDataFieldsResult fetchDataFieldsResult = fetchResult;
            return fetchDataFieldsResult;
        }
        finally {
            logger.trace((Object)"Exiting ProcessModelfetchDataFields()");
        }
    }

    private FetchDataFieldsResult generateDataFields(JSONObject bpmJObj) throws AcmException {
        try {
            JSONObject jObj;
            String fieldName;
            Set entries;
            JSONObject joData = this.getDataPayloadObject(bpmJObj);
            JSONObject joDataModel = (JSONObject)joData.get((Object)DATAMODEL);
            JSONObject joInputs = (JSONObject)joDataModel.get((Object)INPUTS);
            JSONObject joOutputs = (JSONObject)joDataModel.get((Object)OUTPUTS);
            logger.trace((Object)("Number of input data fields: " + joInputs.size()));
            logger.trace((Object)("Number of output data fields: " + joOutputs.size()));
            ArrayList<DataField> inputFields = new ArrayList<DataField>();
            ArrayList<DataField> outputFields = new ArrayList<DataField>();
            if (!joInputs.isEmpty()) {
                entries = joInputs.entrySet();
                for (Map.Entry entry : entries) {
                    fieldName = (String)entry.getKey();
                    jObj = (JSONObject)entry.getValue();
                    inputFields.add(this.generateDataField(fieldName, jObj));
                }
            }
            if (!joOutputs.isEmpty()) {
                entries = joOutputs.entrySet();
                for (Map.Entry entry : entries) {
                    fieldName = (String)entry.getKey();
                    jObj = (JSONObject)entry.getValue();
                    outputFields.add(this.generateDataField(fieldName, jObj));
                }
            }
            return new FetchDataFieldsResult(Collections.unmodifiableList(inputFields), Collections.unmodifiableList(outputFields));
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private DataField generateDataField(String fieldName, JSONObject jObj) throws AcmException {
        try {
            String description = "";
            if (jObj.containsKey((Object)DESCRIPTION)) {
                description = (String)jObj.get((Object)DESCRIPTION);
            }
            String typeName = (String)jObj.get((Object)TYPE);
            FieldType type = this.convertFieldType(typeName);
            boolean isAList = (Boolean)jObj.get((Object)ISLIST);
            return new DataField(fieldName, description, type, typeName, isAList);
        }
        catch (Exception e) {
            throw new AcmException("EXTERNAL_ERROR_MESSAGE" + e);
        }
    }

    private FieldType convertFieldType(String typeName) {
        FieldType fieldType = typeName.equalsIgnoreCase(TYPE_STRING) ? FieldType.STRING : (typeName.equalsIgnoreCase(TYPE_BOOLEAN) ? FieldType.BOOLEAN : (typeName.equalsIgnoreCase(TYPE_DATE) ? FieldType.DATE : (typeName.equalsIgnoreCase(TYPE_DECIMAL) ? FieldType.DECIMAL : (typeName.equalsIgnoreCase(TYPE_INTEGER) ? FieldType.INTEGER : FieldType.OBJECT))));
        return fieldType;
    }

    public static final class FetchDataFieldsResult {
        private final List<DataField> inputFields;
        private final List<DataField> outputFields;

        public List<DataField> getInputFields() {
            return this.inputFields;
        }

        public List<DataField> getOutputFields() {
            return this.outputFields;
        }

        private FetchDataFieldsResult(List<DataField> inputFields, List<DataField> outputFields) {
            this.inputFields = inputFields;
            this.outputFields = outputFields;
        }
    }

    public static final class DataField {
        private final String name;
        private final String description;
        private final FieldType type;
        private final String typeName;
        private final boolean isAList;

        private DataField(String name, String description, FieldType type, String typeName, boolean isAList) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.typeName = typeName;
            this.isAList = isAList;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public FieldType getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isList() {
            return this.isAList;
        }
    }

    public static enum FieldType {
        INTEGER,
        DECIMAL,
        BOOLEAN,
        STRING,
        DATE,
        OBJECT;

    }
}

