/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector.onebpm;

import com.filenet.api.core.ObjectStore;
import com.filenet.api.util.Id;
import com.ibm.acm.sold.args.OneBPMArgs;
import com.ibm.acm.sold.args.TaskInfo;
import com.ibm.acm.sold.connector.onebpm.OneBPMConnectionInfo;
import com.ibm.acm.sold.connector.onebpm.ProcessModel;
import com.ibm.acm.sold.connector.onebpm.ProcessServer;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumFieldDirection;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumFieldType;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyMapType;
import com.ibm.xmlns.prod.ecm.acm.sdf.WorkflowPropertyMapsType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.EnumCardinality;

public class OneBPMValidator {
    private static final Log logger = LogFactory.getLog((String)"CB");
    private String DEFAULT_SNAPSHOT_ID = null;
    private String DEFAULT_SNAPSHOT_NAME = null;
    private Locale locale = null;

    public HashMap<String, List<String>> validateBPM(ObjectStore targetOs, OneBPMArgs solutionArgs) throws AcmException {
        if (solutionArgs != null) {
            this.locale = solutionArgs.getClientLocale();
        }
        logger.trace((Object)">validate");
        HashMap<String, List<String>> validationMap = new HashMap<String, List<String>>();
        ArrayList<String> errList = new ArrayList<String>();
        if (solutionArgs == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "solutionArgs");
            logger.trace((Object)msg.getFormattedText());
            errList.add(msg.getFormattedText());
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        if (targetOs == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "targetOs");
            logger.trace((Object)msg.getFormattedText(solutionArgs.getClientLocale()));
            errList.add(msg.getFormattedText(solutionArgs.getClientLocale()));
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        if (!targetOs.isAddOnInstalled(new Id("{AC500ADD-0000-0000-0000-000000000002}"))) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "{AC500ADD-0000-0000-0000-000000000002}");
            logger.trace((Object)msg.getFormattedText(solutionArgs.getClientLocale()));
            errList.add(msg.getFormattedText(solutionArgs.getClientLocale()));
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        OneBPMConnectionInfo bpmConn = new OneBPMConnectionInfo();
        try {
            bpmConn.getOneBPMConnectionObject(targetOs);
        }
        catch (Exception e) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "IBPM Connection Info");
            logger.trace((Object)msg.getFormattedText(solutionArgs.getClientLocale()));
            errList.add(msg.getFormattedText(solutionArgs.getClientLocale()));
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        if (solutionArgs.getOneBPMIntegrationInfo() == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "IBPM Integration Info");
            logger.trace((Object)msg.getFormattedText(solutionArgs.getClientLocale()));
            errList.add(msg.getFormattedText(solutionArgs.getClientLocale()));
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        String cbProcessAppAcronym = solutionArgs.getOneBPMIntegrationInfo().getProcessApplicationAcronym();
        if (cbProcessAppAcronym == null) {
            Message msg = new Message("B0014E.SYSTEM_ERROR", "missing ProcessAppAcronym");
            logger.trace((Object)msg.getFormattedText(solutionArgs.getClientLocale()));
            errList.add(msg.getFormattedText(solutionArgs.getClientLocale()));
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        String cbCaseId = solutionArgs.getCaseType().getCaseIdentifier();
        try {
            errList.addAll(this.validateProcessApp(bpmConn, cbProcessAppAcronym));
        }
        catch (AcmException e) {
            Message msg = new Message("B0014E.SYSTEM_ERROR", "validateProcessApp");
            logger.trace((Object)msg.getFormattedText(solutionArgs.getClientLocale()));
            errList.add(msg.getFormattedText(solutionArgs.getClientLocale()));
            validationMap.put("error", errList);
            this.printValidationMap(validationMap);
            return validationMap;
        }
        if (errList.size() > 0) {
            validationMap.put(cbCaseId, errList);
        }
        if (this.DEFAULT_SNAPSHOT_ID == null) {
            this.printValidationMap(validationMap);
            return validationMap;
        }
        ProcessServer ps = ProcessServer.getFetchlessProcessServer(bpmConn);
        List<ProcessServer.Process> bpmProcessList = ps.fetchExposedProcessesForSnapshotId(this.DEFAULT_SNAPSHOT_ID);
        List<TaskInfo> cbTaskList = solutionArgs.getCaseType().getTaskList();
        for (TaskInfo task : cbTaskList) {
            try {
                String cbWorkflowName = task.getWorkFlowName();
                ArrayList<String> taskErrList = new ArrayList<String>();
                taskErrList.addAll(this.validateTask(bpmProcessList, cbWorkflowName));
                String workflowId = this.getWorkflowId(bpmProcessList, cbWorkflowName);
                if (workflowId != null) {
                    ProcessModel pm = ProcessModel.getFetchlessProcessModel(bpmConn, workflowId, this.DEFAULT_SNAPSHOT_ID);
                    ProcessModel.FetchDataFieldsResult dataFieldsResult = pm.fetchDataFields();
                    List<ProcessModel.DataField> bpmInputFieldList = dataFieldsResult.getInputFields();
                    List<ProcessModel.DataField> bpmOutputFieldList = dataFieldsResult.getOutputFields();
                    WorkflowPropertyMapsType cbFieldMap = task.getFieldList();
                    List cbFieldList = cbFieldMap.getPropertyMap();
                    for (PropertyMapType field : cbFieldList) {
                        String cbFieldName = field.getWorkflowFieldName();
                        EnumFieldType cbFieldType = field.getWorkflowFieldType();
                        EnumCardinality cbFieldCardinality = field.getWorkflowFieldCardinality();
                        EnumFieldDirection cbFieldDirection = field.getWorkflowFieldDirection();
                        taskErrList.addAll(this.validateField(bpmInputFieldList, bpmOutputFieldList, cbFieldName, cbFieldType, cbFieldCardinality, cbFieldDirection, cbWorkflowName));
                    }
                }
                if (taskErrList.size() <= 0) continue;
                validationMap.put(task.getCbTaskSymName(), taskErrList);
            }
            catch (Exception e) {
                this.printValidationMap(validationMap);
                return validationMap;
            }
        }
        this.printValidationMap(validationMap);
        logger.trace((Object)"<validate");
        return validationMap;
    }

    private List<String> validateProcessApp(OneBPMConnectionInfo bpmConn, String cbProcessAppAcronym) throws AcmException {
        ArrayList<String> errors = new ArrayList<String>();
        ProcessServer ps = ProcessServer.getFetchlessProcessServer(bpmConn);
        List<ProcessServer.ProcessApp> bpmProcessAppList = ps.fetchProcessApps();
        Boolean processAppFound = false;
        for (ProcessServer.ProcessApp bpmProcessApp : bpmProcessAppList) {
            if (bpmProcessApp.getShortName().equals(cbProcessAppAcronym)) {
                processAppFound = true;
                ProcessServer.Snapshot snap = bpmProcessApp.getDefaultSnapshot();
                if (snap != null) {
                    this.DEFAULT_SNAPSHOT_ID = snap.getId();
                    this.DEFAULT_SNAPSHOT_NAME = snap.getName();
                } else {
                    Message msg = new Message("B6018E.IBM_BPM_SNAPSHOT_NOT_DEFAULT", bpmProcessApp.getDefaultVersion());
                    logger.trace((Object)msg.getFormattedText(this.locale));
                    errors.add(msg.getFormattedText(this.locale));
                }
            }
            if (!processAppFound.booleanValue()) continue;
            break;
        }
        if (!processAppFound.booleanValue()) {
            Message msg = new Message("B6017E.IBM_BPM_PROCESS_APPLICATION_NOT_FOUND", cbProcessAppAcronym);
            logger.trace((Object)msg.getFormattedText(this.locale));
            errors.add(msg.getFormattedText(this.locale));
        }
        return errors;
    }

    private List<String> validateTask(List<ProcessServer.Process> bpmProcessList, String cbWorkflowName) throws AcmException {
        ArrayList<String> errors = new ArrayList<String>();
        Boolean processFound = false;
        for (ProcessServer.Process bpmProcess : bpmProcessList) {
            if (bpmProcess.getDisplay().equals(cbWorkflowName)) {
                processFound = true;
            }
            if (!processFound.booleanValue()) continue;
            break;
        }
        if (!processFound.booleanValue()) {
            Message msg = new Message("B6020E.IBM_BPM_PROCESS_NOT_EXPOSED", cbWorkflowName);
            logger.trace((Object)msg.getFormattedText(this.locale));
            errors.add(msg.getFormattedText(this.locale));
        }
        return errors;
    }

    private String getWorkflowId(List<ProcessServer.Process> bpmProcessList, String cbWorkflowName) throws AcmException {
        String workflowId = null;
        for (ProcessServer.Process bpmProcess : bpmProcessList) {
            if (!bpmProcess.getDisplay().equals(cbWorkflowName)) continue;
            workflowId = bpmProcess.getItemId();
            break;
        }
        return workflowId;
    }

    private List<String> validateField(List<ProcessModel.DataField> bpmInputFieldList, List<ProcessModel.DataField> bpmOutputFieldList, String cbFieldName, EnumFieldType cbFieldType, EnumCardinality cbFieldCardinality, EnumFieldDirection cbFieldDirection, String cbWorkflowName) {
        Message msg;
        EnumCardinality bpmFieldCardinality;
        EnumFieldType bpmFieldType;
        ProcessModel.DataField bpmField;
        EnumFieldDirection bpmFieldDirection2;
        Iterator<ProcessModel.DataField> it2;
        EnumFieldDirection bpmFieldDirection1;
        Iterator<ProcessModel.DataField> it1;
        ArrayList<String> errors = new ArrayList<String>();
        Boolean fieldFound = false;
        if (cbFieldDirection.compareTo((Enum)EnumFieldDirection.IN) == 0) {
            it1 = bpmInputFieldList.iterator();
            bpmFieldDirection1 = EnumFieldDirection.IN;
            it2 = bpmOutputFieldList.iterator();
            bpmFieldDirection2 = EnumFieldDirection.OUT;
        } else {
            it1 = bpmOutputFieldList.iterator();
            bpmFieldDirection1 = EnumFieldDirection.OUT;
            it2 = bpmInputFieldList.iterator();
            bpmFieldDirection2 = EnumFieldDirection.IN;
        }
        while (it1.hasNext()) {
            bpmField = it1.next();
            if (bpmField.getName().equals(cbFieldName)) {
                bpmFieldType = EnumFieldType.fromValue((String)this.convertFieldType(bpmField.getTypeName()));
                bpmFieldCardinality = EnumCardinality.fromValue((String)this.convertCardinality(bpmField.isList()));
                if (bpmFieldType != cbFieldType || bpmFieldCardinality != cbFieldCardinality || bpmFieldDirection1 != cbFieldDirection) {
                    msg = new Message("B6023E.IBM_BPM_DATA_FIELD_NOT_COMPATIBLE", cbFieldName, cbWorkflowName);
                    logger.trace((Object)msg.getFormattedText(this.locale));
                    errors.add(msg.getFormattedText(this.locale));
                }
                fieldFound = true;
            }
            if (!fieldFound.booleanValue()) continue;
            break;
        }
        if (!fieldFound.booleanValue()) {
            while (it2.hasNext()) {
                bpmField = it2.next();
                if (bpmField.getName().equals(cbFieldName)) {
                    bpmFieldType = EnumFieldType.fromValue((String)this.convertFieldType(bpmField.getTypeName()));
                    bpmFieldCardinality = EnumCardinality.fromValue((String)this.convertCardinality(bpmField.isList()));
                    if (bpmFieldType != cbFieldType || bpmFieldCardinality != cbFieldCardinality || bpmFieldDirection2 != cbFieldDirection) {
                        msg = new Message("B6023E.IBM_BPM_DATA_FIELD_NOT_COMPATIBLE", cbFieldName, cbWorkflowName);
                        logger.trace((Object)msg.getFormattedText(this.locale));
                        errors.add(msg.getFormattedText(this.locale));
                    }
                    fieldFound = true;
                }
                if (!fieldFound.booleanValue()) continue;
                break;
            }
        }
        if (!fieldFound.booleanValue()) {
            Message msg2 = new Message("B6022E.IBM_BPM_DATA_FIELD_NOT_FOUND", cbFieldName, cbWorkflowName);
            logger.trace((Object)msg2.getFormattedText(this.locale));
            errors.add(msg2.getFormattedText(this.locale));
        }
        return errors;
    }

    private String convertFieldType(String type) {
        if (type.equalsIgnoreCase("Integer")) {
            return "integer";
        }
        if (type.equalsIgnoreCase("Decimal")) {
            return "float";
        }
        if (type.equalsIgnoreCase("Boolean")) {
            return "boolean";
        }
        if (type.equalsIgnoreCase("String")) {
            return "string";
        }
        if (type.equalsIgnoreCase("Date")) {
            return "datetime";
        }
        return "object";
    }

    private String convertCardinality(boolean isList) {
        if (isList) {
            return "multi";
        }
        return "single";
    }

    private void printValidationMap(HashMap<String, List<String>> validationMap) {
        logger.trace((Object)("Validation Map size is " + validationMap.size()));
        for (Map.Entry<String, List<String>> entry : validationMap.entrySet()) {
            String key = entry.getKey();
            List<String> errList = entry.getValue();
            logger.trace((Object)("Key = " + key + " has " + errList.size() + " entries."));
            Iterator<String> it = errList.iterator();
            while (it.hasNext()) {
                logger.trace((Object)("Error = " + it.next()));
            }
        }
    }
}

