/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector.onebpm;

import com.ibm.acm.sold.connector.onebpm.OneBPMConnectionInfo;
import com.ibm.acm.sold.connector.onebpm.OneBPMResponse;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Encoder;

public class OneBPMRequestHandler {
    private static final Log logger = LogFactory.getLog((String)"CB");

    public OneBPMResponse readProcessApps(OneBPMConnectionInfo OneBPMConn) throws AcmException {
        URL url;
        try {
            String proto = null;
            proto = OneBPMConn.isSecure() ? "https" : "http";
            url = new URL(proto + "://" + OneBPMConn.getHost() + ":" + OneBPMConn.getPort() + "/rest/bpm/wle/v1/processApps");
        }
        catch (MalformedURLException e) {
            Message msg = new Message("B0014E.SYSTEM_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
        logger.info((Object)(" Reading Process Apps from: " + url.toString()));
        return this.issueOneBPMRequest(url, "GET", "", "application/json", null, OneBPMConn.getUsername(), OneBPMConn.getPassword());
    }

    public OneBPMResponse readExposedProcesses(OneBPMConnectionInfo OneBPMConn) throws AcmException {
        URL url;
        try {
            String proto = null;
            proto = OneBPMConn.isSecure() ? "https" : "http";
            url = new URL(proto + "://" + OneBPMConn.getHost() + ":" + OneBPMConn.getPort() + "/rest/bpm/wle/v1/exposed/process");
        }
        catch (MalformedURLException e) {
            Message msg = new Message("B0014E.SYSTEM_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
        logger.info((Object)(" Reading Exposed Processes from: " + url.toString()));
        return this.issueOneBPMRequest(url, "GET", "", "application/json", null, OneBPMConn.getUsername(), OneBPMConn.getPassword());
    }

    public OneBPMResponse readProcessModel(OneBPMConnectionInfo OneBPMConn, String bpdId, String snapshotId) throws AcmException {
        URL url;
        try {
            String proto = null;
            proto = OneBPMConn.isSecure() ? "https" : "http";
            url = new URL(proto + "://" + OneBPMConn.getHost() + ":" + OneBPMConn.getPort() + "/rest/bpm/wle/v1/processModel/" + bpdId + "?snapshotId=" + snapshotId + "&parts=dataModel");
        }
        catch (MalformedURLException e) {
            Message msg = new Message("B0014E.SYSTEM_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
        logger.info((Object)(" Reading Process Model from: " + url.toString()));
        return this.issueOneBPMRequest(url, "GET", "", "application/json", null, OneBPMConn.getUsername(), OneBPMConn.getPassword());
    }

    private OneBPMResponse issueOneBPMRequest(URL url, String method, String contentType, String accept, String requestBody, String username, String password) throws AcmException {
        try {
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            this.setupSecurity(urlConn, username, password);
            urlConn.setRequestMethod(method);
            urlConn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            urlConn.setRequestProperty("Accept", "application/json");
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            if (requestBody != null && requestBody.length() > 0) {
                OutputStream out = urlConn.getOutputStream();
                out.write(requestBody.getBytes());
                out.flush();
                out.close();
            }
            OneBPMResponse resp = new OneBPMResponse();
            resp.setHttpResponseCode(urlConn.getResponseCode());
            resp.setHttpResponseMsg(urlConn.getResponseMessage());
            resp.setResponseContentType(urlConn.getContentType());
            InputStream respStream = urlConn.getResponseCode() < 400 ? urlConn.getInputStream() : urlConn.getErrorStream();
            BufferedReader reader = null;
            StringBuilder sb = new StringBuilder();
            if (respStream != null) {
                InputStreamReader isReader = new InputStreamReader(respStream, "UTF-8");
                reader = new BufferedReader(isReader);
                String line = "";
                while ((line = reader.readLine()) != null) {
                    sb.append(line + '\n');
                }
                reader.close();
                isReader.close();
            }
            resp.setResponseBody(sb.toString());
            return resp;
        }
        catch (IOException e) {
            Message msg = new Message("B0014E.SYSTEM_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
    }

    private void setupSecurity(HttpURLConnection urlConn, String username, String password) {
        String userPassword = username + ":" + password;
        String encodedCredentials = new BASE64Encoder().encode(userPassword.getBytes());
        urlConn.setRequestProperty("Authorization", "Basic " + encodedCredentials);
    }
}

