/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector.onebpm;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class OneBPMConnectionInfo {
    private static final int g_keyBytes = 16;
    private String host = null;
    private String port = null;
    private String username = null;
    private String password = null;
    private boolean isSecure = false;

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void getOneBPMConnectionObject(ObjectStore os) throws Exception {
        CustomObject IntgData = null;
        ClassDefinition classDef = Factory.ClassDefinition.fetchInstance((ObjectStore)os, (String)"CmAcmTaskWorkflowLaunchSubscription", null);
        PropertyDefinitionList pdl = classDef.get_PropertyDefinitions();
        for (PropertyDefinition pd : pdl) {
            String symName = pd.get_SymbolicName();
            if (symName.compareTo("CmAcmIntegrationData") != 0) continue;
            IntgData = (CustomObject)pd.getProperties().get("PropertyDefaultObject").getEngineObjectValue();
            break;
        }
        if (IntgData == null) {
            throw new Exception("IBM_BPM_INTEGRATION_DATA_NOT_FOUND)");
        }
        IntgData.refresh();
        this.host = IntgData.getProperties().getStringValue("CmAcmHostName");
        this.port = IntgData.getProperties().getStringValue("CmAcmHostPort");
        this.username = IntgData.getProperties().getStringValue("CmAcmUserName1");
        this.password = IntgData.getProperties().getStringValue("CmAcmUserPassword1");
        this.isSecure = IntgData.getProperties().getBooleanValue("CmAcmUseSecuredProtocol");
        byte[] OneBPMX1 = IntgData.getProperties().getBinaryValue("CmAcmX1");
        byte[] OneBPMX2 = IntgData.getProperties().getBinaryValue("CmAcmX2");
        String OneBPMUserPasswordDate1 = IntgData.getProperties().getStringValue("CmAcmUserPasswordDateTime1");
        String OneBPMUserPasswordDate2 = IntgData.getProperties().getStringValue("CmAcmUserPasswordDateTime2");
        try {
            this.username = OneBPMConnectionInfo.decrypt(OneBPMUserPasswordDate1, OneBPMX1, this.username);
            this.password = OneBPMConnectionInfo.decrypt(OneBPMUserPasswordDate1, OneBPMX1, this.password);
        }
        catch (Exception e) {
            this.username = IntgData.getProperties().getStringValue("CmAcmUserName2");
            this.password = IntgData.getProperties().getStringValue("CmAcmUserPassword2");
            this.username = OneBPMConnectionInfo.decrypt(OneBPMUserPasswordDate2, OneBPMX2, this.username);
            this.password = OneBPMConnectionInfo.decrypt(OneBPMUserPasswordDate2, OneBPMX2, this.password);
        }
    }

    private static String decrypt(String S2, byte[] obscKey, String S3) throws Exception {
        int i;
        byte[] key = new byte[16];
        int n = S2.length();
        byte[] ba = new byte[n];
        for (i = 0; i < n; ++i) {
            ba[i] = (byte)(S2.charAt(i) & 0xFF);
        }
        int balen = ba.length;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(ba, 0, balen);
        byte[] X = md.digest();
        for (i = 0; i < 16; ++i) {
            key[i] = (byte)((X[i] ^ obscKey[i]) & 0xFF);
        }
        int S3len = S3.length();
        int v2clen = S3len / 2;
        byte[] v2c = new byte[v2clen];
        int j = 0;
        for (i = 0; i < S3len; i += 2) {
            char t = S3.charAt(i);
            int hi = t & 0xFF;
            hi = (byte)((hi <= 57 ? hi - 48 : hi + 10 - 65) & 0xFF);
            t = S3.charAt(i + 1);
            int lo = t & 0xFF;
            lo = (byte)((lo <= 57 ? lo - 48 : lo + 10 - 65) & 0xFF);
            v2c[j++] = (byte)((hi << 4 | lo) & 0xFF);
        }
        Cipher c = Cipher.getInstance("AES");
        c.init(2, new SecretKeySpec(key, "AES"));
        byte[] decv = c.doFinal(v2c);
        int decvlen = decv.length;
        StringBuffer sb = new StringBuffer();
        for (i = 4; i < decvlen; i += 2) {
            byte t1 = decv[i];
            byte t2 = decv[i + 1];
            sb.append((char)((t1 & 0xFF) << 8 | t2 & 0xFF));
        }
        return new String(sb);
    }
}

