/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.util.UserContext;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.connector.Args;
import com.ibm.acm.sold.connector.XpdlDocHandler;
import com.ibm.acm.sold.converter.AcmProcessSolutionData;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import filenet.vw.api.VWException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XpdlLoader
implements Runnable {
    Args arg;
    private static Log log = LogFactory.getLog((String)XpdlLoader.class.getName());
    private AcmException acmexp = null;
    private Subject authSubject = null;
    private Locale userLocale = null;
    private Locale origLocale = null;
    private UserContext tempUC = null;

    public XpdlLoader(Args arg, Subject authSubject, Locale userLocale) {
        this.arg = arg;
        this.authSubject = authSubject;
        this.userLocale = userLocale;
    }

    public void setAcmexp(AcmException acmexp) {
        this.acmexp = acmexp;
    }

    public AcmException getAcmexp() {
        return this.acmexp;
    }

    public void openSession() throws AcmConnectionFailure {
        this.tempUC = UserContext.get();
        this.origLocale = this.tempUC.getLocale();
        this.tempUC.setLocale(this.userLocale);
        Connection conn = null;
        Domain domain = null;
        try {
            conn = Factory.Connection.getConnection((String)this.arg.getConfig().getCeUri());
            log.debug((Object)("Connection :" + conn));
            if (!this.arg.getConfig().isJaasAuthentication()) {
                Subject m_subj = UserContext.createSubject((Connection)conn, (String)this.arg.getConfig().getUserName(), (String)this.arg.getConfig().getPassword(), null);
                this.tempUC.pushSubject(m_subj);
            } else {
                this.tempUC.pushSubject(this.authSubject);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage());
            Message msg = new Message("B0005E.CONNECTION_FAILURE", e.getLocalizedMessage());
            throw new AcmConnectionFailure(msg);
        }
        if (conn == null) {
            Message msg = new Message("B0005E.CONNECTION_FAILURE");
            throw new AcmConnectionFailure(msg);
        }
        try {
            domain = Factory.Domain.getInstance((Connection)conn, null);
            log.debug((Object)("Domain :" + domain));
        }
        catch (EngineRuntimeException e) {
            log.error((Object)e, (Throwable)e);
            Message msg = new Message("B0006E.DOMAIN_FAILURE");
            throw new AcmConnectionFailure(msg);
        }
        try {
            domain.fetchProperty("ObjectStores", null);
            this.arg.setObjectstore(Factory.ObjectStore.fetchInstance((Domain)domain, (String)this.arg.getConfig().getObjStore(), null));
            log.debug((Object)("ObjectStore :" + this.arg.getObjectstore()));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            Message msg = new Message("B0006E.DOMAIN_FAILURE");
            throw new AcmConnectionFailure(msg, (Throwable)e);
        }
        log.trace((Object)"<< OpenSession");
    }

    public void closeSession() {
        log.trace((Object)">> closeSession");
        if (this.tempUC != null) {
            this.tempUC.setLocale(this.origLocale);
            this.tempUC.popSubject();
        }
        log.trace((Object)"<< closeSession");
    }

    @Override
    public void run() {
        log.trace((Object)">Starter Thread ");
        try {
            this.openSession();
        }
        catch (AcmConnectionFailure e1) {
            this.setAcmexp(e1);
            this.closeSession();
            return;
        }
        for (CaseTypeType ct : this.arg.getSolntype().getCaseTypes().getCaseType()) {
            try {
                log.debug((Object)("Creating xpdl for :" + ct.getDisplayName()));
                this.initCaseTypeData(ct, this.arg.getSolData());
            }
            catch (AcmException e) {
                this.setAcmexp(e);
            }
        }
        this.closeSession();
        log.trace((Object)"<ended thread");
    }

    public void initCaseTypeData(CaseTypeType caseType, SolutionData solData) throws AcmException {
        log.trace((Object)">initCaseType");
        AcmProcessSolutionData procSolData = new AcmProcessSolutionData(solData);
        CaseTypeData ctData = new CaseTypeData();
        if (ctData.getId() == null) {
            ctData.setId(caseType.getId());
        }
        ctData.setSymName(caseType.getName());
        ctData.setDisplayName(caseType.getDisplayName());
        log.debug((Object)("Name :" + caseType.getName()));
        ctData = procSolData.updateCaseTypeDataSharedInfo(solData, caseType.getName(), ctData);
        log.debug((Object)"update of caseTypeDta is completed");
        List actList = caseType.getTasks().getTask();
        XpdlDocHandler xpdldochandler = new XpdlDocHandler(this.arg);
        InputStream xpdlStream = xpdldochandler.retrieveXPDLdoc(ctData.getSymName(), false);
        for (TaskType act : actList) {
            AcmActivity acmActiv = null;
            log.debug((Object)("Creating Activity for Task : " + act.getDisplayName()));
            if (act.getWorkflowType() != null && act.getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) continue;
            acmActiv = procSolData.createActivityObject(act);
            try {
                acmActiv.setGuid(ctData.getId(), acmActiv.getSdfData().getId());
            }
            catch (VWException e) {
                log.error((Object)" error ::  ", (Throwable)e);
                Message msg = new Message("B4066E.VW_EXCEPTION");
                throw new AcmException(msg, (Throwable)e);
            }
            ctData.addActivity(acmActiv);
        }
        try {
            if (xpdlStream != null) {
                ctData.readXpdl(xpdlStream, false);
            } else {
                log.warn((Object)("No XPDL Available for CaseType : " + ctData.getSymName()));
            }
        }
        catch (DiagrammerException e) {
            log.error((Object)" error ::  ", (Throwable)e);
            Message msg = new Message("B4064E.ERROR_DIAGRAM_MODEL");
            throw new AcmException(msg, (Throwable)e);
        }
        solData.setCasetypedata(caseType.getName(), ctData);
        log.trace((Object)"< initCaseType");
    }
}

