/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Document;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.util.Id;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.connector.Args;
import com.ibm.acm.sold.connector.CEDocumentHandler;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ContentType;
import java.io.InputStream;
import java.text.Collator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XpdlDocHandler {
    private String userName = null;
    ObjectStore objectstore = null;
    private SolutionData solData = null;
    private static Log log = LogFactory.getLog((String)XpdlDocHandler.class.getName());

    public XpdlDocHandler(Args arg) {
        this.userName = arg.getUserName();
        this.objectstore = arg.getObjectstore();
        this.solData = arg.getSolData();
    }

    public InputStream retrieveXPDLdoc(String caseTypeName, boolean checkOut) throws AcmException {
        log.trace((Object)">retrieveXPDLdoc");
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        InputStream input = null;
        Id vsId = null;
        if (caseTypeName == null || caseTypeName.length() == 0) {
            log.warn((Object)" case name is NULL");
            Message msg = new Message("B4001E.INVALID_ARGUMENTS_TO_METHOD", "CaseType Name is NULL");
            throw new AcmException(msg);
        }
        List caseTypes = null;
        if (this.solData.getSdfData() == null || this.solData.getSdfData().getSolutionType() == null || this.solData.getSdfData().getSolutionType().getCaseTypes() == null) {
            log.warn((Object)"soldata is NULL");
            return null;
        }
        caseTypes = this.solData.getSdfData().getSolutionType().getCaseTypes().getCaseType();
        log.debug((Object)"casetypes found in solution data");
        for (CaseTypeType caseType : caseTypes) {
            if (!Collator.getInstance().equals(caseTypeName, caseType.getName())) continue;
            log.debug((Object)("Case Name matched :" + caseTypeName));
            ContentType ct = caseType.getProcessDefinition();
            if (ct == null) break;
            vsId = new Id(ct.getContentId());
            break;
        }
        if (vsId == null) {
            log.warn((Object)"VSID is null");
            return null;
        }
        try {
            Document xpdlDoc = docHandler.retrieveDocument(vsId, this.userName, checkOut);
            log.debug((Object)("XPDL document retrieved for VSID :" + vsId));
            xpdlDoc.save(RefreshMode.NO_REFRESH);
            input = docHandler.fetchDocumentContent(xpdlDoc);
        }
        catch (Throwable t) {
            log.error((Object)"exceptio", t);
            Message msg = new Message("B4029E.XPDL_NOT_AVAILABLE", t.getLocalizedMessage());
            throw new AcmException(msg.getFormattedText(), "B4029E.XPDL_NOT_AVAILABLE");
        }
        log.trace((Object)"<retrieveXPDLdoc");
        return input;
    }
}

