/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.ibm.acm.sold.connector.IConnector;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utility
implements IConnector {
    private static final Log log = LogFactory.getLog((String)Utility.class.getName());

    public static InputStream getResourceAsStream(String fname) throws AcmException {
        FileInputStream fis = null;
        File file = new File(fname);
        if (file.exists()) {
            try {
                log.debug((Object)" file found");
                fis = new FileInputStream(fname);
            }
            catch (FileNotFoundException e) {
                Message msg = new Message("B4042E.FILE_NOT_FOUND");
                throw new AcmException(msg, (Throwable)e);
            }
        } else {
            log.warn((Object)" file not found");
        }
        return fis;
    }

    public static InputStream stringToStream(String str) throws AcmException {
        if (str == null) {
            Message msg = new Message("B4001E.INVALID_ARGUMENTS_TO_METHOD");
            log.error((Object)"B4001E.INVALID_ARGUMENTS_TO_METHOD");
            throw new AcmException(msg);
        }
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Message msg = new Message("B4031E.CONVERSION_EXCEPTION");
            throw new AcmException(msg, (Throwable)e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static String readAsUTF8(String src) throws AcmException {
        byte[] buf;
        if (src == null) {
            return null;
        }
        try {
            buf = src.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e1) {
            Message msg = new Message("B4031E.CONVERSION_EXCEPTION");
            throw new AcmException(msg, (Throwable)e1);
        }
        String utf8Str = null;
        try {
            utf8Str = new String(buf, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Message msg = new Message("B4031E.CONVERSION_EXCEPTION");
            throw new AcmException(msg, (Throwable)e);
        }
        return utf8Str;
    }

    public static void deleteTempFile(String fileName) {
        if (null == fileName || fileName.equals("")) {
            return;
        }
        log.debug((Object)("File to be deleted : " + fileName));
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static String readStream(InputStream input, int length) throws AcmException {
        int totalBytesread = 0;
        byte[] buf = new byte[length];
        StringBuffer result = new StringBuffer(length);
        int bytesRead = 0;
        try {
            bytesRead = input.read(buf, 0, length);
        }
        catch (IOException e1) {
            log.error((Object)" error ::", (Throwable)e1);
            Message msg = new Message("B4026E.CONTENT_RETRIEVAL_FAILED" + e1.getLocalizedMessage());
            throw new AcmException(msg);
        }
        while (bytesRead > 0) {
            try {
                result.append(new String(buf, 0, bytesRead, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Message msg = new Message("B4031E.CONVERSION_EXCEPTION");
                throw new AcmException(msg, (Throwable)e);
            }
            totalBytesread += bytesRead;
            try {
                bytesRead = input.read(buf, 0, length);
            }
            catch (IOException e) {
                log.error((Object)" error ::", (Throwable)e);
                Message msg = new Message("B4026E.CONTENT_RETRIEVAL_FAILED" + e.getLocalizedMessage());
                throw new AcmException(msg);
            }
        }
        return result.toString();
    }
}

