/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.xml.XMLToJSONTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class RetrieveUtil {
    private static final Log m_logger = LogFactory.getLog((String)RetrieveUtil.class.getName());
    private static final String m_className = "RetrieveUtil";

    public static String convertXmlToJson(String solutionXml) throws AcmException {
        Message msg;
        String m_method = "convertXmlToJson";
        m_logger.debug((Object)("RetrieveUtil:convertXmlToJson Original Solution XML: " + solutionXml));
        String solutionJson = null;
        solutionXml = solutionXml.replace("propertyBooleanDefinition", "property");
        solutionXml = solutionXml.replace("propertyIntegerDefinition", "property");
        solutionXml = solutionXml.replace("propertyStringDefinition", "property");
        solutionXml = solutionXml.replace("propertyDateTimeDefinition", "property");
        solutionXml = solutionXml.replace("propertyDecimalDefinition", "property");
        solutionXml = solutionXml.replace("choiceListIntegerDefinition", "choiceList");
        solutionXml = solutionXml.replace("choiceListStringDefinition", "choiceList");
        Pattern p = Pattern.compile("(?:\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3})");
        Matcher m = p.matcher(solutionXml);
        while (m.find()) {
            String df = m.group();
            int i = df.indexOf(46);
            String mill = df.substring(i, i + 4);
            df = df.replace(mill, "");
            solutionXml = solutionXml.replace(m.group(), df);
        }
        solutionXml = solutionXml.replace("<label/>", "");
        solutionXml = solutionXml.replace("<label></label>", "");
        solutionXml = solutionXml.replace("<defaultValue/>", "");
        solutionXml = solutionXml.replace("<defaultValue></defaultValue>", "");
        solutionXml = solutionXml.replace("<inbasketFilter/>", "");
        solutionXml = solutionXml.replace("<inbasketFilter></inbasketFilter>", "");
        solutionXml = solutionXml.replace("<localNamespace></localNamespace>", "");
        solutionXml = solutionXml.replace("<localNamespace/>", "");
        m_logger.debug((Object)("RetrieveUtil:convertXmlToJson Modified Solution XML: " + solutionXml));
        InputStream solutionStream = Utility.stringToStream(solutionXml);
        try {
            solutionJson = XMLToJSONTransformer.transform((InputStream)solutionStream);
            solutionJson = solutionJson.replace("\"id\":true,", "");
            solutionJson = solutionJson.replace(",\"id\":true", "");
            solutionJson = solutionJson.replace(",\"label\":true", "");
            solutionJson = solutionJson.replace("\"label\":true,", "");
            solutionJson = solutionJson.replace("\"description\":true,", "");
            solutionJson = solutionJson.replace(",\"description\":true", "");
        }
        catch (SAXException e) {
            m_logger.error((Object)" error ::", (Throwable)e);
            msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        catch (IOException e) {
            m_logger.error((Object)" error ::", (Throwable)e);
            msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        m_logger.debug((Object)("RetrieveUtil:convertXmlToJson Solution JSON: " + solutionJson));
        return solutionJson;
    }
}

