/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.type.Column;
import com.ibm.acm.sold.common.type.Filter;
import com.ibm.acm.sold.common.type.InbasketType;
import com.ibm.acm.sold.common.type.InbasketsType;
import com.ibm.acm.sold.common.type.RoleInbasketsType;
import com.ibm.acm.sold.common.type.RoleType;
import com.ibm.acm.sold.common.type.RolesType;
import com.ibm.acm.sold.common.type.TypeState;
import com.ibm.acm.sold.converter.AcmConverter;
import com.ibm.acm.sold.diagrammer.types.AcmStepProcessorListWrapper;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumPropertyType;

public class PEConfig {
    private SolutionData solutionData;
    private static final Log m_log = LogFactory.getLog((String)PEConfig.class.getName());
    protected AcmConverter m_acmConverter = null;
    protected VWSystemConfiguration m_vwSystemConfiguration = null;
    public HashMap<String, List<VWWorkBasketColumnDefinition>> columnFromOutsideInfo = new HashMap();
    protected List<String> existingQueues = new ArrayList<String>();
    protected String personalInbasketName = null;

    public List<String> getExistingQueues() {
        return this.existingQueues;
    }

    public void setExistingQueues(List<String> existingQueues) {
        this.existingQueues = existingQueues;
    }

    public PEConfig(SolutionData solData, AcmConverter converter) {
        this.solutionData = solData;
        this.m_acmConverter = converter;
        if (this.solutionData.getRoles() == null) {
            this.solutionData.setRoles(new RolesType());
        }
        if (this.solutionData.getInbaskets() == null) {
            this.solutionData.setInbaskets(new InbasketsType());
        }
        if (this.m_vwSystemConfiguration == null) {
            this.m_vwSystemConfiguration = new VWSystemConfiguration();
        }
    }

    public VWSystemConfiguration getSystemConfiguration() {
        return this.m_vwSystemConfiguration;
    }

    public void setConverter(AcmConverter converter) {
        this.m_acmConverter = converter;
    }

    public void initializeConfig(InputStream inStream) throws AcmException {
        CBLogger.trace(m_log, ">initializeConfig ");
        try {
            this.m_vwSystemConfiguration = new VWSystemConfiguration();
            this.m_vwSystemConfiguration.importConfig(inStream);
            VWApplicationSpaceDefinition vwAppSpaceDef = this.m_vwSystemConfiguration.getApplicationSpaceDefinition(this.getSolutionName());
            if (vwAppSpaceDef != null) {
                VWQueueDefinition[] queueList = this.m_vwSystemConfiguration.getQueueDefinitions();
                InbasketsType inbaskets = new InbasketsType();
                Integer inIndex = 1;
                if (queueList != null) {
                    for (int i = 0; i < queueList.length; ++i) {
                        String queueName = queueList[i].getName();
                        this.existingQueues.add(queueName);
                        VWQueueDefinition queueDef = queueList[i];
                        VWWorkBasketDefinition[] workBaskets = queueDef.getWorkBasketDefinitions();
                        if (workBaskets == null) continue;
                        for (int j = 0; j < workBaskets.length; ++j) {
                            VWWorkBasketDefinition wbDef = workBaskets[j];
                            InbasketType inbasket = this.create_Inbasket(wbDef);
                            if (inbasket == null) continue;
                            inbaskets.getInbasketTable().put(inIndex, inbasket);
                            Integer n = inIndex;
                            Integer n2 = inIndex = Integer.valueOf(inIndex + 1);
                        }
                    }
                }
                RolesType rolesType = new RolesType();
                VWRoleDefinition[] roleDefs = vwAppSpaceDef.getRoleDefinitions();
                Integer index = 1;
                if (roleDefs != null) {
                    for (int i = 0; i < roleDefs.length; ++i) {
                        RoleType newRoleType = this.createType_RoleType(roleDefs[i], inbaskets);
                        if (newRoleType != null) {
                            rolesType.getRoleTable().put(index, newRoleType);
                        }
                        CBLogger.debug(m_log, "added role to roles");
                        Integer n = index;
                        Integer n3 = index = Integer.valueOf(index + 1);
                    }
                }
                this.solutionData.setRoles(rolesType);
                this.solutionData.setInbaskets(inbaskets);
            }
        }
        catch (Throwable t) {
            Message msg = new Message("B0010E.ERROR_INITIALIZING_PECONFIG", t.getLocalizedMessage());
            throw new AcmException(msg);
        }
        CBLogger.trace(m_log, "<initializeConfig");
    }

    private InbasketType create_Inbasket(VWWorkBasketDefinition wbDef) throws VWException, AcmException {
        VWExposedFieldDefinition fieldDef;
        CBLogger.trace(m_log, ">create_Inbasket");
        InbasketType inbasket = new InbasketType();
        String queueName = wbDef.getQueueName();
        inbasket.setQueue(queueName);
        inbasket.setName(wbDef.getName());
        inbasket.setDescription(wbDef.getDescription());
        if (queueName.equals("Inbox")) {
            VWAttributeInfo attributes = wbDef.getAttributeInfo();
            if (attributes.getAttributeNames() != null && attributes.getFieldValue("ECM_RemovePrefix") != null) {
                String removePre = (String)attributes.getFieldValue("ECM_RemovePrefix");
                int nIndex = wbDef.getName().indexOf(removePre);
                if (nIndex == 0) {
                    inbasket.setRemovePrefix(removePre);
                }
            }
            if (wbDef.isShowWorkForAllUsers()) {
                inbasket.setType("Work Assignment Inbasket");
            } else {
                VWAttributeInfo attributeInfo = wbDef.getAttributeInfo();
                if (attributeInfo != null && this.personalInbasketName == null && wbDef.getName().startsWith(this.getSolutionPrefix() + "_")) {
                    Object value = attributeInfo.getFieldValue("CB_Inbasket");
                    if (value != null && value instanceof String && ((String)value).contentEquals(this.getSolutionName())) {
                        inbasket.setType("Solution Personal Inbasket");
                        this.personalInbasketName = inbasket.getName();
                    }
                } else {
                    inbasket.setType("Role Personal Inbasket");
                }
            }
        } else {
            inbasket.setType("Role Inbasket");
        }
        inbasket.setColumns(new ArrayList<Column>(100));
        inbasket.setFilters(new ArrayList<Filter>(100));
        VWWorkBasketColumnDefinition[] vwColumnDefs = wbDef.getWorkBasketColumnDefinitions();
        if (vwColumnDefs == null) {
            CBLogger.debug(m_log, "Columns are null ");
        } else {
            CBLogger.debug(m_log, "Creating the columns");
            for (int i = 0; i < vwColumnDefs.length; ++i) {
                Object value;
                VWAttributeInfo attributes;
                Column col = new Column();
                String columnName = vwColumnDefs[i].getName();
                String columnLabel = vwColumnDefs[i].getPrompt();
                fieldDef = vwColumnDefs[i].getColumn();
                if (fieldDef != null) {
                    columnName = fieldDef.getName();
                }
                col.setName(columnName);
                col.setSortable(vwColumnDefs[i].isSortable());
                col.setLabel(columnLabel);
                if (col.isSortable() && (attributes = vwColumnDefs[i].getAttributeInfo()) != null && (value = attributes.getFieldValue("ECM_SortOrder")) != null && value instanceof String) {
                    col.setSortDefault(true);
                    if ("Ascending".compareTo((String)value) == 0) {
                        col.setSortAscending(true);
                    } else if ("Descending".compareTo((String)value) == 0) {
                        col.setSortAscending(false);
                    }
                    attributes = wbDef.getAttributeInfo();
                    if (attributes != null && (value = attributes.getFieldValue("ECM_SortDefault")) != null && value instanceof String) {
                        CBLogger.debug(m_log, "Default sort column is: " + value.toString());
                    }
                }
                inbasket.getColumns().add(col);
            }
        }
        VWWorkBasketFilterDefinition[] wbFilterDefs = wbDef.getWorkBasketFilterDefinitions();
        if (wbFilterDefs != null) {
            for (int i = 0; i < wbFilterDefs.length; ++i) {
                Filter newCondition = new Filter();
                String conditionType = null;
                fieldDef = wbFilterDefs[i].getSearchField();
                if (fieldDef != null) {
                    newCondition.setName(fieldDef.getName());
                }
                newCondition.setLabel(wbFilterDefs[i].getPrompt());
                if (fieldDef != null) {
                    int fieldType = fieldDef.getFieldType();
                    switch (fieldType) {
                        case 1: {
                            conditionType = "integer";
                            break;
                        }
                        case 2: {
                            conditionType = "string";
                            break;
                        }
                        case 4: {
                            conditionType = "boolean";
                            break;
                        }
                        case 8: {
                            conditionType = "float";
                            break;
                        }
                        case 16: {
                            conditionType = "datetime";
                        }
                    }
                }
                newCondition.setType(conditionType);
                switch (wbFilterDefs[i].getOperator()) {
                    case 4: {
                        newCondition.setOperator("<");
                        break;
                    }
                    case 2: {
                        newCondition.setOperator(">");
                        break;
                    }
                    case 5: {
                        newCondition.setOperator("<=");
                        break;
                    }
                    case 3: {
                        newCondition.setOperator(">=");
                        break;
                    }
                    case 0: {
                        newCondition.setOperator("=");
                        break;
                    }
                    case 1: {
                        newCondition.setOperator("!=");
                        break;
                    }
                    case 6: {
                        newCondition.setOperator("%");
                        break;
                    }
                    case 7: {
                        newCondition.setOperator("!%");
                    }
                }
                inbasket.getFilters().add(newCondition);
            }
        }
        CBLogger.trace(m_log, "<create_Inbasket");
        return inbasket;
    }

    public Map<String, List<VWWorkBasketColumnDefinition>> getColumnFromOutsideInfo() {
        return this.columnFromOutsideInfo;
    }

    public void setColumnFromOutsideInfo(HashMap<String, List<VWWorkBasketColumnDefinition>> columnFromOutsideInfo) {
        this.columnFromOutsideInfo = columnFromOutsideInfo;
    }

    private RoleType createType_RoleType(VWRoleDefinition vwRoleDef, InbasketsType inbaskets) throws VWException, AcmException {
        CBLogger.trace(m_log, ">>createRoleType");
        boolean roleSpecificFound = false;
        boolean generalFound = false;
        RoleType newRoleType = new RoleType();
        VWWorkBasketDefinition[] wbDefs = vwRoleDef.getWorkBasketDefinitions();
        newRoleType.setName(vwRoleDef.getName());
        newRoleType.setDescription(vwRoleDef.getDescription());
        newRoleType.setRoleInbasketsType(new ArrayList<RoleInbasketsType>(100));
        boolean ableToAssignWork = true;
        VWAttributeInfo attributes = vwRoleDef.getAttributeInfo();
        if (attributes.getAttributeNames() != null) {
            boolean assignedWorkInBasketViewable = false;
            boolean ableToMoveWorkToPersonalInBasket = false;
            String primaryQueue = null;
            if (attributes.getFieldValue("ECM_canAssignWork") != null) {
                ableToAssignWork = (Boolean)attributes.getFieldValue("ECM_canAssignWork");
                newRoleType.setCanAssignWork(ableToAssignWork);
            }
            if (attributes.getFieldValue("ECM_viewAssignedWorkInBasket") != null) {
                assignedWorkInBasketViewable = (Boolean)attributes.getFieldValue("ECM_viewAssignedWorkInBasket");
                newRoleType.setViewAssignedWorkInBasket(assignedWorkInBasketViewable);
            }
            if (attributes.getFieldValue("ECM_canMoveWorkToPersonalInBasket") != null) {
                ableToMoveWorkToPersonalInBasket = (Boolean)attributes.getFieldValue("ECM_canMoveWorkToPersonalInBasket");
                newRoleType.setCanMoveWorkToPersonalInBasket(ableToMoveWorkToPersonalInBasket);
            }
            if (attributes.getFieldValue("CB_PrimaryQueue") != null) {
                primaryQueue = (String)attributes.getFieldValue("CB_PrimaryQueue");
                newRoleType.setPrimaryQueue(primaryQueue);
            }
        }
        if (wbDefs != null && (newRoleType.getPrimaryQueue() == null || newRoleType.getPrimaryQueue().isEmpty()) && this.m_acmConverter != null && this.m_acmConverter.getSolutionType() != null && (this.m_acmConverter.getSolutionType().getSchemaVersion().equals("1.0") || this.m_acmConverter.getSolutionType().getSchemaVersion().equals("2.0"))) {
            m_log.info((Object)("++++ Upgrade needed, Old solution version found:" + this.m_acmConverter.getSolutionType().getSchemaVersion()));
            newRoleType.setCanAssignWork(true);
            String queueName = null;
            for (int k = 0; k < wbDefs.length; ++k) {
                Object value;
                VWAttributeInfo attributeInfo = wbDefs[k].getAttributeInfo();
                if (attributeInfo == null || (value = attributeInfo.getFieldValue("CB_Inbasket")) == null || !(value instanceof String) || !((String)value).contentEquals(this.getSolutionName())) continue;
                queueName = wbDefs[k].getQueueName();
                if (!queueName.equals("Inbox")) break;
                queueName = null;
            }
            if (queueName != null) {
                m_log.info((Object)("++++ Primary queue associated to the role :" + newRoleType.getName() + "is :" + queueName));
                newRoleType.setPrimaryQueue(queueName);
            }
        }
        generalFound = false;
        roleSpecificFound = false;
        if (wbDefs != null) {
            for (int i = 0; i < wbDefs.length; ++i) {
                RoleInbasketsType roleInbasket = new RoleInbasketsType();
                String queueName = wbDefs[i].getQueueName();
                roleInbasket.setName(wbDefs[i].getName());
                roleInbasket.setQueue(wbDefs[i].getQueueName());
                newRoleType.getRoleInbasketsType().add(roleInbasket);
                if (!queueName.equals("Inbox")) continue;
                VWAttributeInfo attributeInfo = wbDefs[i].getAttributeInfo();
                if (this.personalInbasketName != null && this.personalInbasketName.equals(wbDefs[i].getName()) && !generalFound) {
                    Object value = attributeInfo.getFieldValue("CB_Inbasket");
                    if (value == null || !(value instanceof String) || !((String)value).contentEquals(this.getSolutionName())) continue;
                    generalFound = true;
                    if (this.m_acmConverter == null || this.m_acmConverter.getSolutionType() == null || !this.m_acmConverter.getSolutionType().getSchemaVersion().equals("1.0") && !this.m_acmConverter.getSolutionType().getSchemaVersion().equals("2.0")) continue;
                    newRoleType.setCanMoveWorkToPersonalInBasket(true);
                    continue;
                }
                if (wbDefs[i].isShowWorkForAllUsers() || roleSpecificFound) continue;
                roleSpecificFound = true;
            }
            if (roleSpecificFound) {
                newRoleType.setPersonalInbasketType("Role-specific");
            } else if (generalFound) {
                newRoleType.setPersonalInbasketType("General");
            } else {
                newRoleType.setPersonalInbasketType("None");
            }
        }
        return newRoleType;
    }

    public void createPagesStepProcessors(SolutionData solData, List<String> availablePages) throws AcmException {
        CBLogger.trace(m_log, ">createPagesStepProcessors");
        if (solData == null) {
            return;
        }
        this.cleanStepProcessors(solData, availablePages);
        Set<String> validPagesList = solData.getStepPagesList();
        Set<String> validLaunchPagesList = solData.getStepLaunchPagesList();
        for (String lspName : validLaunchPagesList) {
            this.createStepProcessor(lspName, 4);
        }
        for (String spName : validPagesList) {
            this.createStepProcessor(spName, 8);
        }
        CBLogger.trace(m_log, "<createPagesStepProcessors");
    }

    public void addStepProcessors(SolutionData solutionData) throws AcmException {
        List cases;
        CBLogger.trace(m_log, ">addStepProcessors");
        this.solutionData = solutionData;
        if (solutionData == null) {
            return;
        }
        CBLogger.trace(m_log, ">>addStepProcessors");
        SolutionType solutionType = this.m_acmConverter.getSolutionType();
        if (solutionType != null && solutionType.getCaseTypes() != null && (cases = solutionType.getCaseTypes().getCaseType()) != null) {
            for (CaseTypeType caseType : cases) {
                AcmStepProcessorListWrapper spListWrapper;
                if (solutionData.getCasetypedata(caseType.getName()) == null || (spListWrapper = solutionData.getCasetypedata(caseType.getName()).fetchStepProcessorPagesUsed()) == null) continue;
                for (String lspName : spListWrapper.getLaunchStepPages()) {
                    this.createStepProcessor(lspName, 4);
                }
                for (String spName : spListWrapper.getPages()) {
                    this.createStepProcessor(spName, 8);
                }
            }
        }
        CBLogger.trace(m_log, "<addStepProcessors");
    }

    private void createStepProcessor(String spName, int nProcessorType) {
        CBLogger.trace(m_log, ">createStepProcessor");
        if (this.m_vwSystemConfiguration == null || spName == null || spName.length() == 0) {
            return;
        }
        try {
            VWStepProcessorInfoDefinition spInfoDef = this.m_vwSystemConfiguration.getStepProcessorInfoDefinition(spName);
            if (spInfoDef != null) {
                return;
            }
            spInfoDef = this.m_vwSystemConfiguration.createStepProcessorInfoDefinition();
            if (spInfoDef != null) {
                spInfoDef.setName(spName);
                spInfoDef.setHasChanged(true);
                spInfoDef.setHeight(600);
                spInfoDef.setWidth(800);
                spInfoDef.setProcessorType(nProcessorType);
                spInfoDef.setAppType(32);
            }
        }
        catch (VWException ex) {
            m_log.error((Object)("Error creating step processor: " + spName), (Throwable)ex);
        }
        CBLogger.trace(m_log, "<createStepProcessor");
    }

    private void cleanStepProcessors(SolutionData solData, List<String> pages) throws AcmException {
        CBLogger.trace(m_log, ">cleanStepProcessors");
        HashSet<VWStepProcessorInfoDefinition> deleteProcessors = new HashSet<VWStepProcessorInfoDefinition>();
        try {
            for (VWStepProcessorInfoDefinition spInfoDef : this.m_vwSystemConfiguration.getStepProcessorInfoDefinitions()) {
                if (!this.isBSpacePage(spInfoDef.getName()) || pages == null || pages.isEmpty() || pages.contains(spInfoDef.getName())) continue;
                deleteProcessors.add(spInfoDef);
            }
            for (VWStepProcessorInfoDefinition spInfoDef : deleteProcessors) {
                this.m_vwSystemConfiguration.deleteStepProcessorInfoDefinition(spInfoDef);
            }
        }
        catch (VWException ex) {
            m_log.error((Object)("Error deleting step processor: " + (Object)((Object)ex)));
        }
        CBLogger.trace(m_log, "<cleanStepProcessors");
    }

    public InputStream generateConfig(SolutionData solData) throws AcmConnectionFailure, AcmException {
        CBLogger.trace(m_log, ">>generateConfig");
        try {
            Collection<RoleType> roleTypeList;
            VWQueueDefinition inboxQueue;
            VWApplicationSpaceDefinition vwAppSpaceDef;
            if (this.m_vwSystemConfiguration == null) {
                this.m_vwSystemConfiguration = new VWSystemConfiguration();
            }
            if ((vwAppSpaceDef = this.m_vwSystemConfiguration.getApplicationSpaceDefinition(this.getSolutionName())) == null) {
                CBLogger.trace(m_log, "Creating application space definition: " + this.getSolutionName());
                vwAppSpaceDef = this.m_vwSystemConfiguration.createApplicationSpaceDefinition(this.getSolutionName());
            }
            String rosterName = this.getSafeName(NAMES.ROSTER, this.getSolutionName());
            VWRosterDefinition[] rostersDef = this.m_vwSystemConfiguration.getRosterDefinitions();
            VWRosterDefinition rosterDef = null;
            if (rostersDef == null) {
                m_log.info((Object)("Creating roster definition: " + rosterName));
                rosterDef = this.m_vwSystemConfiguration.createRosterDefinition(rosterName);
                if (rosterDef != null) {
                    rosterDef.createFieldDefinition("F_CaseTask", 512, 0);
                    rosterDef.createFieldDefinition("F_CaseFolder", 512, 0);
                }
            }
            if ((inboxQueue = this.m_vwSystemConfiguration.getQueueDefinition("Inbox")).getField("SolutionIdentifier") == null) {
                inboxQueue.createFieldDefinition("SolutionIdentifier", 2, 64);
            }
            VWWorkBasketDefinition[] wbDefs = new VWWorkBasketDefinition[]{};
            VWRoleDefinition[] roleDefs = vwAppSpaceDef.getRoleDefinitions();
            if (roleDefs != null) {
                for (VWRoleDefinition role : roleDefs) {
                    role.setWorkBasketDefinitions(wbDefs);
                }
            }
            this.createInbaskets();
            RolesType roles = this.solutionData.getRoles();
            if (roles != null && (roleTypeList = roles.getRoleTable().values()) != null) {
                m_log.info((Object)"Processing Roles:");
                ArrayList<RoleType> deletedRoles = new ArrayList<RoleType>();
                for (RoleType tmpRoleType : roleTypeList) {
                    if (tmpRoleType == null) continue;
                    VWRoleDefinition vwRoleDef = vwAppSpaceDef.getRoleDefinition(tmpRoleType.getName());
                    if (tmpRoleType.getState() == TypeState.EnumTypeState.DELETED) {
                        if (vwRoleDef != null) {
                            VWQueueDefinition primaryQueue;
                            CBLogger.debug(m_log, "Deleting role definition: " + tmpRoleType.getName());
                            vwAppSpaceDef.deleteRoleDefinition(tmpRoleType.getName());
                            if (tmpRoleType.getPrimaryQueue() != null && (primaryQueue = this.m_vwSystemConfiguration.getQueueDefinition(tmpRoleType.getPrimaryQueue())) != null && primaryQueue.getWorkBasketDefinitions() == null) {
                                this.m_vwSystemConfiguration.deleteQueueDefinition(primaryQueue.getName());
                            }
                        }
                        deletedRoles.add(tmpRoleType);
                        continue;
                    }
                    if (tmpRoleType.getState() == TypeState.EnumTypeState.NEW && vwRoleDef == null) {
                        CBLogger.debug(m_log, "Creating role definition: " + tmpRoleType.getName());
                        vwRoleDef = vwAppSpaceDef.createRoleDefinition(tmpRoleType.getName());
                    } else if (tmpRoleType.getState() == TypeState.EnumTypeState.MODIFIED) {
                        if (!tmpRoleType.getName().equals(tmpRoleType.getOldName()) && tmpRoleType.getOldName() != null) {
                            vwRoleDef = vwAppSpaceDef.getRoleDefinition(tmpRoleType.getOldName());
                            if (vwRoleDef != null) {
                                vwRoleDef.setName(tmpRoleType.getName());
                            }
                        } else {
                            vwRoleDef = vwAppSpaceDef.getRoleDefinition(tmpRoleType.getName());
                        }
                        tmpRoleType.setOldName(null);
                    }
                    if (tmpRoleType.getDescription() != null && vwRoleDef != null) {
                        vwRoleDef.setDescription(tmpRoleType.getDescription());
                    }
                    VWAttributeInfo attInfo = new VWAttributeInfo();
                    attInfo.setFieldValue("ECM_canAssignWork", (Object)tmpRoleType.isCanAssignWork());
                    attInfo.setFieldValue("ECM_canMoveWorkToPersonalInBasket", (Object)tmpRoleType.isCanMoveWorkToPersonalInBasket());
                    attInfo.setFieldValue("ECM_viewAssignedWorkInBasket", (Object)tmpRoleType.isViewAssignedWorkInBasket());
                    attInfo.setFieldValue("CB_PrimaryQueue", (Object)tmpRoleType.getPrimaryQueue());
                    vwRoleDef.setAttributeInfo(attInfo);
                    ArrayList<VWWorkBasketDefinition> inbaskets = new ArrayList<VWWorkBasketDefinition>();
                    List<RoleInbasketsType> roleInbasketsList = tmpRoleType.getRoleInbasketsType();
                    if (roleInbasketsList == null) continue;
                    for (RoleInbasketsType roleInbasket : roleInbasketsList) {
                        String queue = roleInbasket.getQueue();
                        VWQueueDefinition vwQueue = this.m_vwSystemConfiguration.getQueueDefinition(queue);
                        if (vwQueue == null) continue;
                        VWWorkBasketDefinition vwRoleWorkBasket = vwQueue.getWorkBasketDefinition(roleInbasket.getName());
                        if (vwRoleWorkBasket != null) {
                            inbaskets.add(vwRoleWorkBasket);
                            continue;
                        }
                        if (!vwQueue.getName().equals("Inbox")) continue;
                        vwRoleWorkBasket = vwQueue.getWorkBasketDefinition(this.getSafeName(NAMES.PERSONAL_INBOX, roleInbasket.getName()));
                        inbaskets.add(vwRoleWorkBasket);
                    }
                    if (vwRoleDef == null || inbaskets.size() <= 0) continue;
                    wbDefs = inbaskets.toArray(new VWWorkBasketDefinition[0]);
                    vwRoleDef.setWorkBasketDefinitions(wbDefs);
                }
                if (!deletedRoles.isEmpty()) {
                    for (int nIndex = 0; nIndex < deletedRoles.size(); ++nIndex) {
                        roleTypeList.remove(deletedRoles.get(nIndex));
                    }
                }
            }
            if (this.m_acmConverter.getSolutionType().getCaseTypes() != null) {
                m_log.info((Object)"Generating EventLogs:");
                ArrayList<String> finalLogDef = new ArrayList<String>();
                List cases = this.m_acmConverter.getSolutionType().getCaseTypes().getCaseType();
                if (cases != null) {
                    VWLogDefinition[] originalLogDef = this.m_vwSystemConfiguration.getLogDefinitions();
                    for (CaseTypeType caseType : cases) {
                        String eventLogName = caseType.getName();
                        VWLogDefinition logDef = this.m_vwSystemConfiguration.getLogDefinition(eventLogName);
                        String caseLocalName = caseType.getName();
                        CaseTypeData ct = solData.getCasetypedata(caseLocalName);
                        if (ct != null) {
                            ct.setDisplayName(caseType.getDisplayName());
                            solData.setCasetypedata(caseLocalName, ct);
                        }
                        finalLogDef.add(eventLogName);
                        if (logDef != null) continue;
                        CBLogger.debug(m_log, "Creating event log: " + eventLogName);
                        logDef = this.m_vwSystemConfiguration.createLogDefinition(eventLogName);
                        if (logDef == null) continue;
                        logDef.createFieldDefinition("F_CaseTask", 512, 0);
                        logDef.createFieldDefinition("F_CaseFolder", 512, 0);
                    }
                    if (originalLogDef != null) {
                        for (VWLogDefinition log : originalLogDef) {
                            String solPrefix;
                            String eventLogName;
                            boolean isSolPrefix;
                            VWExposedFieldDefinition caseTaskField = log.getField("F_CaseTask");
                            VWExposedFieldDefinition caseFolderField = log.getField("F_CaseFolder");
                            if (caseFolderField != null || caseTaskField != null || (isSolPrefix = (eventLogName = log.getName()).startsWith((solPrefix = this.getSolutionPrefix()) + "_"))) continue;
                            m_log.debug((Object)"Updating the PD added event logs");
                            finalLogDef.add(log.getName());
                        }
                    }
                    this.updateEventLogs(originalLogDef, finalLogDef, this.m_vwSystemConfiguration);
                }
            }
            this.createStepProcessor(this.getSolutionPrefix() + "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE", 4);
            this.createStepProcessor(this.getSolutionPrefix() + "_CmAcmSTEP_DEFAULT_PAGE", 8);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.m_vwSystemConfiguration.exportConfigChanges((OutputStream)outStream);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            CBLogger.trace(m_log, "<<generateConfig");
            return inStream;
        }
        catch (Throwable t) {
            m_log.error((Object)"Error :", t);
            Message msg = new Message("B0013E.ERROR_GENERATING_PECONFIG", t.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    private void createInbaskets() throws AcmException {
        try {
            Collection<InbasketType> inbasketTypeList;
            InbasketsType inbaskets = this.solutionData.getInbaskets();
            if (inbaskets != null && (inbasketTypeList = inbaskets.getInbasketTable().values()) != null) {
                m_log.info((Object)"Processing inbaskets:");
                ArrayList<InbasketType> deletedInbaskets = new ArrayList<InbasketType>();
                HashMap<String, List<String>> deletedFields = new HashMap<String, List<String>>();
                for (InbasketType inbasket : inbasketTypeList) {
                    VWAttributeInfo attributeInfo;
                    if (inbasket == null) continue;
                    String prefix = this.getSolutionPrefix();
                    String solName = this.getSolutionName();
                    String SolId = prefix + "_" + solName;
                    String inbasketName = "";
                    inbasketName = inbasket.getName();
                    VWQueueDefinition vwQueue = this.m_vwSystemConfiguration.getQueueDefinition(inbasket.getQueue());
                    VWWorkBasketDefinition workBasketDef = null;
                    if (vwQueue != null) {
                        workBasketDef = vwQueue.getWorkBasketDefinition(inbasketName);
                    } else {
                        vwQueue = this.m_vwSystemConfiguration.createQueueDefinition(inbasket.getQueue(), 1);
                    }
                    if (inbasket.getState() == TypeState.EnumTypeState.DELETED) {
                        if (workBasketDef != null) {
                            m_log.debug((Object)("Deleting inbasket definition: " + inbasketName));
                            vwQueue.deleteWorkBasketDefinition(inbasketName);
                            deletedInbaskets.add(inbasket);
                            continue;
                        }
                    } else if (inbasket.getState() == TypeState.EnumTypeState.NEW && workBasketDef == null) {
                        CBLogger.debug(m_log, "Creating inbasket definition: " + inbasketName);
                        workBasketDef = vwQueue.createWorkBasketDefinition(inbasketName);
                        if (vwQueue.getName().equals("Inbox")) {
                            attributeInfo = workBasketDef.getAttributeInfo();
                            if (attributeInfo != null) {
                                attributeInfo.setFieldValue("ECM_RemovePrefix", (Object)inbasket.getRemovePrefix());
                                workBasketDef.setQueryFilterString("SolutionIdentifier = '" + SolId + "'");
                            }
                            if (inbasket.getType().equals("Solution Personal Inbasket")) {
                                if (attributeInfo != null) {
                                    attributeInfo.setFieldValue("CB_Inbasket", (Object)this.getSolutionName());
                                }
                            } else if (inbasket.getType().equals("Work Assignment Inbasket")) {
                                workBasketDef.setShowWorkForAllUsers(true);
                            }
                            workBasketDef.setAttributeInfo(attributeInfo);
                        }
                    }
                    if (inbasket.getState() == TypeState.EnumTypeState.MODIFIED && inbasket.getOldName() != null) {
                        m_log.debug((Object)("Deleting Old inbasket definition: " + inbasket.getOldName()));
                        if (vwQueue.getWorkBasketDefinition(inbasket.getOldName()) != null) {
                            vwQueue.deleteWorkBasketDefinition(inbasket.getOldName());
                        }
                        CBLogger.debug(m_log, "Creating inbasket definition: " + inbasketName);
                        workBasketDef = vwQueue.createWorkBasketDefinition(inbasketName);
                        if (vwQueue.getName().equals("Inbox")) {
                            attributeInfo = workBasketDef.getAttributeInfo();
                            if (attributeInfo != null) {
                                attributeInfo.setFieldValue("ECM_RemovePrefix", (Object)inbasket.getRemovePrefix());
                                workBasketDef.setQueryFilterString("SolutionIdentifier = '" + SolId + "'");
                            }
                            if (inbasket.getType().equals("Solution Personal Inbasket")) {
                                if (attributeInfo != null) {
                                    attributeInfo.setFieldValue("CB_Inbasket", (Object)this.getSolutionName());
                                }
                            } else if (inbasket.getType().equals("Work Assignment Inbasket")) {
                                workBasketDef.setShowWorkForAllUsers(true);
                            }
                            workBasketDef.setAttributeInfo(attributeInfo);
                        }
                        inbasket.setOldName(null);
                    }
                    if (workBasketDef != null) {
                        if (inbasket.getDescription() != null) {
                            workBasketDef.setDescription(inbasket.getDescription());
                        }
                        this.addFilters(workBasketDef, inbasket.getFilters(), vwQueue);
                        this.addColumns(workBasketDef, inbasket.getColumns(), vwQueue, deletedFields);
                    }
                    this.sort(inbasket, vwQueue);
                    this.merge(inbasket, vwQueue);
                }
                if (!deletedFields.isEmpty()) {
                    Set queues = deletedFields.keySet();
                    for (String q : queues) {
                        List fields = (List)deletedFields.get(q);
                        if (fields == null || fields.size() <= 0) continue;
                        for (int i = 0; i < fields.size(); ++i) {
                            VWQueueDefinition queue = this.m_vwSystemConfiguration.getQueueDefinition(q);
                            VWWorkBasketDefinition[] vwInbaskets = queue.getWorkBasketDefinitions();
                            boolean delFlag = true;
                            for (VWWorkBasketDefinition in : vwInbaskets) {
                                VWWorkBasketColumnDefinition[] vwCols;
                                for (VWWorkBasketColumnDefinition col : vwCols = in.getWorkBasketColumnDefinitions()) {
                                    if (!col.getColumn().getName().equals(fields.get(i))) continue;
                                    delFlag = false;
                                }
                            }
                            if (!delFlag) continue;
                            queue.deleteFieldDefinition((String)fields.get(i));
                        }
                    }
                }
                if (!deletedInbaskets.isEmpty()) {
                    for (int nIndex = 0; nIndex < deletedInbaskets.size(); ++nIndex) {
                        inbasketTypeList.remove(deletedInbaskets.get(nIndex));
                    }
                }
            }
        }
        catch (Throwable t) {
            m_log.error((Object)"Error :", t);
            Message msg = new Message("B6027E.ERROR_GENERATE_PE_INBASKETS", t.getLocalizedMessage());
            throw new AcmException(msg.getFormattedText(), "B6027E.ERROR_GENERATE_PE_INBASKETS");
        }
    }

    public String getSafeName(NAMES nameType, String nameStr) throws AcmException {
        CBLogger.trace(m_log, ">getSafeName");
        if (nameType != NAMES.ROSTER) {
            nameStr = this.removePrefix(nameStr);
        }
        switch (nameType) {
            case ROSTER: {
                return PEConfig.removeWhiteCharacters(nameStr);
            }
            case QUEUE: 
            case EVENT_LOG: 
            case FIELD: {
                return this.getSolutionPrefix() + "_" + PEConfig.removeWhiteCharacters(nameStr);
            }
            case PERSONAL_INBOX: {
                return this.getSolutionPrefix() + "_" + nameStr;
            }
        }
        CBLogger.trace(m_log, "<getSafeName");
        return null;
    }

    private String removePrefix(String name) throws AcmException {
        String solutionPrefix;
        int nIndex;
        CBLogger.trace(m_log, ">removePrefix");
        if (name != null && (nIndex = name.indexOf((solutionPrefix = this.getSolutionPrefix()) + "_")) == 0) {
            name = name.substring(solutionPrefix.length() + 1);
        }
        CBLogger.trace(m_log, "<removePrefix");
        return name;
    }

    public static String removeSpecialCharacters(String str) {
        CBLogger.trace(m_log, ">removeSpecialCharacters");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && Character.getType(c) != 6) continue;
            sb.append(str.charAt(i));
        }
        CBLogger.trace(m_log, "<removeSpecialCharacters");
        return sb.toString();
    }

    public static String removeWhiteCharacters(String str) {
        CBLogger.trace(m_log, ">removeWhiteCharacters");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.codePointAt(i) == 32) continue;
            sb.append(str.charAt(i));
        }
        CBLogger.trace(m_log, "<removeWhiteCharacters");
        return sb.toString();
    }

    private void addFilters(VWWorkBasketDefinition workBasketDef, List<Filter> filterList, VWQueueDefinition queueDef) throws VWException, AcmException {
        CBLogger.trace(m_log, ">addFilters");
        if (workBasketDef == null) {
            m_log.warn((Object)"The work basket definition is null!");
            return;
        }
        VWWorkBasketFilterDefinition[] filterDefs = workBasketDef.getWorkBasketFilterDefinitions();
        if (filterDefs != null) {
            for (int i = filterDefs.length - 1; i >= 0; --i) {
                workBasketDef.deleteWorkBasketFilterDefinition(filterDefs[i].getName());
            }
        }
        if (filterList == null) {
            m_log.warn((Object)"The InbasketFilter is null!");
            return;
        }
        ArrayList<Filter> deletedFilters = new ArrayList<Filter>();
        int nIndexCounter = 1;
        for (Filter tmpFilter : filterList) {
            if (tmpFilter == null) continue;
            VWWorkBasketFilterDefinition newFilterDef = null;
            String filterName = "";
            filterName = workBasketDef.getName().equals("All Assigned Work Items") && tmpFilter.getName().equals("F_BoundUser") && tmpFilter.getOperator().equals("=") ? tmpFilter.getName() : Integer.toString(nIndexCounter++);
            String fieldName = tmpFilter.getName();
            if (tmpFilter.getState() == TypeState.EnumTypeState.DELETED) {
                deletedFilters.add(tmpFilter);
                continue;
            }
            CBLogger.debug(m_log, "Creating filter definition: " + filterName);
            newFilterDef = workBasketDef.createWorkBasketFilterDefinition(filterName);
            VWExposedFieldDefinition fieldDef = this.getFieldDefinition(fieldName, queueDef);
            if (fieldDef != null) {
                CBLogger.debug(m_log, "Setting filter condition: " + tmpFilter.getOperator());
                if (tmpFilter.getOperator().equalsIgnoreCase("<")) {
                    newFilterDef.setSearchField(fieldDef, 4);
                } else if (tmpFilter.getOperator().equalsIgnoreCase(">")) {
                    newFilterDef.setSearchField(fieldDef, 2);
                } else if (tmpFilter.getOperator().equalsIgnoreCase("<=")) {
                    newFilterDef.setSearchField(fieldDef, 5);
                } else if (tmpFilter.getOperator().equalsIgnoreCase(">=")) {
                    newFilterDef.setSearchField(fieldDef, 3);
                } else if (tmpFilter.getOperator().equalsIgnoreCase("=")) {
                    newFilterDef.setSearchField(fieldDef, 0);
                } else if (tmpFilter.getOperator().equalsIgnoreCase("!=")) {
                    newFilterDef.setSearchField(fieldDef, 1);
                } else if (tmpFilter.getOperator().equalsIgnoreCase("%")) {
                    newFilterDef.setSearchField(fieldDef, 6);
                } else if (tmpFilter.getOperator().equalsIgnoreCase("!%")) {
                    newFilterDef.setSearchField(fieldDef, 7);
                } else {
                    m_log.warn((Object)"Unknown operator in the inbasketFilter");
                }
            }
            if (tmpFilter.getLabel() == null) continue;
            m_log.debug((Object)("Setting filter label: " + tmpFilter.getLabel()));
            newFilterDef.setPrompt(tmpFilter.getLabel());
        }
        if (!deletedFilters.isEmpty()) {
            for (int nIndex = 0; nIndex < deletedFilters.size(); ++nIndex) {
                filterList.remove(deletedFilters.get(nIndex));
            }
        }
        CBLogger.trace(m_log, "<addFilters");
    }

    private void addColumns(VWWorkBasketDefinition workBasketDef, List<Column> columnList, VWQueueDefinition queueDef, HashMap<String, List<String>> deletedFields) throws VWException, AcmException {
        if (columnList != null) {
            CBLogger.debug(m_log, "Creating inbasket columns");
            ArrayList<String> deletedFieldsList = new ArrayList<String>();
            ArrayList<Column> deletedColumns = new ArrayList<Column>();
            for (Column tmpColumn : columnList) {
                VWAttributeInfo attInfo;
                String fieldName;
                VWExposedFieldDefinition fieldDef;
                if (tmpColumn == null || (fieldDef = this.getFieldDefinition(fieldName = tmpColumn.getName(), queueDef)) == null) continue;
                VWWorkBasketColumnDefinition columnDef = workBasketDef.getWorkBasketColumnDefinition(fieldDef.getName());
                if (tmpColumn.getState() == TypeState.EnumTypeState.DELETED) {
                    if (columnDef != null) {
                        CBLogger.debug(m_log, "Deleting column definition: " + fieldDef.getName());
                        workBasketDef.deleteWorkBasketColumnDefinition(fieldDef.getName());
                        if (!fieldDef.isSystemField()) {
                            deletedFieldsList.add(fieldDef.getName());
                        }
                    }
                    deletedColumns.add(tmpColumn);
                    continue;
                }
                if (columnDef == null) {
                    CBLogger.debug(m_log, "Creating column definition: " + fieldDef.getName());
                    columnDef = workBasketDef.createWorkBasketColumnDefinition(fieldName, fieldDef);
                }
                columnDef.setSortable(tmpColumn.isSortable());
                CmisPropertyDefinitionType propDefType = this.getPropertyDefinition(fieldName);
                if (propDefType != null) {
                    columnDef.setPrompt(propDefType.getDisplayName());
                } else if (tmpColumn.getLabel() != null) {
                    columnDef.setPrompt(tmpColumn.getLabel());
                } else {
                    columnDef.setPrompt(fieldName);
                }
                if (tmpColumn.isSortDefault()) {
                    attInfo = workBasketDef.getAttributeInfo();
                    attInfo.setFieldValue("ECM_SortDefault", (Object)columnDef.getName());
                    workBasketDef.setAttributeInfo(attInfo);
                    attInfo = columnDef.getAttributeInfo();
                    if (tmpColumn.isSortAscending()) {
                        attInfo.setFieldValue("ECM_SortOrder", (Object)"Ascending");
                    } else {
                        attInfo.setFieldValue("ECM_SortOrder", (Object)"Descending");
                    }
                    columnDef.setAttributeInfo(attInfo);
                    continue;
                }
                attInfo = columnDef.getAttributeInfo();
                if (attInfo.getFieldValue("ECM_SortOrder") != null) {
                    attInfo.setFieldValue("ECM_SortOrder", null);
                }
                columnDef.setAttributeInfo(attInfo);
            }
            if (!deletedFieldsList.isEmpty()) {
                deletedFields.put(queueDef.getName(), deletedFieldsList);
            }
            if (!deletedColumns.isEmpty()) {
                for (int nIndex = 0; nIndex < deletedColumns.size(); ++nIndex) {
                    columnList.remove(deletedColumns.get(nIndex));
                }
            }
        }
    }

    private VWExposedFieldDefinition getFieldDefinition(String propertyName, VWQueueDefinition queueDef) throws VWException, AcmException {
        CBLogger.trace(m_log, ">getFieldDefinition");
        VWExposedFieldDefinition fieldDef = null;
        CmisPropertyDefinitionType propDefType = this.getPropertyDefinition(propertyName);
        if (propDefType != null) {
            int nFieldType = this.getPEFieldTypeFromCEType(propDefType.getPropertyType());
            if (nFieldType != -1) {
                String fieldName = PEConfig.removeSpecialCharacters(propDefType.getLocalName());
                CBLogger.debug(m_log, "Looking for field: " + fieldName);
                fieldDef = queueDef.getField(fieldName);
                if (fieldDef != null && fieldDef.getFieldType() != nFieldType) {
                    VWWorkBasketDefinition[] wbDefs;
                    VWIndexDefinition[] indexDefs = queueDef.getIndexes();
                    if (indexDefs != null && indexDefs.length > 0) {
                        block0: for (int i = indexDefs.length - 1; i >= 0; --i) {
                            String[] fieldNames = indexDefs[i].getAuthoredFieldNames();
                            for (int j = 0; j < fieldNames.length; ++j) {
                                if (!fieldNames[j].contentEquals(fieldName)) continue;
                                CBLogger.debug(m_log, "Deleting column definition: " + fieldName);
                                queueDef.deleteIndexDefinition(fieldName);
                                continue block0;
                            }
                        }
                    }
                    if ((wbDefs = queueDef.getWorkBasketDefinitions()) != null && wbDefs.length > 0) {
                        for (int i = 0; i < wbDefs.length; ++i) {
                            VWWorkBasketColumnDefinition columnDef;
                            VWWorkBasketFilterDefinition[] filterDef = wbDefs[i].getWorkBasketFilterDefinitions();
                            if (filterDef != null && filterDef.length > 0) {
                                for (int j = 0; j < filterDef.length; ++j) {
                                    if (filterDef[j] == null || filterDef[j].getSearchField() == null || filterDef[j].getSearchField().getName() == null || !filterDef[j].getSearchField().getName().equals(fieldDef.getName())) continue;
                                    m_log.debug((Object)("Deleting filter definition: " + filterDef[j].getName()));
                                    wbDefs[i].deleteWorkBasketFilterDefinition(filterDef[j].getName());
                                }
                            }
                            if ((columnDef = wbDefs[i].getWorkBasketColumnDefinition(fieldDef.getName())) == null) continue;
                            CBLogger.debug(m_log, "Deleting column definition: " + fieldDef.getName());
                            wbDefs[i].deleteWorkBasketColumnDefinition(fieldDef.getName());
                        }
                    }
                    queueDef.deleteFieldDefinition(fieldDef.getName());
                    fieldDef = null;
                }
                if (fieldDef == null) {
                    CBLogger.debug(m_log, "Creating field definition: " + fieldName);
                    fieldDef = nFieldType == 2 ? queueDef.createFieldDefinition(fieldName, nFieldType, 64) : queueDef.createFieldDefinition(fieldName, nFieldType, 0);
                }
            }
        } else {
            String fieldName = PEConfig.removeSpecialCharacters(propertyName);
            fieldDef = queueDef.getField(fieldName);
            if (fieldDef == null) {
                if (fieldName.equals("F_StepName")) {
                    fieldDef = queueDef.createFieldDefinition("F_StepName", 2, 64);
                    fieldDef.isSystemField();
                }
                if (fieldName.equals("F_BoundUser")) {
                    fieldDef = queueDef.createFieldDefinition("F_BoundUser", 1, 0);
                    fieldDef.isSystemField();
                }
                if (fieldName.equals("F_Locked")) {
                    fieldDef = queueDef.createFieldDefinition("F_Locked", 1, 0);
                    fieldDef.isSystemField();
                }
                if (fieldName.equals("F_LockTime")) {
                    fieldDef = queueDef.createFieldDefinition("F_LockTime", 16, 0);
                    fieldDef.isSystemField();
                }
            }
        }
        CBLogger.trace(m_log, "<getFieldDefinition");
        return fieldDef;
    }

    private CmisPropertyDefinitionType getPropertyDefinition(String propertyName) throws AcmException {
        CBLogger.trace(m_log, ">getPropertyDefinition");
        SolutionType solutionType = this.m_acmConverter.getSolutionType();
        for (CmisPropertyDefinitionType type : solutionType.getProperties().getPropertyDefinition()) {
            if (!propertyName.equals(type.getLocalName())) continue;
            CBLogger.debug(m_log, "Found property: " + propertyName);
            return type;
        }
        CBLogger.debug(m_log, "Did not find property: " + propertyName);
        CBLogger.trace(m_log, "<getPropertyDefinition");
        return null;
    }

    private int getPEFieldTypeFromCEType(EnumPropertyType propType) {
        CBLogger.trace(m_log, ">getPEFieldTypeFromCEType");
        CBLogger.debug(m_log, "Extracting PE Field type from the CE type");
        int PEFieldType = -1;
        if (propType == EnumPropertyType.BOOLEAN) {
            PEFieldType = 4;
        } else if (propType == EnumPropertyType.DATETIME) {
            PEFieldType = 16;
        } else if (propType == EnumPropertyType.DECIMAL) {
            PEFieldType = 8;
        } else if (propType == EnumPropertyType.HTML || propType == EnumPropertyType.STRING || propType == EnumPropertyType.URI) {
            PEFieldType = 2;
        } else if (propType == EnumPropertyType.ID) {
            PEFieldType = 512;
        } else if (propType == EnumPropertyType.INTEGER) {
            PEFieldType = 1;
        }
        CBLogger.debug(m_log, "PEFieldType returned from CE type " + PEFieldType);
        CBLogger.trace(m_log, "<getPEFieldTypeFromCEType");
        return PEFieldType;
    }

    public String getSolutionName() throws AcmException {
        CBLogger.trace(m_log, ">getSolutionName");
        if (this.m_acmConverter != null && this.m_acmConverter.getSolutionType() != null) {
            return this.m_acmConverter.getSolutionType().getName();
        }
        return null;
    }

    public String getSolutionPrefix() throws AcmException {
        CBLogger.trace(m_log, ">getSolutionPrefix");
        String solutionPrefix = null;
        if (this.m_acmConverter != null && this.m_acmConverter.getSolutionType() != null) {
            solutionPrefix = this.m_acmConverter.getSolutionType().getPrefix();
            if (solutionPrefix == null || solutionPrefix.length() == 0) {
                Message msg = new Message("B0011E.NULL_SOLUTION_PREFIX");
                throw new AcmConnectionFailure(msg.getFormattedText(), "B0011E.NULL_SOLUTION_PREFIX");
            }
            char charAt = solutionPrefix.charAt(0);
            if (charAt >= '0' && charAt <= '9') {
                Message msg = new Message("B0012E.INVALID_SOLUTION_PREFIX", solutionPrefix);
                throw new AcmConnectionFailure(msg.getFormattedText(), "B0012E.INVALID_SOLUTION_PREFIX");
            }
        }
        CBLogger.trace(m_log, "<getSolutionPrefix");
        return solutionPrefix;
    }

    private void sort(InbasketType inbasket, VWQueueDefinition queueDef) throws VWException, AcmException {
        CBLogger.trace(m_log, ">sort");
        String inbasketName = inbasket.getName();
        if (queueDef.getName().contentEquals("Inbox")) {
            inbasketName = this.getSafeName(NAMES.PERSONAL_INBOX, inbasketName);
        }
        CBLogger.debug(m_log, "inbasketName" + inbasketName);
        VWWorkBasketDefinition tempworkBasketDef = queueDef.getWorkBasketDefinition(inbasketName);
        if (tempworkBasketDef == null) {
            return;
        }
        VWWorkBasketColumnDefinition[] tempSrcPEColumns = tempworkBasketDef.getWorkBasketColumnDefinitions();
        ArrayList<VWWorkBasketColumnDefinition> tempDstPEColumns = new ArrayList<VWWorkBasketColumnDefinition>();
        List<Column> col = inbasket.getColumns();
        if (col == null) {
            return;
        }
        for (Column column : col) {
            for (int i = 0; i < tempSrcPEColumns.length; ++i) {
                if (!column.getName().equals(tempSrcPEColumns[i].getName())) continue;
                tempDstPEColumns.add(tempSrcPEColumns[i]);
                CBLogger.debug(m_log, "added column" + tempSrcPEColumns[i].getName());
            }
        }
        VWWorkBasketColumnDefinition[] vwwrkbascoldef = new VWWorkBasketColumnDefinition[tempDstPEColumns.size()];
        vwwrkbascoldef = tempDstPEColumns.toArray(vwwrkbascoldef);
        queueDef.getWorkBasketDefinition(inbasketName).setWorkBasketColumnDefinitions(vwwrkbascoldef);
        CBLogger.trace(m_log, "<sort");
    }

    private void merge(InbasketType inbasket, VWQueueDefinition queueDef) throws VWException, AcmException {
        CBLogger.trace(m_log, ">merge");
        if (this.solutionData != null) {
            VWWorkBasketDefinition tempworkBasketDef;
            CBLogger.debug(m_log, "Solution data in config" + this.solutionData);
            List<VWWorkBasketColumnDefinition> columnDefs = null;
            String inbasketName = inbasket.getName();
            if (queueDef.getName().contentEquals("Inbox")) {
                inbasketName = this.getSafeName(NAMES.PERSONAL_INBOX, inbasketName);
            }
            if ((tempworkBasketDef = queueDef.getWorkBasketDefinition(inbasketName)) == null) {
                return;
            }
            VWWorkBasketColumnDefinition[] tempSrcPEColumns = tempworkBasketDef.getWorkBasketColumnDefinitions();
            ArrayList<VWWorkBasketColumnDefinition> tempDstPEColumns = new ArrayList<VWWorkBasketColumnDefinition>();
            if (tempSrcPEColumns != null) {
                for (int idx = 0; idx < tempSrcPEColumns.length; ++idx) {
                    tempDstPEColumns.add(tempSrcPEColumns[idx]);
                }
                if (this.solutionData.getColumnFromOutsideInfo() != null) {
                    Set<String> queues = this.solutionData.getColumnFromOutsideInfo().keySet();
                    for (String q : queues) {
                        if (!q.equals(queueDef.getName())) continue;
                        columnDefs = this.solutionData.getColumnFromOutsideInfo().get(q);
                    }
                    if (columnDefs != null) {
                        for (VWWorkBasketColumnDefinition col : columnDefs) {
                            tempDstPEColumns.add(col);
                            m_log.debug((Object)("merging the column added from outside of case builder" + col.getName()));
                        }
                    }
                    VWWorkBasketColumnDefinition[] vwwrkbascoldef = new VWWorkBasketColumnDefinition[tempDstPEColumns.size()];
                    vwwrkbascoldef = tempDstPEColumns.toArray(vwwrkbascoldef);
                    queueDef.getWorkBasketDefinition(inbasketName).setWorkBasketColumnDefinitions(vwwrkbascoldef);
                }
            }
        }
        CBLogger.trace(m_log, "<merge");
    }

    public void updateEventLogs(VWLogDefinition[] original, ArrayList<String> finalLogDef, VWSystemConfiguration config) throws VWException {
        CBLogger.trace(m_log, ">updateEventLogs");
        boolean found = false;
        if (original == null || finalLogDef == null) {
            return;
        }
        int tmpIdx = 0;
        for (int dstidx = 0; dstidx < original.length; ++dstidx) {
            String orgName = original[dstidx].getName();
            found = false;
            for (tmpIdx = 0; tmpIdx < finalLogDef.size(); ++tmpIdx) {
                if (!orgName.equals(finalLogDef.get(tmpIdx))) continue;
                found = true;
                break;
            }
            if (found) continue;
            config.deleteLogDefinition(orgName);
        }
        CBLogger.trace(m_log, "<updateEventLogs");
    }

    public boolean isBSpacePage(String page1) {
        String pg = page1.substring(0, 6);
        return pg.contains("_");
    }

    public static enum NAMES {
        ROSTER,
        QUEUE,
        EVENT_LOG,
        FIELD,
        PERSONAL_INBOX;

    }
}

