/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.ibm.acm.sold.common.Constants;
import com.ibm.acm.sold.connector.IConnector;
import com.ibm.acm.sold.converter.DateTime;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystem
implements IConnector {
    private static final Log log = LogFactory.getLog((String)FileSystem.class.getName());
    private static int sLockedCount = 0;
    private static int sDeleteCount = 0;

    public FileSystem() {
        File dir = new File(Constants.defaultPath);
        log.debug((Object)("default path:" + Constants.defaultPath));
        if (!dir.exists()) {
            log.debug((Object)"Directory does not exist making a new directory");
            if (dir.mkdir()) {
                log.debug((Object)"created new directory");
            } else {
                log.debug((Object)"unable to create new directory");
            }
            dir.setWritable(true);
        }
    }

    public String close(String solnName) {
        File file = new File(solnName);
        String dateTime = DateTime.listDate(new Date(file.lastModified()));
        return "{'sdfId':'" + dateTime + "','pecdgId':'" + dateTime + "','lastModifiedOn':'" + dateTime + "'}";
    }

    public String dirListInJsonStr(boolean pForSolutions) {
        boolean commaFlag = false;
        log.trace((Object)">>dirListInJsonStr");
        String filenames = "";
        String jsonStr = pForSolutions ? "{solutions:{solution:[" : "{templates:{template:[";
        File dir = new File(Constants.defaultPath);
        File[] files = dir.listFiles();
        log.debug((Object)("directory :" + dir.getName()));
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) continue;
                String temp = files[i].getName();
                log.debug((Object)("filename: " + temp));
                int ext = temp.indexOf(46);
                if (ext == -1) continue;
                String name = temp.substring(0, ext);
                if (commaFlag) {
                    filenames = filenames + ",";
                }
                if (pForSolutions) {
                    String readOnly = files[i].canWrite() ? "false" : "true";
                    String deletable = 0 == sDeleteCount % 5 ? "false" : "true";
                    String dateTime = DateTime.listDate(new Date(files[i].lastModified()));
                    String lockedText = 0 == sLockedCount % 5 ? ", \"" + Constants.solution[9] + "\": \"" + (0 == sLockedCount % 10 ? "demo" : "locker") + "\"" : "";
                    filenames = filenames + "{\"name\":\"" + name + "\"," + "\"" + "description" + "\"" + ":\"" + temp + "\"," + "\"" + Constants.solution[3] + "\"" + ":\"" + readOnly + "\"," + "\"" + Constants.solution[4] + "\"" + ":\"" + deletable + "\"," + "\"" + Constants.solution[5] + "\"" + ":\"" + dateTime + "\"," + "\"" + Constants.solution[6] + "\"" + ":\"" + System.getProperty("user.name") + "\"," + "\"" + Constants.solution[7] + "\"" + ":\"" + dateTime + "\"," + "\"" + Constants.solution[8] + "\"" + ":\"" + System.getProperty("user.name") + "\"," + "\"" + "sdfId" + "\"" + ":\"" + dateTime + "\"," + "\"" + "pecfgId" + "\"" + ":\"" + dateTime + "\"" + lockedText + "}";
                    ++sLockedCount;
                    ++sDeleteCount;
                } else {
                    filenames = filenames + "\"" + name + "\"";
                }
                commaFlag = true;
            }
            jsonStr = jsonStr + filenames + "]}}";
        }
        log.debug((Object)("Entered Json Structure:" + jsonStr));
        log.trace((Object)"<<dirListInJsonStr");
        return jsonStr;
    }

    public String readSDFFile(String fname) throws AcmException {
        log.trace((Object)">>readSDFFile");
        StringBuffer solution = new StringBuffer(2000);
        BufferedReader br = null;
        try {
            String strLine;
            log.debug((Object)"trying to read JSON file");
            String filename = Constants.defaultPath + File.separator + fname + ".json";
            FileInputStream fstream = new FileInputStream(filename);
            br = new BufferedReader(new InputStreamReader((InputStream)fstream, "UTF-8"));
            while ((strLine = br.readLine()) != null) {
                log.debug((Object)("read str :" + strLine));
                solution.append(strLine);
            }
            fstream.close();
        }
        catch (Exception e) {
            log.error((Object)"Exception in reading SDF file", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException("Error occured due to " + errorMessage, "B0014E.SYSTEM_ERROR");
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.trace((Object)"<<readSDFFile");
        return solution.toString();
    }

    public String writeSDFFile(String jsonStr) throws AcmException {
        String response;
        log.trace((Object)">>writeSDFFile");
        FileOutputStream fop = null;
        try {
            int nameIndex = jsonStr.indexOf(Constants.solution[0]);
            int solNameStart = Constants.solution[0].length() + nameIndex + 3;
            int solNameEnd = jsonStr.indexOf("\"", solNameStart);
            String name = jsonStr.substring(solNameStart, solNameEnd);
            File f = new File(Constants.defaultPath + File.separator + name + ".json");
            fop = new FileOutputStream(f);
            log.debug((Object)("final SDF string in local system...." + jsonStr));
            if (f.exists()) {
                log.debug((Object)"Writing json string to the json file");
                fop.write(jsonStr.getBytes("UTF-8"));
                fop.flush();
            } else {
                log.debug((Object)"The file doesn't exist");
            }
            String dateTime = DateTime.listDate(new Date(f.lastModified()));
            response = "{\"sdfId\":\"" + dateTime + "\"," + "\"pecfgId\":\"" + dateTime + "\",\"lastModifiedOn\":\"" + dateTime + "\"}";
        }
        catch (Exception e) {
            log.error((Object)"Exception in writing SDF file", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException("Error occured due to " + errorMessage, "B0014E.SYSTEM_ERROR");
        }
        finally {
            try {
                fop.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.trace((Object)"<<writeSDFFile");
        return response;
    }

    public String deleteSDFFile(String jsonStr) throws AcmException {
        log.trace((Object)">>writeSDFFile");
        String response = "";
        try {
            File file = new File(Constants.defaultPath + File.separator + jsonStr + ".json");
            if (file.delete()) {
                response = "\"Solution Deleted\"";
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in deleting SDF file", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException("Error occured due to " + errorMessage, "B0014E.SYSTEM_ERROR");
        }
        log.trace((Object)"<<writeSDFFile");
        return response;
    }

    public static String allowSolutionCreate() {
        File file = new File(Constants.defaultPath);
        return file.canWrite() ? "true" : "false";
    }
}

