/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SdfData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.LoadAllXpdlArgs;
import com.ibm.acm.sold.connector.CEManager;
import com.ibm.acm.sold.connector.PEConfig;
import com.ibm.acm.sold.converter.AcmConverter;
import com.ibm.acm.sold.converter.AcmJsonSplitter;
import com.ibm.acm.sold.converter.AcmProcessSolutionData;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmRoleInbasketproperties;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmFileNotFoundException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.io.InputStream;
import java.text.Collator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connector {
    private static final Log log = LogFactory.getLog((String)Connector.class.getName());
    private Config config;

    public void setConfig(Config config) {
        this.config = config;
    }

    public String readSDF(String fname, SolutionData solData, boolean forceGet) throws AcmException {
        CBLogger.trace(log, ">>readSDF");
        String xmlstr = null;
        CEManager cemgr = new CEManager(solData, this.config);
        cemgr.openSession();
        xmlstr = cemgr.retrieveSolution(fname, forceGet);
        cemgr.closeSession();
        CBLogger.trace(log, "<<readSDF");
        return xmlstr;
    }

    public String readTemplate(String fname, SolutionData solData) throws AcmException {
        CBLogger.trace(log, ">>readTemplate");
        String xmlstr = null;
        CEManager cemgr = new CEManager(solData, this.config);
        cemgr.openSession();
        xmlstr = cemgr.retrieveTemplate(fname);
        cemgr.closeSession();
        CBLogger.trace(log, "<<readTemplate");
        return xmlstr;
    }

    public String getTemplatelist() throws AcmException, AcmFileNotFoundException, AcmConnectionFailure {
        CBLogger.trace(log, ">>getTemplatelist");
        String filenames = null;
        CEManager cemgr = new CEManager(this.config);
        cemgr.openSession();
        filenames = cemgr.getTemplateList(null);
        cemgr.closeSession();
        CBLogger.trace(log, "<<getTemplatelist");
        return filenames;
    }

    public String getTemplatelist(String intType) throws AcmException, AcmFileNotFoundException, AcmConnectionFailure {
        CBLogger.trace(log, ">>getTemplatelist");
        String filenames = null;
        CEManager cemgr = new CEManager(this.config);
        cemgr.openSession();
        filenames = cemgr.getTemplateList(intType);
        cemgr.closeSession();
        CBLogger.trace(log, "<<getTemplatelist");
        return filenames;
    }

    public String deleteSolution(String jsonStr) throws AcmConnectionFailure, AcmException {
        CBLogger.trace(log, ">>Connector : deleteSolution");
        CEManager cemgr = new CEManager(this.config);
        cemgr.openSession();
        String response = cemgr.deleteSolution(jsonStr);
        cemgr.closeSession();
        CBLogger.trace(log, "<<Connector: deleteSolution");
        return response;
    }

    public String closeSolution(String jsonStr, SolutionData solData) throws AcmConnectionFailure, AcmException {
        String result = null;
        CBLogger.trace(log, ">>Connector : closeSolution");
        CEManager cemgr = new CEManager(solData, this.config);
        cemgr.openSession();
        result = cemgr.closeSolution(jsonStr);
        cemgr.closeSession();
        CBLogger.trace(log, "<<Connector: closeSolution");
        return result;
    }

    public String editSolution(String jsonStr, SolutionData solData) throws AcmException {
        String result;
        CBLogger.trace(log, ">>Connector : editSolution");
        try {
            CEManager cemgr = new CEManager(solData, this.config);
            cemgr.openSession();
            result = cemgr.retrieveSolution(jsonStr);
            cemgr.closeSession();
        }
        catch (AcmException e) {
            log.error((Object)e);
            throw e;
        }
        CBLogger.trace(log, "<<Connector: editSolution");
        return result;
    }

    public String reloadSolution(SolutionData solData, String casetypename) throws AcmException {
        String result;
        CBLogger.trace(log, ">>Connector : reloadSolution");
        try {
            CEManager cemgr = new CEManager(solData, this.config);
            cemgr.openSession();
            result = cemgr.reloadPEconfigXPDL(solData, casetypename);
            cemgr.closeSession();
        }
        catch (AcmException e) {
            log.error((Object)e);
            throw e;
        }
        CBLogger.trace(log, "<<Connector: reloadSolution");
        return result;
    }

    public String cancelSolution(String jsonStr) throws AcmException {
        String result = null;
        CBLogger.trace(log, ">>Connector : cancelSolution");
        CEManager cemgr = new CEManager(this.config);
        cemgr.openSession();
        cemgr.closeSession();
        CBLogger.trace(log, "<<Connector: cancelSolution");
        return result;
    }

    private AcmConverter convertJson(String jsonStr, SolutionData solData) throws AcmException {
        CBLogger.trace(log, ">>convertJson");
        AcmConverter converter = new AcmConverter(jsonStr, solData);
        CBLogger.trace(log, "created AcmConverter");
        if (solData.getSdfData() == null) {
            solData.setSdfData(new SdfData());
        }
        solData.setConverterData(converter);
        converter.resetAllTypeState();
        converter.convertJsonToXml();
        CBLogger.trace(log, "Converted JSON to XML");
        CBLogger.trace(log, "<<convertJson");
        return converter;
    }

    public String save(boolean isInterviewMode, String jsonStr, SolutionData solData) throws AcmException {
        CBLogger.trace(log, ">>save");
        String result = null;
        CBLogger.trace(log, " JSON : " + jsonStr);
        AcmJsonSplitter splitObj = new AcmJsonSplitter(jsonStr);
        splitObj.splitJson();
        log.info((Object)"json Splitting successful");
        jsonStr = splitObj.getActualSolution();
        CBLogger.debug(log, "Actual solution Json Str :" + jsonStr);
        AcmConverter converter = this.convertJson(jsonStr, solData);
        CEManager cemgr = new CEManager(solData, this.config);
        cemgr.setProjectArea(splitObj.getProjectArea());
        CBLogger.debug(log, "Project Area is stored in Connector");
        cemgr.openSession();
        CBLogger.debug(log, " Waiting for Parsing to complete ...");
        converter.getSolutionType();
        PEConfig peconfig = solData.getPeconfigData();
        if (peconfig == null) {
            peconfig = new PEConfig(solData, converter);
            solData.setPeconfigData(peconfig);
        } else {
            peconfig.setConverter(converter);
        }
        peconfig.addStepProcessors(solData);
        if (isInterviewMode) {
            this.updateCaseTypeData(cemgr, solData);
        }
        InputStream configContent = peconfig.generateConfig(solData);
        this.updateCasePropertiesForInbaskets(solData);
        result = cemgr.save(peconfig, configContent);
        CBLogger.debug(log, "Save complete");
        cemgr.closeSession();
        CBLogger.trace(log, "<<save");
        return result;
    }

    public String saveAndClose(boolean isInterviewMode, String jsonStr, SolutionData solData) throws AcmException {
        CBLogger.trace(log, ">>saveAndClose");
        CBLogger.trace(log, " JSON : " + jsonStr);
        AcmJsonSplitter splitObj = new AcmJsonSplitter(jsonStr);
        splitObj.splitJson();
        CBLogger.debug(log, "json Splitting successful");
        jsonStr = splitObj.getActualSolution();
        CBLogger.debug(log, "Actual solution Json Str :" + jsonStr);
        AcmConverter converter = this.convertJson(jsonStr, solData);
        CEManager cemgr = new CEManager(solData, this.config);
        cemgr.setProjectArea(splitObj.getProjectArea());
        CBLogger.debug(log, "Project Area is stored in Connector");
        cemgr.openSession();
        CBLogger.debug(log, " Waiting for Parsing to complete ...");
        converter.getSolutionType();
        PEConfig peconfig = solData.getPeconfigData();
        if (peconfig == null) {
            peconfig = new PEConfig(solData, converter);
            solData.setPeconfigData(peconfig);
        } else {
            peconfig.setConverter(converter);
        }
        peconfig.addStepProcessors(solData);
        if (isInterviewMode) {
            this.updateCaseTypeData(cemgr, solData);
        }
        InputStream configContent = peconfig.generateConfig(solData);
        this.updateCasePropertiesForInbaskets(solData);
        String result = cemgr.saveAndCloseSolution(peconfig, configContent);
        CBLogger.debug(log, "Save complete");
        cemgr.closeSession();
        CBLogger.trace(log, "<<saveAndClose");
        return result;
    }

    public void updateCaseTypeData(CEManager cemgr, SolutionData solData) throws AcmException {
        CaseTypeData ctData;
        SdfData sdf = solData.getSdfData();
        AcmConverter uiData = solData.getConverterData();
        HashSet<String> newCaseList = new HashSet<String>(10);
        SolutionType uiSolntype = uiData.getSolutionType();
        List uiCaseTypes = null;
        if (uiSolntype.getCaseTypes() != null) {
            uiCaseTypes = uiSolntype.getCaseTypes().getCaseType();
        }
        if (uiCaseTypes == null && sdf.getSolutionType() == null) {
            return;
        }
        String solPrefix = uiSolntype.getPrefix();
        if (uiCaseTypes != null) {
            for (CaseTypeType uiCaseType : uiCaseTypes) {
                if (uiCaseType.getCaseCreationPageName() == null) {
                    uiCaseType.setCaseCreationPageName(solPrefix + "_CmAcmCASE_NEW_DEFAULT_PAGE");
                }
                if (uiCaseType.getCasePageName() != null) continue;
                uiCaseType.setCasePageName(solPrefix + "_CmAcmCASE_DEFAULT_PAGE");
            }
        }
        AcmProcessSolutionData procSolData = new AcmProcessSolutionData(solData);
        boolean isNewCaseType = true;
        if (uiCaseTypes != null && sdf.getSolutionType() != null) {
            List caseTypes = null;
            if (sdf.getSolutionType().getCaseTypes() != null) {
                caseTypes = sdf.getSolutionType().getCaseTypes().getCaseType();
                for (CaseTypeType uiCaseType : uiCaseTypes) {
                    isNewCaseType = true;
                    for (CaseTypeType caseType : caseTypes) {
                        List tasks = caseType.getTasks().getTask();
                        if (!Collator.getInstance().equals(uiCaseType.getName(), caseType.getName())) continue;
                        isNewCaseType = false;
                        CaseTypeData ctData2 = solData.getCasetypedata(caseType.getName());
                        List uiTasks = uiCaseType.getTasks().getTask();
                        if (uiTasks.size() != tasks.size() && ctData2 == null) {
                            ctData2 = cemgr.initCaseType(caseType, solData, true);
                        }
                        for (TaskType uiTask : uiTasks) {
                            boolean isTaskNew = true;
                            for (TaskType task : tasks) {
                                AcmActivity acmActiv;
                                if (!uiTask.getName().equals(task.getName())) continue;
                                isTaskNew = false;
                                if (!this.isTaskModifiedInWizardMode(uiTask, task)) continue;
                                if (ctData2 == null) {
                                    ctData2 = cemgr.initCaseType(caseType, solData, true);
                                }
                                if ((acmActiv = ctData2.getActivityByName(uiTask.getName())) != null) {
                                    if (this.isTaskWorkflowTypeChanged(uiTask, task)) {
                                        isTaskNew = true;
                                    }
                                    acmActiv.setName(uiTask.getDisplayName());
                                    acmActiv.setDescription(uiTask.getDescription());
                                    ctData2.addActivity(acmActiv);
                                }
                                solData.setCasetypedata(caseType.getName(), ctData2);
                            }
                            if (!isTaskNew) continue;
                            if (ctData2 == null) {
                                ctData2 = cemgr.initCaseType(caseType, solData, true);
                            }
                            AcmActivity acmActiv = null;
                            acmActiv = procSolData.createActivityObject(uiTask);
                            acmActiv.initAcmActivity(ctData2.getSharedInfo());
                            try {
                                acmActiv.setGuid(ctData2.getId(), acmActiv.getSdfData().getId());
                            }
                            catch (VWException e) {
                                log.error((Object)" error ::  ", (Throwable)e);
                                Message msg = new Message("B4066E.VW_EXCEPTION");
                                throw new AcmException(msg, (Throwable)e);
                            }
                            ctData2.addActivity(acmActiv);
                            solData.setCasetypedata(caseType.getName(), ctData2);
                        }
                    }
                    if (!isNewCaseType) continue;
                    newCaseList.add(uiCaseType.getName());
                    CaseTypeData ctData3 = new CaseTypeData();
                    ctData3.setSymName(uiCaseType.getName());
                    ctData3.setDisplayName(uiCaseType.getDisplayName());
                    solData.setCasetypedata(uiCaseType.getName(), ctData3);
                }
            }
        }
        if (uiCaseTypes != null && sdf.getSolutionType() == null) {
            for (CaseTypeType uiCaseType : uiCaseTypes) {
                newCaseList.add(uiCaseType.getName());
                ctData = new CaseTypeData();
                ctData.setSymName(uiCaseType.getName());
                ctData.setDisplayName(uiCaseType.getDisplayName());
                solData.setCasetypedata(uiCaseType.getName(), ctData);
            }
        }
        for (String casename : newCaseList) {
            ctData = solData.getCasetypedata(casename);
            ctData = procSolData.updateCaseTypeDataSharedInfo(solData, casename, ctData);
            procSolData.updateActivityData(solData, casename, ctData);
            for (AcmActivity task : ctData.getActivitiesMap().values()) {
                task.initAcmActivity(ctData.getSharedInfo());
                try {
                    task.setGuid(ctData.getId(), task.getSdfData().getId());
                }
                catch (VWException e) {
                    log.error((Object)" error ::  ", (Throwable)e);
                    Message msg = new Message("B4066E.VW_EXCEPTION");
                    throw new AcmException(msg, (Throwable)e);
                }
            }
            solData.setCasetypedata(casename, ctData);
        }
    }

    public String processDeploy(int heartbeatPeriod) throws AcmException {
        String adosName = "";
        String connProfName = "";
        String atosName = "";
        String caseUrl = "";
        String cmisUrl = "";
        String accessAllowed = "";
        int heartbeat = heartbeatPeriod * 1000;
        adosName = this.config.getObjStore();
        caseUrl = this.config.getCaseUrl();
        cmisUrl = this.config.getCmisUrl();
        String result = "{\"designObjectStore\":\"" + adosName + "\"," + "\"connectionDefinitionName\":\"" + connProfName + "\"," + "\"targetObjectStore\":\"" + atosName + "\"," + "\"caseURL\":\"" + caseUrl + "\"," + "\"cmisURL\":\"" + cmisUrl + "\"," + "\"heartbeatPeriod\":\"" + heartbeat + "\"" + "}";
        return result;
    }

    public String getAllXpdl(LoadAllXpdlArgs argobj) throws AcmException {
        String result = null;
        CBLogger.trace(log, ">>getAllXpdl");
        try {
            if (argobj.getSolData().getXpdlThread() != null && Thread.State.TERMINATED != argobj.getSolData().getXpdlThread().getState()) {
                argobj.getSolData().getXpdlThread().join();
                if (argobj.getSolData().getXpdlloader().getAcmexp() != null) {
                    throw argobj.getSolData().getXpdlloader().getAcmexp();
                }
            }
        }
        catch (InterruptedException e) {
            log.error((Object)" error ::  ", (Throwable)e);
            Message msg = new Message("B4043E.THREAD_INTERRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        CBLogger.trace(log, "<<getAllXpdl");
        return result;
    }

    private void updateCasePropertiesForInbaskets(SolutionData solData) {
        try {
            List caseTypes = solData.getConverterData().getSolutionType().getCaseTypes().getCaseType();
            AcmProcessSolutionData procSolData = new AcmProcessSolutionData(solData);
            PEConfig peconfig = solData.getPeconfigData();
            for (CaseTypeType caseType : caseTypes) {
                CaseTypeData caseTypeData = solData.getCasetypedata(caseType.getName());
                Set<String> caseProperties = procSolData.getpropertiesSymbolicList(solData, caseType.getName());
                if (caseTypeData == null) continue;
                AcmCaseShareInfo caseShareInfo = caseTypeData.getSharedInfo();
                if (caseTypeData.getActivitiesMap().size() == 0) continue;
                Map<String, AcmActivity> actList = caseTypeData.getActivitiesMap();
                for (String key : actList.keySet()) {
                    AcmActivity activity = actList.get(key);
                    Set<String> queueNamesUsedInActivity = activity.returnRoleLanesQueueNames(caseShareInfo);
                    Map<String, AcmRoleInbasketproperties> inbasketPropsMap = this.returnCasePropertiesUsedAsInBaskets(queueNamesUsedInActivity, peconfig, caseProperties, procSolData);
                    this.createDataFieldsForInBaskets(activity.getWorkflowDef(), inbasketPropsMap);
                }
            }
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
    }

    private Map<String, AcmRoleInbasketproperties> returnCasePropertiesUsedAsInBaskets(Set<String> queueNamesUsedInActivity, PEConfig peconfig, Set<String> caseProps, AcmProcessSolutionData procSolData) throws AcmException {
        HashMap<String, AcmRoleInbasketproperties> propertiesUsedAsInBaskets = new HashMap<String, AcmRoleInbasketproperties>();
        for (String queueName : queueNamesUsedInActivity) {
            Set<AcmRoleInbasketproperties> roleInbasketProps = procSolData.getRoleInbasketProperties(queueName, peconfig, caseProps);
            for (AcmRoleInbasketproperties inbasks : roleInbasketProps) {
                propertiesUsedAsInBaskets.put(inbasks.getSymName(), inbasks);
            }
        }
        return propertiesUsedAsInBaskets;
    }

    private void createDataFieldsForInBaskets(VWWorkflowDefinition workflowDef, Map<String, AcmRoleInbasketproperties> inbasketProps) {
        CBLogger.trace(log, ">>createDataFieldsForInBaskets in Connector.java");
        VWFieldDefinition[] fieldDefs = null;
        try {
            fieldDefs = workflowDef.getFields();
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        for (AcmRoleInbasketproperties p : inbasketProps.values()) {
            boolean found = false;
            if (fieldDefs != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    if (!fieldDefs[i].getName().equals(p.getSymName())) continue;
                    found = true;
                }
            }
            if (found) continue;
            String defaultValue = AcmActivityEditorUtil.getDefaultValue(p.getDataType(), p.isArray());
            try {
                workflowDef.createFieldUsingString(p.getSymName(), defaultValue, p.getDataType(), p.isArray());
            }
            catch (VWException e) {
                e.printStackTrace();
            }
        }
        CBLogger.trace(log, "<<createDataFieldsForInBaskets in Connector.java");
    }

    private boolean isTaskModifiedInWizardMode(TaskType uitask, TaskType sdftask) {
        if (!Collator.getInstance().equals(uitask.getDisplayName(), sdftask.getDisplayName())) {
            return true;
        }
        if (uitask.getDescription() == null && sdftask.getDescription() != null) {
            return true;
        }
        if (uitask.getDescription() != null && sdftask.getDescription() == null) {
            return true;
        }
        if (uitask.getDescription() != null && sdftask.getDescription() != null && !Collator.getInstance().equals(uitask.getDescription(), sdftask.getDescription())) {
            return true;
        }
        return sdftask.getWorkflowType() != null && uitask.getWorkflowType() == null;
    }

    private boolean isTaskWorkflowTypeChanged(TaskType uitask, TaskType sdftask) {
        return sdftask.getWorkflowType() != null && uitask.getWorkflowType() == null;
    }
}

