/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.filenet.api.collection.DocumentSet;
import com.filenet.api.collection.FolderSet;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.J2EEUtil;
import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SdfData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.connector.Args;
import com.ibm.acm.sold.connector.CEDocumentHandler;
import com.ibm.acm.sold.connector.CEFolderHandler;
import com.ibm.acm.sold.connector.PEConfig;
import com.ibm.acm.sold.connector.RetrieveUtil;
import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.connector.XpdlLoader;
import com.ibm.acm.sold.converter.AcmConverter;
import com.ibm.acm.sold.converter.AcmProcessSolutionData;
import com.ibm.acm.sold.converter.DateTime;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmFileNotFoundException;
import com.ibm.acm.sold.exception.AcmNullValueException;
import com.ibm.acm.sold.jaxb.JAXBRetrieve;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListIntegerDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListStringDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ContentType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumChoiceListType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TypeDefinitionsType;
import filenet.vw.api.VWException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

public class CEManager {
    private static final Log log = LogFactory.getLog((String)CEManager.class.getName());
    UserContext origUC = null;
    ObjectStore objectstore = null;
    Folder folder = null;
    SdfData Sdfdata = null;
    SolutionData solData = null;
    String userName = null;
    Folder m_solutionsFolder = null;
    private Config config;
    private String projectArea = null;
    private PropertyFilter pf = null;

    public String getProjectArea() {
        return this.projectArea;
    }

    public void setProjectArea(String projectArea) {
        this.projectArea = projectArea;
    }

    public CEManager(Config cfg) {
        this.config = cfg;
        this.pf = new PropertyFilter();
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "Name", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "Reservation", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "SecurityFolder", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "ContentElements", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "DateLastModified", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "CurrentVersion", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "VersionSeries", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "DocumentTitle", null));
    }

    public CEManager(SolutionData data, Config cfg) {
        this.solData = data;
        this.config = cfg;
        this.Sdfdata = data.getSdfData();
        this.pf = new PropertyFilter();
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "Name", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "Reservation", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "SecurityFolder", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "ContentElements", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "DateLastModified", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "CurrentVersion", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "VersionSeries", null));
        this.pf.addIncludeProperty(new FilterElement(null, null, null, "DocumentTitle", null));
        if (this.solData.getUserName() != null) {
            this.userName = this.solData.getUserName();
        } else {
            CBLogger.error(log, "user name is not set in solData");
        }
    }

    public CEManager() {
    }

    public synchronized void openSession() throws AcmConnectionFailure, AcmException {
        CBLogger.trace(log, ">> OpenSession");
        this.origUC = UserContext.get();
        UserContext tempUC = new UserContext();
        tempUC.setLocale(this.origUC.getLocale());
        UserContext.set((UserContext)tempUC);
        Connection conn = null;
        try {
            conn = Factory.Connection.getConnection((String)this.config.getCeUri());
            CBLogger.debug(log, "Connection :" + conn);
            if (!this.config.isJaasAuthentication()) {
                Subject subject = UserContext.createSubject((Connection)conn, (String)this.config.getUserName(), (String)this.config.getPassword(), null);
                UserContext.get().pushSubject(subject);
            }
        }
        catch (EngineRuntimeException e) {
            CBLogger.error(log, e.getLocalizedMessage());
            Message msg = new Message("B0005E.CONNECTION_FAILURE", e.getLocalizedMessage());
            throw new AcmConnectionFailure(msg);
        }
        catch (Exception e) {
            CBLogger.debug(log, e.getLocalizedMessage());
            Message msg = new Message("B0005E.CONNECTION_FAILURE", e.getLocalizedMessage());
            throw new AcmConnectionFailure(msg);
        }
        if (conn == null) {
            Message msg = new Message("B0005E.CONNECTION_FAILURE");
            throw new AcmConnectionFailure(msg);
        }
        this.objectstore = this.getObjectSore();
        CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
        this.m_solutionsFolder = cefldrhandler.getSolutionsFolder();
        CBLogger.trace(log, "<< OpenSession");
    }

    public void closeSession() {
        CBLogger.trace(log, ">> closeSession");
        if (this.origUC != null) {
            UserContext.set((UserContext)this.origUC);
        }
        CBLogger.trace(log, "<< closeSession");
    }

    public ObjectStore getObjectSore() throws AcmException {
        ObjectStore dos = null;
        try {
            Connection p8connection = Factory.Connection.getConnection((String)this.config.getCeUri());
            Domain domain = Factory.Domain.getInstance((Connection)p8connection, null);
            domain.fetchProperty("ObjectStores", null);
            dos = Factory.ObjectStore.fetchInstance((Domain)domain, (String)this.config.getObjStore(), null);
            CBLogger.trace(log, "ObjectStore :" + this.objectstore);
        }
        catch (Exception e) {
            CBLogger.error(log, e.toString(), e);
            Message msg = new Message("B0006E.DOMAIN_FAILURE");
            throw new AcmConnectionFailure(msg, (Throwable)e);
        }
        return dos;
    }

    public String getTemplateList(String intTyp) throws AcmException {
        FolderSet templateFolders;
        Folder templatesFolder;
        CBLogger.trace(log, ">>getTemplateList");
        String jsonStr = "{\"templates\":{\"template\":[";
        StringBuffer tempStr = new StringBuffer();
        String filenames = "";
        try {
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            templatesFolder = cefldrhandler.getTemplatesFolder();
        }
        catch (EngineRuntimeException e) {
            Message msg = new Message("B4040E.GET_TEMPLATES_FOLDER_FAILED", e.getLocalizedMessage());
            CBLogger.error(log, msg.getFormattedText());
            throw new AcmException(msg);
        }
        boolean firstTime = true;
        try {
            templateFolders = templatesFolder.get_SubFolders();
        }
        catch (EngineRuntimeException e) {
            CBLogger.error(log, "Error occured in bringing up the template list");
            if (e.getExceptionCode().getKey().equals(ExceptionCode.E_ACCESS_DENIED)) {
                CBLogger.error(log, "Access denied for getting the template list");
            }
            Message msg = new Message("B4010E.CONTENT_ENGINE_ERROR", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        Iterator templateIter = templateFolders.iterator();
        int result = 0;
        if (intTyp != null) {
            int n = result = intTyp.equalsIgnoreCase("CM8") ? 1 : 0;
        }
        while (templateIter.hasNext()) {
            try {
                Folder templatefldr = (Folder)templateIter.next();
                String title = templatefldr.get_FolderName();
                int folderInt = templatefldr.getProperties().getInteger32Value("CmAcmIntegrationType");
                if (result != folderInt) continue;
                if (firstTime) {
                    tempStr.append("\"" + title + "\"");
                    firstTime = false;
                    continue;
                }
                tempStr.append(",\"" + title + "\"");
            }
            catch (Exception e) {
                log.warn((Object)("Error occured in bringing up the template list " + e.getLocalizedMessage()));
            }
        }
        filenames = filenames + tempStr.toString();
        jsonStr = jsonStr + filenames + "]}}";
        CBLogger.debug(log, jsonStr);
        CBLogger.trace(log, ">>getTemplateList");
        return jsonStr;
    }

    public String getPagesListXml(String solPrefix, String SolutionName) throws AcmException {
        CBLogger.trace(log, ">>getPagesListXml");
        Folder solPagesFolder = null;
        if (SolutionName == null) {
            Message msg = new Message("B4009E.INVALID_SOLUTION_NAME");
            throw new AcmException(msg);
        }
        solPagesFolder = this.getSolutionPagesFolder(SolutionName);
        String temp1Str = "";
        String temp2Str = "";
        String temp3Str = "";
        try {
            if (solPagesFolder != null) {
                temp1Str = temp1Str + "<caseCreationPageNames>";
                temp2Str = temp2Str + "<casePageNames>";
                temp3Str = temp3Str + "<caseSplitPageNames>";
                PropertyFilter pf = new PropertyFilter();
                pf.addIncludeProperty(new FilterElement(null, null, null, "ContainedDocuments", null));
                solPagesFolder.refresh(pf);
                DocumentSet pageDocs = solPagesFolder.get_ContainedDocuments();
                for (Document page : pageDocs) {
                    try {
                        Properties props = page.getProperties();
                        String name = props.getStringValue("Name");
                        name = solPrefix + "_" + name;
                        CBLogger.info(log, "After retrieving the page name. Name = " + name);
                        Integer type = props.getInteger32Value("CmAcmType");
                        CBLogger.info(log, "page = " + page.get_Name() + ". type = " + type + ". id = " + page.get_Id());
                        if (type == 2) {
                            temp1Str = temp1Str + "<caseCreationPageName>";
                            temp1Str = temp1Str + "<name>" + name + "</name>";
                            temp1Str = temp1Str + "</caseCreationPageName>";
                        }
                        if (type == 0) {
                            temp2Str = temp2Str + "<casePageName>";
                            temp2Str = temp2Str + "<name>" + name + "</name>";
                            temp2Str = temp2Str + "</casePageName>";
                        }
                        if (type == 11) {
                            temp3Str = temp3Str + "<caseSplitPageName>";
                            temp3Str = temp3Str + "<name>" + name + "</name>";
                            temp3Str = temp3Str + "</caseSplitPageName>";
                        }
                        if (type == 4) {
                            this.solData.getStepPagesList().add(name);
                        }
                        if (type != 6) continue;
                        this.solData.getStepLaunchPagesList().add(name);
                    }
                    catch (EngineRuntimeException e) {
                        CBLogger.info(log, "page = " + page.get_Name() + ". id = " + page.get_Id());
                        CBLogger.error(log, " CE Runtime Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage());
                    }
                }
                temp1Str = temp1Str + "</caseCreationPageNames>";
                temp2Str = temp2Str + "</casePageNames>";
                temp3Str = temp3Str + "</caseSplitPageNames>";
            }
        }
        catch (EngineRuntimeException e) {
            log.error((Object)(" CE Runtime Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage()));
            return "";
        }
        catch (Exception e) {
            log.error((Object)(" Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage()));
            return "";
        }
        CBLogger.trace(log, ">>getPagesListXml");
        return temp1Str + temp2Str + temp3Str;
    }

    public List<String> getPagesList(String SolutionName) throws AcmException {
        CBLogger.trace(log, ">>getPagesList");
        ArrayList<String> pagesList = new ArrayList<String>();
        Folder solPagesFolder = null;
        if (SolutionName == null) {
            Message msg = new Message("B4009E.INVALID_SOLUTION_NAME");
            throw new AcmException(msg);
        }
        solPagesFolder = this.getSolutionPagesFolder(SolutionName);
        try {
            if (solPagesFolder != null) {
                DocumentSet pageDocs = solPagesFolder.get_ContainedDocuments();
                Iterator pageIter = pageDocs.iterator();
                String solPrefix = this.solData.getSdfData().getSolutionType().getPrefix();
                while (pageIter.hasNext()) {
                    Document page = (Document)pageIter.next();
                    pagesList.add(solPrefix + "_" + page.get_Name());
                }
            }
        }
        catch (EngineRuntimeException e) {
            log.error((Object)(" CE Runtime Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            log.error((Object)(" Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage()));
        }
        CBLogger.trace(log, ">>getPagesList");
        return pagesList;
    }

    public Folder getSolutionPagesFolder(String solutionName) throws AcmNullValueException {
        CBLogger.trace(log, ">>getSolutionPagesFolder");
        if (solutionName == null) {
            return null;
        }
        Folder pagesFolder = null;
        try {
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            Folder solFolder = cefldrhandler.getFolder(solutionName, "solution");
            FolderSet SolFolders = solFolder.get_SubFolders();
            for (Folder fld : SolFolders) {
                if (fld.get_FolderName().compareToIgnoreCase("Pages") != 0) continue;
                pagesFolder = fld;
                CBLogger.trace(log, "Pages Folder exists :: ");
            }
        }
        catch (EngineRuntimeException e) {
            log.error((Object)(" CE Runtime Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage()));
            return null;
        }
        catch (Exception e) {
            log.error((Object)(" Exception occured while retrieving Solution Pages details" + e.getLocalizedMessage()));
            return null;
        }
        if (pagesFolder == null) {
            log.warn((Object)(" Pages folder name is NOT FOUND in Solution :" + solutionName));
        }
        CBLogger.trace(log, "<<getSolutionPagesFolder");
        return pagesFolder;
    }

    public Document getDocument(Folder folder, String fileName, String type) throws AcmFileNotFoundException {
        CBLogger.trace(log, ">>getDocument");
        String folderName = folder.get_Name();
        String fileString = null;
        Document doc = null;
        int Type2 = type.compareToIgnoreCase("solution");
        fileString = Type2 == 0 ? "/" + this.config.getRootFolder() + "/" + this.config.getSolutionFolder() + "/" + folderName + "/" + fileName : "/" + this.config.getRootFolder() + "/" + this.config.getTemplateFolder() + "/" + folderName + "/" + fileName;
        try {
            doc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)fileString, null);
            CBLogger.debug(log, "Document Name " + doc.get_Name());
            CBLogger.trace(log, "<<getDocument");
            return doc;
        }
        catch (EngineRuntimeException e) {
            Message msg = new Message("B4042E.FILE_NOT_FOUND", fileName);
            throw new AcmFileNotFoundException(msg);
        }
    }

    public String deleteSolution(String solutionName) throws AcmException {
        CBLogger.trace(log, ">> deleteSolution");
        try {
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
            Folder solFolder = cefldrhandler.getFolder(solutionName, "solution");
            FolderSet SolFolders = solFolder.get_SubFolders();
            for (Folder childfldr : SolFolders) {
                docHandler.deleteDocumentsFromFolder(childfldr, this.pf);
                childfldr.delete();
                childfldr.save(RefreshMode.NO_REFRESH, this.pf);
            }
            docHandler.deleteDocumentsFromFolder(solFolder, this.pf);
            solFolder.delete();
            solFolder.save(RefreshMode.NO_REFRESH, this.pf);
            Message msg = new Message("B4023I.SOLUTION_DELETED");
            CBLogger.trace(log, " << deleteSolution");
            return "\"" + msg.getFormattedText() + "\"";
        }
        catch (Exception e) {
            CBLogger.error(log, " error in deleting soluiton :: ", e);
            Message msg = new Message("B4034E.UNABLE_TO_REMOVE_SOLUTION");
            throw new AcmException(msg, (Throwable)e);
        }
    }

    public Folder chkifSolExist(String solutionName) throws AcmException {
        CBLogger.trace(log, ">>chkifSolExists");
        if (null == this.m_solutionsFolder) {
            CBLogger.error(log, "Solutions folder is null");
            Message msg = new Message("B4039E.GET_SOLUTIONS_FOLDER_FAILED");
            throw new AcmException(msg);
        }
        FolderSet SolFolders = this.m_solutionsFolder.get_SubFolders();
        Iterator solflderIter = SolFolders.iterator();
        CBLogger.debug(log, "entering thre cursor to list sols");
        while (solflderIter.hasNext()) {
            Folder solutionfldr = (Folder)solflderIter.next();
            if (solutionfldr.get_FolderName().compareToIgnoreCase(solutionName) != 0) continue;
            CBLogger.debug(log, "solution exists :: " + solutionfldr);
            return solutionfldr;
        }
        CBLogger.trace(log, "solution doesnt exists :: ");
        return null;
    }

    public ObjectStore getSourceObjectStore() {
        return this.objectstore;
    }

    public String closeSolution(String solutionName) throws AcmException {
        CBLogger.trace(log, "-->> Entered close solution");
        String response = "";
        try {
            CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            Folder solFolder = cefldrhandler.getFolder(solutionName, "solution");
            Document configDoc = this.getDocument(solFolder, "PE Configuration", "solution");
            Document sdfDoc = this.getDocument(solFolder, "Solution Definition", "solution");
            Id sdfVsid = sdfDoc.get_VersionSeries().get_Id();
            Id configVsid = configDoc.get_VersionSeries().get_Id();
            ArrayList<IndependentlyPersistableObject> docs = new ArrayList<IndependentlyPersistableObject>(6);
            docs.add((IndependentlyPersistableObject)docHandler.closeDocument(sdfVsid));
            docs.add((IndependentlyPersistableObject)docHandler.closeDocument(configVsid));
            if (docHandler.checkDocExists(solFolder, "Solution Workflow Collection")) {
                Document globalXpdlDoc = this.getDocument(solFolder, "Solution Workflow Collection", "solution");
                Id globalXpdlVsid = globalXpdlDoc.get_VersionSeries().get_Id();
                docs.add((IndependentlyPersistableObject)docHandler.closeDocument(globalXpdlVsid));
            }
            if (this.solData != null && this.solData.getSdfData() != null && this.solData.getSdfData().getSolutionType() != null && this.solData.getSdfData().getSolutionType().getCaseTypes() != null) {
                List caseTypes = this.solData.getSdfData().getSolutionType().getCaseTypes().getCaseType();
                for (CaseTypeType caseType : caseTypes) {
                    CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                    if (caseType.getProcessDefinition() == null) continue;
                    Id id = new Id(caseType.getProcessDefinition().getContentId());
                    if (id == null) {
                        log.warn((Object)"couldn't find the xpdl");
                    }
                    docs.add((IndependentlyPersistableObject)docHandler.closeDocument(id));
                }
            }
            this.updateDocumentsInBatch(docs, RefreshMode.REFRESH, this.pf);
            Document configDoc_new = this.getDocument(solFolder, "PE Configuration", "solution");
            Document sdfDoc_new = this.getDocument(solFolder, "Solution Definition", "solution");
            String pecfgId = ((Document)configDoc_new.get_CurrentVersion()).get_Id().toString();
            String sdfId = ((Document)sdfDoc_new.get_CurrentVersion()).get_Id().toString();
            String sdf_lastModified = DateTime.listDate(sdfDoc_new.get_DateLastModified());
            String lockedBy = null;
            if (configDoc_new.get_IsReserved().booleanValue()) {
                Document resvObj = (Document)configDoc_new.get_Reservation();
                lockedBy = resvObj.get_Creator();
            }
            response = lockedBy != null ? "{\"sdfId\":\"" + sdfId + "\",\"pecfgId\":\"" + pecfgId + "\",\"lastModifiedOn\":\"" + sdf_lastModified + "\",\"lockedBy\":\"" + lockedBy + "\"}" : "{\"sdfId\":\"" + sdfId + "\",\"pecfgId\":\"" + pecfgId + "\",\"lastModifiedOn\":\"" + sdf_lastModified + "\"}";
            return response;
        }
        catch (EngineRuntimeException e) {
            CBLogger.error(log, " error ::  " + e.getMessage());
            Message msg = new Message("B4036E.CLOSE_SOLUTION_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg, (Throwable)e);
        }
        catch (AcmException e) {
            throw e;
        }
        catch (Exception e) {
            CBLogger.error(log, " error ::  " + e.getMessage());
            Message msg = new Message("B4010E.CONTENT_ENGINE_ERROR", e.getLocalizedMessage());
            throw new AcmException(msg, (Throwable)e);
        }
    }

    public String save(PEConfig peconfig, InputStream configContent) throws AcmException {
        CBLogger.trace(log, " >> Save");
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        SolutionType solutionType = this.solData.getConverterData().getSolutionType();
        String solutionName = solutionType.getName();
        String solutionDesc = solutionType.getDescription();
        String solutionIconURI = null;
        if (solutionType.getIcon() != null) {
            solutionIconURI = solutionType.getIcon().getUri();
        }
        Id sdfVsid = null;
        Id configVsid = null;
        ArrayList<IndependentlyPersistableObject> docs = new ArrayList<IndependentlyPersistableObject>(6);
        ArrayList<IndependentlyPersistableObject> docsList = new ArrayList<IndependentlyPersistableObject>(6);
        List caseTypes = null;
        if (solutionType.getCaseTypes() != null) {
            caseTypes = solutionType.getCaseTypes().getCaseType();
        }
        if (this.m_solutionsFolder.equals(null)) {
            CBLogger.error(log, "Solutions folder is null");
            Message msg = new Message("B4039E.GET_SOLUTIONS_FOLDER_FAILED");
            throw new AcmException(msg);
        }
        CBLogger.debug(log, "title :" + solutionName);
        try {
            InputStream sdfContent;
            Folder solFolder = this.chkifSolExist(solutionName);
            if (solFolder == null) {
                CBLogger.debug(log, "Folder doesn't exists, creating the folder :" + solutionName);
                solFolder = Factory.Folder.createInstance((ObjectStore)this.objectstore, (String)"CmAcmSolutionFolder");
                solFolder.set_Parent(this.m_solutionsFolder);
                solFolder.set_FolderName(solutionName);
                if (solutionDesc != null) {
                    solFolder.getProperties().putValue("Description", solutionDesc);
                }
                if (solutionIconURI != null) {
                    solFolder.getProperties().putValue("CmAcmIconURI", solutionIconURI);
                }
                docs.add((IndependentlyPersistableObject)docHandler.createDocument(CEDocumentHandler.EnumDocumentType.SDF));
                docs.add((IndependentlyPersistableObject)docHandler.createDocument(CEDocumentHandler.EnumDocumentType.PECONFIG));
                docs.add((IndependentlyPersistableObject)docHandler.createDocument(CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL));
                docs.add((IndependentlyPersistableObject)solFolder);
                for (CaseTypeType caseType : caseTypes) {
                    CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                    if (caseTypeData == null) continue;
                    docs.add((IndependentlyPersistableObject)docHandler.createDocument(CEDocumentHandler.EnumDocumentType.XPDL, caseType.getDisplayName()));
                }
                this.updateDocumentsInBatch(docs, RefreshMode.REFRESH, this.pf);
                docHandler.fileToFolder(solFolder, (Document)docs.get(0), this.pf);
                docHandler.fileToFolder(solFolder, (Document)docs.get(1), this.pf);
                docHandler.fileToFolder(solFolder, (Document)docs.get(2), this.pf);
                ContentType ct = new ContentType();
                Id global_xpdl_vsid = ((Document)docs.get(2)).get_VersionSeries().get_Id();
                ct.setContentId(global_xpdl_vsid.toString());
                solutionType.setGlobalProcessCollection(ct);
                CaseTypeData ctd = new CaseTypeData();
                ctd.setSymName(global_xpdl_vsid.toString());
                this.solData.setCasetypedata(global_xpdl_vsid.toString(), ctd);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ctd.toXPDLStream(out, solutionType.getName());
                }
                catch (Exception e) {
                    CBLogger.error(log, "error in creating Global XPDL stream");
                    Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
                    throw new AcmException(msg);
                }
                ByteArrayInputStream content = new ByteArrayInputStream(out.toByteArray());
                docsList.add((IndependentlyPersistableObject)docHandler.saveDocument(global_xpdl_vsid, content, CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL));
                int i = 4;
                for (CaseTypeType caseType : caseTypes) {
                    CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                    if (caseTypeData == null) continue;
                    docHandler.fileToFolder(solFolder, (Document)docs.get(i), caseType.getName(), this.pf);
                    ct = new ContentType();
                    ct.setContentId(((Document)docs.get(i)).get_VersionSeries().get_Id().toString());
                    caseType.setProcessDefinition(ct);
                    CBLogger.debug(log, "updating xpdl for Case :" + caseType.getName());
                    CBLogger.debug(log, " VSID : " + caseType.getProcessDefinition().getContentId());
                    ++i;
                }
            }
            if (solutionType.getGlobalProcessCollection() == null) {
                if (this.Sdfdata != null && this.Sdfdata.getSolutionType() != null && this.Sdfdata.getSolutionType().getGlobalProcessCollection() != null) {
                    solutionType.setGlobalProcessCollection(this.Sdfdata.getSolutionType().getGlobalProcessCollection());
                } else {
                    docsList.add((IndependentlyPersistableObject)this.createGlobalXpdl(solFolder, docHandler, solutionType));
                }
            }
            if (solutionDesc != null) {
                solFolder.getProperties().putValue("Description", solutionDesc);
            } else {
                solFolder.getProperties().putValue("Description", "");
            }
            if (solutionIconURI != null) {
                solFolder.getProperties().putValue("CmAcmIconURI", solutionIconURI);
            }
            if (this.projectArea != null) {
                CBLogger.debug(log, "Project Area is :" + this.projectArea);
                String projectAreaPath = "/IBM Case Manager/Connection Definitions/" + this.projectArea;
                Document projectAreaDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)projectAreaPath, null);
                solFolder.getProperties().putValue("CmAcmProjectArea", (EngineObject)projectAreaDoc.get_VersionSeries());
                CBLogger.debug(log, "Project area set for the solution folder");
            }
            String integrationType = solutionType.getIntegrationType().name();
            CBLogger.debug(log, "Integration Type :" + integrationType);
            int result = integrationType.equalsIgnoreCase("CM_8") ? 1 : 0;
            CBLogger.debug(log, "Integration Type Value :" + result);
            solFolder.getProperties().putValue("CmAcmIntegrationType", result);
            CBLogger.debug(log, "Integration type is set successfully to :" + result);
            solFolder.save(RefreshMode.NO_REFRESH, this.pf);
            TypeDefinitionsType docTypes = solutionType.getTypes();
            Map<String, String> docGuids = this.solData.getDocTypeGuids();
            if (docTypes != null && docGuids != null) {
                Iterator<String> i1 = docGuids.keySet().iterator();
                while (i1.hasNext()) {
                    String key = i1.next();
                    boolean found = false;
                    for (CmisTypeDefinitionType d : docTypes.getTypeDefinition()) {
                        if (!key.equals(d.getLocalName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    i1.remove();
                }
            }
            PropertyDefinitionsType props = solutionType.getProperties();
            Map<String, String> propGuids = this.solData.getPropertyGuids();
            if (props != null && propGuids != null) {
                Iterator<String> i1 = propGuids.keySet().iterator();
                while (i1.hasNext()) {
                    String key = i1.next();
                    boolean found = false;
                    for (CmisPropertyDefinitionType p : props.getPropertyDefinition()) {
                        if (!key.equals(p.getLocalName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    i1.remove();
                }
            }
            Document sdfDoc = this.getDocument(solFolder, "Solution Definition", "solution");
            sdfVsid = sdfDoc.get_VersionSeries().get_Id();
            Document configDoc = this.getDocument(solFolder, "PE Configuration", "solution");
            configVsid = configDoc.get_VersionSeries().get_Id();
            ContentType ct = new ContentType();
            ct.setContentId(configVsid.toString());
            solutionType.setProcessConfiguration(ct);
            ArrayList<String> detetedXpdlList = new ArrayList<String>(5);
            if (this.Sdfdata != null && this.Sdfdata.getSolutionType() != null && this.Sdfdata.getSolutionType().getCaseTypes() != null) {
                List oldCaseTypesList = this.Sdfdata.getSolutionType().getCaseTypes().getCaseType();
                for (CaseTypeType oldCaseType : oldCaseTypesList) {
                    boolean bFound = false;
                    for (CaseTypeType caseType : caseTypes) {
                        if (!Collator.getInstance().equals(oldCaseType.getName(), caseType.getName())) continue;
                        caseType.setProcessDefinition(oldCaseType.getProcessDefinition());
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    if (oldCaseType.getProcessDefinition() != null) {
                        detetedXpdlList.add(oldCaseType.getProcessDefinition().getContentId());
                    }
                    this.solData.removeCaseTypeTaskGuids(oldCaseType.getName());
                }
            }
            for (CaseTypeType caseType : caseTypes) {
                Document savedDoc;
                CaseTypeData caseTypeData = this.solData.getCasetypedata(caseType.getName());
                if (caseTypeData == null) continue;
                if (caseTypeData.getActivitiesMap().size() != 0) {
                    Map<String, AcmActivity> actList = caseTypeData.getActivitiesMap();
                    Iterator<String> i1 = actList.keySet().iterator();
                    while (i1.hasNext()) {
                        String key = i1.next();
                        boolean found = false;
                        List tasklist = caseType.getTasks().getTask();
                        for (TaskType t : tasklist) {
                            if (!Collator.getInstance().equals(key, t.getName())) continue;
                            found = true;
                        }
                        if (found) continue;
                        i1.remove();
                        this.solData.removeTaskGuid(key);
                    }
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    caseTypeData.toXPDLStream(out, solutionType.getName());
                }
                catch (Exception e) {
                    CBLogger.error(log, "error in creating XPDL stream", e);
                    Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
                    throw new AcmException(msg);
                }
                ByteArrayInputStream content = new ByteArrayInputStream(out.toByteArray());
                Id id = null;
                if (caseType.getProcessDefinition() != null) {
                    id = new Id(caseType.getProcessDefinition().getContentId());
                }
                if (id == null) {
                    Document doc = docHandler.createDocument(CEDocumentHandler.EnumDocumentType.XPDL, caseType.getDisplayName());
                    doc.save(RefreshMode.REFRESH, this.pf);
                    docHandler.fileToFolder(solFolder, doc, caseType.getName(), this.pf);
                    id = doc.get_VersionSeries().get_Id();
                    ContentType cType = new ContentType();
                    cType.setContentId(id.toString());
                    caseType.setProcessDefinition(cType);
                }
                if ((savedDoc = docHandler.saveDocument(id, content, CEDocumentHandler.EnumDocumentType.XPDL)) == null) continue;
                docsList.add((IndependentlyPersistableObject)savedDoc);
            }
            if (configContent != null) {
                docsList.add((IndependentlyPersistableObject)docHandler.saveDocument(configVsid, configContent, CEDocumentHandler.EnumDocumentType.PECONFIG));
                CBLogger.debug(log, "updated config document successfully");
            }
            if ((sdfContent = this.solData.getConverterData().getConverterdXMLStream()) != null) {
                docsList.add((IndependentlyPersistableObject)docHandler.saveDocument(sdfVsid, sdfContent, CEDocumentHandler.EnumDocumentType.SDF));
                CBLogger.debug(log, "updated sdf document successfully");
            }
            this.updateDocumentsInBatch(docsList, RefreshMode.NO_REFRESH, this.pf);
            for (String xpdlVsid : detetedXpdlList) {
                docHandler.deleteDocument(new Id(xpdlVsid), this.pf);
            }
            this.Sdfdata.setSolutionType(solutionType);
            this.solData.setPeconfigData(peconfig);
            sdfContent.close();
            Utility.deleteTempFile(solutionName);
        }
        catch (AcmException e) {
            throw e;
        }
        catch (Exception e) {
            Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
            CBLogger.error(log, "save solution: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AcmException(msg);
        }
        Message msg = new Message("B4005I.SOLUTION_CREATED");
        CBLogger.debug(log, msg.getFormattedText());
        String response = "";
        response = sdfVsid != null ? response.concat("{\"msg\":\"" + msg.getFormattedText() + "\",\"sdfVSID\":\"" + sdfVsid.toString() + "\"}") : response.concat("{\"msg\":\"" + msg.getFormattedText() + "\"}");
        CBLogger.trace(log, " << Save");
        return response;
    }

    public void updateDocumentsInBatch(List<IndependentlyPersistableObject> docs, RefreshMode refMode, PropertyFilter pf) {
        UpdatingBatch ub = UpdatingBatch.createUpdatingBatchInstance((Domain)this.objectstore.get_Domain(), (RefreshMode)refMode);
        for (IndependentlyPersistableObject document : docs) {
            ub.add(document, pf);
        }
        ub.updateBatch();
    }

    public String saveAndCloseSolution(PEConfig peconfig, InputStream configContent) throws AcmException {
        String result = "";
        String response = "";
        String sdfId = "";
        String sdf_lastModified = "";
        result = "";
        String solutionName = this.solData.getConverterData().getSolutionType().getName();
        try {
            response = this.save(peconfig, configContent);
            response = this.closeSolution(solutionName);
            CEFolderHandler cefldrhandler = new CEFolderHandler(this.objectstore);
            Folder solFolder = cefldrhandler.getFolder(solutionName, "solution");
            Document sdfDoc = this.getDocument(solFolder, "Solution Definition", "solution");
            Document cfgDoc = this.getDocument(solFolder, "PE Configuration", "solution");
            sdfId = sdfDoc.get_Id().toString();
            String pecfgId = cfgDoc.get_Id().toString();
            sdf_lastModified = DateTime.listDate(sdfDoc.get_DateLastModified());
            String sdfVsid = sdfDoc.get_VersionSeries().get_Id().toString();
            response = result.concat("{\"sdfId\":\"" + sdfId + "\",\"pecfgId\":\"" + pecfgId + "\",\"sdfVSID\":\"" + sdfVsid + "\",\"lastModifiedOn\":\"" + sdf_lastModified + "\"}");
            return response;
        }
        catch (AcmException e) {
            CBLogger.error(log, "error passed back from save and close :: " + e.getLocalizedMessage());
            throw e;
        }
        catch (Exception e) {
            Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public String retrieveTemplate(String solutionName) throws AcmException {
        Document configDoc = null;
        Document sdfDoc = null;
        CEFolderHandler folderHandler = new CEFolderHandler(this.objectstore);
        Folder solFolder = folderHandler.getTemplateFolder(solutionName);
        if (solFolder == null) {
            Message msg = new Message("B0007E.FOLDER_NOT_FOUND");
            throw new AcmException(msg);
        }
        try {
            sdfDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)("/IBM Case Manager/Solution Templates/" + solutionName + "/" + "Solution Definition"), null);
            configDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)("/IBM Case Manager/Solution Templates/" + solutionName + "/" + "PE Configuration"), null);
        }
        catch (EngineRuntimeException e) {
            CBLogger.error(log, "Error retrieving template " + solutionName + " :: " + e.getMessage());
            Message msg = new Message("B4038E.TEMPLATE_RETRIEVAL_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        if (configDoc == null) {
            Message msg = new Message("B0002E.CONFIG_FILE_MISSING");
            throw new AcmException(msg);
        }
        if (sdfDoc == null) {
            Message msg = new Message("B0008E.SDF_NOT_FOUND");
            throw new AcmException(msg);
        }
        return this.retrieve(sdfDoc, configDoc, null);
    }

    public String retrieveSolution(String solutionName, boolean forceGet) throws AcmException {
        CBLogger.trace(log, ">> retrieveSolution");
        if (forceGet) {
            CBLogger.debug(log, "Retriving solution even it is edited by other user");
            return this.retrieveSolution(solutionName);
        }
        Document configDoc = null;
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        CEFolderHandler folderHandler = new CEFolderHandler(this.objectstore);
        Folder solFolder = folderHandler.getSolutionFolder(solutionName);
        if (solFolder == null) {
            Message msg = new Message("B0007E.FOLDER_NOT_FOUND");
            throw new AcmException(msg);
        }
        try {
            configDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)("/IBM Case Manager/Solutions/" + solutionName + "/" + "PE Configuration"), null);
        }
        catch (EngineRuntimeException e) {
            Message msg = new Message("B4042E.FILE_NOT_FOUND", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        if (configDoc == null) {
            Message msg = new Message("B0002E.CONFIG_FILE_MISSING");
            throw new AcmException(msg);
        }
        Id configVsid = configDoc.get_VersionSeries().get_Id();
        int isCheckedOut = docHandler.isDocumentCheckedOut(configVsid, this.userName);
        CBLogger.debug(log, "Is PEConfig file checked out? :" + isCheckedOut);
        if (isCheckedOut == 1) {
            Message msg = new Message("B4012E.ANOTHER_SESSION_EDITING_THIS_SOLUTION");
            throw new AcmException(msg);
        }
        CBLogger.debug(log, "Retrieving the solution");
        return this.retrieveSolution(solutionName);
    }

    public String retrieveSolution(String solutionName) throws AcmException {
        CBLogger.trace(log, ">> retrieveSolution");
        Document configDoc = null;
        Document sdfDoc = null;
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        CEFolderHandler folderHandler = new CEFolderHandler(this.objectstore);
        Folder solFolder = folderHandler.getSolutionFolder(solutionName);
        Boolean preserveId = null;
        if (solFolder == null) {
            Message msg = new Message("B0007E.FOLDER_NOT_FOUND");
            throw new AcmException(msg);
        }
        try {
            sdfDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)("/IBM Case Manager/Solutions/" + solutionName + "/" + "Solution Definition"), null);
            configDoc = Factory.Document.fetchInstance((ObjectStore)this.objectstore, (String)("/IBM Case Manager/Solutions/" + solutionName + "/" + "PE Configuration"), null);
            preserveId = solFolder.getProperties().get("CmAcmPreserveIdentifier").getBooleanValue();
        }
        catch (EngineRuntimeException e) {
            Message msg = new Message("B4042E.FILE_NOT_FOUND", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        if (configDoc == null) {
            Message msg = new Message("B0002E.CONFIG_FILE_MISSING");
            throw new AcmException(msg);
        }
        if (sdfDoc == null) {
            Message msg = new Message("B0008E.SDF_NOT_FOUND");
            throw new AcmException(msg);
        }
        try {
            Id sdfVsid = sdfDoc.get_VersionSeries().get_Id();
            Id configVsid = configDoc.get_VersionSeries().get_Id();
            ArrayList<IndependentlyPersistableObject> docs = new ArrayList<IndependentlyPersistableObject>(5);
            docs.add((IndependentlyPersistableObject)docHandler.retrieveDocument(sdfVsid, this.userName, true));
            docs.add((IndependentlyPersistableObject)docHandler.retrieveDocument(configVsid, this.userName, true));
            this.updateDocumentsInBatch(docs, RefreshMode.REFRESH, this.pf);
            sdfDoc = (Document)docs.get(0);
            configDoc = (Document)docs.get(1);
        }
        catch (AcmException e) {
            CBLogger.error(log, "error at retrieve solution is  :: " + e.getMessage());
            throw e;
        }
        return this.retrieve(sdfDoc, configDoc, preserveId);
    }

    public String retrieve(Document sdfDoc, Document configDoc, Boolean preserveId) throws AcmException {
        CBLogger.trace(log, ">>retrieve");
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        String sdfString = null;
        String soljson = null;
        if (sdfDoc == null || configDoc == null) {
            Message msg = new Message("B4001E.INVALID_ARGUMENTS_TO_METHOD", "retrieve()");
            throw new AcmException(msg);
        }
        sdfString = docHandler.getDocumentContent(sdfDoc);
        CBLogger.debug(log, "SDF Content : " + sdfString);
        if (sdfString == null) {
            Message msg = new Message("B4026E.CONTENT_RETRIEVAL_FAILED", sdfDoc.get_Name());
            throw new AcmException(msg);
        }
        JAXBRetrieve jr = new JAXBRetrieve(sdfString);
        if (this.Sdfdata == null) {
            this.Sdfdata = new SdfData();
            this.solData.setSdfData(this.Sdfdata);
        }
        SolutionType solntype = jr.getSolutionTypeObj();
        this.solData.getSdfData().setSolutionType(solntype);
        String solName = this.solData.getSdfData().getSolutionType().getName();
        String solPrefix = this.solData.getSdfData().getSolutionType().getPrefix();
        CBLogger.debug(log, "solution name" + solName);
        String result = jr.retrieve();
        CBLogger.debug(log, "retrieve from the sdf" + result);
        AcmConverter converter = this.solData.getConverterData();
        if (converter == null) {
            converter = new AcmConverter(this.solData);
            this.solData.setConverterData(converter);
        }
        converter.setSolutionType(solntype);
        PEConfig peConfig = new PEConfig(this.solData, converter);
        this.solData.setPeconfigData(peConfig);
        InputStream inStream = docHandler.fetchDocumentContent(configDoc);
        if (inStream == null) {
            Message msg = new Message("B0013E.ERROR_GENERATING_PECONFIG");
            throw new AcmException(msg);
        }
        peConfig.initializeConfig(inStream);
        if (peConfig.getColumnFromOutsideInfo() != null) {
            this.solData.setColumnFromOutsideInfo(peConfig.getColumnFromOutsideInfo());
        }
        if (peConfig.getExistingQueues() != null) {
            this.solData.setExistingQueues(peConfig.getExistingQueues());
        }
        this.createGuidsTables();
        StringBuffer sb = new StringBuffer("<solution>");
        if (preserveId != null) {
            sb.append("<preserveId>");
            if (preserveId.booleanValue()) {
                sb.append("true");
            } else if (!preserveId.booleanValue()) {
                sb.append("false");
            }
            sb.append("</preserveId>");
        }
        if (this.solData.getExistingQueues() != null) {
            List<String> existingQueues = this.solData.getExistingQueues();
            for (int i = 0; i < existingQueues.size(); ++i) {
                sb.append("<existingQueues>" + existingQueues.get(i) + "</" + "existingQueues" + ">");
            }
        }
        this.solData.getRoles().toXml(sb);
        if (this.solData.getInbaskets() != null) {
            this.solData.getInbaskets().toXml(sb);
        }
        String pagesListXml = this.getPagesListXml(solPrefix, solName);
        peConfig.createPagesStepProcessors(this.solData, this.getPagesList(solName));
        sb.append(pagesListXml);
        sb.append(result);
        soljson = RetrieveUtil.convertXmlToJson(sb.toString());
        Args xpdlThreadarg = new Args();
        xpdlThreadarg.setConfig(this.config);
        xpdlThreadarg.setSolData(this.solData);
        xpdlThreadarg.setUserName(this.userName);
        xpdlThreadarg.setSolntype(solntype);
        CBLogger.debug(log, "Created the argument object");
        if (solntype.getCaseTypes().getCaseType().size() > 0) {
            Subject authSubject = this.getAuthentiocationSubject();
            Locale userLocale = UserContext.get().getLocale();
            XpdlLoader loader = new XpdlLoader(xpdlThreadarg, authSubject, userLocale);
            Thread loaderThr = new Thread(loader);
            this.solData.setXpdlThread(loaderThr);
            this.solData.setXpdlloader(loader);
            loaderThr.start();
        }
        CBLogger.trace(log, "<<retrieve");
        return soljson;
    }

    private Subject getAuthentiocationSubject() {
        UserContext uc;
        Subject subject = null;
        J2EEUtil j2eeUtil = J2EEUtil.getInstance();
        if (j2eeUtil != null) {
            subject = j2eeUtil.getCurrentSubject();
        }
        if (subject == null && (uc = UserContext.get()) != null) {
            subject = uc.getSubject();
        }
        return subject;
    }

    public String reloadPEconfigXPDL(SolutionData solData, String caseTypeName) throws AcmException {
        Id configVSID = null;
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        InputStream configStream = null;
        if (solData.getSdfData() != null && solData.getSdfData().getSolutionType() != null && solData.getSdfData().getSolutionType().getProcessConfiguration() != null) {
            configVSID = new Id(solData.getSdfData().getSolutionType().getProcessConfiguration().getContentId());
        }
        Document configDoc = docHandler.retrieveDocument(configVSID, this.userName, false);
        configDoc.save(RefreshMode.REFRESH, this.pf);
        configStream = docHandler.fetchDocumentContent(configDoc);
        PEConfig peConfig = solData.getPeconfigData();
        peConfig.initializeConfig(configStream);
        StringBuffer sb = new StringBuffer("<solution>");
        solData.getRoles().toXml(sb);
        if (solData.getInbaskets() != null) {
            solData.getInbaskets().toXml(sb);
        }
        sb.append("</solution>");
        String jsonstr = RetrieveUtil.convertXmlToJson(sb.toString());
        CaseTypeData ctData = solData.getCasetypedata(caseTypeName);
        InputStream xpdlStream = this.retrieveXPDLdoc(ctData.getSymName(), false);
        try {
            if (xpdlStream != null) {
                ctData.readXpdl(xpdlStream, true);
            } else {
                log.warn((Object)("No XPDL Available for CaseType : " + ctData.getSymName()));
            }
        }
        catch (DiagrammerException e) {
            CBLogger.error(log, " error ::  ", e);
            Message msg = new Message("B4064E.ERROR_DIAGRAM_MODEL");
            throw new AcmException(msg, (Throwable)e);
        }
        solData.setCasetypedata(caseTypeName, ctData);
        return jsonstr;
    }

    public CaseTypeData initCaseType(CaseTypeType caseType, SolutionData solData, boolean checkOut) throws AcmException {
        AcmProcessSolutionData procSolData = new AcmProcessSolutionData(solData);
        CaseTypeData ctData = new CaseTypeData();
        if (ctData.getId() == null) {
            ctData.setId(caseType.getId());
        }
        ctData.setSymName(caseType.getName());
        ctData.setDisplayName(caseType.getDisplayName());
        ctData = procSolData.updateCaseTypeDataSharedInfo(solData, caseType.getName(), ctData);
        List actList = caseType.getTasks().getTask();
        for (TaskType act : actList) {
            AcmActivity acmActiv = null;
            if (act.getWorkflowType() != null && act.getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) continue;
            acmActiv = procSolData.createActivityObject(act);
            try {
                acmActiv.setGuid(ctData.getId(), acmActiv.getSdfData().getId());
            }
            catch (VWException e) {
                CBLogger.error(log, " error ::  ", e);
                Message msg = new Message("B4066E.VW_EXCEPTION");
                throw new AcmException(msg, (Throwable)e);
            }
            ctData.addActivity(acmActiv);
        }
        InputStream xpdlStream = this.retrieveXPDLdoc(ctData.getSymName(), checkOut);
        try {
            if (xpdlStream != null) {
                ctData.readXpdl(xpdlStream, checkOut);
            } else {
                log.warn((Object)("No XPDL Available for CaseType : " + ctData.getSymName()));
            }
        }
        catch (DiagrammerException e) {
            CBLogger.error(log, " error ::  ", e);
            Message msg = new Message("B4064E.ERROR_DIAGRAM_MODEL");
            throw new AcmException(msg, (Throwable)e);
        }
        solData.setCasetypedata(caseType.getName(), ctData);
        return ctData;
    }

    public void createGuidsTables() throws AcmException {
        ChoiceListDefinitionsType choiceListTypes;
        TypeDefinitionsType docTypes;
        PropertyDefinitionsType props;
        List caseTypes;
        CBLogger.trace(log, ">> createGuidsTables");
        SolutionType solnType = this.solData.getSdfData().getSolutionType();
        if (solnType.getCaseTypes() != null && (caseTypes = solnType.getCaseTypes().getCaseType()) != null) {
            for (CaseTypeType caseType : caseTypes) {
                List tlist;
                this.solData.getCaseTypeGuids().put(caseType.getName(), caseType.getId());
                if (caseType.getTasks() == null || (tlist = caseType.getTasks().getTask()) == null) continue;
                for (TaskType t : tlist) {
                    this.solData.getTaskGuids().put(t.getName(), t.getId());
                    CBLogger.debug(log, "Stored Name: " + t.getName() + " GUID: " + t.getId());
                }
            }
        }
        if ((props = solnType.getProperties()) != null) {
            for (CmisPropertyDefinitionType p : props.getPropertyDefinition()) {
                this.solData.getPropertyGuids().put(p.getLocalName(), p.getId());
                CBLogger.debug(log, "Stored Name: " + p.getLocalName() + " GUID: " + p.getId());
            }
        }
        if ((docTypes = solnType.getTypes()) != null) {
            for (CmisTypeDefinitionType d : docTypes.getTypeDefinition()) {
                this.solData.getDocTypeGuids().put(d.getLocalName(), d.getId());
                CBLogger.debug(log, "Stored Name: " + d.getLocalName() + " GUID: " + d.getId());
            }
        }
        if ((choiceListTypes = solnType.getChoiceLists()) != null) {
            CBLogger.debug(log, "Choicelist is not empty");
            for (ChoiceListDefinitionType chlist : choiceListTypes.getChoiceListDefinition()) {
                if (chlist.getType().compareTo((Enum)EnumChoiceListType.INTEGER) == 0) {
                    this.solData.getChoiceListTypeGuids().put(((ChoiceListIntegerDefinitionType)chlist).getChoice().getDisplayName(), chlist.getId());
                    CBLogger.debug(log, "Stored Name: " + ((ChoiceListIntegerDefinitionType)chlist).getChoice().getDisplayName() + " GUID: " + chlist.getId());
                    continue;
                }
                if (chlist.getType().compareTo((Enum)EnumChoiceListType.STRING) == 0) {
                    this.solData.getChoiceListTypeGuids().put(((ChoiceListStringDefinitionType)chlist).getChoice().getDisplayName(), chlist.getId());
                    CBLogger.debug(log, "Stored Name: " + ((ChoiceListStringDefinitionType)chlist).getChoice().getDisplayName() + " GUID: " + chlist.getId());
                    continue;
                }
                log.warn((Object)"Unknown list type");
            }
        }
        CBLogger.trace(log, "<< createGuidsTables");
    }

    public InputStream retrieveXPDLdoc(String caseTypeName, boolean checkOut) throws AcmException {
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        InputStream input = null;
        Id vsId = null;
        if (caseTypeName == null || caseTypeName.length() == 0) {
            Message msg = new Message("B4001E.INVALID_ARGUMENTS_TO_METHOD", "CaseType Name is NULL");
            throw new AcmException(msg);
        }
        List caseTypes = null;
        if (this.solData.getSdfData() == null || this.solData.getSdfData().getSolutionType() == null || this.solData.getSdfData().getSolutionType().getCaseTypes() == null) {
            CBLogger.debug(log, " New solution or no casetypes found on retrieve");
            return null;
        }
        caseTypes = this.solData.getSdfData().getSolutionType().getCaseTypes().getCaseType();
        for (CaseTypeType caseType : caseTypes) {
            if (!Collator.getInstance().equals(caseTypeName, caseType.getName())) continue;
            ContentType ct = caseType.getProcessDefinition();
            if (ct == null) break;
            vsId = new Id(ct.getContentId());
            break;
        }
        if (vsId == null) {
            CBLogger.debug(log, " VSID is null for CaseType:" + caseTypeName);
            return null;
        }
        try {
            Document xpdlDoc = docHandler.retrieveDocument(vsId, this.userName, checkOut);
            xpdlDoc.save(RefreshMode.REFRESH, this.pf);
            input = docHandler.fetchDocumentContent(xpdlDoc);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Message msg = new Message("B4029E.XPDL_NOT_AVAILABLE", t.getLocalizedMessage());
            throw new AcmException(msg.getFormattedText(), "B4029E.XPDL_NOT_AVAILABLE");
        }
        return input;
    }

    public InputStream retrieveGlobalXPDL() throws AcmException {
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        InputStream input = null;
        Id vsId = null;
        if (this.solData.getSdfData() != null && this.solData.getSdfData().getSolutionType() != null) {
            ContentType ct = this.solData.getSdfData().getSolutionType().getGlobalProcessCollection();
            if (ct != null) {
                vsId = new Id(ct.getContentId());
            }
        } else {
            CBLogger.error(log, " SolutionType invalid or null, Failed to retrieve Global XPDL");
            return null;
        }
        if (vsId == null) {
            CBLogger.error(log, " Global XPDL VSID is null");
            return null;
        }
        try {
            Document xpdlDoc = docHandler.retrieveDocument(vsId, this.userName, true);
            xpdlDoc.save(RefreshMode.REFRESH, this.pf);
            input = docHandler.fetchDocumentContent(xpdlDoc);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Message msg = new Message("B4029E.XPDL_NOT_AVAILABLE", t.getLocalizedMessage());
            throw new AcmException(msg.getFormattedText(), "B4029E.XPDL_NOT_AVAILABLE");
        }
        return input;
    }

    public String hasDeleteAccess(Folder solutionfldr) {
        String allowDelete = null;
        try {
            int fldraccess = solutionfldr.getAccessAllowed();
            allowDelete = (fldraccess & 0x10000) != 0 ? "true" : "false";
            CBLogger.trace(log, "The user can delete the solutions : " + allowDelete);
        }
        catch (Exception e) {
            e.printStackTrace();
            CBLogger.error(log, "Error occured in hasDeleteAccess method ");
            allowDelete = "false";
        }
        return allowDelete;
    }

    public Document createGlobalXpdl(Folder solFolder, CEDocumentHandler docHandler, SolutionType solutionType) throws AcmException {
        Document doc = docHandler.createDocument(CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL);
        doc.save(RefreshMode.REFRESH, this.pf);
        docHandler.fileToFolder(solFolder, doc, this.pf);
        ContentType ct = new ContentType();
        Id global_xpdl_vsid = doc.get_VersionSeries().get_Id();
        ct.setContentId(global_xpdl_vsid.toString());
        solutionType.setGlobalProcessCollection(ct);
        CaseTypeData ctd = new CaseTypeData();
        ctd.setSymName(global_xpdl_vsid.toString());
        this.solData.setCasetypedata(global_xpdl_vsid.toString(), ctd);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ctd.toXPDLStream(out, solutionType.getName());
        }
        catch (Exception e) {
            CBLogger.error(log, e.toString(), e);
            Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        ByteArrayInputStream content = new ByteArrayInputStream(out.toByteArray());
        return docHandler.saveDocument(global_xpdl_vsid, content, CEDocumentHandler.EnumDocumentType.GLOBAL_XPDL);
    }

    public void updateXPDLReservation(ObjectStore objectStore, String solutionName, String caseTypeName, InputStream inputStream) throws AcmException {
        CEDocumentHandler docHandler = new CEDocumentHandler(objectStore);
        CEFolderHandler folHandler = new CEFolderHandler(objectStore);
        Document doc = null;
        try {
            Folder solFolder = folHandler.getFolder(solutionName, "solution");
            doc = this.getDocument(solFolder, caseTypeName, "solution");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doc != null) {
            docHandler.updateReservation(doc, inputStream, CEDocumentHandler.EnumDocumentType.XPDL).save(RefreshMode.NO_REFRESH);
        }
    }

    public static enum EnumCreationType {
        SOLUTION,
        TEMPLATE;

    }
}

