/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectStore;
import com.ibm.acm.sold.connector.CEManager;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CEFolderHandler {
    private static final Log log = LogFactory.getLog((String)CEManager.class.getName());
    private static final String m_className = "CEFolderHandler";
    private ObjectStore m_objStore = null;
    public static final String SOLUTIONS_FOLDER_PATH = "/IBM Case Manager/Solutions";
    public static final String TEMPLATES_FOLDER_PATH = "/IBM Case Manager/Solution Templates";

    public CEFolderHandler(ObjectStore objectStore) {
        this.m_objStore = objectStore;
    }

    public Folder getSolutionFolder(String solutionName) throws AcmException {
        log.trace((Object)">>getFolder");
        try {
            Folder solFolder = Factory.Folder.fetchInstance((ObjectStore)this.m_objStore, (String)("/IBM Case Manager/Solutions/" + solutionName), null);
            log.trace((Object)("Get solution folder: folder name is  " + solFolder.get_FolderName()));
            log.trace((Object)"<<getFolder");
            return solFolder;
        }
        catch (Exception e) {
            log.debug((Object)("unable to get solution folder " + e.getLocalizedMessage()));
            Message msg = new Message("B4035E.SOLUTION_RETRIEVE_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public Folder getTemplateFolder(String templateName) throws AcmException {
        log.trace((Object)">>getTemplateFolder");
        try {
            Folder solFolder = Factory.Folder.fetchInstance((ObjectStore)this.m_objStore, (String)("/IBM Case Manager/Solution Templates/" + templateName), null);
            log.trace((Object)("Get Template folder: folder name is  " + solFolder.get_FolderName()));
            log.trace((Object)"<<getFolder");
            return solFolder;
        }
        catch (Exception e) {
            log.debug((Object)("unable to get template folder " + e.getLocalizedMessage()));
            Message msg = new Message("B4035E.SOLUTION_RETRIEVE_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public Folder getSolutionsFolder() throws AcmException {
        log.trace((Object)">>getSolutionsFolder");
        try {
            Folder folder = Factory.Folder.fetchInstance((ObjectStore)this.m_objStore, (String)SOLUTIONS_FOLDER_PATH, null);
            log.trace((Object)"<<getsolutionsFolder");
            return folder;
        }
        catch (Exception e) {
            log.debug((Object)("unable to get solutions folder " + e.getLocalizedMessage()));
            Message msg = new Message("B4039E.GET_SOLUTIONS_FOLDER_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public Folder getTemplatesFolder() throws AcmException {
        log.trace((Object)">>getTemplatesFolder");
        try {
            Folder folder = Factory.Folder.fetchInstance((ObjectStore)this.m_objStore, (String)TEMPLATES_FOLDER_PATH, null);
            log.trace((Object)"<<getTemplatesFolder");
            return folder;
        }
        catch (Exception e) {
            log.debug((Object)("unable to get templates folder " + e.getLocalizedMessage()));
            Message msg = new Message("B4040E.GET_TEMPLATES_FOLDER_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public Folder getFolder(String folderName, String type) throws Exception {
        log.trace((Object)">>getFolder");
        String folderPath = null;
        if (folderName == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT");
            throw new AcmException(msg);
        }
        int Type2 = type.compareToIgnoreCase("solution");
        folderPath = Type2 == 0 ? "/IBM Case Manager/Solutions/" + folderName : "/IBM Case Manager/Solution Templates/" + folderName;
        log.trace((Object)("Get folder: folder path is  " + folderPath));
        try {
            Folder folder = Factory.Folder.fetchInstance((ObjectStore)this.m_objStore, (String)folderPath, null);
            log.trace((Object)"<<getFolder");
            return folder;
        }
        catch (Exception e) {
            log.debug((Object)("unable to get folder " + e.getLocalizedMessage()));
            throw e;
        }
    }
}

