/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.connector;

import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.DocumentSet;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.DynamicReferentialContainmentRelationship;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmFileNotFoundException;
import com.ibm.acm.sold.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CEDocumentHandler {
    private static final Log log = LogFactory.getLog((String)CEDocumentHandler.class.getName());
    private static ObjectStore m_objStore = null;

    public CEDocumentHandler(ObjectStore objStore) {
        m_objStore = objStore;
    }

    public Document updateReservation(Document doc, InputStream input, EnumDocumentType type) throws AcmException {
        Document reservation = null;
        String fileName = null;
        String mimeType = null;
        switch (type) {
            case SDF: {
                fileName = "sdf.xml";
                mimeType = "text/xml";
                break;
            }
            case PECONFIG: {
                fileName = "config.xml";
                mimeType = "text/xml";
                break;
            }
            case XPDL: {
                fileName = "routing.xpdl";
                mimeType = "application/x-filenet-xpdlworkflowdefinition";
                break;
            }
            case GLOBAL_XPDL: {
                fileName = "routing.xpdl";
                mimeType = "application/x-filenet-xpdlworkflowdefinition";
            }
        }
        if (doc.get_IsReserved().booleanValue()) {
            reservation = (Document)doc.get_Reservation();
        } else {
            log.debug((Object)"The document is not in checked out state");
        }
        if (reservation == null) {
            log.debug((Object)"reservation object is null");
            log.debug((Object)("is document in checked out state ? " + doc.get_IsReserved()));
        } else {
            try {
                ContentElementList contentElementList = Factory.ContentElement.createList();
                ContentTransfer contentTransfer = Factory.ContentTransfer.createInstance();
                contentTransfer.setCaptureSource(input);
                contentTransfer.set_RetrievalName(fileName);
                contentElementList.add(0, (Object)contentTransfer);
                reservation.set_ContentElements(contentElementList);
                reservation.set_MimeType(mimeType);
            }
            catch (ClassCastException e) {
                log.trace((Object)("unable to update the document " + e.getLocalizedMessage()));
                Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
                throw new AcmException(msg);
            }
            catch (IndexOutOfBoundsException e) {
                log.trace((Object)("unable to update the document " + e.getLocalizedMessage()));
                Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
                throw new AcmException(msg);
            }
            catch (Exception e) {
                log.trace((Object)("unable to update the document " + e.getLocalizedMessage()));
                Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
                throw new AcmException(msg);
            }
        }
        return reservation;
    }

    private void checkin(Document doc) throws AcmException {
        try {
            doc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        }
        catch (Exception e) {
            log.trace((Object)"unable to check-in the  the document");
            Message msg = new Message("B4037E.SOLUTION_UPDATE_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    private Document cancelCheckout(Document doc) {
        if (doc.get_IsReserved().booleanValue()) {
            doc.cancelCheckout();
            Document reservation = (Document)doc.get_Reservation();
            return reservation;
        }
        return null;
    }

    public Document saveDocument(Id vsId, InputStream input, EnumDocumentType type) throws AcmException {
        Document doc = CEDocumentHandler.fetchDocument(vsId);
        return this.updateReservation(doc, input, type);
    }

    public Document createDocument(EnumDocumentType type) throws AcmException {
        return this.createDocument(type, null);
    }

    public Document createDocument(EnumDocumentType type, String caseTypeName) throws AcmException {
        Document doc;
        String className = null;
        String mimeType = null;
        String title = null;
        switch (type) {
            case SDF: {
                className = "Document";
                mimeType = "text/xml";
                title = "Solution Definition";
                break;
            }
            case PECONFIG: {
                className = "Document";
                mimeType = "text/xml";
                title = "PE Configuration";
                break;
            }
            case XPDL: {
                className = "WorkflowDefinition";
                mimeType = "application/x-filenet-xpdlworkflowdefinition";
                title = caseTypeName + " Workflow Definition";
                break;
            }
            case GLOBAL_XPDL: {
                className = "WorkflowDefinition";
                mimeType = "application/x-filenet-xpdlworkflowdefinition";
                title = "Solution Workflow Collection";
            }
        }
        try {
            doc = Factory.Document.createInstance((ObjectStore)m_objStore, (String)className);
            doc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MINOR_VERSION);
            doc.checkout(ReservationType.EXCLUSIVE, null, null, null);
            doc.set_MimeType(mimeType);
            doc.getProperties().putValue("DocumentTitle", title);
        }
        catch (Exception e) {
            log.trace((Object)"unable to create the document");
            Message msg = new Message("B4016E.SAVE_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        return doc;
    }

    public Document closeDocument(Id vsId) throws AcmException {
        try {
            Document doc = CEDocumentHandler.fetchDocument(vsId);
            log.debug((Object)("doc.security :" + doc.get_SecurityFolder()));
            Document reservation = null;
            if (doc.get_IsReserved().booleanValue()) {
                log.debug((Object)(doc.get_Name() + " document has been checkout"));
                reservation = (Document)doc.get_Reservation();
                reservation.set_SecurityFolder(doc.get_SecurityFolder());
                ContentElementList docContentList = reservation.get_ContentElements();
                if (docContentList.size() != 0) {
                    this.checkin(reservation);
                } else {
                    reservation = this.cancelCheckout(doc);
                }
                return reservation;
            }
            log.debug((Object)(doc.get_Name() + " document is not checked out"));
            return doc;
        }
        catch (AcmException e) {
            throw e;
        }
        catch (Exception e) {
            log.trace((Object)"unable to close the document");
            Message msg = new Message("B4036E.CLOSE_SOLUTION_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public Document retrieveDocument(Id vsId, String userName, boolean checkOut) throws AcmException {
        Document doc = CEDocumentHandler.fetchDocument(vsId);
        Document reservation = null;
        if (doc != null) {
            if (doc.get_IsReserved().booleanValue()) {
                reservation = (Document)doc.get_Reservation();
                reservation.set_SecurityFolder(doc.get_SecurityFolder());
                log.debug((Object)("reservation object creator is :: " + reservation.get_Creator()));
                String creator = reservation.get_Creator();
                if (creator.equalsIgnoreCase(userName)) {
                    ContentElementList docContentList = reservation.get_ContentElements();
                    if (docContentList.size() != 0) {
                        return reservation;
                    }
                    return doc;
                }
                log.error((Object)("file has been checked out by " + creator + " and hence you cannot edit the file "));
                Message msg = new Message("B4007E.ANOTHER_USER_EDITING_THIS_SOLUTION");
                throw new AcmException(msg);
            }
            if (checkOut) {
                doc.checkout(ReservationType.EXCLUSIVE, null, doc.getClassName(), doc.getProperties());
            }
        } else {
            log.debug((Object)"The document couldn't be fetched as its null");
        }
        return doc;
    }

    public void fileToFolder(Folder solutionFolder, Document doc, PropertyFilter pf) {
        DynamicReferentialContainmentRelationship drcr = (DynamicReferentialContainmentRelationship)solutionFolder.file((IndependentlyPersistableObject)doc, AutoUniqueName.NOT_AUTO_UNIQUE, doc.getProperties().get("DocumentTitle").getStringValue(), DefineSecurityParentage.DEFINE_SECURITY_PARENTAGE);
        drcr.save(RefreshMode.NO_REFRESH, pf);
    }

    public void fileToFolder(Folder solutionFolder, Document doc, String caseSymName, PropertyFilter pf) {
        DynamicReferentialContainmentRelationship drcr = (DynamicReferentialContainmentRelationship)solutionFolder.file((IndependentlyPersistableObject)doc, AutoUniqueName.NOT_AUTO_UNIQUE, caseSymName, DefineSecurityParentage.DEFINE_SECURITY_PARENTAGE);
        drcr.save(RefreshMode.NO_REFRESH, pf);
    }

    public static Document fetchDocument(Id vsId) throws AcmException {
        Document doc = null;
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(null, null, null, "CurrentVersion", null));
        pf.addIncludeProperty(new FilterElement(null, null, null, "SecurityParent", null));
        try {
            VersionSeries verSeries = Factory.VersionSeries.fetchInstance((ObjectStore)m_objStore, (Id)vsId, (PropertyFilter)pf);
            Versionable version = verSeries.get_CurrentVersion();
            doc = (Document)version;
        }
        catch (Exception e) {
            log.error((Object)("Unable to fetch the document with vsid  " + vsId));
            Message msg = new Message("B4042E.FILE_NOT_FOUND", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        return doc;
    }

    public InputStream fetchDocumentContent(Document doc) throws AcmException {
        if (doc == null) {
            Message msg = new Message("B4042E.FILE_NOT_FOUND");
            throw new AcmFileNotFoundException(msg.getFormattedText());
        }
        ContentElementList docContentList = doc.get_ContentElements();
        if (docContentList.size() == 0) {
            log.warn((Object)"The document is empty");
            return null;
        }
        ContentTransfer ct = (ContentTransfer)docContentList.get(0);
        return ct.accessContentStream();
    }

    public void deleteDocument(Id vsId, PropertyFilter pf) throws Exception {
        Document doc = CEDocumentHandler.fetchDocument(vsId);
        VersionSeries verSeries = doc.get_VersionSeries();
        verSeries.delete();
        verSeries.save(RefreshMode.REFRESH, pf);
    }

    public void deleteDocumentsFromFolder(Folder folder, PropertyFilter pf) throws Exception {
        Document doc = null;
        DocumentSet docSet = folder.get_ContainedDocuments();
        Iterator documents = docSet.iterator();
        while (documents.hasNext()) {
            try {
                doc = (Document)documents.next();
                VersionSeries verSeries = doc.get_VersionSeries();
                verSeries.delete();
                verSeries.save(RefreshMode.NO_REFRESH, pf);
            }
            catch (Exception e) {
                log.error((Object)("Unable to delete document " + doc.get_Name()));
                throw e;
            }
        }
    }

    public boolean checkDocExists(Folder solFolder, String title) throws AcmException {
        boolean fileExists = false;
        DocumentSet docSet = solFolder.get_ContainedDocuments();
        Iterator documents = docSet.iterator();
        while (documents.hasNext()) {
            try {
                Document soldoc = (Document)documents.next();
                log.debug((Object)(" Checking for Document Title :" + soldoc.get_Name()));
                if (!soldoc.get_Name().equalsIgnoreCase(title)) continue;
                fileExists = true;
            }
            catch (EngineRuntimeException e) {
                log.error((Object)("Unable to check documents in Solution Folder:" + solFolder.get_Name()));
                Message msg = new Message("B4010E.CONTENT_ENGINE_ERROR", e.getLocalizedMessage());
                throw new AcmException(msg, (Throwable)e);
            }
        }
        return fileExists;
    }

    public int isDocumentCheckedOut(Id vsId, String userName) throws AcmException {
        Document doc = null;
        doc = CEDocumentHandler.fetchDocument(vsId);
        if (doc != null && doc.get_IsReserved().booleanValue()) {
            return 1;
        }
        return 0;
    }

    public String getDocumentContent(Document document) throws AcmFileNotFoundException, AcmException {
        log.trace((Object)">>getDocumentContent");
        int docLen = 0;
        String docString = null;
        if (document == null) {
            Message msg = new Message("B4001E.INVALID_ARGUMENTS_TO_METHOD", "getDocumentContent()");
            throw new AcmFileNotFoundException(msg);
        }
        try {
            ContentElementList contents = document.get_ContentElements();
            for (ContentTransfer ct : contents) {
                docLen = ct.get_ContentSize().intValue();
                InputStream stream = ct.accessContentStream();
                String readStr = null;
                readStr = Utility.readStream(stream, docLen);
                log.debug((Object)("Content:\n " + readStr));
                docString = docString == null ? readStr : docString + readStr;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while retrieving document content ");
            log.error((Object)e.getMessage());
            Message msg = new Message("B4026E.CONTENT_RETRIEVAL_FAILED", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        log.trace((Object)"<<getDocumentContent");
        return docString;
    }

    public static enum EnumDocumentType {
        SDF,
        PECONFIG,
        XPDL,
        GLOBAL_XPDL;

    }
}

