/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.common.type;

import com.ibm.acm.sold.common.type.RoleInbasketsType;
import com.ibm.acm.sold.common.type.TypeState;
import com.ibm.acm.sold.messages.XMLTagger;
import java.util.List;

public class RoleType
extends TypeState {
    protected String name;
    protected String oldName;
    protected String primaryQueue;
    protected String personalInbasketType;
    protected boolean canAssignWork;
    protected boolean viewAssignedWorkInBasket;
    protected boolean canMoveWorkToPersonalInBasket;
    protected String description;
    protected List<RoleInbasketsType> roleInbasketsType;

    public RoleType() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getPrimaryQueue() {
        return this.primaryQueue;
    }

    public void setPrimaryQueue(String primaryQueue) {
        this.primaryQueue = primaryQueue;
    }

    public RoleInbasketsType findInbasket(String name, String queue) {
        if (this.roleInbasketsType != null) {
            for (RoleInbasketsType inbasket : this.roleInbasketsType) {
                if (!inbasket.getName().equals(name) || !inbasket.getQueue().equals(queue)) continue;
                return inbasket;
            }
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RoleType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getPersonalInbasketType() {
        return this.personalInbasketType;
    }

    public void setPersonalInbasketType(String personalInbasketType) {
        this.personalInbasketType = personalInbasketType;
    }

    public boolean isCanAssignWork() {
        return this.canAssignWork;
    }

    public void setCanAssignWork(boolean canAssignWork) {
        this.canAssignWork = canAssignWork;
    }

    public boolean isViewAssignedWorkInBasket() {
        return this.viewAssignedWorkInBasket;
    }

    public void setViewAssignedWorkInBasket(boolean viewAssignedWorkInBasket) {
        this.viewAssignedWorkInBasket = viewAssignedWorkInBasket;
    }

    public boolean isCanMoveWorkToPersonalInBasket() {
        return this.canMoveWorkToPersonalInBasket;
    }

    public void setCanMoveWorkToPersonalInBasket(boolean canMoveWorkToPersonalInBasket) {
        this.canMoveWorkToPersonalInBasket = canMoveWorkToPersonalInBasket;
    }

    public List<RoleInbasketsType> getRoleInbasketsType() {
        return this.roleInbasketsType;
    }

    public void setRoleInbasketsType(List<RoleInbasketsType> roleInbasketsType) {
        this.roleInbasketsType = roleInbasketsType;
    }

    public void toXml(StringBuffer sb, int index) {
        sb.append("<roles><name>" + XMLTagger.escapeXMLValue(this.name) + "</" + "name" + ">");
        if (this.primaryQueue != null) {
            sb.append("<primaryQueue>" + XMLTagger.escapeXMLValue(this.primaryQueue) + "</" + "primaryQueue" + ">");
        }
        if (this.description != null && !this.description.equals("")) {
            sb.append("<description><![CDATA[" + this.description + "]]>" + "</" + "description" + ">");
        }
        sb.append("<index>" + index + "</" + "index" + ">");
        if (this.personalInbasketType != null) {
            sb.append("<personalInbasketType>" + this.personalInbasketType + "</" + "personalInbasketType" + ">");
        }
        if (this.canAssignWork) {
            sb.append("<ECM_canAssignWork>" + this.canAssignWork + "</" + "ECM_canAssignWork" + ">");
        }
        if (this.viewAssignedWorkInBasket) {
            sb.append("<ECM_viewAssignedWorkInBasket>" + this.viewAssignedWorkInBasket + "</" + "ECM_viewAssignedWorkInBasket" + ">");
        }
        if (this.canMoveWorkToPersonalInBasket) {
            sb.append("<ECM_canMoveWorkToPersonalInBasket>" + this.canMoveWorkToPersonalInBasket + "</" + "ECM_canMoveWorkToPersonalInBasket" + ">");
        }
        if (this.roleInbasketsType != null) {
            int size = this.roleInbasketsType.size();
            for (int i = 0; i < size; ++i) {
                this.roleInbasketsType.get(i).toXml(sb);
            }
        }
        sb.append("</roles>");
    }
}

