/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.common.type;

import com.ibm.acm.sold.common.type.Column;
import com.ibm.acm.sold.common.type.Filter;
import com.ibm.acm.sold.common.type.TypeState;
import com.ibm.acm.sold.messages.XMLTagger;
import java.util.List;

public class InbasketType
extends TypeState {
    protected String name;
    protected String oldName;
    protected String description;
    protected String type;
    protected String queue;
    protected List<Column> columns;
    protected List<Filter> filters;
    protected String removePrefix;

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public String getRemovePrefix() {
        return this.removePrefix;
    }

    public void setRemovePrefix(String removePrefix) {
        this.removePrefix = removePrefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public Column findColumn(String columnName) {
        if (this.columns != null) {
            int size = this.columns.size();
            for (int i = 0; i < size; ++i) {
                if (!this.columns.get(i).getName().equals(columnName)) continue;
                return this.columns.get(i);
            }
        }
        return null;
    }

    public Filter findFilter(String filterName) {
        if (this.filters != null) {
            int size = this.filters.size();
            for (int i = 0; i < size; ++i) {
                String uniqueName = this.filters.get(i).getName() + this.filters.get(i).getOperator();
                if (!uniqueName.equals(filterName)) continue;
                return this.filters.get(i);
            }
        }
        return null;
    }

    public void toXml(StringBuffer sb, Integer index) {
        int i;
        int size;
        sb.append("<inbaskets><name>" + XMLTagger.escapeXMLValue(this.name) + "</" + "name" + ">");
        if (this.description != null && !this.description.equals("")) {
            sb.append("<description><![CDATA[" + this.description + "]]>" + "</" + "description" + ">");
        }
        if (index != null) {
            sb.append("<index>" + index + "</" + "index" + ">");
        }
        if (this.type != null) {
            sb.append("<type>" + this.type + "</" + "type" + ">");
        }
        sb.append("<queue>" + XMLTagger.escapeXMLValue(this.queue) + "</" + "queue" + ">");
        if (this.removePrefix != null) {
            sb.append("<ECM_RemovePrefix>" + this.removePrefix + "</" + "ECM_RemovePrefix" + ">");
        }
        if (this.columns != null) {
            size = this.columns.size();
            for (i = 0; i < size; ++i) {
                this.columns.get(i).toXml(sb);
            }
        }
        if (this.filters != null) {
            size = this.filters.size();
            for (i = 0; i < size; ++i) {
                this.filters.get(i).toXml(sb);
            }
        }
        sb.append("</inbaskets>");
    }
}

