/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.common;

import com.ibm.acm.casebuilder.flows.AcmProcessFlowData;
import com.ibm.acm.casebuilder.handlers.Information;
import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.casebuilder.response.AcmListResponse;
import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.CommonDataSingleton;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.LoadAllXpdlArgs;
import com.ibm.acm.sold.connector.Connector;
import com.ibm.acm.sold.converter.AcmProcessActivity;
import com.ibm.acm.sold.converter.AcmProcessSolutionData;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.exception.AcmFileNotFoundException;
import com.ibm.acm.sold.exception.AcmNullValueException;
import com.ibm.acm.sold.info.ReferenceInfo;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import ilog.views.diagrammer.IlvDiagrammer;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Handle {
    private Config config;
    private boolean localFileSystem;
    private static final Log log = LogFactory.getLog((String)Handle.class.getName());

    public boolean getLocalFileSystem() {
        return this.localFileSystem;
    }

    public void setLocalFileSystem(boolean localFileSystem) {
        this.localFileSystem = localFileSystem;
    }

    public CommonDataSingleton getCommonData() {
        return CommonDataSingleton.getInstance();
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String openTemplate(String templateName, SolutionData solData, Locale locale) {
        CBLogger.trace(log, ">>openTemplate");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        String xmlStr = null;
        try {
            xmlStr = conctr.readTemplate(templateName, solData);
            AcmResponse response = new AcmResponse(0, xmlStr);
            xmlStr = response.toJson();
        }
        catch (AcmConnectionFailure e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            xmlStr = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            xmlStr = response.toJson();
        }
        CBLogger.debug(log, "JSON DATA : " + xmlStr);
        CBLogger.trace(log, "<<openTemplate");
        return xmlStr;
    }

    public String save(boolean mode, String jsonStr, SolutionData solData, Locale locale) {
        CBLogger.trace(log, ">>save");
        CBLogger.debug(log, "Incoming json:..." + jsonStr);
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        String result = null;
        try {
            result = conctr.save(mode, jsonStr, solData);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<save");
        return result;
    }

    public String saveAndClose(boolean mode, String jsonStr, SolutionData solData, Locale locale) {
        CBLogger.trace(log, ">>saveAndClose");
        CBLogger.debug(log, "Incoming json:..." + jsonStr);
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        String result = null;
        try {
            result = conctr.saveAndClose(mode, jsonStr, solData);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<saveAndClose");
        return result;
    }

    public String deleteSolution(String jsonStr, Locale locale) {
        CBLogger.trace(log, ">>deleteSolution");
        CBLogger.debug(log, "Incoming solution name to be deleted:..." + jsonStr);
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        String result = null;
        try {
            result = conctr.deleteSolution(jsonStr);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmConnectionFailure e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<deleteSolution");
        return result;
    }

    public String getTemplateNames(Locale locale) {
        String result;
        CBLogger.trace(log, ">>getTemplateNames");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        try {
            Message msg = Config.getErrMsg();
            if (null != msg) {
                throw new AcmException(msg);
            }
            result = conctr.getTemplatelist();
            AcmListResponse response = new AcmListResponse(0, result);
            result = response.toJson();
        }
        catch (AcmFileNotFoundException e) {
            CBLogger.error(log, e.toString(), e);
            AcmListResponse response = new AcmListResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        catch (AcmConnectionFailure e) {
            CBLogger.error(log, e.toString(), e);
            AcmListResponse response = new AcmListResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmListResponse response = new AcmListResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<getTemplateNames");
        return result;
    }

    public String getTemplateNames(String intgType, Locale locale) {
        String result;
        CBLogger.trace(log, ">>getTemplateNames");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        CBLogger.debug(log, "Template FilerType : " + intgType);
        try {
            Message msg = Config.getErrMsg();
            if (null != msg) {
                throw new AcmException(msg);
            }
            result = conctr.getTemplatelist(intgType);
            AcmListResponse response = new AcmListResponse(0, result);
            result = response.toJson();
        }
        catch (AcmFileNotFoundException e) {
            CBLogger.error(log, e.toString(), e);
            AcmListResponse response = new AcmListResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        catch (AcmConnectionFailure e) {
            CBLogger.error(log, e.toString(), e);
            AcmListResponse response = new AcmListResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmListResponse response = new AcmListResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<getTemplateNames");
        return result;
    }

    public String closeSolution(String jsonStr, SolutionData solData, Locale locale) {
        String res = null;
        CBLogger.trace(log, ">>closeSolution");
        CBLogger.debug(log, "Incoming solution name to be closed:..." + jsonStr);
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        try {
            res = conctr.closeSolution(jsonStr, solData);
            AcmResponse response = new AcmResponse(0, res);
            res = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            res = response.toJson();
        }
        CBLogger.trace(log, "<<close solution");
        return res;
    }

    public String reloadSolution(SolutionData solData, String casetypename, Locale locale) {
        CBLogger.trace(log, ">> reloadSolution");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        String result = null;
        try {
            result = conctr.reloadSolution(solData, casetypename);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.debug(log, "JSON DATA : " + result);
        CBLogger.trace(log, "<< reloadSolution");
        return result;
    }

    public String editSolution(String solName, SolutionData solData, Locale locale, boolean forceGet) {
        CBLogger.trace(log, ">>editSolution");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        String result = null;
        try {
            result = this.processContainerTasks(conctr.readSDF(solName, solData, forceGet));
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.debug(log, "JSON DATA : " + result);
        CBLogger.trace(log, "<<EditSolution");
        return result;
    }

    private String processContainerTasks(String sdfData) {
        JSONObject jsobj = new JSONObject();
        JSONObject soljsobj = null;
        JSONObject cstypjsobj = null;
        JSONArray cstypearray = null;
        JSONObject tempObj = null;
        JSONObject tasksobj = null;
        JSONArray taskarray = null;
        JSONObject temptaskObj = null;
        JSONArray containedTasks = null;
        try {
            jsobj = JSONObject.parse((String)sdfData);
            soljsobj = (JSONObject)jsobj.get((Object)"solution");
            cstypjsobj = (JSONObject)soljsobj.get((Object)"caseTypes");
            if (cstypjsobj == null) {
                return sdfData;
            }
            cstypjsobj = (JSONObject)soljsobj.get((Object)"caseTypes");
            if (cstypjsobj.get((Object)"caseType") instanceof JSONArray) {
                cstypearray = (JSONArray)cstypjsobj.get((Object)"caseType");
            } else {
                cstypearray = new JSONArray();
                cstypearray.add(cstypjsobj.get((Object)"caseType"));
            }
            for (int i = 0; i < cstypearray.size(); ++i) {
                tempObj = (JSONObject)cstypearray.get(i);
                tasksobj = (JSONObject)tempObj.get((Object)"tasks");
                if (tasksobj == null || tasksobj.get((Object)"task") == null) continue;
                if (tasksobj.get((Object)"task") instanceof JSONArray) {
                    taskarray = (JSONArray)tasksobj.get((Object)"task");
                } else {
                    taskarray = new JSONArray();
                    taskarray.add(tasksobj.get((Object)"task"));
                }
                for (int j = 0; j < taskarray.size(); ++j) {
                    temptaskObj = (JSONObject)taskarray.get(j);
                    containedTasks = new JSONArray();
                    if ("true".equals(temptaskObj.get((Object)"isContainer"))) {
                        containedTasks = this.getContainedTasks((String)temptaskObj.get((Object)"name"), taskarray);
                    }
                    temptaskObj.put((Object)"containedTasks", (Object)containedTasks);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsobj.toString();
    }

    private JSONArray getContainedTasks(String name, JSONArray arr) {
        JSONArray ctarray = new JSONArray();
        for (int i = 0; i < arr.size(); ++i) {
            if (!name.equals(((JSONObject)arr.get(i)).get((Object)"parentTask"))) continue;
            ctarray.add(((JSONObject)arr.get(i)).get((Object)"name"));
        }
        return ctarray;
    }

    public AcmResponse loadXPDL(String solutionJson, String casetypename, SolutionData solData, Locale locale, JSONArray jsonarray) {
        AcmResponse response = null;
        String result = "Loaded XPDL";
        try {
            AcmProcessSolutionData procSolData = new AcmProcessSolutionData(solData);
            procSolData.setConfig(this.config);
            procSolData.updateSolDataXPDL(solutionJson, casetypename);
            solData.getCasetypedata(casetypename).getNameToWorkClassMap(jsonarray);
            response = new AcmResponse(0, result);
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            response = new AcmResponse(1, e.getMessage(locale), e.getUid());
        }
        return response;
    }

    public String cancelSolution(String jsonStr, Locale locale) {
        String result = null;
        CBLogger.trace(log, ">>cancelSolution");
        CBLogger.debug(log, "Incoming solution name to be canceled:..." + jsonStr);
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        try {
            result = conctr.cancelSolution(jsonStr);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmNullValueException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<cancelsolution");
        return result;
    }

    public String processDeploy(Locale locale, int heartbeat) {
        String result = null;
        CBLogger.trace(log, ">>processDeploy");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        CBLogger.debug(log, "heartbeat period of the session is  " + heartbeat);
        try {
            Message msg = Config.getErrMsg();
            if (null != msg) {
                throw new AcmException(msg);
            }
            result = conctr.processDeploy(heartbeat);
            CBLogger.info(log, "RESULT from deploy :" + result);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        CBLogger.trace(log, "<<processDeploy");
        return result;
    }

    public String processActivity(String jsonStr, SolutionData solData, Locale locale, IlvDiagrammer diagrammer) {
        String result = null;
        try {
            AcmProcessActivity processActData = new AcmProcessActivity(solData);
            processActData.processActivity(jsonStr, solData, diagrammer);
            JSONObject guidData = new JSONObject();
            guidData.put((Object)"caseTypeId", (Object)"-1");
            guidData.put((Object)"taskId", (Object)"-1");
            AcmResponse response = new AcmResponse(0, guidData.toString());
            result = response.toJson();
        }
        catch (AcmException e) {
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        return result;
    }

    public String processFlowEditor(String jsonStr, SolutionData solData, Locale locale) {
        String result = null;
        try {
            AcmProcessFlowData procFlow = new AcmProcessFlowData(solData);
            JSONArray flowJson = procFlow.processFlowData(jsonStr, solData);
            AcmResponse response = new AcmResponse(0, flowJson.toString());
            result = response.toJson();
        }
        catch (AcmException e) {
            AcmResponse response = new AcmResponse(1, e.getMessage(locale), e.getUid());
            result = response.toJson();
        }
        return result;
    }

    public String getInfo() {
        String htmlStr = null;
        Information info = new Information();
        try {
            htmlStr = info.getInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return htmlStr;
    }

    public String getAllXpdl(LoadAllXpdlArgs argObj) {
        String result = null;
        CBLogger.trace(log, ">>getAllXpdl");
        Connector conctr = new Connector();
        conctr.setConfig(this.config);
        try {
            result = conctr.getAllXpdl(argObj);
            AcmResponse response = new AcmResponse(0, result);
            result = response.toJson();
        }
        catch (AcmException e) {
            CBLogger.error(log, e.toString(), e);
            AcmResponse response = new AcmResponse(1, e.getMessage(argObj.getLocale()), e.getUid());
            result = response.toJson();
        }
        CBLogger.debug(log, "JSON DATA : " + result);
        CBLogger.trace(log, "<<getAllXpdl");
        return result;
    }

    public String getBackReference(SolutionData solData) {
        ReferenceInfo ref = new ReferenceInfo(solData);
        String finalRef = null;
        try {
            finalRef = ref.readReferenceInfo();
        }
        catch (DiagrammerException e) {
            e.printStackTrace();
        }
        return finalRef;
    }
}

