/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.comm;

import com.filenet.api.util.Id;
import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SdfData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.type.InbasketsType;
import com.ibm.acm.sold.common.type.RolesType;
import com.ibm.acm.sold.connector.CEManager;
import com.ibm.acm.sold.connector.PEConfig;
import com.ibm.acm.sold.connector.XpdlLoader;
import com.ibm.acm.sold.converter.AcmConverter;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolutionData
implements HttpSessionBindingListener {
    private static final Log log = LogFactory.getLog((String)SolutionData.class.getName());
    private SdfData sdfData;
    private PEConfig peconfigData;
    private Map<String, CaseTypeData> casetypedata = new HashMap<String, CaseTypeData>(10);
    private AcmConverter converterData;
    private RolesType roles;
    private List<String> existingQueues;
    private InbasketsType inbaskets;
    String userName = null;
    private Set<String> stepPagesList = new HashSet<String>(10);
    private Set<String> stepLaunchPagesList = new HashSet<String>(10);
    private Map<String, Object> activityConfigInfo;
    private Map<String, List<VWWorkBasketColumnDefinition>> ColumnFromOutsideInfo;
    private Map<String, String> caseTypeGuids;
    private Map<String, String> taskGuids;
    private Map<String, String> propertyGuids;
    private Map<String, String> docTypeGuids;
    private Map<String, String> choiceListTypeGuids;
    private Thread xpdlThread;
    private XpdlLoader xpdlloader;
    private VWWorkflowCollectionDefinition globalXPDLcollection;

    public InbasketsType getInbaskets() {
        return this.inbaskets;
    }

    public void setInbaskets(InbasketsType inbaskets) {
        this.inbaskets = inbaskets;
    }

    public List<String> getExistingQueues() {
        return this.existingQueues;
    }

    public void setExistingQueues(List<String> existingQueues) {
        this.existingQueues = existingQueues;
    }

    public Thread getXpdlThread() {
        return this.xpdlThread;
    }

    public void setXpdlThread(Thread xpdlThread) {
        this.xpdlThread = xpdlThread;
    }

    public Map<String, List<VWWorkBasketColumnDefinition>> getColumnFromOutsideInfo() {
        return this.ColumnFromOutsideInfo;
    }

    public void setColumnFromOutsideInfo(Map<String, List<VWWorkBasketColumnDefinition>> map) {
        this.ColumnFromOutsideInfo = map;
    }

    public SolutionData() {
        this.setCaseTypeGuids(new HashMap<String, String>(10));
        this.setTaskGuids(new HashMap<String, String>(10));
        this.setPropertyGuids(new HashMap<String, String>(10));
        this.setDocTypeGuids(new HashMap<String, String>(10));
        this.setChoiceListTypeGuids(new HashMap<String, String>(10));
    }

    public SolutionData(HttpSession session) {
        this.setActivityConfigInfo(SolutionData.readConfigInfo(session));
        this.setCaseTypeGuids(new HashMap<String, String>(10));
        this.setTaskGuids(new HashMap<String, String>(10));
        this.setPropertyGuids(new HashMap<String, String>(10));
        this.setDocTypeGuids(new HashMap<String, String>(10));
        this.setChoiceListTypeGuids(new HashMap<String, String>(10));
    }

    public static Map<String, Object> readConfigInfo(HttpSession session) {
        HashMap<String, Object> configInfo = new HashMap<String, Object>(10);
        configInfo.put("SWIMLANE_NAME_UNSUPPORTED", (String)session.getAttribute("SWIMLANE_NAME_UNSUPPORTED"));
        configInfo.put("SWIMLANE_NAME_NO_PARTICPANT", (String)session.getAttribute("SWIMLANE_NAME_NO_PARTICPANT"));
        configInfo.put("LAUNCH_STEP_NAME", (String)session.getAttribute("LAUNCH_STEP_NAME"));
        return configInfo;
    }

    public SdfData getSdfData() {
        return this.sdfData;
    }

    public void setSdfData(SdfData sdfData) {
        this.sdfData = sdfData;
    }

    public CaseTypeData getCasetypedata(String key) {
        return this.casetypedata.get(key);
    }

    public void setCasetypedata(String key, CaseTypeData casetypedata) {
        this.casetypedata.put(key, casetypedata);
    }

    public void deleteCasetypedata(String key, CaseTypeData casetypedata) {
        this.casetypedata.remove(key);
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
    }

    public void setStepLaunchPagesList(Set<String> stepLaunchPagesList) {
        this.stepLaunchPagesList = stepLaunchPagesList;
    }

    public Set<String> getStepLaunchPagesList() {
        return this.stepLaunchPagesList;
    }

    public void setStepPagesList(Set<String> stepPagesList) {
        this.stepPagesList = stepPagesList;
    }

    public Set<String> getStepPagesList() {
        return this.stepPagesList;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setActivityConfigInfo(Map<String, Object> activityConfigInfo) {
        this.activityConfigInfo = activityConfigInfo;
    }

    public Map<String, Object> getActivityConfigInfo() {
        return this.activityConfigInfo;
    }

    public void setCaseTypeGuids(Map<String, String> caseTypeGuids) {
        this.caseTypeGuids = caseTypeGuids;
    }

    public Map<String, String> getCaseTypeGuids() {
        return this.caseTypeGuids;
    }

    public void setTaskGuids(Map<String, String> taskGuids) {
        this.taskGuids = taskGuids;
    }

    public Map<String, String> getTaskGuids() {
        return this.taskGuids;
    }

    public void setPropertyGuids(Map<String, String> propertyGuids) {
        this.propertyGuids = propertyGuids;
    }

    public Map<String, String> getPropertyGuids() {
        return this.propertyGuids;
    }

    public void setDocTypeGuids(Map<String, String> docTypeGuids) {
        this.docTypeGuids = docTypeGuids;
    }

    public Map<String, String> getDocTypeGuids() {
        return this.docTypeGuids;
    }

    public String checkCreateCaseTypeGuid(String name) {
        String guid = null;
        if (this.caseTypeGuids.containsKey(name)) {
            guid = this.caseTypeGuids.get(name);
        } else {
            guid = Id.createId().toString();
            this.caseTypeGuids.put(name, guid);
        }
        return guid;
    }

    public void removeCaseTypeTaskGuids(String casetypename) {
        CaseTypeData ct;
        if (this.caseTypeGuids.containsKey(casetypename)) {
            this.caseTypeGuids.remove(casetypename);
        }
        if ((ct = this.getCasetypedata(casetypename)) != null) {
            for (AcmActivity act : ct.getActivitiesMap().values()) {
                if (!this.taskGuids.containsKey(act.getSymbolicName())) continue;
                this.taskGuids.remove(act.getSymbolicName());
            }
        }
    }

    public String checkCreateTaskGuid(String name) {
        String guid = null;
        if (this.taskGuids.containsKey(name)) {
            guid = this.taskGuids.get(name);
        } else {
            guid = Id.createId().toString();
            this.taskGuids.put(name, guid);
        }
        return guid;
    }

    public void removeTaskGuid(String name) {
        if (this.taskGuids.containsKey(name)) {
            this.taskGuids.remove(name);
        }
    }

    public String checkCreatePropertyGuid(String name) {
        String guid = null;
        if (this.propertyGuids.containsKey(name)) {
            guid = this.propertyGuids.get(name);
        } else {
            guid = Id.createId().toString();
            this.propertyGuids.put(name, guid);
        }
        return guid;
    }

    public void removePropertyGuid(String name) {
        if (this.propertyGuids.containsKey(name)) {
            this.propertyGuids.remove(name);
        }
    }

    public String checkCreateDocTypeGuid(String name) {
        String guid = null;
        if (this.docTypeGuids.containsKey(name)) {
            guid = this.docTypeGuids.get(name);
        } else {
            guid = Id.createId().toString();
            this.docTypeGuids.put(name, guid);
        }
        return guid;
    }

    public void removeDocTypeGuid(String name) {
        if (this.docTypeGuids.containsKey(name)) {
            this.docTypeGuids.remove(name);
        }
    }

    public Map<String, String> getChoiceListTypeGuids() {
        return this.choiceListTypeGuids;
    }

    public void setChoiceListTypeGuids(Map<String, String> choiceListTypeGuids) {
        this.choiceListTypeGuids = choiceListTypeGuids;
    }

    public String checkCreateChoiceListTypeGuid(String name) {
        log.trace((Object)">> checkCreateChoiceListTypeGuid");
        String guid = null;
        if (this.choiceListTypeGuids.containsKey(name)) {
            guid = this.choiceListTypeGuids.get(name);
            CBLogger.debug(log, "GUID already exists for this symbol : " + name + ": GUID = " + guid);
        } else {
            guid = Id.createId().toString();
            this.choiceListTypeGuids.put(name, guid);
            CBLogger.debug(log, "GUID created for this symbol : " + name + ": GUID = " + guid);
        }
        log.trace((Object)"<< checkCreateChoiceListTypeGuid");
        return guid;
    }

    public String checkChoiceListTypeGuid(String name) {
        log.trace((Object)">> checkCreateChoiceListTypeGuid");
        String guid = null;
        if (this.choiceListTypeGuids.containsKey(name)) {
            guid = this.choiceListTypeGuids.get(name);
            CBLogger.debug(log, "GUID already exists for this symbol : " + name + ": GUID = " + guid);
        }
        log.trace((Object)"<< checkCreateChoiceListTypeGuid");
        return guid;
    }

    public void removeChoiceListTypeGuid(String name) {
        if (this.choiceListTypeGuids.containsKey(name)) {
            this.choiceListTypeGuids.remove(name);
        }
    }

    public void setXpdlloader(XpdlLoader xpdlloader) {
        this.xpdlloader = xpdlloader;
    }

    public XpdlLoader getXpdlloader() {
        return this.xpdlloader;
    }

    public void setGlobalXPDLcollection(VWWorkflowCollectionDefinition globalXPDLcollection) {
        this.globalXPDLcollection = globalXPDLcollection;
    }

    public VWWorkflowCollectionDefinition getGlobalXPDLcollection() {
        return this.globalXPDLcollection;
    }

    public void initGlobalXPDLCollection(Config config) throws AcmException {
        log.trace((Object)">> initGlobalXPDLCollection");
        CEManager cemgr = new CEManager(this, config);
        cemgr.openSession();
        InputStream xpdlStream = cemgr.retrieveGlobalXPDL();
        cemgr.closeSession();
        try {
            this.globalXPDLcollection = VWWorkflowCollectionDefinition.read((InputStream)xpdlStream);
        }
        catch (VWException e) {
            e.printStackTrace();
            log.error((Object)e);
            Message msg = new Message("B4066E.VW_EXCEPTION", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
        CBLogger.debug(log, "globalXPDLcollection initialized in SolutionData ");
        log.trace((Object)"<< initGlobalXPDLCollection");
    }

    public void setPeconfigData(PEConfig peconfigData) {
        this.peconfigData = peconfigData;
    }

    public PEConfig getPeconfigData() {
        return this.peconfigData;
    }

    public void setConverterData(AcmConverter converterData) {
        this.converterData = converterData;
    }

    public AcmConverter getConverterData() {
        return this.converterData;
    }

    public void setRoles(RolesType roles) {
        this.roles = roles;
    }

    public RolesType getRoles() {
        return this.roles;
    }
}

