/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.comm;

import com.filenet.api.core.Document;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.util.Id;
import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.connector.CEDocumentHandler;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.ContentType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalXpdlData {
    String symName;
    String id;
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.comm.GlobalXpdlData");
    private ObjectStore objectstore;
    private String userName;
    private SolutionType solType;
    VWWorkflowCollectionDefinition wrkflwcoln = null;

    public String getSymName() {
        return this.symName;
    }

    public void read() throws AcmException {
        InputStream stream = null;
        stream = this.retrieveXPDLdoc();
        CBLogger.debug(log, " Retrieving global xpdl doc is done ");
        this.initVWCollection(stream);
        CBLogger.debug(log, "reading completed");
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)e, (Throwable)e);
        }
    }

    public void initVWCollection(InputStream stream) throws AcmException {
        try {
            this.wrkflwcoln = VWWorkflowCollectionDefinition.read((InputStream)stream);
            CBLogger.debug(log, "work flow collection Initialization success");
            this.printWorkFlowNames();
        }
        catch (VWException e) {
            e.printStackTrace();
            log.error((Object)e);
            Message msg = new Message("B4066E.VW_EXCEPTION", e.getLocalizedMessage());
            throw new AcmException(msg);
        }
    }

    public void setSymName(String symName) {
        this.symName = symName;
    }

    public InputStream retrieveXPDLdoc() throws AcmException {
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        InputStream input = null;
        Id vsId = null;
        ContentType ct = this.solType.getGlobalProcessCollection();
        if (ct != null) {
            vsId = new Id(ct.getContentId());
            CBLogger.debug(log, "VSID of global xpdl is :" + vsId);
        }
        if (vsId == null) {
            CBLogger.debug(log, "VSID of global xpdl is NULL");
            return null;
        }
        try {
            Document xpdlDoc = docHandler.retrieveDocument(vsId, this.userName, true);
            input = docHandler.fetchDocumentContent(xpdlDoc);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t, t);
            Message msg = new Message("B4029E.XPDL_NOT_AVAILABLE", t.getLocalizedMessage());
            throw new AcmException(msg);
        }
        return input;
    }

    public ObjectStore getObjectstore() {
        return this.objectstore;
    }

    public void setObjectstore(ObjectStore objectstore) {
        this.objectstore = objectstore;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMainWorkFlowBaseClass() {
        String name = null;
        if (this.wrkflwcoln != null) {
            name = this.wrkflwcoln.getMainWorkflow().getBaseWorkClassName();
        }
        CBLogger.debug(log, " Main Base workflow class name : " + name);
        return name;
    }

    public String getBaseWorkFlowClassName(String wrkflwname) throws Exception {
        String name = null;
        if (this.wrkflwcoln != null) {
            VWWorkflowDefinition lwrkflow = this.wrkflwcoln.getWorkflow(wrkflwname);
            if (lwrkflow != null) {
                name = lwrkflow.getBaseWorkClassName();
                CBLogger.debug(log, "Setting the name of the workflow :" + name);
            } else {
                CBLogger.debug(log, "Work flow doesn't exists, DEBUG");
            }
        }
        CBLogger.debug(log, " Base workflow class name : " + name);
        return name;
    }

    public String getWorkFlowName(String wrkflwname) throws Exception {
        String name = null;
        if (this.wrkflwcoln != null) {
            VWWorkflowDefinition lwrkflow = this.wrkflwcoln.getWorkflow(wrkflwname);
            if (lwrkflow != null) {
                name = lwrkflow.getName();
                CBLogger.debug(log, "Setting the name of the workflow :" + name);
            } else {
                CBLogger.debug(log, "Work flow doesn't exists, DEBUG");
            }
        }
        CBLogger.debug(log, " Workflow name is : " + name);
        return name;
    }

    public VWWorkflowDefinition getWorkFlow(String wrkflwname) {
        VWWorkflowDefinition lwrkflow = null;
        if (this.wrkflwcoln != null) {
            try {
                lwrkflow = this.wrkflwcoln.getWorkflow(wrkflwname);
            }
            catch (VWException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return lwrkflow;
    }

    public void setSolType(SolutionType solType) {
        this.solType = solType;
    }

    public SolutionType getSolType() {
        return this.solType;
    }

    public Id getGlobalXpdlVSID() {
        Id vsId = null;
        ContentType ct = this.solType.getGlobalProcessCollection();
        if (ct != null) {
            vsId = new Id(ct.getContentId());
            CBLogger.debug(log, "VSID of global xpdl is :" + vsId);
        }
        if (vsId == null) {
            CBLogger.debug(log, "VSID of global xpdl is NULL");
            return null;
        }
        return vsId;
    }

    private void closeGlobalXpdl(Id id) {
        CEDocumentHandler docHandler = new CEDocumentHandler(this.objectstore);
        CBLogger.debug(log, "Closing the Global XPDL " + id);
        try {
            docHandler.closeDocument(id);
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        Id id = this.getGlobalXpdlVSID();
        if (id != null) {
            this.closeGlobalXpdl(id);
        }
    }

    public void printWorkFlowNames() throws VWException {
        VWWorkflowDefinition[] listwrkflw = this.wrkflwcoln.getWorkflows();
        CBLogger.debug(log, "Available work flows ");
        CBLogger.debug(log, "----------------------------");
        if (listwrkflw != null) {
            for (int i = 0; i < listwrkflw.length; ++i) {
                CBLogger.debug(log, listwrkflw[i].getName());
            }
        }
        CBLogger.debug(log, "----------------------------");
    }
}

