/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.comm;

import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.SolutionData;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CommonDataSingleton {
    private static volatile CommonDataSingleton me = null;
    private static volatile Map<String, SolutionData> solutiondata = null;
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.comm.CommonDataSingleton");

    private CommonDataSingleton() {
    }

    public static CommonDataSingleton getInstance() {
        if (me == null) {
            me = new CommonDataSingleton();
        }
        if (solutiondata == null) {
            solutiondata = Collections.synchronizedMap(new WeakHashMap(10));
        }
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, SolutionData object) {
        log.trace((Object)"> put");
        Map<String, SolutionData> map = solutiondata;
        synchronized (map) {
            solutiondata.put(key, object);
        }
        log.trace((Object)"< put");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolutionData get(String key) {
        log.trace((Object)"> get");
        if (!solutiondata.isEmpty()) {
            if (solutiondata.containsKey(key)) {
                Map<String, SolutionData> map = solutiondata;
                synchronized (map) {
                    return solutiondata.get(key);
                }
            }
            CBLogger.debug(log, "key not found");
        } else {
            CBLogger.debug(log, "data is empty");
        }
        return null;
    }
}

