/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.comm;

import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmStepProcessorListWrapper;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CaseTypeData {
    String symName;
    String id;
    private String displayName;
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.comm.CaseTypeData");
    private Map<String, AcmActivity> activitiesMap;
    private Map<String, AcmWorkGroupDefinition> workgroupsMap;
    private Map<String, AcmActivityAttachment> attachmentsMap;
    private Set<VWWorkflowDefinition> wfWithNoActivity;
    private Set<AcmWorkGroupDefinition> workgroupsSet;
    private AcmCaseShareInfo sharedInfo;

    public CaseTypeData() {
        this.activitiesMap = new HashMap<String, AcmActivity>(10);
        this.workgroupsMap = new HashMap<String, AcmWorkGroupDefinition>(10);
        this.attachmentsMap = new HashMap<String, AcmActivityAttachment>(10);
        this.wfWithNoActivity = new HashSet<VWWorkflowDefinition>();
        this.setSharedInfo(new AcmCaseShareInfo());
    }

    public CaseTypeData(String name, String id, SolutionData solData) {
        this.setSymName(name);
        this.activitiesMap = new HashMap<String, AcmActivity>(10);
        this.workgroupsMap = new HashMap<String, AcmWorkGroupDefinition>(10);
        this.attachmentsMap = new HashMap<String, AcmActivityAttachment>(10);
        this.setSharedInfo(new AcmCaseShareInfo());
        if (id.equalsIgnoreCase("-1") && name != null) {
            String guid = solData.checkCreateCaseTypeGuid(name);
            this.setId(guid);
        } else {
            this.setId(id);
        }
    }

    public void addActivity(AcmActivity activity) {
        if (this.activitiesMap.containsKey(activity.getSymbolicName())) {
            this.activitiesMap.remove(activity.getSymbolicName());
            CBLogger.debug(log, "Removed the activity : " + activity.getSymbolicName());
        }
        if (!activity.getSdfData().isContainer()) {
            this.activitiesMap.put(activity.getSymbolicName(), activity);
            CBLogger.debug(log, "Added the activity : " + activity.getSymbolicName());
        }
    }

    public void addAttachment(AcmActivityAttachment attach) {
        if (this.attachmentsMap.containsKey(attach.getName())) {
            this.attachmentsMap.remove(attach.getName());
        }
        this.attachmentsMap.put(attach.getName(), attach);
    }

    public void addWorkGroup(AcmWorkGroupDefinition workgroup) {
        if (this.workgroupsMap.containsKey(workgroup.getName())) {
            this.workgroupsMap.remove(workgroup.getName());
        }
        this.workgroupsMap.put(workgroup.getName(), workgroup);
    }

    public AcmStepProcessorListWrapper fetchStepProcessorPagesUsed() {
        AcmStepProcessorListWrapper list = new AcmStepProcessorListWrapper();
        if (this.activitiesMap != null) {
            for (AcmActivity temp : this.activitiesMap.values()) {
                if (temp.getPagesUsed() != null) {
                    list.addPages(temp.getPagesUsed());
                }
                if (temp.getLaunchStepPagesUsed() == null) continue;
                list.addLaunchStepPages(temp.getLaunchStepPagesUsed());
            }
        }
        if (this.wfWithNoActivity != null) {
            for (VWWorkflowDefinition wfDef : this.wfWithNoActivity) {
                list.addPages(AcmActivityEditorUtil.getPagesUsedInWorkflow(wfDef));
                list.addLaunchStepPages(AcmActivityEditorUtil.getLaunchStepPage(wfDef));
            }
        }
        return list;
    }

    public Map<String, AcmActivity> getActivitiesMap() {
        return this.activitiesMap;
    }

    public Set<VWWorkflowDefinition> getWorkflowsWithNoActivity() {
        return this.wfWithNoActivity;
    }

    public AcmActivity getActivityByName(String activityName) {
        return this.activitiesMap.get(activityName);
    }

    public AcmActivityAttachment getAttachmentByName(String attachName) {
        return this.attachmentsMap.get(attachName);
    }

    public String getSymName() {
        return this.symName;
    }

    public AcmWorkGroupDefinition getWorkGroupByName(String workgroupName) {
        return this.workgroupsMap.get(workgroupName);
    }

    public Set<AcmWorkGroupDefinition> getWorkgroupsSet() {
        return this.workgroupsSet;
    }

    public void readXpdl(InputStream stream, boolean checkOut) throws DiagrammerException {
        try {
            VWWorkflowCollectionDefinition coll = VWWorkflowCollectionDefinition.read((InputStream)stream);
            this.activitiesMap = AcmActivityEditorUtil.createAcmActivitiesFromVWCollection(this.activitiesMap, coll, this.sharedInfo, checkOut);
            this.wfWithNoActivity = AcmActivityEditorUtil.getWorkflowsWithNoActivities(this.activitiesMap, coll);
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
    }

    public void removeActivity(String activityName) {
        if (this.activitiesMap.containsKey(activityName)) {
            this.activitiesMap.remove(activityName);
        }
    }

    public void setSymName(String symName) {
        this.symName = symName;
    }

    public void setWorkgroupsSet(Set<AcmWorkGroupDefinition> workgroupsSet) {
        this.workgroupsSet = workgroupsSet;
    }

    public void toXPDLStream(OutputStream outStream) throws DiagrammerException {
        VWWorkflowCollectionDefinition workflowCollection = AcmActivityEditorUtil.createVWCollectionFromActivites(this.activitiesMap, this.wfWithNoActivity);
        try {
            workflowCollection.write(outStream);
        }
        catch (VWException e) {
            e.printStackTrace();
            log.error((Object)e, (Throwable)e);
            throw new DiagrammerException(e.getMessage());
        }
    }

    public void toXPDLStream(OutputStream outStream, String applicationSpaceName) throws DiagrammerException {
        VWWorkflowCollectionDefinition workflowCollection = AcmActivityEditorUtil.createVWCollectionFromActivites(this.activitiesMap, this.wfWithNoActivity);
        try {
            workflowCollection.setApplicationSpaceName(applicationSpaceName);
            log.info((Object)("Setting Application Name : " + applicationSpaceName));
            workflowCollection.write(outStream);
        }
        catch (VWException e) {
            e.printStackTrace();
            log.error((Object)e, (Throwable)e);
            throw new DiagrammerException(e.getMessage());
        }
    }

    public String toXPDLString() throws DiagrammerException {
        VWWorkflowCollectionDefinition workflowCollection = AcmActivityEditorUtil.createVWCollectionFromActivites(this.activitiesMap, this.wfWithNoActivity);
        String xpdl = null;
        try {
            xpdl = workflowCollection.asXPDLString();
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        return xpdl;
    }

    public void updateActivity(AcmActivity activity) throws DiagrammerException {
        AcmActivity oldObject = this.getActivityByName(activity.getSymbolicName());
        if (oldObject == null) {
            throw new DiagrammerException("Object to be updated not found");
        }
        this.activitiesMap.remove(activity.getSymbolicName());
        this.activitiesMap.put(activity.getSymbolicName(), activity);
    }

    public HashMap<String, VWValidationError[]> validateCaseActivities(VWSystemConfiguration config, String sdfFile, VWWorkflowCollectionDefinition gblColl) throws DiagrammerException {
        return AcmActivityEditorUtil.validateActivites(this.sharedInfo, this.activitiesMap, config, sdfFile, this.wfWithNoActivity, gblColl);
    }

    public void setSharedInfo(AcmCaseShareInfo sharedInfo) {
        this.sharedInfo = sharedInfo;
    }

    public AcmCaseShareInfo getSharedInfo() {
        return this.sharedInfo;
    }

    public void resetSharedInfo() {
        this.sharedInfo = new AcmCaseShareInfo();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void getNameToWorkClassMap(JSONArray jsonArray) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        JSONObject jsonObj1 = null;
        jsonArray.clear();
        if (this.activitiesMap.size() > 0) {
            CBLogger.debug(log, "Acitivty Map exists");
            for (Map.Entry<String, AcmActivity> entry : this.activitiesMap.entrySet()) {
                AcmActivity activity = entry.getValue();
                jsonObj1 = new JSONObject();
                jsonMap.clear();
                if (activity.getSdfData() != null) {
                    if (activity.getSdfData().getWorkflowType() != null) {
                        if (!activity.getSdfData().getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) {
                            CBLogger.debug(log, "Normal workflow");
                            jsonMap.put("taskName", activity.getSymbolicName());
                            jsonMap.put("processName", activity.getBaseWorkClassName());
                        }
                    } else {
                        CBLogger.debug(log, "Workflow type is missing");
                        jsonMap.put("taskName", activity.getSymbolicName());
                        jsonMap.put("processName", activity.getBaseWorkClassName());
                    }
                } else {
                    CBLogger.debug(log, "sdf data is missing");
                    jsonMap.put("taskName", activity.getSymbolicName());
                    jsonMap.put("processName", activity.getBaseWorkClassName());
                }
                jsonObj1.putAll(jsonMap);
                CBLogger.debug(log, "Added : " + jsonObj1.toString());
                jsonArray.add((Object)jsonObj1);
            }
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean reuseBPMtasksExists() {
        boolean flag = false;
        for (AcmActivity act : this.activitiesMap.values()) {
            if (!act.isTaskForReuseWorkflow()) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

