/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.logger;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.java.CommonBaseEventFilter;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;
import org.eclipse.hyades.logging.java.XmlFormatter;

public class CaseMgmtCBELogger {
    private static final String SYSTEM_PROPERTY_FILE_HANDLER_PATTERN = "ICMCBELogFilePattern";
    private static final String LOGGER_NAME = "com.ibm.casemgmt.cbe";
    private static Logger theLogger;
    private static String processId;
    private static String PROCESS_ID_UNKNOWN;
    private static final String APPLICATION_NAME = "IBM Case Manager";
    private static final String PRODUCT_CODE = "FNRP";
    private static final String LOGGER_FILEHANDLER_PATTERN = "%h/icm_casebuildercbe%u.log";
    private static final String EVENT_FACTORY_HOME_TYPE = "org.eclipse.hyades.logging.events.cbe.impl.EventXMLFileEventFactoryHomeImpl";
    private static final String ICM_EVENT_FACTORY_NAME = "com.ibm.casemgmt.cbe";
    private static final String ICM_CBE_EXECUTION_ENV = "Java";
    private static final String ICM_CBE_COMPONENT_TYPE = "J2EE Application";
    private static final String ICM_CBE_SUB_COMPONENT_DEFAULT = "main";
    private static final String ICM_CBE_REASONING_SCOPE_INTERNAL = "Internal";
    private static final String ICM_CBE_OTHER_SITUATION_ANY = "";
    private static final String ICM_CBE_MESSAGE_CATALOG_GENERAL = "ICMMsgCatalog";
    private static final String ICM_CBE_MESSAGE_CATALOG_GENERAL_TYPE = "Java";
    private static final String ICM_CBE_EXT_MSG_NAME = "Throwable";
    private static EventFactory eventFactory;
    private static String localHostIP;
    private static String localeStr;
    private static AtomicLong cbeCount;

    private static void initLoggers() throws IOException {
        String pattern = System.getProperty(SYSTEM_PROPERTY_FILE_HANDLER_PATTERN);
        theLogger = Logger.getLogger("com.ibm.casemgmt.cbe");
        Handler fileHandler = null;
        if (pattern != null && pattern.length() > 0) {
            try {
                fileHandler = new FileHandler(pattern, true);
            }
            catch (Throwable t) {
                fileHandler = null;
            }
        }
        if (fileHandler == null) {
            fileHandler = new FileHandler(LOGGER_FILEHANDLER_PATTERN, true);
        }
        fileHandler.setFormatter((Formatter)new XmlFormatter());
        fileHandler.setFilter((Filter)new CommonBaseEventFilter());
        theLogger.addHandler(fileHandler);
    }

    private static boolean isCBELoggingEnabled() {
        return eventFactory != null;
    }

    private static CommonBaseEvent createCommonBaseEvent(String componentName) {
        CommonBaseEvent event = eventFactory.createCommonBaseEvent();
        event.setCreationTimeAsLong(System.currentTimeMillis());
        event.setGlobalInstanceId(Guid.generate());
        event.setSequenceNumber(cbeCount.getAndIncrement());
        ComponentIdentification sourceComponentId = eventFactory.createComponentIdentification();
        sourceComponentId.setLocation(localHostIP);
        sourceComponentId.setLocationType("IPV4");
        sourceComponentId.setExecutionEnvironment("Java");
        sourceComponentId.setApplication(APPLICATION_NAME);
        sourceComponentId.setComponent(componentName);
        sourceComponentId.setSubComponent(ICM_CBE_SUB_COMPONENT_DEFAULT);
        sourceComponentId.setComponentIdType("Application");
        sourceComponentId.setComponentType(ICM_CBE_COMPONENT_TYPE);
        sourceComponentId.setProcessId(processId);
        sourceComponentId.setThreadId(new Long(Thread.currentThread().getId()).toString());
        event.setSourceComponentId(sourceComponentId);
        return event;
    }

    private static void updateEventGeneral(CommonBaseEvent event, Class callingClass, String key) {
        OtherSituation otherSituation = eventFactory.createOtherSituation();
        otherSituation.setAny(ICM_CBE_OTHER_SITUATION_ANY);
        otherSituation.setReasoningScope(ICM_CBE_REASONING_SCOPE_INTERNAL);
        Situation situation = eventFactory.createSituation();
        situation.setCategoryName("OtherSituation");
        situation.setSituationType((SituationType)otherSituation);
        event.setSituation(situation);
        if (key != null) {
            MsgDataElement msgDataElement = eventFactory.createMsgDataElement();
            msgDataElement.setMsgId(key);
            msgDataElement.setMsgIdType(PRODUCT_CODE);
            if (callingClass != null) {
                msgDataElement.setMsgCatalog(callingClass.getName());
            } else {
                msgDataElement.setMsgCatalog(ICM_CBE_MESSAGE_CATALOG_GENERAL);
            }
            msgDataElement.setMsgCatalogType("Java");
            msgDataElement.setMsgLocale(localeStr);
            event.setMsgDataElement(msgDataElement);
        }
    }

    private static ExtendedDataElement createExtendDateElementFromThrowable(Throwable t) {
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(ICM_CBE_EXT_MSG_NAME);
        extendedDataElement.setType("stringArray");
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        if (stackTraceElements.length > 0) {
            String[] values = new String[stackTraceElements.length + 1];
            values[0] = t.toString();
            for (int counter = 0; counter < stackTraceElements.length; ++counter) {
                values[counter + 1] = stackTraceElements[counter].toString();
            }
            extendedDataElement.setValues(values);
        } else {
            extendedDataElement.setValues(new String[]{t.toString()});
        }
        return extendedDataElement;
    }

    private static void logEvent(Log theLog, String message, String msgId, short severity) {
        if (CaseMgmtCBELogger.isCBELoggingEnabled()) {
            String componentName = theLog instanceof Jdk14Logger ? ((Jdk14Logger)theLog).getLogger().getName() : "com.ibm.casemgmt.cbe";
            CommonBaseEvent event = CaseMgmtCBELogger.createCommonBaseEvent(componentName);
            CaseMgmtCBELogger.updateEventGeneral(event, null, msgId);
            event.setSeverity(severity);
            event.setMsg(message);
            CommonBaseEventLogRecord commonBaseEventLogRecord = new CommonBaseEventLogRecord(event);
            commonBaseEventLogRecord.setLoggerName("com.ibm.casemgmt.cbe");
            theLogger.log((LogRecord)commonBaseEventLogRecord);
        }
    }

    private static void logEvent(Log theLog, String message, String msgId, short severity, Throwable t) {
        if (CaseMgmtCBELogger.isCBELoggingEnabled()) {
            String componentName = theLog instanceof Jdk14Logger ? ((Jdk14Logger)theLog).getLogger().getName() : "com.ibm.casemgmt.cbe";
            CommonBaseEvent event = CaseMgmtCBELogger.createCommonBaseEvent(componentName);
            CaseMgmtCBELogger.updateEventGeneral(event, null, msgId);
            event.addExtendedDataElement(CaseMgmtCBELogger.createExtendDateElementFromThrowable(t));
            event.setSeverity(severity);
            event.setMsg(message);
            CommonBaseEventLogRecord commonBaseEventLogRecord = new CommonBaseEventLogRecord(event);
            commonBaseEventLogRecord.setLoggerName("com.ibm.casemgmt.cbe");
            theLogger.log((LogRecord)commonBaseEventLogRecord);
        }
    }

    public static void info(Log theLog, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)10);
    }

    public static void info(Log theLog, String msgId, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)10);
    }

    public static void warn(Log theLog, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)30);
    }

    public static void warn(Log theLog, String message, Throwable t) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)30, t);
    }

    public static void warn(Log theLog, String msgId, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)30);
    }

    public static void warn(Log theLog, String msgId, String message, Throwable t) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)30, t);
    }

    public static void error(Log theLog, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)50);
    }

    public static void error(Log theLog, String message, Throwable t) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)50, t);
    }

    public static void error(Log theLog, String msgId, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)50);
    }

    public static void error(Log theLog, String msgId, String message, Throwable t) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)50, t);
    }

    public static void trace(Log theLog, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)20);
    }

    public static void trace(Log theLog, String message, Throwable t) {
        CaseMgmtCBELogger.logEvent(theLog, message, null, (short)20, t);
    }

    public static void trace(Log theLog, String msgId, String message) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)20);
    }

    public static void trace(Log theLog, String msgId, String message, Throwable t) {
        CaseMgmtCBELogger.logEvent(theLog, message, msgId, (short)20, t);
    }

    static {
        processId = null;
        PROCESS_ID_UNKNOWN = "Unknown";
        eventFactory = null;
        localHostIP = ICM_CBE_OTHER_SITUATION_ANY;
        localeStr = null;
        cbeCount = new AtomicLong(0L);
        try {
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException u) {
            localHostIP = "127.0.0.1";
        }
        try {
            processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            if (processId == null && processId.length() == 0) {
                throw new RuntimeException();
            }
        }
        catch (Throwable t) {
            processId = PROCESS_ID_UNKNOWN;
        }
        try {
            EventFactoryContext eventFactoryContext = EventFactoryContext.getInstance();
            eventFactoryContext.setEventFactoryHomeType(EVENT_FACTORY_HOME_TYPE);
            EventFactoryHome eventFactoryHome = eventFactoryContext.getEventFactoryHome();
            eventFactory = eventFactoryHome.getEventFactory("com.ibm.casemgmt.cbe");
            eventFactory.setCompleteEvent(true);
            CaseMgmtCBELogger.initLoggers();
            localeStr = Locale.getDefault().getLanguage().concat("-").concat(Locale.getDefault().getCountry());
        }
        catch (Throwable t) {
            eventFactory = null;
        }
    }
}

