/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.handlers;

import com.filenet.api.util.Id;
import com.ibm.acm.sold.comm.SolutionData;
import filenet.vw.api.VWClassFactory;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Information {
    private static final Log log = LogFactory.getLog((String)Information.class.getName());
    private static final String PE_VERSION_FILE = "pe-ver.properties";
    private static final String CMIS_VERSION_FILE = "build.properties";
    private static final String PE_BUILDLINE = "buildLine";
    private static final String CMIS_BUILD_NUMBER = "build.number";
    private static final String JAVA_VM_VENDOR = "java.vm.vendor";
    private static final String JAVA_VM_NAME = "java.vm.name";
    private static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    private static final String JAVA_RUNTIME_NAME = "java.runtime.name";
    private static final String JAVA_VM_VERSION = "java.vm.version";
    private static final String JAVA_VM_INFO = "java.vm.info";
    private static final String JAVA_FULLVERSION = "java.fullversion";
    private static final String USER_DIR = "user.dir";
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final String JAVA_CLASS_PATH = "java.class.path";

    public String getInfo() throws Exception {
        log.trace((Object)">>getInfo");
        StringBuffer htmlOutput = new StringBuffer();
        Date dt = Calendar.getInstance().getTime();
        String dateStr = dt.toString();
        String CEbuildVersion = this.getInfo(Id.class);
        String PEbuildVersion = this.getInfo(VWClassFactory.class);
        String cbVersion = this.getInfo(SolutionData.class);
        htmlOutput.append("<html><head><title>IBM Case Manager</title>");
        htmlOutput.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        htmlOutput.append("<meta name='Copyright' content='\u00a9 Copyright IBM Corp. 2010.  All Rights Reserved.'>");
        htmlOutput.append("</head><body style='font-family:Tahoma;' bgcolor='white'>");
        htmlOutput.append("<table style='font-size:12px;' border='1'>");
        htmlOutput.append("<tr><th>Key</th><th>Value</th></tr>");
        htmlOutput.append("<tr bgcolor='#f0f0f0'><td width='12%'>Product name</td> <td width='88%'><B>IBM Case Manager - 5.1.0</B>&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='#f0f0f0'><td>Operating System</td><td>" + this.getOSInfo() + "&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='white'><td>JVM</td><td>" + this.genHtmlJVMInfo() + "</td></tr>");
        htmlOutput.append("<tr bgcolor='#f0f0f0'><td>Date</td><td>" + dateStr + "&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='white'><td>Classpath</td><td  style='font-size:12px;' >" + this.getClassPath() + "&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='#f0f0f0'><td>Case Builder Build</td><td>" + cbVersion + "&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='#f0f0f0'><td>CE Client Build</td><td>" + CEbuildVersion + "&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='white'><td>PE Client Build</td><td>" + PEbuildVersion + "&nbsp;</td></tr>");
        htmlOutput.append("<tr bgcolor='#f0f0f0'><td>Working Directory</td><td>" + this.getWorkDir() + "&nbsp;</td></tr>");
        htmlOutput.append("</table>");
        htmlOutput.append("<div style='font-size:12px;'>");
        htmlOutput.append("<br>Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2010 - All Rights reserved.");
        htmlOutput.append("</div>");
        htmlOutput.append("</body>");
        htmlOutput.append("</html>");
        log.trace((Object)"<<getInfo");
        return htmlOutput.toString();
    }

    private String getWorkDir() {
        return System.getProperty(USER_DIR);
    }

    private String getClassPath() {
        return System.getProperty(JAVA_CLASS_PATH);
    }

    private String getOSInfo() {
        Properties sProp = System.getProperties();
        String osVersion = sProp.getProperty(OS_VERSION);
        String osName = sProp.getProperty(OS_NAME);
        return osName + " " + osVersion;
    }

    private String genHtmlJVMInfo() {
        StringBuffer htmlOutput = new StringBuffer();
        Properties sProp = System.getProperties();
        htmlOutput.append("<table style='font-size:12px;'>");
        String jvmVendor = sProp.getProperty(JAVA_VM_VENDOR);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_VM_VENDOR);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jvmVendor);
        htmlOutput.append("</td></tr>");
        String jvmName = sProp.getProperty(JAVA_VM_NAME);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_VM_NAME);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jvmName);
        htmlOutput.append("</td></tr>");
        String jVersion = sProp.getProperty(JAVA_RUNTIME_VERSION);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_RUNTIME_VERSION);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jVersion);
        htmlOutput.append("</td></tr>");
        String jruntimeName = sProp.getProperty(JAVA_RUNTIME_NAME);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_RUNTIME_NAME);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jruntimeName);
        htmlOutput.append("</td></tr>");
        String jvmVersion = sProp.getProperty(JAVA_VM_VERSION);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_VM_VERSION);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jvmVersion);
        htmlOutput.append("</td></tr>");
        String jvmInfo = sProp.getProperty(JAVA_VM_INFO);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_VM_INFO);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jvmInfo);
        htmlOutput.append("</td></tr>");
        String jFullVersion = sProp.getProperty(JAVA_FULLVERSION);
        htmlOutput.append("<tr><td>");
        htmlOutput.append(JAVA_FULLVERSION);
        htmlOutput.append("</td><td>");
        htmlOutput.append(jFullVersion);
        htmlOutput.append("</td></tr>");
        htmlOutput.append("</table>");
        return htmlOutput.toString();
    }

    private String getInfo(Class jarClass) {
        String buildInfo = "";
        try {
            String fpath = jarClass.getProtectionDomain().getCodeSource().getLocation().getFile();
            log.info((Object)("jar path : " + fpath));
            JarFile jf = new JarFile(fpath);
            Manifest mf = jf.getManifest();
            if (mf != null) {
                ZipEntry ze;
                Attributes attr = mf.getMainAttributes();
                buildInfo = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (buildInfo == null && (ze = jf.getEntry(PE_VERSION_FILE)) != null) {
                    InputStream stream = jf.getInputStream(ze);
                    Properties jProps = new Properties();
                    jProps.load(stream);
                    buildInfo = (String)jProps.get(PE_BUILDLINE);
                }
            } else {
                ZipEntry ze = jf.getEntry(CMIS_VERSION_FILE);
                if (ze != null) {
                    InputStream stream = jf.getInputStream(ze);
                    Properties jProps = new Properties();
                    jProps.load(stream);
                    buildInfo = (String)jProps.get(CMIS_BUILD_NUMBER);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buildInfo;
    }
}

