/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows.utils;

import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Utils {
    public static JSONObject createJSONObject(String jsonStr) {
        JSONObject json = null;
        try {
            json = JSONObject.parse((String)jsonStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String readFromFile(String file) {
        String str = "";
        try {
            String tempStr;
            FileInputStream fs = new FileInputStream(file);
            DataInputStream ds = new DataInputStream(fs);
            BufferedReader br = new BufferedReader(new InputStreamReader(ds));
            while ((tempStr = br.readLine()) != null) {
                str = str + tempStr;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public static int parseUnit(String unit) {
        int unitValue = -1;
        if (unit.equals("Minutes")) {
            unitValue = 2;
        } else if (unit.equals("Hours")) {
            unitValue = 3;
        } else if (unit.equals("Days")) {
            unitValue = 4;
        } else if (unit.equals("Weeks")) {
            unitValue = 5;
        }
        return unitValue;
    }

    public static String getDefaultValue(int nFieldType, boolean bIsArray) {
        switch (nFieldType) {
            case 32: {
                VWAttachment vwAtt = new VWAttachment();
                if (bIsArray) {
                    return "{\"" + vwAtt.toString() + "\"}";
                }
                return "\"" + vwAtt.toString() + "\"";
            }
            case 4: {
                if (bIsArray) {
                    return "{true}";
                }
                return "true";
            }
            case 8: {
                if (bIsArray) {
                    return "{0.0}";
                }
                return "0.0";
            }
            case 512: {
                try {
                    VWGuid vwGuid = new VWGuid();
                    if (bIsArray) {
                        return "{\"" + vwGuid.toString() + "\"}";
                    }
                    return "\"" + vwGuid.toString() + "\"";
                }
                catch (VWException e) {
                    e.printStackTrace();
                }
            }
            case 1: {
                if (bIsArray) {
                    return "{0}";
                }
                return "0";
            }
            case 2: 
            case 64: 
            case 128: {
                if (bIsArray) {
                    return "{\"\"}";
                }
                return "\"\"";
            }
            case 16: {
                if (bIsArray) {
                    return "{systemtime()}";
                }
                return "systemtime()";
            }
        }
        return "";
    }
}

