/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows.handlers;

import com.ibm.acm.casebuilder.flows.AcmRequest;
import com.ibm.acm.casebuilder.flows.JsonToVWDefinition;
import com.ibm.acm.casebuilder.flows.VWDefintionToJson;
import com.ibm.acm.casebuilder.flows.handlers.BaseHandler;
import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.Handle;
import com.ibm.acm.sold.connector.CEManager;
import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

public class FlowEditorHandler
extends BaseHandler {
    private static final Log logger = LogFactory.getLog((String)Handle.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcmResponse doGet(AcmRequest request) throws AcmException {
        logger.trace((Object)"Entering doGet: ");
        try {
            AcmResponse response;
            AcmResponse acmResponse = response = this.getWorkflowJson(request);
            return acmResponse;
        }
        finally {
            logger.trace((Object)"Exiting doGet: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcmResponse doPut(AcmRequest request) throws AcmException {
        logger.trace((Object)"Entering doPut: ");
        try {
            AcmResponse response = null;
            response = Boolean.parseBoolean(request.getParameter("validate")) ? this.validate(request) : this.putWorkflowJson(request);
            AcmResponse acmResponse = response;
            return acmResponse;
        }
        finally {
            logger.trace((Object)"Exiting doPut: ");
        }
    }

    @Override
    public AcmResponse doDelete(AcmRequest request) throws AcmException {
        AcmResponse response = null;
        return response;
    }

    @Override
    public AcmResponse doPost(AcmRequest request) throws AcmException {
        Object response = null;
        return null;
    }

    private AcmResponse getWorkflowJson(AcmRequest request) throws AcmException {
        JSONObject mapJson;
        AcmResponse response;
        block6: {
            response = null;
            mapJson = null;
            String[] resource = request.getResourceRequestURI().split("/");
            String solutionName = resource[1];
            String caseTypeName = resource[3];
            String taskName = resource[5];
            System.out.println("solutionName: " + solutionName);
            System.out.println("caseTypeName: " + caseTypeName);
            System.out.println("taskName: " + taskName);
            Config config = request.getConfig();
            HttpSession sess = request.getSession();
            SolutionData solData = (SolutionData)sess.getAttribute("SolutionData");
            Set<String> casePropeties = this.getpropertiesSymbolicList(solData, caseTypeName);
            CEManager cemgr = new CEManager(solData, config);
            cemgr.openSession();
            try {
                VWWorkflowCollectionDefinition collection = null;
                VWWorkflowDefinition wfDef = null;
                InputStream inStream = cemgr.retrieveXPDLdoc(caseTypeName, true);
                if (inStream == null) break block6;
                collection = VWWorkflowCollectionDefinition.read((InputStream)inStream);
                try {
                    wfDef = collection.getWorkflow(taskName);
                }
                catch (VWException e) {
                    logger.info((Object)("Workflow for task " + taskName + " does not exist"));
                }
                if (wfDef != null) {
                    VWDefintionToJson vwToJson = new VWDefintionToJson();
                    mapJson = vwToJson.convertToMapJson(wfDef, casePropeties);
                } else {
                    logger.info((Object)"Work flow doesn't exists, DEBUG");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
                response = new AcmResponse(1, e.getLocalizedMessage());
            }
        }
        response = mapJson == null ? new AcmResponse(0, "{}") : new AcmResponse(0, mapJson.toString());
        return response;
    }

    private AcmResponse putWorkflowJson(AcmRequest request) throws AcmException {
        CEManager cemgr;
        SolutionData solData;
        String taskName;
        String caseTypeName;
        JSONObject successResponse;
        AcmResponse response;
        block13: {
            response = null;
            successResponse = new JSONObject();
            String[] resource = request.getResourceRequestURI().split("/");
            String solutionName = resource[1];
            caseTypeName = resource[3];
            taskName = resource[5];
            System.out.println("solutionName: " + solutionName);
            System.out.println("caseTypeName: " + caseTypeName);
            System.out.println("taskName: " + taskName);
            String payload = request.getRequestBody();
            System.out.println("body: " + payload);
            JSONObject actualMapJson = null;
            if (!payload.isEmpty()) {
                try {
                    actualMapJson = JSONObject.parse((String)payload);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    logger.error((Object)e1, (Throwable)e1);
                    response = new AcmResponse(1, e1.getLocalizedMessage());
                }
            }
            if (payload.isEmpty()) {
                System.out.println("payload is empty!");
            }
            Config config = request.getConfig();
            HttpSession sess = request.getSession();
            solData = (SolutionData)sess.getAttribute("SolutionData");
            Set<String> casePropeties = this.getpropertiesSymbolicList(solData, caseTypeName);
            cemgr = new CEManager(solData, config);
            cemgr.openSession();
            try {
                VWWorkflowCollectionDefinition collection = null;
                VWWorkflowDefinition wfDef = null;
                JsonToVWDefinition jsonToVW = null;
                InputStream inStream = cemgr.retrieveXPDLdoc(caseTypeName, true);
                if (inStream == null) break block13;
                collection = VWWorkflowCollectionDefinition.read((InputStream)inStream);
                try {
                    wfDef = collection.getWorkflow(taskName);
                }
                catch (VWException e) {
                    logger.info((Object)("Workflow for task " + taskName + " does not exist in the collection"));
                }
                if (wfDef == null) {
                    jsonToVW = new JsonToVWDefinition(new VWWorkflowDefinition(), taskName);
                    VWWorkflowDefinition wf = jsonToVW.createWorkflow(actualMapJson, casePropeties);
                    collection.addWorkflow(wf);
                } else {
                    jsonToVW = new JsonToVWDefinition(wfDef, taskName);
                    jsonToVW.updateWorkflow(actualMapJson, casePropeties);
                }
                InputStream inputStream = Utility.stringToStream(collection.asXPDLString());
                cemgr.updateXPDLReservation(cemgr.getObjectSore(), solutionName, caseTypeName, inputStream);
                successResponse.put((Object)"updates", (Object)jsonToVW.getUpdatesMap());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
                response = new AcmResponse(1, e.getLocalizedMessage());
            }
        }
        if (response == null) {
            JSONObject currentMapJson = this.getCurrentMapJson(cemgr, solData, caseTypeName, taskName);
            if (currentMapJson != null && !currentMapJson.isEmpty()) {
                System.out.println("current Map Json = " + currentMapJson.toString());
                successResponse.put((Object)"map", (Object)currentMapJson);
            } else {
                successResponse.put((Object)"map", (Object)"{}");
            }
            response = new AcmResponse(0, successResponse.toString());
        }
        cemgr.closeSession();
        return response;
    }

    public AcmResponse validate(AcmRequest request) throws AcmException {
        CEManager cemgr;
        JSONObject successResponse;
        AcmResponse response;
        block11: {
            response = null;
            successResponse = new JSONObject();
            String[] resource = request.getResourceRequestURI().split("/");
            String solutionName = resource[1];
            String caseTypeName = resource[3];
            String taskName = resource[5];
            System.out.println("solutionName: " + solutionName);
            System.out.println("caseTypeName: " + caseTypeName);
            System.out.println("taskName: " + taskName);
            String payload = request.getRequestBody();
            System.out.println("body: " + payload);
            JSONObject actualMapJson = null;
            if (!payload.isEmpty()) {
                try {
                    actualMapJson = JSONObject.parse((String)payload);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    logger.error((Object)e1, (Throwable)e1);
                    response = new AcmResponse(1, e1.getLocalizedMessage());
                }
            }
            if (payload.isEmpty()) {
                System.out.println("payload is empty!");
            }
            Config config = request.getConfig();
            HttpSession sess = request.getSession();
            SolutionData solData = (SolutionData)sess.getAttribute("SolutionData");
            Set<String> casePropeties = this.getpropertiesSymbolicList(solData, caseTypeName);
            cemgr = new CEManager(solData, config);
            cemgr.openSession();
            try {
                VWWorkflowCollectionDefinition collection = null;
                VWWorkflowDefinition wfDef = null;
                JsonToVWDefinition jsonToVW = null;
                InputStream inStream = cemgr.retrieveXPDLdoc(caseTypeName, true);
                if (inStream == null) break block11;
                collection = VWWorkflowCollectionDefinition.read((InputStream)inStream);
                try {
                    wfDef = collection.getWorkflow(taskName);
                }
                catch (VWException e) {
                    logger.info((Object)("Workflow for task " + taskName + " does not exist in the collection"));
                    throw e;
                }
                jsonToVW = new JsonToVWDefinition(wfDef, taskName);
                jsonToVW.updateWorkflow(actualMapJson, casePropeties);
                String sdfFile = AcmActivityEditorUtil.createSdfFromSolutionType(solData.getSdfData().getSolutionType());
                wfDef.setValidateFlag(true);
                VWValidationError[] error = wfDef.validate(null, solData.getPeconfigData().getSystemConfiguration(), sdfFile);
                JSONArray errors = new JSONArray();
                if (error != null) {
                    for (int i = 0; i < error.length; ++i) {
                        errors.add((Object)(error[i].getName() + ": " + error[i].getMessage()));
                    }
                    successResponse.put((Object)"errors", (Object)errors);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
                response = new AcmResponse(1, e.getLocalizedMessage());
            }
        }
        cemgr.closeSession();
        if (response == null) {
            response = new AcmResponse(0, successResponse.toString());
        }
        return response;
    }

    private JSONObject getCurrentMapJson(CEManager cemgr, SolutionData solData, String caseTypeName, String taskName) throws AcmException {
        JSONObject mapJson;
        block6: {
            AcmResponse response = null;
            mapJson = null;
            try {
                VWWorkflowCollectionDefinition collection = null;
                VWWorkflowDefinition wfDef = null;
                InputStream inStream = cemgr.retrieveXPDLdoc(caseTypeName, true);
                if (inStream == null) break block6;
                collection = VWWorkflowCollectionDefinition.read((InputStream)inStream);
                try {
                    wfDef = collection.getWorkflow(taskName);
                }
                catch (VWException e) {
                    logger.info((Object)("Workflow for task " + taskName + " does not exist"));
                }
                if (wfDef != null) {
                    VWDefintionToJson vwToJson = new VWDefintionToJson();
                    mapJson = vwToJson.convertToMapJson(wfDef, this.getpropertiesSymbolicList(solData, caseTypeName));
                } else {
                    logger.info((Object)"Work flow doesn't exists, DEBUG");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
                response = new AcmResponse(1, e.getLocalizedMessage());
            }
        }
        return mapJson;
    }

    public Set<String> getpropertiesSymbolicList(SolutionData solData, String caseTypeName) {
        HashSet<String> properties = new HashSet<String>();
        List caseList = null;
        try {
            caseList = solData.getSdfData().getSolutionType().getCaseTypes().getCaseType();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (caseList != null) {
            for (CaseTypeType caseType : caseList) {
                if (!caseType.getName().equalsIgnoreCase(caseTypeName)) continue;
                if (caseType.getCaseProperties() == null) break;
                Iterator propIter = caseType.getCaseProperties().getPropertyDefinition().iterator();
                while (propIter.hasNext()) {
                    properties.add(((CmisPropertyDefinitionType)propIter.next()).getLocalName());
                }
                break block2;
            }
        }
        return properties;
    }
}

