/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.acm.casebuilder.flows.Constants;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WorkItemParameter {
    private VWWorkflowDefinition workflowDef;

    public WorkItemParameter(VWWorkflowDefinition wDef) {
        this.workflowDef = wDef;
    }

    private int getAccessMode(String access) {
        int mode = 3;
        if (access.equals("r")) {
            mode = 1;
        } else if (access.equals("rw")) {
            mode = 3;
        } else if (access.equals("w")) {
            mode = 2;
        }
        return mode;
    }

    private String getParameterPrefix(int type) {
        String prefix = "";
        switch (type) {
            case 32: 
            case 64: {
                prefix = "";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                prefix = "F_CaseFolder.";
            }
        }
        return prefix;
    }

    private int getParameterType(String type) {
        int typeDef = 2;
        if (type.equals("attachment")) {
            typeDef = 32;
        } else if (type.equals("workflowGroup")) {
            typeDef = 64;
        } else if (type.equals("string")) {
            typeDef = 2;
        } else if (type.equals("integer")) {
            typeDef = 1;
        } else if (type.equals("float")) {
            typeDef = 8;
        } else if (type.equals("boolean")) {
            typeDef = 4;
        } else if (type.equals("datetime")) {
            typeDef = 16;
        }
        return typeDef;
    }

    public void updateParameter(VWStepDefinition step, JSONArray parameters, Set<String> caseProperties) throws VWException {
        int i;
        VWParameterDefinition[] parametersDef = step.getParameterDefinitions();
        if (parametersDef != null) {
            for (i = 0; i < parametersDef.length; ++i) {
                if (parametersDef[i].getDataType() != 32 && parametersDef[i].getDataType() != 64 && !caseProperties.contains(parametersDef[i].getName())) continue;
                try {
                    step.deleteParameter(parametersDef[i].getName());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < parameters.size(); ++i) {
            JSONObject paramJson = (JSONObject)parameters.get(i);
            String type = (String)paramJson.get((Object)"type");
            if (type.equals("dataField")) continue;
            String name = (String)paramJson.get(Constants.ACM_FE_NAME);
            String desc = (String)paramJson.get(Constants.ACM_FE_PROMPT);
            String accessRight = (String)paramJson.get(Constants.ACM_FE_ACCESS);
            boolean isArray = Boolean.parseBoolean(paramJson.get(Constants.ACM_FE_ISARRY).toString());
            VWFieldDefinition fieldDef = null;
            int mode = this.getAccessMode(accessRight);
            int typeDef = this.getParameterType(type);
            String prefix = this.getParameterPrefix(typeDef);
            if (typeDef == 32 || typeDef == 64) {
                fieldDef = this.workflowDef.getField(name);
                isArray = fieldDef.isArray();
            } else {
                this.createDataFields(name, AcmActivityEditorUtil.getDefaultValue(typeDef, isArray), typeDef, isArray);
            }
            VWParameterDefinition paramCreated = step.createParameter(name, mode, prefix + name, typeDef, isArray);
            paramCreated.setDescription(desc);
        }
        this.createPostAssignements(step, caseProperties);
    }

    private void createDataFields(String name, String value, int type, boolean isArray) throws VWException {
        VWFieldDefinition fieldDef = null;
        try {
            fieldDef = this.workflowDef.getField(name);
        }
        catch (VWException e) {
            // empty catch block
        }
        try {
            if (fieldDef == null) {
                fieldDef = this.workflowDef.createFieldUsingString(name, value, type, isArray);
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void createPostAssignements(VWStepDefinition step, Set<String> caseProperties) throws VWException {
        int i;
        VWParameterDefinition[] paramDefs = step.getParameterDefinitions();
        String[][] existingAssignments = step.getPostAssignments();
        ArrayList<String> paramsList = new ArrayList<String>();
        HashMap<String, String> assignmentsMap = new HashMap<String, String>();
        if (existingAssignments != null) {
            for (i = 0; i < existingAssignments.length; ++i) {
                assignmentsMap.put(existingAssignments[i][0], existingAssignments[i][1]);
            }
        }
        if (paramDefs != null && paramDefs.length > 0) {
            for (i = 0; i < paramDefs.length; ++i) {
                if (!caseProperties.contains(paramDefs[i].getName()) || paramDefs[i].getMode() != 3 && paramDefs[i].getMode() != 2) continue;
                if (!assignmentsMap.containsKey(paramDefs[i].getName())) {
                    assignmentsMap.put(paramDefs[i].getName(), paramDefs[i].getValue());
                }
                paramsList.add(paramDefs[i].getName());
            }
        }
        Iterator it = assignmentsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String s = (String)entry.getKey();
            if (!caseProperties.contains(assignmentsMap.get(s)) || paramsList.contains(s)) continue;
            it.remove();
        }
        Set set = assignmentsMap.keySet();
        String[][] newAssignments = new String[assignmentsMap.size()][2];
        int i2 = 0;
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            String s;
            newAssignments[i2][0] = s = (String)i$.next();
            newAssignments[i2][1] = (String)assignmentsMap.get(s);
            ++i2;
        }
        if (i2 == 0) {
            step.setPostAssignments(new String[0][0]);
        } else {
            step.setPostAssignments(newAssignments);
        }
    }
}

