/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.acm.casebuilder.flows.MapJson;
import com.ibm.acm.casebuilder.flows.NodeJson;
import com.ibm.acm.casebuilder.flows.RouteJson;
import com.ibm.acm.casebuilder.flows.WorkflowJson;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VWDefintionToJson {
    private static final Log log = LogFactory.getLog((String)VWDefintionToJson.class.getName());

    public JSONObject convertToMapJson(VWWorkflowDefinition wfDef, Set<String> caseProperties) {
        log.trace((Object)">> convertToMapJson");
        JSONObject json = new JSONObject();
        MapJson mapJson = new MapJson();
        try {
            int i;
            VWMapDefinition mainMap = wfDef.getMainMap();
            VWMapNode[] nodes = mainMap.getSteps();
            VWFieldDefinition[] fields = wfDef.getFields();
            WorkflowJson wfJson = new WorkflowJson();
            String mainAttachment = wfDef.getMainAttachmentName();
            for (i = 0; i < fields.length; ++i) {
                if (32 == fields[i].getFieldType()) {
                    if (mainAttachment != null && !mainAttachment.isEmpty()) {
                        if (mainAttachment.replaceAll("\"", "").equals(fields[i].getName())) {
                            wfJson.addAttachment(fields[i], true);
                        } else {
                            wfJson.addAttachment(fields[i], false);
                        }
                    } else {
                        wfJson.addAttachment(fields[i], false);
                    }
                }
                if (64 == fields[i].getFieldType()) {
                    wfJson.addWorkgroup(fields[i]);
                    continue;
                }
                if (32 == fields[i].getFieldType() || 64 == fields[i].getFieldType() || 512 == fields[i].getFieldType()) continue;
                wfJson.addDataField(fields[i]);
            }
            for (i = 0; i < nodes.length; ++i) {
                log.debug((Object)"Reading the VW nodes started");
                NodeJson nodeJson = new NodeJson();
                if (nodes[i] instanceof VWStepDefinition) {
                    nodeJson.setType("step");
                }
                if (nodes[i] instanceof VWCompoundStepDefinition) {
                    nodeJson.setType("compoundStep");
                }
                if (nodes[i] instanceof VWStepDefinition) {
                    VWAttributeInfo customAttribInfo;
                    VWParticipant[] participants;
                    nodeJson.setId(nodes[i].getStepId(), true);
                    nodeJson.setTitle(nodes[i].getName());
                    nodeJson.setDescription(nodes[i].getDocumentation());
                    nodeJson.setInstruction(nodes[i].getDescription());
                    nodeJson.setReassign(((VWStepDefinition)nodes[i]).getCanReassign());
                    nodeJson.setPageName(((VWStepDefinition)nodes[i]).getRequestedInterface());
                    String queue = ((VWStepDefinition)nodes[i]).getQueueName();
                    if (queue != null) {
                        nodeJson.setQueue(queue);
                    }
                    if ((participants = ((VWStepDefinition)nodes[i]).getParticipants()) != null) {
                        nodeJson.setParticipants(participants);
                    }
                    int deadline_value = (int)((VWStepDefinition)nodes[i]).getDeadline();
                    int reminder_value = (int)((VWStepDefinition)nodes[i]).getReminder();
                    String expr = ((VWStepDefinition)nodes[i]).getDeadlineExpr();
                    String submap = ((VWStepDefinition)nodes[i]).getDeadlineMap();
                    nodeJson.setDeadline(deadline_value, reminder_value, expr, submap);
                    String[] resp = ((VWStepDefinition)nodes[i]).getResponses();
                    if (resp != null) {
                        nodeJson.setResponses(resp);
                    }
                    int joinType = ((VWStepDefinition)nodes[i]).getJoinType();
                    nodeJson.setJoin(joinType);
                    int splitType = ((VWStepDefinition)nodes[i]).getSplitType();
                    nodeJson.setSplit(splitType);
                    VWParameterDefinition[] vwParams = ((VWStepDefinition)nodes[i]).getParameterDefinitions();
                    if (vwParams != null) {
                        for (int j = 0; j < vwParams.length; ++j) {
                            nodeJson.addParameter(vwParams[j], caseProperties);
                        }
                    }
                    if ((customAttribInfo = nodes[i].getAttributeInfo()) != null) {
                        String[] attribs = customAttribInfo.getAttributeNames();
                        for (int j = 0; j < attribs.length; ++j) {
                            nodeJson.addCustomAttributes(attribs[j], customAttribInfo.getFieldType(attribs[j]), customAttribInfo.isFieldArray(attribs[j]), customAttribInfo.getFieldValue(attribs[j]));
                        }
                    }
                }
                if (nodes[i] instanceof VWCompoundStepDefinition) {
                    nodeJson.setId(nodes[i].getStepId(), true);
                    nodeJson.setTitle(nodes[i].getName());
                    nodeJson.setDescription(nodes[i].getDescription());
                }
                mapJson.addNode(nodeJson.getNodeJson());
                log.debug((Object)"Reading the VW nodes ended");
                VWRouteDefinition[] routeDef = nodes[i].getNextRoutes();
                if (routeDef == null) continue;
                for (int j = 0; j < routeDef.length; ++j) {
                    log.debug((Object)"Reading the VW routes started");
                    RouteJson routeJson = new RouteJson();
                    routeJson.setTitle(routeDef[j].getName());
                    routeJson.setDescription(routeDef[j].getDescription());
                    routeJson.setCondition(routeDef[j].getCondition());
                    routeJson.setID(routeDef[j].getRouteId());
                    routeJson.setFromID(routeDef[j].getSourceStep().getStepId());
                    routeJson.setToID(routeDef[j].getDestinationStep().getStepId());
                    mapJson.addRoute(routeJson.getRouteJson());
                    log.debug((Object)"Reading the VW routes ended");
                }
            }
            json.put((Object)"nodes", mapJson.getNodes());
            json.put((Object)"routes", mapJson.getRoutes());
            json.put((Object)"map", mapJson.getMap());
            json.put((Object)"workflow", (Object)wfJson.getWorkflowJson());
            System.out.println("map JSON = " + json.toString());
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        log.trace((Object)"<< convertToMapJson");
        return json;
    }
}

