/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.acm.casebuilder.flows.Constants;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import java.util.Set;

public class NodeJson {
    private JSONObject general = new JSONObject();
    private JSONObject routing = new JSONObject();
    private JSONObject deadline = new JSONObject();
    private JSONArray parameters = new JSONArray();
    private JSONArray customAttributes = new JSONArray();
    private String description;

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setType(String type) {
        this.general.put((Object)"type", (Object)type);
    }

    public void subType(String val) {
        this.general.put((Object)"subType", (Object)val);
    }

    public void setTitle(String title) {
        this.general.put((Object)"title", (Object)title);
    }

    public void setInstruction(String instr) {
        this.general.put((Object)"instruction", (Object)instr);
    }

    public void setQueue(String queue) {
        this.general.put((Object)"queue", (Object)queue);
    }

    public void setReassign(boolean reassign) {
        this.general.put((Object)"reassignable", (Object)reassign);
    }

    public void setPageName(String pageName) {
        this.general.put((Object)"pageName", (Object)pageName);
    }

    public void setId(int val, boolean generated) {
        JSONObject tempJson = new JSONObject();
        tempJson.put(Constants.ACM_FE_VALUE, (Object)val);
        this.general.put((Object)"id", (Object)tempJson);
    }

    public void setParticipants(VWParticipant[] vwParticipants) {
        JSONArray arr = new JSONArray();
        if (vwParticipants != null && vwParticipants.length > 0) {
            for (int i = 0; i < vwParticipants.length; ++i) {
                arr.add((Object)vwParticipants[i].getParticipantName());
            }
        }
        this.general.put((Object)"participants", (Object)arr);
    }

    public void setResponses(String[] resp) {
        JSONArray arr = new JSONArray();
        for (int i = 0; i < resp.length; ++i) {
            arr.add((Object)resp[i]);
        }
        this.routing.put((Object)"responses", (Object)arr);
    }

    public void setJoin(int joinType) {
        if (2 == joinType) {
            this.routing.put((Object)"join", Constants.ACM_FE_OR);
        } else if (1 == joinType) {
            this.routing.put((Object)"join", Constants.ACM_FE_AND);
        } else if (3 == joinType) {
            this.routing.put((Object)"join", Constants.ACM_FE_OR);
        }
    }

    public void setSplit(int splitType) {
        if (2 == splitType) {
            this.routing.put(Constants.ACM_FE_SPLIT, Constants.ACM_FE_OR);
        } else if (1 == splitType) {
            this.routing.put(Constants.ACM_FE_SPLIT, Constants.ACM_FE_AND);
        } else if (3 == splitType) {
            this.routing.put(Constants.ACM_FE_SPLIT, Constants.ACM_FE_OR);
        }
    }

    public void setDeadline(int deadline_value, int reminder_value, String expr, String submapID) {
        this.deadline.put(Constants.ACM_FE_VALUE, (Object)deadline_value);
        this.deadline.put((Object)"reminder", (Object)reminder_value);
        if (deadline_value == -1) {
            this.deadline.put((Object)"expression", (Object)expr);
        }
        this.deadline.put(Constants.ACM_FE_SUBMAP, (Object)submapID);
    }

    public void addParameter(VWParameterDefinition vwParam, Set<String> caseProperties) {
        JSONObject param = new JSONObject();
        String paramName = vwParam.getName();
        int paramType = vwParam.getDataType();
        int access = vwParam.getMode();
        String prompt = vwParam.getDescription();
        boolean isArray = vwParam.getIsArray();
        param.put(Constants.ACM_FE_NAME, (Object)paramName);
        if (32 == paramType) {
            param.put((Object)"type", (Object)"attachment");
        } else if (64 == paramType) {
            param.put((Object)"type", (Object)"workflowGroup");
        } else if (caseProperties.contains(paramName)) {
            if (4 == paramType) {
                param.put((Object)"type", (Object)"boolean");
            } else if (8 == paramType) {
                param.put((Object)"type", (Object)"float");
            } else if (2 == paramType) {
                param.put((Object)"type", (Object)"string");
            } else if (1 == paramType) {
                param.put((Object)"type", (Object)"integer");
            } else if (16 == paramType) {
                param.put((Object)"type", (Object)"datetime");
            } else {
                param.put((Object)"type", (Object)"dataField");
            }
        } else {
            param.put((Object)"type", (Object)"dataField");
        }
        if (1 == access) {
            param.put(Constants.ACM_FE_ACCESS, (Object)"r");
        } else if (2 == access) {
            param.put(Constants.ACM_FE_ACCESS, (Object)"w");
        } else if (3 == access) {
            param.put(Constants.ACM_FE_ACCESS, (Object)"rw");
        }
        param.put(Constants.ACM_FE_ISARRY, (Object)isArray);
        param.put(Constants.ACM_FE_PROMPT, (Object)prompt);
        this.parameters.add((Object)param);
    }

    public void addCustomAttributes(String name, int type, boolean array, Object value) {
        JSONObject custAttribJson = new JSONObject();
        custAttribJson.put(Constants.ACM_FE_NAME, (Object)name);
        custAttribJson.put((Object)"type", (Object)type);
        custAttribJson.put(Constants.ACM_FE_ISARRY, (Object)array);
        custAttribJson.put(Constants.ACM_FE_VALUE, value);
        this.customAttributes.add((Object)custAttribJson);
    }

    public Object getNodeJson() {
        JSONObject json = new JSONObject();
        json.put((Object)"general", (Object)this.general);
        json.put((Object)"routing", (Object)this.routing);
        json.put((Object)"deadline", (Object)this.deadline);
        json.put((Object)"parameters", (Object)this.parameters);
        json.put((Object)"customAttributes", (Object)this.customAttributes);
        json.put((Object)"description", (Object)this.description);
        return json;
    }
}

