/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.acm.casebuilder.flows.Constants;
import com.ibm.acm.casebuilder.flows.WorkItemParameter;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonToVWDefinition {
    private VWWorkflowDefinition wfDef;
    private VWMapDefinition mapDef;
    private boolean isUserCreatedTask = false;
    public JSONArray updates;
    private Set<String> caseProperties;
    private static final Log log = LogFactory.getLog((String)JsonToVWDefinition.class.getName());

    public JsonToVWDefinition() {
    }

    public JsonToVWDefinition(VWWorkflowDefinition wf, String taskName) throws VWException {
        this.wfDef = wf;
        try {
            this.mapDef = this.wfDef.getMainMap();
            this.wfDef.setName(taskName);
        }
        catch (VWException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public VWWorkflowDefinition createWorkflow(JSONObject mapJson, Set<String> caseProperties) throws VWException {
        JSONObject map;
        this.updates = new JSONArray();
        this.caseProperties = caseProperties;
        if (mapJson.get(Constants.ACM_FE_DESCRIPTION) != null) {
            this.wfDef.setDescription((String)mapJson.get(Constants.ACM_FE_DESCRIPTION));
        }
        if ((map = (JSONObject)mapJson.get(Constants.ACM_FE_MAP)) != null) {
            this.isUserCreatedTask = Boolean.parseBoolean(map.get((Object)"userCreated").toString());
        }
        JSONArray nodes = (JSONArray)mapJson.get(Constants.ACM_FE_NODES);
        JSONObject workflowJson = (JSONObject)mapJson.get(Constants.ACM_FE_WORKFLOW);
        JSONArray attachments = (JSONArray)workflowJson.get((Object)"attachments");
        JSONArray workgroups = (JSONArray)workflowJson.get((Object)"workgroups");
        this.createAttachments(attachments);
        this.createWorkgroups(workgroups);
        this.createUpdateSteps(nodes);
        JSONArray routes = (JSONArray)mapJson.get(Constants.ACM_FE_ROUTES);
        for (int i = 0; i < routes.size(); ++i) {
            this.createUpdateRoute((JSONObject)routes.get(i));
        }
        return this.wfDef;
    }

    private void createUpdateSteps(JSONArray nodes) throws VWException {
        log.debug((Object)"<< Enter createStep");
        ArrayList<Integer> stepList = new ArrayList<Integer>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            JSONObject node = (JSONObject)nodes.get(i);
            JSONObject general = (JSONObject)node.get(Constants.ACM_FE_STEP_GENERAL);
            String stepType = (String)general.get((Object)"type");
            JSONObject idJson = (JSONObject)general.get((Object)"id");
            int id = Integer.parseInt(idJson.get(Constants.ACM_FE_VALUE).toString());
            boolean isGenerated = id < 0;
            try {
                JSONObject updObj;
                VWCompoundStepDefinition step;
                if (stepType.equals("compoundStep")) {
                    if (isGenerated) {
                        step = this.mapDef.createCompoundStep((String)general.get((Object)"title"));
                        updObj = new JSONObject();
                        updObj.put(Constants.ACM_FE_ORIGID, (Object)Integer.toString(id));
                        updObj.put((Object)"id", (Object)Integer.toString(step.getStepId()));
                        this.updates.add((Object)updObj);
                        id = step.getStepId();
                    } else {
                        step = (VWCompoundStepDefinition)this.mapDef.getStep(id);
                    }
                    this.updateCompoundStep(step, node);
                } else if (stepType.equals("step")) {
                    if (id == 0 && !this.isUserCreatedTask) continue;
                    if (isGenerated) {
                        step = this.mapDef.createStep((String)general.get((Object)"title"));
                        updObj = new JSONObject();
                        updObj.put(Constants.ACM_FE_ORIGID, (Object)Integer.toString(id));
                        updObj.put((Object)"id", (Object)Integer.toString(step.getStepId()));
                        this.updates.add((Object)updObj);
                        id = step.getStepId();
                    } else {
                        step = (VWStepDefinition)this.mapDef.getStep(id);
                    }
                    this.updateStep((VWStepDefinition)step, node);
                }
            }
            catch (VWException e) {
                e.printStackTrace();
                throw e;
            }
            stepList.add(id);
        }
        VWMapNode[] nodeDefs = this.mapDef.getSteps();
        for (int i = 0; i < nodeDefs.length; ++i) {
            if (!(nodeDefs[i] instanceof VWStepDefinition) || stepList.contains(nodeDefs[i].getStepId())) continue;
            try {
                this.mapDef.deleteStep(nodeDefs[i].getStepId());
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
        log.debug((Object)">> Exit createStep");
    }

    private void updateCompoundStep(VWCompoundStepDefinition step, JSONObject node) throws VWException {
        JSONObject general = (JSONObject)node.get(Constants.ACM_FE_STEP_GENERAL);
        String description = (String)node.get(Constants.ACM_FE_DESCRIPTION);
        step.setName((String)general.get((Object)"title"));
        step.setDescription(description);
    }

    private void updateStep(VWStepDefinition step, JSONObject node) throws VWException {
        Object[] responses;
        JSONObject general = (JSONObject)node.get(Constants.ACM_FE_STEP_GENERAL);
        JSONObject routing = (JSONObject)node.get(Constants.ACM_FE_STEP_ROUTING);
        JSONArray parameters = (JSONArray)node.get(Constants.ACM_FE_STEP_PARAMETERS);
        JSONObject deadline = (JSONObject)node.get(Constants.ACM_FE_STEP_DEADLINE);
        JSONArray custAttribs = (JSONArray)node.get((Object)"customAttributes");
        String description = (String)node.get(Constants.ACM_FE_DESCRIPTION);
        if (general.get((Object)"title") != null) {
            step.setName((String)general.get((Object)"title"));
        }
        if (general.get((Object)"instruction") != null) {
            step.setDescription((String)general.get((Object)"instruction"));
        }
        if (description != null) {
            step.setDocumentation(description);
        }
        if (general.get((Object)"pageName") != null) {
            step.setRequestedInterface((String)general.get((Object)"pageName"));
        }
        if (step.getStepId() != 0) {
            if (general.get((Object)"reassignable") != null) {
                step.setCanReassign(Boolean.parseBoolean(general.get((Object)"reassignable").toString()));
            } else {
                step.setCanReassign(true);
            }
            JSONArray participantsJson = (JSONArray)general.get((Object)"participants");
            if (participantsJson != null && !participantsJson.isEmpty()) {
                VWParticipant[] participants = new VWParticipant[participantsJson.size()];
                for (int i = 0; i < participantsJson.size(); ++i) {
                    participants[i] = new VWParticipant(participantsJson.get(i).toString());
                }
                step.setParticipants(participants);
                step.setQueueName("Inbox");
            } else {
                step.setQueueName((String)general.get((Object)"queue"));
                step.setParticipants(null);
            }
            if (deadline.containsKey(Constants.ACM_FE_VALUE) && deadline.get(Constants.ACM_FE_VALUE) != null) {
                step.setDeadline(Long.parseLong(deadline.get(Constants.ACM_FE_VALUE).toString()));
            }
            if (deadline.containsKey((Object)"reminder") && deadline.get((Object)"reminder") != null) {
                step.setReminder(Long.parseLong(deadline.get((Object)"reminder").toString()));
            }
            if (deadline.containsKey((Object)"expression") && deadline.get((Object)"expression") != null) {
                step.setDeadlineExpr((String)deadline.get((Object)"expression"));
            }
        }
        if (routing.containsKey((Object)"join")) {
            String joinType = (String)routing.get((Object)"join");
            if (joinType.equalsIgnoreCase("OR")) {
                step.setJoinType(2);
            } else if (joinType.equalsIgnoreCase("AND")) {
                step.setJoinType(1);
            } else {
                step.setJoinType(3);
            }
        }
        if (routing.containsKey(Constants.ACM_FE_SPLIT)) {
            String splitType = (String)routing.get(Constants.ACM_FE_SPLIT);
            if (splitType.equalsIgnoreCase("OR")) {
                step.setSplitType(2);
            } else if (splitType.equalsIgnoreCase("AND")) {
                step.setSplitType(1);
            } else {
                step.setSplitType(3);
            }
        }
        if (routing.containsKey((Object)"responses") && routing.get((Object)"responses") != null && (responses = ((JSONArray)routing.get((Object)"responses")).toArray()) != null && responses.length > 0) {
            String[] responsesArray = Arrays.asList(responses).toArray(new String[responses.length]);
            step.setResponses(responsesArray);
        }
        if (parameters != null) {
            WorkItemParameter workParameter = new WorkItemParameter(this.wfDef);
            workParameter.updateParameter(step, parameters, this.caseProperties);
        }
        if (custAttribs != null) {
            VWAttributeInfo attrib = new VWAttributeInfo();
            for (int i = 0; i < custAttribs.size(); ++i) {
                JSONObject attribJson = (JSONObject)custAttribs.get(i);
                Object obj = attribJson.get(Constants.ACM_FE_VALUE);
                if (obj instanceof Long) {
                    int value = Integer.parseInt(obj.toString());
                    attrib.setFieldValue((String)attribJson.get(Constants.ACM_FE_NAME), (Object)value);
                    continue;
                }
                attrib.setFieldValue((String)attribJson.get(Constants.ACM_FE_NAME), obj);
            }
            step.setAttributeInfo(attrib);
        }
    }

    private void createUpdateRoute(JSONObject routeJson) throws VWException {
        log.debug((Object)"<< Enter createRoute");
        int from = Integer.parseInt(routeJson.get((Object)"from").toString());
        int to = Integer.parseInt(routeJson.get((Object)"to").toString());
        VWMapNode sourceStep = null;
        VWMapNode targetStep = null;
        try {
            if (from < 0) {
                from = this.getVWRouteId(from);
            }
            if (to < 0) {
                to = this.getVWRouteId(to);
            }
            VWMapNode[] allSteps = this.mapDef.getSteps();
            for (int i = 0; i < allSteps.length; ++i) {
                int currentStepId = allSteps[i].getStepId();
                if (from == currentStepId) {
                    sourceStep = allSteps[i];
                } else if (to == currentStepId) {
                    targetStep = allSteps[i];
                }
                if (sourceStep != null && targetStep != null) break;
            }
            VWRouteDefinition existingRoute = null;
            try {
                existingRoute = sourceStep.getRouteTo(targetStep.getStepId());
                if (existingRoute != null) {
                    sourceStep.deleteRoute(existingRoute.getRouteId());
                }
            }
            catch (VWException e) {
                log.error((Object)"Error occured while delete existing route", (Throwable)e);
            }
            VWRouteDefinition route = sourceStep.createRoute(targetStep.getStepId());
            route.setName((String)routeJson.get((Object)"title"));
            route.setDescription((String)routeJson.get(Constants.ACM_FE_DESCRIPTION));
            route.setCondition((String)routeJson.get((Object)"condition"));
        }
        catch (VWException e) {
            e.printStackTrace();
            throw e;
        }
        log.debug((Object)">> Exit createRoute");
    }

    private int getVWRouteId(int generatedId) {
        for (int i = 0; i < this.updates.size(); ++i) {
            JSONObject updObj = (JSONObject)this.updates.get(i);
            if (Integer.parseInt(updObj.get(Constants.ACM_FE_ORIGID).toString()) != generatedId) continue;
            return Integer.parseInt(updObj.get((Object)"id").toString());
        }
        return 0;
    }

    private void createWorkgroups(JSONArray workgroups) throws VWException {
        ArrayList<String> wgList = new ArrayList<String>(workgroups.size());
        for (int i = 0; i < workgroups.size(); ++i) {
            JSONObject json = (JSONObject)workgroups.get(i);
            String name = (String)json.get(Constants.ACM_FE_NAME);
            String desc = (String)json.get(Constants.ACM_FE_DESCRIPTION);
            String value = (String)json.get(Constants.ACM_FE_VALUE);
            boolean isArray = true;
            wgList.add(name);
            VWFieldDefinition fieldDef = null;
            try {
                fieldDef = this.wfDef.getField(name);
            }
            catch (VWException e) {
                // empty catch block
            }
            try {
                if (fieldDef == null) {
                    if (value.equals("")) {
                        value = AcmActivityEditorUtil.getDefaultValue(64, isArray);
                    }
                    fieldDef = this.wfDef.createFieldUsingString(name, value, 64, isArray);
                }
                fieldDef.setDescription(desc);
                continue;
            }
            catch (VWException e) {
                e.printStackTrace();
                throw e;
            }
        }
        VWFieldDefinition[] fieldDefs = this.wfDef.getFields();
        for (int i = 0; i < fieldDefs.length; ++i) {
            if (fieldDefs[i].getFieldType() != 64 || wgList.contains(fieldDefs[i].getName())) continue;
            try {
                this.wfDef.deleteField(fieldDefs[i].getName());
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
    }

    private void createAttachments(JSONArray attachments) throws VWException {
        ArrayList<String> attList = new ArrayList<String>(attachments.size());
        for (int i = 0; i < attachments.size(); ++i) {
            JSONObject json = (JSONObject)attachments.get(i);
            String name = (String)json.get(Constants.ACM_FE_NAME);
            String desc = (String)json.get(Constants.ACM_FE_DESCRIPTION);
            String value = (String)json.get(Constants.ACM_FE_VALUE);
            boolean isArray = Boolean.parseBoolean(json.get(Constants.ACM_FE_ISARRY).toString());
            boolean isInitiate = Boolean.parseBoolean(json.get(Constants.ACM_FE_INITIATE).toString());
            attList.add(name);
            VWFieldDefinition fieldDef = null;
            try {
                fieldDef = this.wfDef.getField(name);
            }
            catch (VWException e) {
                // empty catch block
            }
            try {
                if (fieldDef == null) {
                    if (value.equals("")) {
                        value = AcmActivityEditorUtil.getDefaultValue(32, isArray);
                    }
                    fieldDef = this.wfDef.createFieldUsingString(name, value, 32, isArray);
                }
                fieldDef.setDescription(desc);
                fieldDef.setMergeType(6);
                if (!isInitiate) continue;
                this.wfDef.setMainAttachmentName("\"" + name + "\"");
                continue;
            }
            catch (VWException e) {
                e.printStackTrace();
                throw e;
            }
        }
        VWFieldDefinition[] fieldDefs = this.wfDef.getFields();
        for (int i = 0; i < fieldDefs.length; ++i) {
            if (fieldDefs[i].getFieldType() != 32 || attList.contains(fieldDefs[i].getName())) continue;
            try {
                this.wfDef.deleteField(fieldDefs[i].getName());
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
    }

    public void updateWorkflow(JSONObject mapJson, Set<String> caseProperties) throws VWException {
        JSONObject map;
        this.updates = new JSONArray();
        this.caseProperties = caseProperties;
        if (mapJson.get(Constants.ACM_FE_DESCRIPTION) != null) {
            this.wfDef.setDescription((String)mapJson.get(Constants.ACM_FE_DESCRIPTION));
        }
        if ((map = (JSONObject)mapJson.get(Constants.ACM_FE_MAP)) != null && !map.isEmpty()) {
            this.isUserCreatedTask = Boolean.parseBoolean(map.get((Object)"userCreated").toString());
        }
        JSONArray nodes = (JSONArray)mapJson.get(Constants.ACM_FE_NODES);
        JSONObject workflowJson = (JSONObject)mapJson.get(Constants.ACM_FE_WORKFLOW);
        JSONArray attachments = (JSONArray)workflowJson.get((Object)"attachments");
        JSONArray workgroups = (JSONArray)workflowJson.get((Object)"workgroups");
        this.createAttachments(attachments);
        this.createWorkgroups(workgroups);
        this.createUpdateSteps(nodes);
        JSONArray routes = (JSONArray)mapJson.get(Constants.ACM_FE_ROUTES);
        for (int i = 0; i < routes.size(); ++i) {
            this.createUpdateRoute((JSONObject)routes.get(i));
        }
    }

    public JSONArray getUpdatesMap() {
        return this.updates;
    }
}

