/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmXPDLFlowHandler {
    private static final Log log = LogFactory.getLog((String)AcmXPDLFlowHandler.class.getName());
    VWMapDefinition mainMap = null;
    public static final String TYPE = "type";
    public static final String STEP = "Step";
    public static final String RESPONSE = "Response";
    public static final String ROUTE = "route";
    public static final String ID = "id";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String INSTRUCTION = "instruction";
    public static final String DEADLINE = "deadline";
    public static final String ISREAASIGNABLE = "is reassignable";
    public static final String PARTICIPANTNAME = "participant name";
    public static final String VALUE = "value";
    public static final String REMINDER = "reminder";
    public static final String PROPERTIES = "properties";
    public static final String LRESPONSE = "response";
    public static final String ONEOF = "OneOf";
    public static final String ANYOF = "AnyOf";
    public static final int SPLIT_TYPE_AND = 1;
    public static final int SPLIT_TYPE_OR = 2;
    public static final int SPLIT_TYPE_NONE = 3;
    public static final String REASSIGNABLE = "reassignable";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String EMPTYSTRING = "";
    public static final String COMPLETESIN = "completeIn";
    public static final String UNIT = "unit";
    public static final String HRS = "hrs";
    Hashtable<Object, Object> steptable = new Hashtable();
    Hashtable<Object, Object> routeresponsetable = new Hashtable();

    public void generateFlows(InputStream input_stream) {
        JSONArray arr = new JSONArray();
        VWWorkflowDefinition[] workFlows = null;
        try {
            VWWorkflowCollectionDefinition coll = VWWorkflowCollectionDefinition.read((InputStream)input_stream);
            workFlows = coll.getWorkflows();
            log.info((Object)("Workflow Name : " + workFlows[0].getName()));
            this.mainMap = workFlows[0].getMainMap();
            VWMapNode[] steps = this.mainMap.getSteps();
            this.generateStepJSON(steps);
            int stepid = this.mainMap.getStartStep().getStepId();
            arr.add(this.steptable.get(stepid));
            if (this.mainMap.getStep(stepid).getNextRoutes() != null) {
                arr.add(this.routeresponsetable.get(stepid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)"Flow is ");
        log.info((Object)arr);
    }

    public JSONArray generateFlows(VWWorkflowDefinition workflowDef) {
        JSONArray arr = new JSONArray();
        try {
            log.info((Object)("Workflow Name : " + workflowDef.getName()));
            this.mainMap = workflowDef.getMainMap();
            VWMapNode[] steps = this.mainMap.getSteps();
            this.generateStepJSON(steps);
            int stepid = this.mainMap.getStartStep().getStepId();
            arr.add(this.steptable.get(stepid));
            if (this.mainMap.getStep(stepid).getNextRoutes() != null) {
                arr.add(this.routeresponsetable.get(stepid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)"Flow is ");
        log.info((Object)arr);
        return arr;
    }

    public JSONArray generateFlows(VWWorkflowCollectionDefinition wf_collection, String task_name) {
        JSONArray arr = new JSONArray();
        VWWorkflowDefinition[] workFlows = null;
        try {
            workFlows = wf_collection.getWorkflows();
            log.info((Object)("Workflow Name : " + workFlows[0].getName()));
            this.mainMap = workFlows[0].getMainMap();
            VWMapNode[] steps = this.mainMap.getSteps();
            this.generateStepJSON(steps);
            int stepid = this.mainMap.getStartStep().getStepId();
            arr.add(this.steptable.get(stepid));
            if (this.mainMap.getStep(stepid).getNextRoutes() != null) {
                arr.add(this.routeresponsetable.get(stepid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)"Flow is ");
        log.info((Object)arr);
        return arr;
    }

    private void generateStepJSON(VWMapNode[] steps) {
        try {
            for (int i = 0; i < steps.length; ++i) {
                this.steptable.put(steps[i].getStepId(), this.convertSteptoJSON(steps[i].getStepId()));
            }
            log.info((Object)"Generated the JSON for the steps ");
            this.generateRouteJSON(steps[0].getStepId());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)"Unable to generate the JSON for the steps ");
        }
    }

    private void generateRouteJSON(int startstep_id) {
        try {
            if (this.mainMap.getStartStep().getNextRoutes() != null) {
                this.routeresponsetable.put(this.mainMap.getStartStep().getStepId(), this.convertRoutetoJSON(this.mainMap.getStartStep().getStepId()));
            }
            log.info((Object)"Generated the JSON for the Routes ");
            for (int j = 0; j < this.routeresponsetable.size(); ++j) {
                log.info((Object)this.routeresponsetable.get(j).toString());
            }
            log.info((Object)"Generated the JSON for the Routes ");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)"Unable to generate the JSON for the steps ");
        }
    }

    private Object convertRoutetoJSON(int step_id) {
        JSONObject route = new JSONObject();
        JSONArray routeitems = new JSONArray();
        try {
            int split_type = this.mainMap.getStep(step_id).getSplitType();
            log.info((Object)("Split type :" + split_type + "Step id" + step_id));
            if (split_type == 1) {
                route.put((Object)TYPE, (Object)ANYOF);
            }
            if (split_type == 2) {
                route.put((Object)TYPE, (Object)ONEOF);
            }
            if (split_type == 3) {
                route.put((Object)TYPE, (Object)"Always");
            }
            route.put((Object)ID, (Object)"1");
            VWRouteDefinition[] next_route = this.mainMap.getStep(step_id).getNextRoutes();
            for (int i = 0; i < next_route.length; ++i) {
                JSONObject response = new JSONObject();
                JSONArray responseitems = new JSONArray();
                response.put((Object)TYPE, (Object)RESPONSE);
                response.put((Object)ID, (Object)next_route[i].getRouteId());
                String route_name = next_route[i].getCondition() == null ? EMPTYSTRING : next_route[i].getName();
                response.put((Object)LRESPONSE, (Object)route_name);
                log.info((Object)("The condition for this route is : " + next_route[i].getCondition()));
                responseitems.add(this.steptable.get(next_route[i].getDestinationStepId()));
                if (this.mainMap.getStep(next_route[i].getDestinationStepId()).getNextRoutes() != null) {
                    JSONObject ii = (JSONObject)this.convertRoutetoJSON(next_route[i].getDestinationStepId());
                    log.info((Object)ii);
                    responseitems.add((Object)ii);
                }
                response.put((Object)"items", (Object)responseitems);
                routeitems.add((Object)response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        route.put((Object)"items", (Object)routeitems);
        return route;
    }

    private Object convertSteptoJSON(int step_id) {
        JSONObject object = new JSONObject();
        JSONObject c_valueobject = new JSONObject();
        JSONObject deadlinevalueobject = new JSONObject();
        JSONObject r_valueobject = new JSONObject();
        JSONObject deadlineobject = new JSONObject();
        try {
            VWMapNode map_node = this.mainMap.getStep(step_id);
            object.put((Object)TYPE, (Object)STEP);
            object.put((Object)ID, (Object)map_node.getStepId());
            String name = map_node.getName() == null ? EMPTYSTRING : map_node.getName();
            object.put((Object)TITLE, (Object)name);
            String description = map_node.getDocumentation() == null ? EMPTYSTRING : map_node.getName();
            object.put((Object)DESCRIPTION, (Object)description);
            String instruction = map_node.getDescription() == null ? EMPTYSTRING : map_node.getName();
            object.put((Object)INSTRUCTION, (Object)instruction);
            c_valueobject.put((Object)VALUE, (Object)((VWStepDefinition)map_node).getDeadline());
            c_valueobject.put((Object)UNIT, (Object)HRS);
            deadlinevalueobject.put((Object)COMPLETESIN, (Object)c_valueobject);
            r_valueobject.put((Object)VALUE, (Object)((VWStepDefinition)map_node).getReminder());
            r_valueobject.put((Object)UNIT, (Object)HRS);
            deadlinevalueobject.put((Object)REMINDER, (Object)r_valueobject);
            String reassignable = ((VWStepDefinition)map_node).getCanReassign() ? YES : NO;
            deadlineobject.put((Object)DEADLINE, (Object)deadlinevalueobject);
            deadlineobject.put((Object)REASSIGNABLE, (Object)reassignable);
            object.put((Object)PROPERTIES, (Object)deadlineobject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }
}

