/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.Handle;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmRequest {
    private static final Log logger = LogFactory.getLog((String)Handle.class.getName());
    private String resourceRequestURI;
    private String requestHeader;
    private Map<String, String[]> requestQueryString;
    private String requestBody = null;
    private Config configuration = null;
    private HttpSession session = null;

    public AcmRequest(HttpServletRequest request, Config config) throws IOException {
        this.resourceRequestURI = request.getPathInfo().substring(1);
        this.configuration = config;
        this.session = request.getSession();
        this.readRequestBody(request);
        String servletContext = request.getContextPath() + request.getServletPath();
        this.requestQueryString = request.getParameterMap();
        System.out.println("resourceRequestURI: " + this.resourceRequestURI + ", servletContext " + servletContext);
    }

    public String getParameter(String paramKey) {
        if (this.requestQueryString.containsKey(paramKey)) {
            return this.requestQueryString.get(paramKey)[0];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRequestBody(HttpServletRequest request) throws IOException {
        logger.trace((Object)"Entering readRequestBody: ");
        ServletInputStream in = null;
        try {
            in = request.getInputStream();
            int length = request.getContentLength();
            if (length > 0) {
                int totalBytesread = 0;
                byte[] buf = new byte[length];
                StringBuilder result = new StringBuilder(length);
                int bytesRead = in.read(buf, 0, length);
                while (bytesRead > 0) {
                    result.append(new String(buf, 0, bytesRead, "UTF-8"));
                    totalBytesread += bytesRead;
                    bytesRead = in.read(buf, 0, length);
                }
                this.requestBody = result.toString();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        logger.trace((Object)"Exiting readRequestBody: ");
    }

    public String getResourceRequestURI() {
        return this.resourceRequestURI;
    }

    public Config getConfig() {
        return this.configuration;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public HttpSession getSession() {
        return this.session;
    }
}

