/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.casebuilder.flows;

import com.ibm.acm.casebuilder.flows.AcmXPDLFlowHandler;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.AcmActivitySdfData;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumTaskLaunchMode;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskGroupType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TasksType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import ilog.views.diagrammer.IlvDiagrammer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmProcessFlowData {
    private static final Log log = LogFactory.getLog((String)AcmProcessFlowData.class.getName());
    private SolutionData m_solData;

    public AcmProcessFlowData(SolutionData solData) {
        this.m_solData = solData;
    }

    public void updateActivityTypeDataFromJson(Object[] keys, JSONObject js, TasksType actsType) {
        log.trace((Object)">>updateActivityTypeDataFromJson");
        TaskType activityType = new TaskType();
        activityType.setRequired(false);
        activityType.setHidden(Boolean.valueOf(false));
        activityType.setLaunchMode(EnumTaskLaunchMode.AUTOMATIC);
        activityType.setRepeatable(false);
        activityType.setUserCreatable(false);
        activityType.setId("");
        boolean createGuid = false;
        block18: for (int i = 0; i < keys.length; ++i) {
            switch (this.checkActivityKey(keys[i].toString())) {
                case 418: {
                    Boolean isContainer = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    activityType.setIsContainer(isContainer);
                    continue block18;
                }
                case 419: {
                    String parentTask = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setParentTask(parentTask);
                    continue block18;
                }
                case 420: {
                    if (js.get((Object)keys[i].toString()) != null && js.get((Object)keys[i].toString()) instanceof JSONArray) {
                        JSONArray propArray = (JSONArray)js.get((Object)keys[i].toString());
                        for (int j = 0; j < propArray.size(); ++j) {
                            activityType.getPropertyUpdateTrigger().add(propArray.get(j).toString());
                        }
                        continue block18;
                    }
                    if (js.get((Object)keys[i].toString()) == null || !(js.get((Object)keys[i].toString()) instanceof String)) continue block18;
                    String propUpdate = (String)js.get((Object)keys[i].toString());
                    activityType.getPropertyUpdateTrigger().add(propUpdate);
                    continue block18;
                }
                case 400: {
                    String sname = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setName(sname);
                    activityType.setWorkflowName(sname);
                    continue block18;
                }
                case 401: {
                    String dname = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setDisplayName(dname);
                    continue block18;
                }
                case 402: {
                    String desc = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setDescription(desc);
                    continue block18;
                }
                case 403: {
                    String designnote = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setDesignNote(designnote);
                    continue block18;
                }
                case 404: {
                    if (js.get((Object)keys[i].toString()) != null && js.get((Object)keys[i].toString()) instanceof JSONArray) {
                        JSONArray docArray = (JSONArray)js.get((Object)keys[i].toString());
                        for (int j = 0; j < docArray.size(); ++j) {
                            activityType.getFilingDocumentType().add(docArray.get(j).toString());
                        }
                        continue block18;
                    }
                    if (js.get((Object)keys[i].toString()) == null || !(js.get((Object)keys[i].toString()) instanceof String)) continue block18;
                    String filingDoc = (String)js.get((Object)keys[i].toString());
                    activityType.getFilingDocumentType().add(filingDoc);
                    continue block18;
                }
                case 405: {
                    String propertypre = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setPropertyPrecondition(propertypre);
                    continue block18;
                }
                case 406: {
                    Boolean required = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    activityType.setRequired(required.booleanValue());
                    continue block18;
                }
                case 421: {
                    Boolean hidden = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    activityType.setRequired(hidden.booleanValue());
                    continue block18;
                }
                case 407: {
                    EnumTaskLaunchMode launchmode = EnumTaskLaunchMode.fromValue((String)js.get(keys[i]).toString());
                    activityType.setLaunchMode(launchmode);
                    continue block18;
                }
                case 408: {
                    Boolean repeatable = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    activityType.setRepeatable(repeatable.booleanValue());
                    continue block18;
                }
                case 409: {
                    Boolean usercreatable = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    activityType.setUserCreatable(usercreatable.booleanValue());
                    continue block18;
                }
                case 411: {
                    String id = new String(js.get((Object)keys[i].toString()).toString());
                    if (id.equalsIgnoreCase("-1")) {
                        createGuid = true;
                        continue block18;
                    }
                    activityType.setId(id);
                    createGuid = false;
                    continue block18;
                }
                case 410: {
                    String group = new String(js.get((Object)keys[i].toString()).toString());
                    for (TaskGroupType agt : actsType.getTaskGroup()) {
                        if (!group.equals(agt.getName())) continue;
                        activityType.setGroupId(agt.getId());
                        continue block18;
                    }
                    continue block18;
                }
            }
        }
        if (createGuid && activityType.getName() != null) {
            String guid = this.m_solData.checkCreateTaskGuid(activityType.getName());
            activityType.setId(guid);
        }
        actsType.getTask().add(activityType);
        log.trace((Object)"<<updateActivityTypeDataFromJson");
    }

    private void updateActivityDataFromJson(JSONObject js, AcmActivity activityData, String casetypename) throws AcmException {
        log.trace((Object)">>updateActivityDataFromJson");
        List caseTypes = null;
        if (this.m_solData.getConverterData() != null && this.m_solData.getConverterData().getSolutionType() != null && this.m_solData.getConverterData().getSolutionType().getCaseTypes() != null) {
            caseTypes = this.m_solData.getConverterData().getSolutionType().getCaseTypes().getCaseType();
        }
        String actName = (String)js.get((Object)"name");
        boolean found = false;
        ArrayList actList = null;
        if (caseTypes != null) {
            for (CaseTypeType caseType : caseTypes) {
                if (casetypename.equals(caseType.getName())) {
                    actList = (ArrayList)caseType.getTasks().getTask();
                    for (TaskType act : actList) {
                        if (!act.getName().equals(actName)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                break;
            }
        }
        TaskType activityType = new TaskType();
        activityType.setRequired(false);
        activityType.setHidden(Boolean.valueOf(false));
        activityType.setLaunchMode(EnumTaskLaunchMode.AUTOMATIC);
        activityType.setRepeatable(false);
        activityType.setUserCreatable(false);
        activityType.setId("");
        AcmActivitySdfData actSdfdata = activityData.getSdfData();
        if (actSdfdata == null) {
            log.error((Object)"SdfData object in ACM Activity not found");
            Message msg = new Message("B4061E.CREATE_TASK_ERROR");
            throw new AcmException(msg);
        }
        Object[] keys = js.keySet().toArray();
        boolean createGuid = false;
        block20: for (int i = 0; i < keys.length; ++i) {
            switch (this.checkActivityKey(keys[i].toString())) {
                case 418: {
                    Boolean isContainer = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    activityType.setIsContainer(isContainer);
                    actSdfdata.setContainer(isContainer);
                    continue block20;
                }
                case 419: {
                    String parentTask = new String(js.get((Object)keys[i].toString()).toString());
                    activityType.setParentTask(parentTask);
                    actSdfdata.setparentTask(parentTask);
                    continue block20;
                }
                case 420: {
                    if (js.get((Object)keys[i].toString()) != null && js.get((Object)keys[i].toString()) instanceof JSONArray) {
                        JSONArray propArray = (JSONArray)js.get((Object)keys[i].toString());
                        for (int j = 0; j < propArray.size(); ++j) {
                            actSdfdata.getpropertyUpdateTrigger().add(propArray.get(j).toString());
                            if (found) continue;
                            activityType.getPropertyUpdateTrigger().add(propArray.get(j).toString());
                        }
                        continue block20;
                    }
                    if (js.get((Object)keys[i].toString()) == null || !(js.get((Object)keys[i].toString()) instanceof String)) continue block20;
                    String propUpdate = (String)js.get((Object)keys[i].toString());
                    actSdfdata.getpropertyUpdateTrigger().add(propUpdate);
                    if (found) continue block20;
                    activityType.getPropertyUpdateTrigger().add(propUpdate);
                    continue block20;
                }
                case 400: {
                    String sname = new String(js.get((Object)keys[i].toString()).toString());
                    activityData.setSymbolicName(sname);
                    actSdfdata.setSymbolicName(sname);
                    if (found) continue block20;
                    activityType.setName(sname);
                    continue block20;
                }
                case 401: {
                    String dname = new String(js.get((Object)keys[i].toString()).toString());
                    activityData.setName(dname);
                    if (found) continue block20;
                    activityType.setDisplayName(dname);
                    continue block20;
                }
                case 402: {
                    String desc = new String(js.get((Object)keys[i].toString()).toString());
                    activityData.setDescription(desc);
                    if (found) continue block20;
                    activityType.setDescription(desc);
                    continue block20;
                }
                case 403: {
                    String designnote = new String(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setDesignNote(designnote);
                    if (found) continue block20;
                    activityType.setDesignNote(designnote);
                    continue block20;
                }
                case 404: {
                    if (js.get((Object)keys[i].toString()) != null && js.get((Object)keys[i].toString()) instanceof JSONArray) {
                        JSONArray docArray = (JSONArray)js.get((Object)keys[i].toString());
                        for (int j = 0; j < docArray.size(); ++j) {
                            actSdfdata.getFilingDocumentTypeList().add(docArray.get(j).toString());
                            if (found) continue;
                            activityType.getFilingDocumentType().add(docArray.get(j).toString());
                        }
                        continue block20;
                    }
                    if (js.get((Object)keys[i].toString()) == null || !(js.get((Object)keys[i].toString()) instanceof String)) continue block20;
                    String filingDoc = (String)js.get((Object)keys[i].toString());
                    actSdfdata.getFilingDocumentTypeList().add(filingDoc);
                    if (found) continue block20;
                    activityType.getFilingDocumentType().add(filingDoc);
                    continue block20;
                }
                case 405: {
                    String propertypre = new String(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setPropertyPreCondition(propertypre);
                    if (found) continue block20;
                    activityType.setPropertyPrecondition(propertypre);
                    continue block20;
                }
                case 406: {
                    Boolean required = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setRequired(required);
                    if (found) continue block20;
                    activityType.setRequired(required.booleanValue());
                    continue block20;
                }
                case 421: {
                    Boolean hidden = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setHidden(hidden);
                    if (found) continue block20;
                    activityType.setHidden(Boolean.valueOf(hidden));
                    continue block20;
                }
                case 407: {
                    String launchmode = new String(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setLaunchMode(launchmode);
                    if (found) continue block20;
                    activityType.setLaunchMode(EnumTaskLaunchMode.fromValue((String)launchmode));
                    continue block20;
                }
                case 408: {
                    Boolean repeatable = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setRepeatable(repeatable);
                    if (found) continue block20;
                    activityType.setRepeatable(repeatable.booleanValue());
                    continue block20;
                }
                case 409: {
                    Boolean usercreatable = Boolean.parseBoolean(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setUserCreatable(usercreatable);
                    if (found) continue block20;
                    activityType.setUserCreatable(usercreatable.booleanValue());
                    continue block20;
                }
                case 410: {
                    String groupid = new String(js.get((Object)keys[i].toString()).toString());
                    actSdfdata.setGroupID(groupid);
                    continue block20;
                }
                case 411: {
                    String id = new String(js.get((Object)keys[i].toString()).toString());
                    if (id.equalsIgnoreCase("-1")) {
                        createGuid = true;
                    } else {
                        actSdfdata.setId(id);
                        createGuid = false;
                    }
                    if (found) continue block20;
                    activityType.setId(id);
                }
            }
        }
        if (createGuid && activityData.getSymbolicName() != null) {
            String guid = this.m_solData.checkCreateTaskGuid(activityData.getSymbolicName());
            actSdfdata.setId(guid);
            if (!found) {
                activityType.setId(guid);
            }
        }
        if (!found && actList != null) {
            actList.add(activityType);
        }
        log.trace((Object)"<<updateActivityDataFromJson");
    }

    public AcmActivity createActivityDataFromJson(JSONObject js, CaseTypeData newctData, String casetypename, IlvDiagrammer diagrammer) throws AcmException {
        log.trace((Object)">>createActivityDataFromJson");
        AcmActivity activityData = null;
        try {
            activityData = new AcmActivity();
        }
        catch (DiagrammerException e) {
            log.error((Object)" error ::  ", (Throwable)e);
            Message msg = new Message("B4061E.CREATE_TASK_ERROR");
            throw new AcmException(msg, (Throwable)e);
        }
        try {
            AcmActivitySdfData actSdfdata = new AcmActivitySdfData();
            activityData.setSdfData(actSdfdata);
            this.updateActivityDataFromJson(js, activityData, casetypename);
            activityData.initAcmActivity(newctData.getSharedInfo());
            if (newctData.getId() == null || newctData.getId().equals("-1")) {
                String guid = this.m_solData.checkCreateCaseTypeGuid(casetypename);
                newctData.setId(guid);
            }
            activityData.setGuid(newctData.getId(), activityData.getSdfData().getId());
        }
        catch (DiagrammerException e) {
            log.error((Object)" error ::  ", (Throwable)e);
            Message msg = new Message("B4064E.ERROR_DIAGRAM_MODEL");
            throw new AcmException(msg, (Throwable)e);
        }
        catch (VWException vwe) {
            log.error((Object)" error ::  ", (Throwable)vwe);
            Message msg = new Message("B4064E.ERROR_DIAGRAM_MODEL");
            throw new AcmException(msg, (Throwable)vwe);
        }
        catch (Exception e) {
            log.error((Object)" error ::  ", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException(msg);
        }
        activityData.updateBasicWorkflowProperties(newctData.getSharedInfo());
        if (diagrammer != null) {
            AcmActivityEditorUtil.copyDiagrammerOld(activityData.getDiagrammer(), diagrammer);
        }
        log.trace((Object)"<<createActivityDataFromJson");
        return activityData;
    }

    private int checkActivityKey(String key) {
        if (key.equalsIgnoreCase("name")) {
            return 400;
        }
        if (key.equalsIgnoreCase("isContainer")) {
            return 418;
        }
        if (key.equalsIgnoreCase("parentTask")) {
            return 419;
        }
        if (key.equalsIgnoreCase("propertyUpdateTrigger")) {
            return 420;
        }
        if (key.equalsIgnoreCase("hidden")) {
            return 421;
        }
        if (key.equalsIgnoreCase("displayName")) {
            return 401;
        }
        if (key.equalsIgnoreCase("description")) {
            return 402;
        }
        if (key.equalsIgnoreCase("designNote")) {
            return 403;
        }
        if (key.equalsIgnoreCase("filingDocumentType")) {
            return 404;
        }
        if (key.equalsIgnoreCase("propertyPreCondition")) {
            return 405;
        }
        if (key.equalsIgnoreCase("required")) {
            return 406;
        }
        if (key.equalsIgnoreCase("launchMode")) {
            return 407;
        }
        if (key.equalsIgnoreCase("repeatable")) {
            return 408;
        }
        if (key.equalsIgnoreCase("userCreatable")) {
            return 409;
        }
        if (key.equalsIgnoreCase("groupId")) {
            return 410;
        }
        if (key.equalsIgnoreCase("id")) {
            return 411;
        }
        log.warn((Object)("Unknown Key is :" + key.toString()));
        return 999;
    }

    public JSONArray processFlowData(String jsonstr, SolutionData solData) throws AcmException {
        String[] guids = new String[2];
        String casetypename = null;
        Object caseId = null;
        boolean isNewTask = false;
        String taskname = null;
        AcmActivity acmActivity = null;
        CaseTypeData ctData = null;
        this.m_solData = solData;
        log.trace((Object)("Obtained JSON:" + jsonstr));
        JSONObject js = null;
        try {
            js = JSONObject.parse((String)jsonstr);
            casetypename = (String)js.get((Object)"caseName");
            taskname = (String)js.get((Object)"taskName");
        }
        catch (IOException e) {
            Message msg = new Message("B4065E.ERROR_IO_EXCEPTION", e.getLocalizedMessage());
            throw new AcmException(msg, (Throwable)e);
        }
        JSONArray flowJson = null;
        AcmXPDLFlowHandler flowHndlr = new AcmXPDLFlowHandler();
        try {
            if (solData != null) {
                log.trace((Object)"Obtained Solution Data object from the session ---");
                ctData = solData.getCasetypedata(casetypename);
                if (ctData != null) {
                    acmActivity = ctData.getActivityByName(taskname);
                    VWWorkflowDefinition workflowDef = acmActivity.getVWWorkflowDefinition();
                    flowJson = flowHndlr.generateFlows(workflowDef);
                    ctData.addActivity(acmActivity);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)" error ::  ", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException(msg);
        }
        solData.setCasetypedata(casetypename, ctData);
        return flowJson;
    }
}

