#!/bin/bash

# /*
# Licensed Materials - Property of IBM
# 5900-A2A
# © Copyright IBM Corporation 2020. All Rights Reserved.
# This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer
# (a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM product,
# either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's
# own products.
# */

# Interactive mode: Prompt the user for provisioning details

read -p 'Enter UID(email) to be provisioned:' uservar
read -p 'Enter familyname:' familyname
read -p 'Enter givenname:' givenname
read -p 'Enter preferred language:' preferredlanguage
read -p 'Enter a groupname to add to the user:' groupname

echo
echo Thank you $uservar your ID is being provisioned...


curl -X POST -k -H 'Content-Type: application/json' -H 'Authorization: Basic <Token>' -H 'IBM-CSRF-TOKEN: <IBM-CSRF-TOKEN>' -i 'https://vhostxxx.com/instance/services/users' --data '{ 
        "user_id": "'$uservar'",
        "email": "'$uservar'",
        "base_dn": "cn=users,O=IBM,C=US", 
        "given_name": "'$givenname'", 
        "family_name": "'$familyname'", 
        "groups": [{"name": "'$groupname'","base_dn": "cn=groups,O=IBM,C=US"}],
        "details": { "preferred_language": "'$preferredlanguage'" } 
        }'
echo "\n Added $uservar to the global directory using cn=users,O=IBM,C=US" 

echo $'\ndone'
