# /*
# Licensed Materials - Property of IBM
# 5900-A2A
# © Copyright IBM Corporation 2020. All Rights Reserved.
# This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer
# (a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM product,
# either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's
# own products.
# */

#Python script to create user with groups
#Command to run the script : python3 <name_of_the_pythonfile>.py

import http.client
import json
import ssl

conn = http.client.HTTPSConnection("vhost***.com",context = ssl._create_unverified_context())
#Example payload
# payload = { 
#         "user_id": "testingusers@frmpython.com",
#         "email": "testingusers@frmpython.com",
#         "base_dn": "cn=users,O=IBM,C=US", 
#         "given_name": "test", 
#         "family_name": "python",
#         "groups": [{"name": "Developers","base_dn": "cn=groups,O=IBM,C=US"},{"name": "Administrators","base_dn": "cn=groups,O=IBM,C=US"}],
#         "details": { "preferred_language": "en" }
# }

payload = { 
        "user_id": "<uid>",
        "email": "<email_id>",
        "base_dn": "cn=users,O=IBM,C=US", 
        "given_name": "<given_name>", 
        "family_name": "<family_name>",
        "groups": [{"name": "<groupname1_to_add_to_user>","base_dn": "cn=groups,O=IBM,C=US"},{"name": "<groupname2_to_add_to_user>","base_dn": "cn=groups,O=IBM,C=US"}],
        "details": { "preferred_language": "<language>" }
}

user_json = json.dumps(payload)

headers = {
    'Authorization': "Basic <auth_token>",
    'Content-Type': "application/json",
    'IBM-CSRF-TOKEN': "<csrf_token>"
    }

conn.request("POST", "/instance/services/users", user_json, headers)

res = conn.getresponse()
data = res.read()

print(data.decode("utf-8"))
