# /*
# Licensed Materials - Property of IBM
# 5900-A2A
# © Copyright IBM Corporation 2020. All Rights Reserved.
# This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer
# (a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM product,
# either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's
# own products.
# */

#Python script to create user with groups
#Command to run the script : python3 <name_of_the_pythonfile>.py

import http.client
import json
import ssl

conn = http.client.HTTPSConnection("vhost***.com",context = ssl._create_unverified_context())

payload = { 
    "name": "<name_of_group>", 
    "base_dn": "cn=groups,O=IBM,C=US", 
    "members": [ 
        { "member_id": "test@us.ibm.com", 
          "type": "user", 
          "base_dn": "cn=users,O=IBM,C=US" 
        },
        { "member_id": "testgroup", 
          "type": "group", 
          "base_dn": "cn=groups,O=IBM,C=US" 
        } 
      ]
    }
    

group_json = json.dumps(payload)

headers = {
    'Authorization': "Basic <auth_token>",
    'Content-Type': "application/json",
    'IBM-CSRF-TOKEN': "<csrf_token>"
    }

conn.request("POST", "/instance/services/groups", group_json, headers)

res = conn.getresponse()
data = res.read()
